## CARATTERISTICHE PRINCIPALI

Le caratteristiche chiave del Content Init Componente sono:

* Funzionalità di base per la creazione di contenuti
* Struttura di base per l'organizzazione dei contenuti
* Nessuna funzionalità di accessibilità specifica è disponibile

## VARIANTI

Le varianti disponibili per il componente Content Init sono:

* **Default**: La variante predefinita del componente, che fornisce una struttura di base per la creazione di contenuti.
	+ Casi d'uso: Utilizzare come punto di partenza per la creazione di nuovi contenuti
	+ Descrizione breve: Variante predefinita del componente

## BEST PRACTICES

Le raccomandazioni d'uso per il componente Content Init sono:

* Utilizzare il componente come punto di partenza per la creazione di nuovi contenuti
* Evitare di utilizzare il componente come contenitore per altri elementi

## COMPONENTI CORRELATI

I componenti associati al Content Init Componente sono:

* Header: Il componente che solitamente precede il componente Content Init nella struttura della pagina

Nota: Non ci sono informazioni disponibili sugli aspetti tecnici rilevanti, caratteristiche di accessibilità e linee guida implementative.

## OVERVIEW
<div class="table-responsive">`import { ContentInitComponent } from '@inail/intranet-webkit/page-sections';`</div>

Il componente ContentInitComponent è utilizzato per indicare l'inizio del contenuto principale di una pagina. Questo componente viene generalmente posizionato sotto l'header della pagina e funge da segnaposto per identificare l'inizio del contenuto accessibile agli utenti, inclusi quelli che utilizzano tecnologie assistive come screen reader.

## API
<div class="table-responsive">
  <table class="table table-documentation">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>message</code></td>
         <td>
            `@Input() message = 'MESSAGES.MAIN_CONTENT_INIT';` <br />
            Il campo message rappresenta il testo che sarà mostrato all'interno del componente. È possibile passare una stringa personalizzata o una chiave di traduzione (ad esempio, per il supporto i18n).
         </td>
      </tr>
   </tbody>
</table>
</div>