## CARATTERISTICHE PRINCIPALI

*   Funzionalità chiave:
    *   Selezione di un valore da una lista di opzioni
    *   Inserimento di un testo personalizzato
*   Aspetti tecnici rilevanti:
    *   Utilizza la proprietà "propertyName" per impostare il nome della proprietà associata al componente
    *   Supporta l'inserimento di descrizioni dettagliate per ogni opzione
*   Caratteristiche di accessibilità: N.D.

## VARIANTI

Il componente Combobox presenta diverse varianti, ognuna con caratteristiche e casi d'uso specifici:

*   **Test della descrizione dell'input combobox INAIL**
    *   Descrizione: Variante che include una descrizione dettagliata per ogni opzione
    *   Caso d'uso: utile quando è necessario fornire informazioni aggiuntive agli utenti durante la selezione di un valore
*   **Combobox Label**
    *   Descrizione: Variante che include un'etichetta personalizzabile per il componente
    *   Caso d'uso: Utile quando è necessario fornire un contesto chiaro per la selezione del valore

## BEST PRACTICES

*   Raccomandazioni d'uso:
    *   Utilizzare descrizioni dettagliate per ogni opzione per aiutare gli utenti a comprendere le scelte disponibili
    *   Personalizzare l'etichetta del componente per fornire un contesto chiaro per la selezione del valore
*   Linee guida implementative:
    *   Utilizzare la proprietà "propertyName" per impostare il nome della proprietà associata al componente
    *   Supportare l'inserimento di descrizioni dettagliate per ogni opzione
*   Pratiche da evitare: N.D.

## COMPONENTI CORRELATI

Il componente Combobox può essere utilizzato in combinazione con altri componenti per creare interfacce utente più complesse. Alcuni esempi di componenti correlati includono:

*   Input testuali
*   Pulsanti di azione

## OVERVIEW
<div class="table-responsive">`import { InputComboboxComponent } from '@inail/intranet-webkit/form-controls';`</div>
Il componente Combobox è progettato per fornire agli utenti un menu a tendina che consente di selezionare opzioni. Questo componente supporta diverse funzionalità per migliorare l'accessibilità, l'usabilità e l'aspetto visivo ed è particolarmente adatto per scenari di form complessi in applicazioni aziendali di livello enterprise. 

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>field-for-option</code></td>
      <td>
        `@Input('field-for-option') fieldForOptionElement = 'descrizione';` <br />
        Specifica il nome del campo utilizzato per le etichette delle opzioni.
      </td>
    </tr>
    <tr>
      <td><code>pending</code></td>
      <td>
        `@Input() pending = false;` <br />
        Indica se il campo è in attesa di ulteriori azioni prima di poter essere finalizzato.
      </td>
    </tr>
    <tr>
      <td><code>remote</code></td>
      <td>
        `@Input() remote!: (param: any) => Observable<ComboBoxOption[]>;` <br />
        Specificare l'observable utilizzato per la ricerca. Questo è utile quando i dati per il menu a discesa non sono statici e devono essere recuperati da un server remoto o elaborati dinamicamente in base all'input dell'utente.
      </td>
    </tr>
    <tr>
      <td><code>options</code></td>
      <td>
		   `@Input() options: any[];` <br />
		    Rappresenta l'elenco delle opzioni disponibili per il componente di combobox.
	    </td>
    </tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class InputComboboxComponent extends BaseInputComponent` <br />
        La classe InputComboboxComponent estende <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent</a>
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
		   `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
		    La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
	    </td>
    </tr>
  </tbody>
</table>
</div>