## CARATTERISTICHE PRINCIPALI
Le caratteristiche chiave della componente Pagina Non Trovata includono:

* Funzionalità di visualizzazione del messaggio di errore
* Possibilità di personalizzare il testo del messaggio di errore
* Aspetti tecnici rilevanti: la componente mostra dinamicamente il messaggio di errore tramite rendering lato client.
* Caratteristiche di accessibilità: la componente è progettata per essere accessibile agli utenti con disabilità, rispettando gli standard di accessibilità web

## VARIANTI
La componente Pagina Non Trovata presenta le seguenti varianti:

* **Pagina non trovata**: visualizza un messaggio di errore generico quando una pagina non viene trovata
	+ Caso d'uso: errore 404
	+ Descrizione breve: messaggio di errore personalizzato per la pagina non trovata

## BEST PRACTICES
Le raccomandazioni d'uso per la componente Pagina Non Trovata includono:

* Utilizzare un testo chiaro e conciso per il messaggio di errore
* Personalizzare il testo del messaggio di errore in base alle esigenze specifiche dell'applicazione
* Rispettare gli standard di accessibilità web per garantire l'accessibilità della componente agli utenti con disabilità

## COMPONENTI CORRELATI
La componente Pagina Non Trovata è correlata ai seguenti componenti:

* Componente di errore generico
* Componente di accessibilità




## OVERVIEW
<div class="table-responsive">`import { PageNotFoundComponent } from '@inail/internet-webkit/page-sections';`</div>

Il componente `PageNotFoundComponent` serve a segnalare all'utente che la pagina richiesta non è disponibile, fornendo un'interfaccia chiara e intuitiva per la gestione degli errori 404. È altamente configurabile, consentendo la personalizzazione del messaggio di errore in base alle esigenze specifiche dell'applicazione.

## API
Questo componente non ha controlli.