## CARATTERISTICHE PRINCIPALI

Le caratteristiche principali del componente "Input Number" includono:

* **Funzionalità chiave**: il componente supporta le seguenti funzionalità:
 + Inserimento di valori numerici
 + Gestione degli errori e delle avvertenze
 + Supporto per la personalizzazione della dimensione del campo di input
* **Aspetti tecnici rilevanti**:
 + Il componente utilizza una struttura HTML standard per il campo di input
 + Supporta la gestione degli eventi JavaScript per la gestione degli errori e delle avvertenze
* **Caratteristiche di accessibilità**: il componente è progettato per essere accessibile agli utenti con disabilità, fornendo una struttura HTML standard e supportando la tecnologia di assistenza.

## VARIANTI
Il componente Input Number presenta le seguenti varianti:

* **Stories Input Number Test della descrizione dell' input number INAIL**: questa variante mostra un esempio di come utilizzare il componente per inserire un valore numerico con una descrizione personalizzata.
* **Number Input Number Need help? Contact support. Show code**: questa variante mostra un esempio di come utilizzare il componente per inserire un valore numerico con un messaggio di aiuto e un link per contattare il supporto.

## BEST PRACTICES

* **Raccomandazioni d'uso**: utilizzare il componente Input Number quando si necessita di inserire valori numerici in una forma semplice e intuitiva.
* **Linee guida implementative**: assicurarsi di personalizzare la dimensione del campo di input in base alle esigenze specifiche dell'applicazione.
* **Pratiche da evitare**: non utilizzare il componente per inserire valori non numerici, poiché ciò potrebbe causare errori e problemi di accessibilità.

## COMPONENTI CORRELATI
Il componente Input Number può essere utilizzato in combinazione con altri componenti per fornire un' esperienza utente più completa. Alcuni esempi di componenti correlati sono:

* **Campo di input testuale**: può essere utilizzato per inserire valori non numerici.
* **Pulsante di submit**: può essere utilizzato per inviare i dati inseriti dall'utente.

## OVERVIEW
<div class="table-responsive">`import { InputNumberComponent } from '@inail/internet-webkit/form-controls';`</div>

Il componente Input Number è progettato per offrire un controllo numerico flessibile e configurabile.
Supporta funzionalità avanzate come messaggi di supporto, validazioni, tooltip e gestione di classi CSS personalizzate.

## API
<div class="table-responsive">
  <table class="table">
  <thead>
	<tr>
	  <th><strong>Campo</strong></th>
	  <th><strong>Descrizione</strong></th>
	</tr>
  </thead>
  <tbody>
	<tr>
	  <td><code>externalClass</code></td>
	  <td>
		`@Input() externalClass = '';` <br />
		Applica classi CSS personalizzate per definire lo stile del componente.
	  </td>
	</tr>
	<tr>
	  <td><code>BaseInputComponent controls</code></td>
	  <td>
		`class InputNumberComponents extends BaseInputComponent` <br />
		Fare riferimento a <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent.</a>
	  </td>
	</tr>
	<tr>
		<td><code>size</code></td>
		<td>
		    `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
			La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
		</td>
	</tr>
  </tbody>
</table>
</div>