## CARATTERISTICHE PRINCIPALI

* Funzionalità chiave:
 + Visualizzazione di contenuti in una finestra modale
 + Supporto per tab e box
 + Personalizzazione delle dimensioni e del layout della finestra modale
* Aspetti tecnici rilevanti:
 + Utilizza la libreria Angular per la gestione dei componenti
 + Supporta la gestione degli eventi e le azioni dell'utente
* Caratteristiche di accessibilità:
 + Supporto per la navigazione con tastiera
 + Compatibilità con gli screen reader

## VARIANTI

* Elenco delle varianti disponibili:
	+ Un tasto
	+ Due tasti
	+ Tre tasti
	+ Con form
	+ Con tabella
	+ Con lista
* Descrizione e casi d'uso per ogni variante:
	+ Un tasto: utilizzato per confermare un'azione o procedere con un processo
	+ Due tasti: utilizzato per fornire all'utente due opzioni di scelta (ad esempio, "Si" e "No")
	+ Tre tasti: utilizzato per fornire all'utente tre opzioni di scelta (ad esempio, "Si", "No" e "Annulla")
	+ Con form: utilizzato per raccogliere informazioni dall'utente
	+ Con tabella: utilizzato per visualizzare dati in una struttura tabellare
	+ Con lista: utilizzato per visualizzare un elenco di elementi

## BEST PRACTICES

* Raccomandazioni d'uso:
	+ Utilizzare il componente Box e Tab Finestre Modali quando è necessario visualizzare contenuti aggiuntivi all'utente senza dover ricaricare la pagina
	+ Personalizzare le dimensioni e il layout della finestra modale in base alle esigenze specifiche dell'applicazione
* Linee guida implementative:
	+ Utilizzare la libreria Angular per gestire i componenti
	+ Supportare la gestione degli eventi e delle azioni dell'utente
* Pratiche da evitare:
	+ Utilizzare il componente Box e Tab Finestre Modali come sostituto di una pagina web completa
	+ Inserire nella finestra contenuti lunghi, che fuoriescono dalla schermata e
	costringono l’utente a fare scorrere verticalmente la finestra
	+ Inserire nella finestra contenuti o componenti complessi (per esempio Wizard o TAB)
	+ Permettere l’apertura di più finestre modali in sovrapposizione. Può essere
	presente al massimo una finestra modale sulla schermata.


## COMPONENTI CORRELATI

* Componenti associati:
	+ Finestra modale
	+ Tab
	+ Box
* Relazioni con altri elementi:
	+ Il componente Box e Tab Finestre Modali può essere utilizzato in combinazione con altri componenti di interfaccia utente per creare un'esperienza utente completa e coesa.

## ACCESSIBILITA'
Le finestre modali devono sempre essere identificate dallo screen reader come “finestre di dialogo” e il focus deve rimanere intrappolato all’interno della finestra finché l’utente la richiude.
