## Caratteristiche Principali

Le caratteristiche principali del componente "Checkbox" includono:

* **Funzionalità chiave**: la possibilità di selezionare una o più opzioni, la visualizzazione delle opzioni in forma di caselle da spuntare
* **Aspetti tecnici rilevanti**: il componente utilizza la proprietà `checked` per gestire lo stato di selezione delle opzioni, e la proprietà `disabled` per disabilitare le opzioni
* **Caratteristiche di accessibilità**: il componente è progettato per essere accessibile agli utenti con disabilità, grazie all'utilizzo di etichette e attributi ARIA

## Varianti

Le varianti disponibili del componente "Checkbox" includono:

### Variante 1: Opzioni multiple

* Descrizione: questa variante consente agli utenti di selezionare più opzioni contemporaneamente
* Casi d'uso specifici:
	+ Quando è necessario consentire agli utenti di scegliere tra diverse alternative che non sono mutualmente esclusive
	+ Quando si desidera fornire un modo semplice e intuitivo per gli utenti di selezionare più opzioni

Breve descrizione: questa variante consente agli utenti di selezionare più opzioni contemporaneamente, grazie all'utilizzo di caselle da spuntare multiple.

### Variante 2: Opzione singola

* Descrizione: questa variante consente agli utenti di selezionare una sola opzione
* Casi d'uso specifici:
	+ Quando è necessario consentire agli utenti di scegliere tra diverse alternative mutualmente esclusive
	+ Quando si desidera fornire un modo semplice e intuitivo per gli utenti di selezionare solo un' opzione

Breve descrizione: questa variante consente agli utenti di selezionare una sola opzione, grazie all'utilizzo di una casella da spuntare singola.

## Best Practices

Le raccomandazioni d'uso del componente "Checkbox" includono:

* Utilizzare etichette e attributi ARIA per garantire l'accessibilità del componente
* Personalizzare l'aspetto e il comportamento del componente per adattarlo alle esigenze specifiche dell'applicazione
* Evitare di utilizzare il componente "Checkbox" come sostituto di un pulsante o di un altro elemento di input

## Componenti Correlati

I componenti associati al componente "Checkbox" includono:

* **Pulsanti**: possono essere utilizzati per fornire un modo alternativo per gli utenti di interagire con le opzioni
* **Elementi di input**: possono essere utilizzati per fornire un modo alternativo per gli utenti di inserire dati

Relazioni con altri elementi:

* Il componente "Checkbox" può essere utilizzato in combinazione con altri componenti, come ad esempio i pulsanti e gli elementi di input, per creare form complessi ed interattivi.


## OVERVIEW
<div class="table-responsive">`import { CheckboxComponent } from '@inail/internet-webkit/form-controls';`</div>
Il componente Checkbox è progettato per offrire un modo semplice e intuitivo per creare un elenco di opzioni selezionabili all'interno di un'interfaccia utente. Ogni opzione nell'elenco rappresenta una scelta indipendente che l'utente può abilitare o disabilitare a seconda delle proprie esigenze.


## API
<div class="table-responsive">
  <table class="table">
  <thead>
	<tr>
	  <th><strong>Campo</strong></th>
	  <th><strong>Descrizione</strong></th>
	</tr>
  </thead>
  <tbody>
	<tr>
	  <td><code>line</code></td>
	  <td>
		`@Input() line = false;` <br />
		Controlla il layout del componente checkbox, visualizzandolo come un elemento block-level quando è impostato su false o inline con altri elementi quando è impostato su true.
	  </td>
	</tr>
	<tr>
	  <td><code>field-for-id</code></td>
	  <td>
		`@Input('field-for-id') fieldForId: string | undefined;` <br />
		Specificare il nome del campo per estrarre il valore per il form control.
	  </td>
	</tr>
	<tr>
	  <td><code>field-for-option</code></td>
	  <td>
		`@Input('field-for-option') fieldForOptionElement = 'descrizione';` <br />
		Il nome del campo utilizzato per l'etichetta di ciascuna opzione del checkbox.
	  </td>
	</tr>
	<tr>
	  <td><code>BaseInputComponent controls</code></td>
	  <td>
		`class CheckboxComponent extends BaseInputComponent` <br />
		Fare riferimento a <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent</a>
	  </td>
	</tr>
	<tr>
	  <td><code>size</code></td>
	  <td>
		`@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
		La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
	  </td>
	</tr>
  </tbody>
</table>
</div>