# Tab

Documentazione dettagliata dell'oggetto custom  **Tab**, usato nei componenti di Intranet Webkit v17. 
**Tab** viene utilizzato per creare tab nei componenti <a href="?path=/story/components-tabs-tabs--tabs">Tabs</a>.

## Implementazione
<div class="table-responsive">`import { Tab, WebkitModule } from '@inail/intranet-webkit'`</div>
<br />

***Struttura:***
`class Tab extends BaseModel {
	private _id: number;
	private _title: string;
	private _hasError: boolean | undefined;
	private _disable: boolean | undefined;
	private _templateNo: any;
}`

***Esempio d'uso:***
<div class="table-responsive">`new Tab(2, 'TITLE.TAB_2', false, false, 2)`</div>

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>id</code></td>
      <td>
        Campo numerico che assegna un ID al tab.
      </td>
    </tr>
    <tr>
      <td><code>title</code></td>
      <td>
        Campo di tipo `string` che assegna il titolo alla tab creata.
      </td>
    </tr>
    <tr>
      <td><code>hasError</code></td>
      <td>
        Booleano che, quando è impostato su `true`, mostra un errore nella tab.
      </td>
    </tr>
    <tr>
      <td><code>disable</code></td>
      <td>
        Booleano che, quando è impostato su  `true`, disabilita la tab.
      </td> 
    </tr>
    <tr>
      <td><code>templateNo</code></td>
      <td>
        Campo che imposta l' index (partendo da 1) del template che viene visualizzato nella tab corrente. I template sono contenuti in un array di `TemplateRef` che contiene referenze a degli `<ng-template #id>`, dove l' `#id` serve come referenza per l' input `[templates]="[id]"`.
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-tabs-tabs--tabs">Tabs</a>
