## CARATTERISTICHE PRINCIPALI
- Funzionalità chiave: gestione delle richieste di pagine non trovate
- Aspetti tecnici rilevanti: configurazione del server, gestione degli errori HTTP
- Caratteristiche di accessibilità: messaggio di errore accessibile e contestuale, con collegamento chiaro alla homepage.

## VARIANTI
- **Variante 1:** Pagina Non Trovata Standard
 + Descrizione: pagina di default per le richieste non trovate
 + Caso d'uso: utente inserisce un URL non esistente
 + Breve descrizione: "La pagina richiesta non è stata trovata. Torna alla homepage."
- **Variante 2:** Pagina Non Trovata Personalizzata
 + Descrizione: pagina personalizzata per le richieste non trovate
 + Caso d'uso: utente inserisce un URL non esistente in un'applicazione personalizzata
 + Breve descrizione: "Verifica l’indirizzo inserito e riprova, oppure torna alla homepage."

## BEST PRACTICES
- Raccomandazioni d'uso: utilizzare una pagina di errore personalizzata per migliorare l'esperienza utente
- Linee guida implementative: configurare il server per gestire le richieste non trovate, utilizzare messaggi di errore coerenti
- Pratiche da evitare: Evitare l’uso di pagine di errore generiche prive di istruzioni o link utili.

## COMPONENTI CORRELATI
- Componenti associati: Header, Footer, Homepage
- Relazioni con altri elementi: navigazione, menu, collegamenti ipertestuali

## OVERVIEW
<div class="table-responsive">`import { PageNotFoundComponent } from '@inail/intranet-webkit/page-sections';`</div>

Il componente `PageNotFoundComponent` serve a segnalare all'utente che la pagina richiesta non è disponibile, fornendo un'interfaccia chiara e intuitiva per la gestione degli errori 404. È altamente configurabile, consentendo la personalizzazione del messaggio di errore in base alle esigenze specifiche dell'applicazione.

## API
Questo componente non ha controlli.