## CARATTERISTICHE PRINCIPALI
Le funzionalità chiave del componente Input Label includono:

* La possibilità di visualizzare una descrizione o un'etichetta per un campo di input
* La capacità di personalizzare la descrizione o l'etichetta a seconda delle esigenze dell'applicazione

Gli aspetti tecnici rilevanti del componente Input Label includono:

* La possibilità di utilizzare il componente con diversi tipi di campi di input (ad esempio, testo, numero, data, ecc.)
* La capacità di personalizzare l'aspetto e la disposizione del componente a seconda delle esigenze dell'applicazione

Le caratteristiche di accessibilità del componente Input Label includono:

* La possibilità di utilizzare il componente con tecnologie assistive (ad esempio, lettori di schermo)
* La capacità di fornire una descrizione o un'etichetta chiara e concisa per i campi di input

## VARIANTI
Il componente Input Label dispone delle seguenti varianti:

* **Test della descrizione dell'input Label INAIL**: Questa variante include una descrizione dettagliata dell'utilizzo del componente Input Label.
* **Label**: Questa variante include un'esempio di utilizzo del componente Input Label con un campo di input.

Casi d'uso specifici per ogni variante:

* La variante "Test della descrizione dell'input Label INAIL" può essere utilizzata per fornire una descrizione dettagliata dell'utilizzo del componente Input Label in un contesto specifico.
* La variante "Label" può essere utilizzata per fornire un'esempio di utilizzo del componente Input Label con un campo di input.

## BEST PRACTICES
Le raccomandazioni d'uso del componente Input Label includono:

* Utilizzare il componente per fornire una descrizione o un'etichetta chiara e concisa per i campi di input
* Personalizzare la descrizione o l'etichetta a seconda delle esigenze dell'applicazione

Le linee guida implementative del componente Input Label includono:

* Utilizzare il componente con diversi tipi di campi di input (ad esempio, testo, numero, data, ecc.)
* Personalizzare l'aspetto e la disposizione del componente a seconda delle esigenze dell'applicazione

Le pratiche da evitare del componente Input Label includono:

* Non utilizzare il componente per fornire informazioni non rilevanti o confuse
* Non personalizzare eccessivamente la descrizione o l'etichetta, in modo da renderla difficile da comprendere

## COMPONENTI CORRELATI
Il componente Input Label è associato ai seguenti componenti:

* Campo di input: il componente Input Label è utilizzato per fornire una descrizione o un'etichetta per un campo di input.
* Etichetta: il componente Input Label può essere utilizzato per fornire un'esempio di utilizzo del componente con un campo di input.

## OVERVIEW
<div class="table-responsive">`import { InputLabelComponent } from '@inail/intranet-webkit/form-controls';`</div>


Il componente InputLabelComponent viene utilizzato per creare un'etichetta personalizzabile associata a un campo di input, con supporto per tooltip e opzioni di accessibilità avanzate, come la visibilità esclusiva per gli screen reader. Inoltre, consente di indicare se il campo è obbligatorio e di gestire messaggi specifici per migliorare l'usabilità.


## API
<div class="table-responsive">
  <table class="table table-documentation">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>inailInputLabel</code></td>
         <td>
            `@Input('inailInputLabel') label!: string;` <br />
            Etichetta per il campo di input.
         </td>
      </tr>
      <tr>
         <td><code>srOnly</code></td>
         <td>
            `@Input() srOnly!: boolean;` <br />
            Specificare se l'etichetta deve essere presente solo per gli screen reader.
         </td>
      </tr>
      <tr>
         <td><code>inputId</code></td>
         <td>
            `@Input() inputId!: string;` <br />
            L'ID dell'input.
         </td>
      </tr>
      <tr>
         <td><code>required</code></td>
         <td>
            `@Input() required!: boolean;` <br />
            Indica se il campo è obbligatorio.
         </td>
      </tr>
      <tr>
         <td><code>asteriskReplacedToSR</code></td>
         <td>
            `@Input() asteriskReplacedToSR = true;` <br />
           Sostituisci l'asterisco nell' etichetta con il messaggio 'ERROR.REQUIRED'.
         </td>
      </tr>
         <tr>
         <td><code>tooltip</code></td>
         <td>
            `@Input() tooltip!: TooltipModel;` <br />
           Oggetto <a href = "?path=/docs/resources-models-tooltipmodel--docs">Tooltip</a>  per il campo di input.
         </td>
      </tr>
   </tbody>
</table>
</div>