## CARATTERISTICHE PRINCIPALI
Le caratteristiche principali del componente Tabs includono:

* **Funzionalità chiave**: la possibilità di creare più tab con contenuto diverso e navigare tra essi
* **Aspetti tecnici rilevanti**: il componente utilizza una struttura HTML personalizzata per rappresentare i tab e il loro contenuto
* **Caratteristiche di accessibilità**: il componente è progettato per essere accessibile agli utenti con disabilità, grazie all'utilizzo di attributi ARIA e alla possibilità di navigazione tramite tastiera

## VARIANTI
Le varianti del componente Tabs includono:

* **Tab 1**: la prima variante del componente, che visualizza il contenuto del primo tab
	+ Caso d'uso: utilizzare il componente per visualizzare informazioni generali su un argomento
	+ Breve descrizione: il primo tab contiene informazioni di base sull'argomento
* **Tab 2**: la seconda variante del componente, che visualizza il contenuto del secondo tab
	+ Caso d'uso: utilizzare il componente per visualizzare informazioni dettagliate su un argomento
	+ Breve descrizione: il secondo tab contiene informazioni più dettagliate sull'argomento
* **Tab 3**: la terza variante del componente, che visualizza il contenuto del terzo tab
	+ Caso d'uso: utilizzare il componente per visualizzare esempi o casi studio su un argomento
	+ Breve descrizione: il terzo tab contiene esempi o casi studio sull'argomento
* **Tab 4**: la quarta variante del componente, che visualizza il contenuto del quarto tab
	+ Caso d'uso: utilizzare il componente per visualizzare informazioni aggiuntive su un argomento
	+ Breve descrizione: il quarto tab contiene informazioni aggiuntive sull'argomento
* **Tab 5**: la quinta variante del componente, che visualizza il contenuto del quinto tab
	+ Caso d'uso: utilizzare il componente per visualizzare risorse aggiuntive su un argomento
	+ Breve descrizione: il quinto tab contiene risorse aggiuntive sull'argomento

## BEST PRACTICES
Le raccomandazioni per l'utilizzo del componente Tabs includono:

* Utilizzare il componente per organizzare e visualizzare più sezioni di contenuto in una singola area
* Personalizzare l'aspetto e il comportamento dei tab per adattarli alle esigenze specifiche dell'applicazione
* Utilizzare gli attributi ARIA per garantire l'accessibilità del componente

Le linee guida implementative includono:

* Creare una struttura HTML personalizzata per rappresentare i tab e il loro contenuto
* Utilizzare CSS per personalizzare l'aspetto dei tab
* Utilizzare JavaScript per gestire la navigazione tra i tab

Le pratiche da evitare includono:

* Non utilizzare il componente per visualizzare troppo contenuto in una singola area
*  Non lasciare i tab con impostazioni predefinite se non coerenti con l'interfaccia utente generale dell'applicazione.
* Non omettere gli attributi ARIA, poiché sono essenziali per garantire l’accessibilità del componente.

## COMPONENTI CORRELATI
I componenti correlati al componente Tabs includono:

* **Accordion**: un componente che consente di visualizzare e nascondere sezioni di contenuto
* **Collapse**: un componente che consente di visualizzare e nascondere sezioni di contenuto
* **Dropdown**: un componente che consente di visualizzare un menu a discesa con opzioni diverse

## OVERVIEW
 <div class="table-responsive">`import { TabsComponent } from '@inail/internet-webkit/tabs';`</div>
 
 Il TabsComponent rappresenta un sistema di navigazione a schede (tabs) che permette di visualizzare contenuti diversi in base alla scheda selezionata. Ogni scheda può avere un template personalizzato, e il componente gestisce lo stato della scheda attiva tramite l'input activeTab e l'output onTabChanged. È progettato per essere configurabile con un array di schede e relativi template, supportando funzionalità avanzate come tipi di schede e creazione dinamica dei contenuti.

 ## API
<div class="table-responsive">
  <table class="table">
   <thead>
	  <tr>
		 <th style="width: 20%"><strong>Campo</strong></th>
		 <th style="width: 80%"><strong>Descrizione</strong></th>
	  </tr>
   </thead>
   <tbody>
	  <tr>
		 <td><code>id</code></td>
		 <td> <code> @Input() id!: string;</code><br /> Identificativo univoco per il Tabs. Può essere utilizzato per riferirsi al componente in modo specifico. </td>
	  </tr>
	  <tr>
		 <td><code>createAll</code></td>
		 <td>
			`@Input() createAll = false;` <br />
			Valore booleano che gestisce la generazione dei template.
		 </td>
	  </tr>
	  <tr>
		 <td><code>type</code></td>
		 <td>
			` @Input() type: 'default' | 'secondary' = 'default';` <br />
			Tipo di tab gestito nel HTML.
		 </td>
	  </tr>
	   <tr>
		 <td><code>tabs</code></td>
		 <td>
			`  @Input() tabs: (AdvancedTab)[] = [];` <br />
		   Un array di oggetti di tipo <a href="?path=/docs/resources-models-advancedtab--docs"> AdvancedTab</a> che rappresentano tutti i tab disponibili nella pagina. 
		 </td>
	  </tr>
   </tbody>
</table>
</div>

<br/>

<div class="table-responsive">
  <table class="table">
  <thead>
	<tr>
	  <th style="width: 20%"><strong>Event</strong></th>
	  <th style="width: 80%"><strong>Descrizione</strong></th>
	</tr>
  </thead>
  <tbody>
	<tr>
	  <td><code>onTabChanged</code></td>
	  <td>
		`@Output() onTabChanged: EventEmitter<AdvancedTab> = new EventEmitter();` <br />
		Event emitter che gestisce l'evento onChangeTab($event).
	  </td>
	</tr>
  </tbody>
</table>
</div>