## CARATTERISTICHE PRINCIPALI

* Funzionalità chiave:
 + Visualizzazione di contenuti in una finestra modale
 + Supporto per tab e box
 + Personalizzazione delle dimensioni e del layout della finestra modale
* Aspetti tecnici rilevanti:
 + Utilizza la libreria Angular per la gestione dei componenti
 + Supporta la gestione degli eventi e le azioni dell'utente
* Caratteristiche di accessibilità:
 + Supporto per la navigazione con tastiera
 + Compatibilità con gli screen reader

## VARIANTI

* Elenco delle varianti disponibili:
	+ Un tasto
	+ Due tasti
	+ Tre tasti
	+ Con form
	+ Con tabella
	+ Con lista
* Descrizione e casi d'uso per ogni variante:
	+ Un tasto: utilizzato per confermare un'azione o procedere con un processo
	+ Due tasti: utilizzato per fornire all'utente due opzioni di scelta (ad esempio, "Si" e "No")
	+ Tre tasti: utilizzato per fornire all'utente tre opzioni di scelta (ad esempio, "Si", "No" e "Annulla")
	+ Con form: utilizzato per raccogliere informazioni dall'utente
	+ Con tabella: utilizzato per visualizzare dati in una struttura tabellare
	+ Con lista: utilizzato per visualizzare un elenco di elementi

## BEST PRACTICES

* Raccomandazioni d'uso:
	+ Utilizzare il componente Box e Tab Finestre Modali quando è necessario visualizzare contenuti aggiuntivi all'utente senza dover ricaricare la pagina
	+ Personalizzare le dimensioni e il layout della finestra modale in base alle esigenze specifiche dell'applicazione
* Linee guida implementative:
	+ Utilizzare la libreria Angular per gestire i componenti
	+ Supportare la gestione degli eventi e delle azioni dell'utente
* Pratiche da evitare:
	+ Non utilizzare il componente Box e Tab Finestre Modali come sostituto di una pagina web completa

## COMPONENTI CORRELATI

* Componenti associati:
	+ Finestra modale
	+ Tab
	+ Box
* Relazioni con altri elementi:
	+ Il componente Box e Tab Finestre Modali può essere utilizzato in combinazione con altri componenti di interfaccia utente per creare un'esperienza utente completa e coesa.

## ACCESSIBILITA'
Lo scopo del link “scopri di più” deve essere comprensibile fuori dal contesto della pagina.
A questo scopo deve essere inserita un’informazione aggiuntiva non visibile a schermata, per
esempio:
```
<a href=”#”>
Scopri di più <span class=”sr-only”> sulle modalità di iscrizione al bando ISI 2025 </span>
</a>
```

Se una lista non presenta un titolo visibile o un altro elemento che possa essere collegato tramite `aria-labelledby`, dovrà essere inserito sul contenitore della lista un attributo `aria-label`. Questo attributo dovrà essere valorizzato con il "nome lista" descrittivo che si intende assegnare alla lista stessa, garantendo così che lo screen reader possa comunicarne chiaramente lo scopo e il contenuto all'utente.
