## CARATTERISTICHE PRINCIPALI

* **Funzionalità chiave**: il componente Tooltip offre le seguenti funzionalità principali:
  - Possibilità di impostare un titolo che viene visualizzato quando l'utente passa il mouse sopra l'elemento associato.
  - Supporto per un testo descrittivo che fornisce ulteriori informazioni all'utente.
  - Opzione per aggiungere un'icona al tooltip per migliorare la comprensione visiva.

* **Aspetti tecnici rilevanti**: il componente Tooltip utilizza le seguenti tecnologie:
  - HTML per la struttura.
  - CSS per lo stile e il posizionamento.
  - JavaScript per la gestione dinamica dell’interazione.
* **Caratteristiche di accessibilità**: il componente è conforme alle linee guida WCAG 2.1 e include:
  - Attributi ARIA per migliorare l'accessibilità agli utenti con disabilità.
  - Supporto per la personalizzazione del colore e della dimensione del testo.

## VARIANTI

Il componente Tooltip dispone delle seguenti varianti:

* **Variante con titolo e testo descrittivo**
  - **Descrizione**: include un titolo e un testo descrittivo per fornire informazioni dettagliate all'utente.
  - **Caso d'uso**: utile per fornire suggerimenti contestuali sugli elementi interattivi.

* **Variante con icona**
  - **Descrizione**: aggiunge un'icona accanto al tooltip per fornire un'indicazione visiva aggiuntiva.
  - **Caso d'uso**: indicato per evidenziare elementi che richiedono particolare attenzione.

## BEST PRACTICES

* **Raccomandazioni d'uso**:
  - Utilizzare il tooltip per fornire informazioni concise e utili senza sovraccaricare l'utente.
  - Assicurarsi che il contenuto del tooltip sia chiaro e comprensibile.
  - Testare il componente su diversi dispositivi e browser per garantire un'esperienza utente uniforme.

* **Linee guida implementative**:
  - Utilizzare HTML, CSS e JavaScript per configurare il componente.
  - Personalizzare l'aspetto tramite le classi CSS per adattarlo al design dell'applicazione.

* **Pratiche da evitare**:
  - Evitare di inserire testi troppo lunghi o complessi nei tooltip.
  - Non utilizzare il tooltip per contenuti essenziali che devono essere sempre visibili nell’interfaccia.

## COMPONENTI CORRELATI

Il componente Tooltip può essere utilizzato in combinazione con altri componenti per migliorare l'esperienza utente:

* **Button**: può essere utilizzato per attivare la visualizzazione del tooltip.
* **Icona**: fornisce un supporto visivo aggiuntivo per attirare l'attenzione dell'utente.

*N.D.* – Nota: le informazioni relative ai componenti correlati non sono disponibili.

## OVERVIEW
<div class="table-responsive">`import { InputTooltipComponent } from '@inail/internet-webkit/form-controls';`</div>

Il componente `InputTooltipComponent` viene utilizzato per fornire suggerimenti contestuali agli utenti attraverso un tooltip interattivo. Supporta la visualizzazione di contenuti testuali o template personalizzati e offre opzioni di configurazione come titolo, icona e classi CSS aggiuntive. Grazie all'integrazione con Bootstrap, il tooltip può essere mostrato o nascosto dinamicamente in risposta alle interazioni dell'utente.

## API
<div class="table-responsive">
  <table class="table">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>tooltip</code></td>
         <td>
            `Input() tooltip!: TooltipModel | 'template';` <br />
            Specifica il contenuto del tooltip, che può essere un modello di tooltip (`TooltipModel`) con testo o un template personalizzato per una maggiore flessibilità.
        </td>
      </tr>
      <tr>
         <td><code>tooltipTitle</code></td>
         <td>
            `@Input() tooltipTitle!: string;` <br />
            Definisce il titolo visualizzato all'interno del tooltip per fornire un'indicazione chiara del contenuto.
         </td>
      </tr>
       <tr>
         <td><code>extraClass</code></td>
         <td>
            `@Input() extraClass!: string;` <br />
            Permette di aggiungere classi CSS personalizzate per modificare l'aspetto del tooltip in base alle esigenze del progetto.
         </td>
      </tr>
       <tr>
         <td><code>icon</code></td>
         <td>
            `@Input() icon = 'info-circle';` <br />
            Specifica l'icona visualizzata accanto all'elemento per indicare la presenza di un tooltip.
         </td>
      </tr>
   </tbody>
</table>
</div>