## CARATTERISTICHE PRINCIPALI
Il componente Form Items Campi Input presenta le seguenti caratteristiche chiave:

* Funzionalità di input del testo: il componente consente agli utenti di inserire testo nel campo di input
* Gestione degli errori e dei messaggi di aiuto: il componente fornisce la possibilità di visualizzare messaggi di errore e di aiuto per assistere gli utenti nella compilazione del campo di input

Gli aspetti tecnici rilevanti includono:

* Utilizzo di HTML, CSS e JavaScript per la creazione del componente
* Possibilità di personalizzazione tramite l'uso di classi CSS e attributi HTML

Le caratteristiche di accessibilità includono:

* Supporto per tastiere e dispositivi di input alternativi
* Utilizzo di etichette e messaggi di aiuto per assistere gli utenti con disabilità visive o uditive

## VARIANTI
Il componente Form Items Campi Input è disponibile in diverse varianti, tra cui:

### Campo di input di testo
Descrizione: campo di input standard per l'inserimento del testo
Casi d'uso specifici: utilizzato per la raccolta di dati testuali dagli utenti

Breve descrizione: Il campo di input di testo è un componente di base che consente agli utenti di inserire testo in un campo di input.

### Campo di input di testo disabilitato
Descrizione: campo di input disabilitato per l'inserimento del testo
Casi d'uso specifici: utilizzato quando il campo di input non deve essere modificabile dall'utente

Breve descrizione: Il campo di input di testo disabilitato è un componente che consente di visualizzare un testo in un campo di input, ma senza consentire all'utente di modificarlo.

### Campo di input con errore
Descrizione: campo di input con messaggio di errore per l'inserimento del testo
Casi d'uso specifici: utilizzato quando si verifica un errore durante la compilazione del campo di input

Breve descrizione: Il campo di input con errore è un componente che visualizza un messaggio di errore per assistere gli utenti nella risoluzione dell'errore.

### Campo di input con tasto di info
Descrizione: campo di input con tasto di informazione per l'inserimento del testo
Casi d'uso specifici: utilizzato quando si desidera fornire ulteriori informazioni agli utenti sulla compilazione del campo di input

Breve descrizione: Il campo di input con tasto di info è un componente che fornisce un tasto di informazione per assistere gli utenti nella compilazione del campo di input.

## BEST PRACTICES
Per utilizzare il componente Form Items Campi Input in modo efficace, si consiglia di:

* Utilizzare etichette e messaggi di aiuto per assistere gli utenti nella compilazione del campo di input
* Utilizzare classi CSS e attributi HTML per personalizzare l'aspetto e il comportamento del componente
* Testare il componente con diverse combinazioni di dispositivi e browser per garantire la compatibilità

## COMPONENTI CORRELATI
Il componente Form Items Campi Input può essere utilizzato in combinazione con altri componenti, tra cui:

* Componenti di form: come ad esempio pulsanti di invio e reset
* Componenti di navigazione: come ad esempio link e menu
* Componenti di layout: come ad esempio griglie e contenitori

## ACCESSIBILITA'
Una volta inserito del testo nel campo di input il placeholder scompare dalla schermata e non sarà più letto dallo screen reader, si consiglia quindi di non inserire nel placeholder informazioni indispensabili per l’utente e di limitare il suo utilizzo all’inserimento di esempi.
Inoltre, si consiglia di inserire un placeholder solo se può essere realmente utile per l’utente. Per esempio,
inserire un placeholder “Inserire il nome” dentro un campo “Nome” non è utile per l’utente e sarà ridondante
per chi utilizza uno SR.
