/* $(document).ready(function() {
    const $input = $('#combobox-input');
    const $options = $('#combobox-options');
    const $optionElements = $options.find('.option');
    let currentFilter = '';
    let isKeyboardNavigation = false;

    // Filtra le opzioni
    function filterOptions(filter) {
        currentFilter = filter.toLowerCase();
        let hasMatches = false;
        
        $optionElements.each(function() {
            const $option = $(this);
            const isMatch = $option.text().toLowerCase().includes(currentFilter);
            $option.toggle(isMatch);
            hasMatches = hasMatches || isMatch;
        });
        
        $options.toggle(hasMatches && currentFilter !== '');
    }

    // Gestione eventi input
    $input.on('input', function() {
        filterOptions($(this).val());
    }).on('focus', function() {
        if ($input.val().trim() !== '') {
            filterOptions($input.val());
        }
    }).on('keydown', function(e) {
        if (e.key === 'ArrowDown') {
            e.preventDefault();
            isKeyboardNavigation = true;
            const $visible = $optionElements.filter(':visible');
            if ($visible.length) $visible.first().focus();
        } else if (e.key === 'Enter') {
            e.preventDefault();
            $options.show();
        }
    }).on('blur', function() {
        if (!isKeyboardNavigation) {
            setTimeout(() => $options.hide(), 100);
        }
    });

    // Gestione eventi opzioni
    $optionElements.on('click', function() {
        if ($(this).text() != '- seleziona opzione -') {
            $input.val($(this).text()).focus();
        } else {
            $input.val('').focus();
        }
        $options.hide();
    }).on('keydown', function(e) {
        const $visible = $optionElements.filter(':visible');
        const currentIndex = $visible.index(this);

        if (e.key === 'Enter') {
            if ($(this).text() != '- seleziona opzione -') {
                $input.val($(this).text()).focus();
            } else {
                $input.val('').focus();
            }
            $options.hide();
        } else if (e.key === 'ArrowDown') {
            e.preventDefault();
            $visible.eq(currentIndex + 1).focus();
        } else if (e.key === 'ArrowUp') {
            e.preventDefault();
            currentIndex <= 0 ? $input.focus() : $visible.eq(currentIndex - 1).focus();
        } else if (e.key === 'Escape') {
            $input.focus();
        }
    });

    // Blocca la chiusura durante la navigazione
    $options.on('mouseenter', () => isKeyboardNavigation = false)
           .on('keydown', () => isKeyboardNavigation = true);
}); */

// $(document).ready(function() {
//     const $input = $('#combobox-input');
//     const $options = $('#combobox-options');
//     const $optionElements = $options.find('.option');
//     let currentFilter = '';
//     let isKeyboardNavigation = false;

//     // Filtra le opzioni
//     function filterOptions(filter) {
//         currentFilter = filter.toLowerCase();
//         let hasMatches = false;
        
//         $optionElements.each(function() {
//             const $option = $(this);
//             const isMatch = $option.text().toLowerCase().includes(currentFilter);
//             $option.toggle(isMatch);
//             hasMatches = hasMatches || isMatch;
//         });
        
//         $options.toggle(hasMatches && currentFilter !== '');
//         const visibleCount = $optionElements.filter(':visible').length;
//         annunciaNumeroOpzioni(visibleCount);
//         $('.inail-span-ht.inail-span-ht-combobox').text('Spostarsi con le frecce o digitare del testo per filtrare le opzioni');
//     }

//     function annunciaNumeroOpzioni(count) {
//         const $status = $('#ariaOptionStatus');

//         // Pulisce il contenuto per forzare il ri-annuncio
//         $status.text('');

//         setTimeout(() => {
//             const messaggio = count === 0
//                 ? 'Nessuna opzione disponibile'
//                 : `${count} opzion${count > 1 ? 'i' : 'e'} disponibil${count > 1 ? 'i' : 'e'}`;

//             $status.text(messaggio);
//         }, 10);
//     }

//     // Mostra tutte le opzioni
//     function showAllOptions() {
//         $optionElements.show();
//         $options.show();
//     }

//     // Gestione eventi input
//     $input.on('input', function() {
//         filterOptions($(this).val());
//     }).on('focus', function() {
//         /* if ($input.val().trim() !== '') {
//             filterOptions($input.val());
//         } */
//     }).on('click', function() {
//         showAllOptions();
//     }).on('keydown', function(e) {
//         if (e.key === 'ArrowDown') {
//             e.preventDefault();
//             isKeyboardNavigation = true;
//             const $visible = $optionElements.filter(':visible');
//             if ($visible.length) $visible.first().focus();
//         } else if (e.key === 'Enter') {
//             e.preventDefault();
//             showAllOptions();
//         }
//     }).on('blur', function() {
//         if (!isKeyboardNavigation) {
//             setTimeout(() => $options.hide(), 100);
//         }
//     });

//     // Gestione eventi opzioni
//     $optionElements.on('click', function() {
//         if ($(this).text() != '- seleziona opzione -') {
//             $input.val($(this).text()).focus();
//         } else {
//             $input.val('').focus();
//         }
//         $options.hide();
//     }).on('keydown', function(e) {
//         const $visible = $optionElements.filter(':visible');
//         const currentIndex = $visible.index(this);

//         if (e.key === 'Enter') {
//             if ($(this).text() != '- seleziona opzione -') {
//                 $input.val($(this).text()).focus();
//             } else {
//                 $input.val('').focus();
//             }
//             $options.hide();
//         } else if (e.key === 'ArrowDown') {
//             e.preventDefault();
//             $visible.eq(currentIndex + 1).focus();
//         } else if (e.key === 'ArrowUp') {
//             e.preventDefault();
//             currentIndex <= 0 ? $input.focus() : $visible.eq(currentIndex - 1).focus();
//         } else if (e.key === 'Escape') {
//             $input.focus();
//         }
//     });

//     // Blocca la chiusura durante la navigazione
//     $options.on('mouseenter', () => isKeyboardNavigation = false)
//            .on('keydown', () => isKeyboardNavigation = true);
// });


$(document).ready(function () {
  setTimeout(() => {
   $("input[data-input-type='combobox']").each(function () {
    const $input = $(this);
    const $container = $input.closest('.inail-combobox-input-container');
    const $options = $container.find('.inail-combobox-panel');
    const $optionElements = $options.find('.option');
    const $status = $container.closest('.combobox').find('#ariaOptionStatus');

    let currentFilter = '';
    let isKeyboardNavigation = false;
    let justSelected = false;

    function filterOptions(filter) {
      currentFilter = filter.toLowerCase();
      let hasMatches = false;

      $optionElements.each(function () {
        const $option = $(this);
        const isMatch = $option.text().toLowerCase().includes(currentFilter);
        $option.toggle(isMatch);
        hasMatches = hasMatches || isMatch;
      });

      $options.toggle(hasMatches && currentFilter !== '');
      announceOptionsCount($optionElements.filter(':visible').length);
    }

    function announceOptionsCount(count) {
      if (!$status.length) return;
      $status.text('');
      setTimeout(() => {
        const message = count === 0
          ? 'Nessuna opzione disponibile'
          : `${count} opzion${count > 1 ? 'i' : 'e'} disponibil${count > 1 ? 'i' : 'e'}`;
        $status.text(message);
      }, 10);
    }

    function showAllOptions() {
      $optionElements.show();
      $options.show();
       announceOptionsCount($optionElements.length);
    }

    $input.on('input', function () {
      filterOptions($(this).val());
    }).on('click', function () {
      showAllOptions();
    }).on('keydown', function (e) {
      if (e.key === 'ArrowDown') {
        e.preventDefault();
        isKeyboardNavigation = true;
        const $visible = $optionElements.filter(':visible');
        if ($visible.length) $visible.first().focus();
      } else if (e.key === 'Enter') {
        e.preventDefault();
        showAllOptions();
      }
    }).on('blur', function () {
      setTimeout(() => {
        if (!isKeyboardNavigation && !justSelected) {
          $options.hide();
        }
        justSelected = false;
      }, 150);
    });

    $optionElements.on('click', function () {
      justSelected = true;
      const val = $(this).text();
      $input.val(val).trigger("change").focus();
      $options.hide();
    }).on('keydown', function (e) {
      const $visible = $optionElements.filter(':visible');
      const currentIndex = $visible.index(this);

      if (e.key === 'Enter') {
        e.preventDefault();
        justSelected = true;
        const val = $(this).text();
        $input.val(val).trigger("change").focus();
        $options.hide();
      } else if (e.key === 'ArrowDown') {
        e.preventDefault();
        $visible.eq(currentIndex + 1).focus();
      } else if (e.key === 'ArrowUp') {
        e.preventDefault();
        currentIndex <= 0 ? $input.focus() : $visible.eq(currentIndex - 1).focus();
      } else if (e.key === 'Escape') {
        $input.focus();
        $options.hide();
      }
    });

    $options.on('mouseenter', () => isKeyboardNavigation = false)
            .on('keydown', () => isKeyboardNavigation = true);
  }); 
  }, 0);
  
});