## CARATTERISTICHE PRINCIPALI
Il componente Menu Item INAIL offre le seguenti caratteristiche chiave:

* Funzionalità chiave:
 + Personalizzazione del testo e dell'icona
 + Possibilità di aggiungere descrizioni dettagliate
* Aspetti tecnici rilevanti:
 + Utilizza tecnologie web standard (HTML, CSS, JavaScript)
 + Supporto alle funzioni di accessibilità (WCAG 2.1)
* Caratteristiche di accessibilità:
 + Supporto alla navigazione con tastiera
 + Possibilità di personalizzare il colore e la dimensione del testo

## VARIANTI
Il componente Menu Item INAIL offre le seguenti varianti:

* **Variante 1: Menu Item con descrizione**
 + Descrizione: Questa variante include una descrizione dettagliata del menu item.
 + Casi d'uso specifici: Utilizzare questa variante quando è necessario fornire ulteriori informazioni sul menu item.
 + Breve descrizione: Menu item con descrizione dettagliata.
* **Variante 2: Menu Item senza descrizione**
 + Descrizione: Questa variante non include una descrizione dettagliata del menu item.
 + Casi d'uso specifici: Utilizzare questa variante quando non è necessario fornire ulteriori informazioni sul menu item.
 + Breve descrizione: Menu item senza descrizione dettagliata.

## BEST PRACTICES
Per utilizzare il componente Menu Item INAIL in modo efficace, seguire le seguenti raccomandazioni:

* Utilizzare una struttura di menu chiara e organizzata
* Fornire descrizioni dettagliate per i menu item quando necessario
* Utilizzare colori e dimensioni del testo accessibili

## COMPONENTI CORRELATI
Il componente Menu Item INAIL è correlato ai seguenti componenti:

* Componente Menu: il componente Menu Item INAIL è utilizzato all'interno del componente Menu per creare menu item personalizzabili.
* Componente Icon: il componente Menu Item INAIL utilizza il componente Icon per visualizzare icone personalizzate.


## OVERVIEW
<div class="table-responsive">`import { MenuItemComponent } from '@inail/intranet-webkit/page-sections';`</div>

Questo componente rappresenta una voce di menu per le sezioni di una pagina e consente di gestire la navigazione tra diverse aree dell'applicazione. Supporta un array di elementi di menu configurabili, che includono titolo, azioni di navigazione e icone opzionali.
Inoltre, il componente gestisce eventi di clic e offre opzioni per mostrare o nascondere icone e limitare il numero massimo di voci di menu visibili.
 
Il componente è altamente configurabile e supporta proprietà, eventi e opzioni per gestire scenari complessi, migliorando l'esperienza utente e l'accessibilità

## API
<div class="table-responsive">
  <table class="table table-documentation">
   <thead>
      <tr>
         <th style="width: 20%"><strong>Campo</strong></th>
         <th style="width: 80%"><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>items</code></td>
         <td>
            `@Input() items: MenuItem[] = [];` <br />
            Array di oggetti che rappresentano le voci di menu che verranno visualizzate.
         </td>
      </tr>
      <tr>
         <td><code>isChild</code></td>
         <td>
            `@Input() isChild = false;` <br />
            Indica se la voce di menu è una voce child (submenu).
         </td>
      </tr>
   </tbody>
</table>
</div>

<br/>

<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Campo</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>manageClick</code></td>
      <td>
        `@Output('manageClick') manageClickCallBack = new EventEmitter<>();` <br />
        Event emitter output che gestisce il click event.
      </td>
    </tr>
  </tbody>
</table>
</div>
