## CARATTERISTICHE PRINCIPALI

- **Funzionalità chiave**
* Il componente dispone di due proprietà booleane: `loading` e `isSelect`
* La proprietà `loading` consente di attivare o disattivare lo stato di caricamento
* La proprietà `isSelect` consente di applicare uno stile personalizzato allo stato di caricamento

- **Aspetti tecnici rilevanti**
* Il componente utilizza la classe CSS `mr-loading` per visualizzare lo stato di caricamento
* La classe `mr-loading` può essere personalizzata tramite CSS per adattarsi alle esigenze del progetto

- **Caratteristiche di accessibilità**
* Il componente è progettato per essere percepito dagli screen reader, indicando all'utente che un'operazione è in corso
* Supporta la gestione del focus e delle notifiche di stato per utenti con disabilità visive.

## VARIANTI
Il componente dispone di una variante:

* **Test della descrizione dell' input loading INAIL**: questa variante visualizza un esempio di utilizzo del componente con un testo di esempio

- **Casi d'uso specifici per ogni variante**
* Utilizzare il componente per visualizzare uno stato di caricamento durante le operazioni di caricamento dei dati
* Personalizzare l'aspetto dello stato di caricamento tramite la proprietà `isSelect`

**Breve descrizione per ogni variante**

* La variante **Test della descrizione dell' input loading INAIL** fornisce un esempio di utilizzo del componente con un testo di esempio

## BEST PRACTICES
- **Raccomandazioni d'uso**:
* Utilizzare il componente solo quando necessario, per evitare di confondere l'utente con troppi stati di caricamento
* Personalizzare l'aspetto dello stato di caricamento per adattarlo alle esigenze del progetto
- **Linee guida implementative**: non disponibili
- **Pratiche da evitare**: 
* Evitare di lasciare il componente in stato di caricamento per troppo tempo senza fornire un feedback aggiuntivo all'utente

## COMPONENTI CORRELATI
- **Componenti associati**: non disponibili
- **Relazioni con altri elementi**: il componente Loading può essere utilizzato in combinazione con altri componenti dell'interfaccia utente per indicare lo stato di caricamento in diverse sezioni dell'interfaccia.

## OVERVIEW
<div class="table-responsive">`import { InputLoadingComponent } from '@inail/internet-webkit/utils';`</div>

Il componente InputLoadingComponent viene utilizzato per indicare visivamente lo stato di caricamento di un campo di input. Supporta personalizzazioni attraverso le proprietà disponibili, consentendo di adattarlo a diversi scenari di utilizzo.

## API
<div class="table-responsive">
  <table class="table">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>loading</code></td>
         <td>
            `@Input() loading = false;` <br />
            Booleano per attivare/disattivare lo stato di caricamento 
         </td>
      </tr>
      <tr>
         <td><code>isSelect</code></td>
         <td>
            `@Input() isSelect = false;` <br />
             Booleano per applicare uno stile personalizzato all'elemento.
         </td>
      </tr>
   </tbody>
</table>
</div>