## CARATTERISTICHE PRINCIPALI
Le funzionalità chiave del componente Button e Link includono:

* Personalizzazione del testo e dell'icona
* Stato del pulsante (abilitato o disabilitato)
* Associazione di azioni specifiche al clic sul pulsante

Gli aspetti tecnici rilevanti includono:

* Utilizzo di classi CSS per personalizzare l'aspetto del componente
* Utilizzo di attributi HTML per impostare le proprietà del componente

Le caratteristiche di accessibilità includono:

* Supporto per la navigazione con tastiera
* Supporto per la lettura dello schermo

## VARIANTI
Sono disponibili le seguenti varianti del componente Button e Link:

* **Conferma**: un pulsante di conferma con testo personalizzato
* **ConfermaDisabilitato**: un pulsante di conferma disabilitato con testo personalizzato
* **ConfermaIcona**: un pulsante di conferma con icona personalizzata
* **Allineato Sinistra**: un pulsante allineato a sinistra con testo personalizzato
* **Allineato Destra**: un pulsante allineato a destra con testo personalizzato

Casi d'uso specifici per ogni variante:

* **Conferma**: utilizzare come pulsante di conferma in un modulo di registrazione
* **ConfermaDisabilitato**: utilizzare come pulsante di conferma disabilitato in un modulo di registrazione quando non sono stati inseriti tutti i dati richiesti
* **ConfermaIcona**: utilizzare come pulsante di conferma con icona personalizzata in un modulo di registrazione
* **Allineato Sinistra**: utilizzare come pulsante allineato a sinistra in un elenco di opzioni
* **Allineato Destra**: utilizzare come pulsante allineato a destra in un elenco di opzioni

## BEST PRACTICES
Raccomandazioni d'uso:

* Utilizzare il componente Button e Link per fornire agli utenti una serie di opzioni per eseguire azioni specifiche all'interno dell'applicazione
* Personalizzare il testo e l'icona del pulsante per adattarlo alle esigenze specifiche dell'applicazione

Linee guida implementative:

* Utilizzare classi CSS per personalizzare l'aspetto del componente
* Utilizzare attributi HTML per impostare le proprietà del componente

Pratiche da evitare:

* Non utilizzare il componente Button e Link come sostituto di un link normale
* Non utilizzare il componente Button e Link senza una descrizione chiara del suo scopo

## COMPONENTI CORRELATI
Il componente Button e Link è associato ai seguenti componenti:

* **Link**: un collegamento ipertestuale a una risorsa esterna
* **Pulsante**: un pulsante generico che può essere personalizzato per eseguire azioni specifiche

Relazioni con altri elementi:

* Il componente Button e Link può essere utilizzato all'interno di un modulo di registrazione o di un elenco di opzioni
* Il componente Button e Link può essere associato a un link normale o a un pulsante generico