## CARATTERISTICHE PRINCIPALI

### Funzionalità chiave

* Visualizzazione del calendario con giorni della settimana e date
* Selezione di una singola data o di un intervallo di date
* Supporto per la navigazione attraverso i mesi e gli anni

### Aspetti tecnici rilevanti

* Implementato utilizzando tecnologie web standard (HTML, CSS, JavaScript)
* Utilizza librerie Angular per il rendering dinamico del calendario
* Supporta la personalizzazione dei formati di data tramite l'utilizzo di pattern specifici

### Caratteristiche di accessibilità

* Il componente è progettato per essere accessibile aiutando gli utenti con disabilità motorie o visive.
* Supporta le funzionalità di accessibilità standard del browser, come la navigazione tramite tastiera e la lettura dello schermo.

## VARIANTI
Sono disponibili diverse varianti del componente per soddisfare esigenze specifiche:

### Variante 1: Selezione Data Singola
Descrizione: Consente all'utente di selezionare una singola data.
Casi d'uso: Registrazione evento, pianificazione appuntamento.

### Variante 2: Selezione Intervallo Date
Descrizione: Permette la selezione di un intervallo di date.
Casi d'uso: Prenotazione hotel, pianificazione viaggio.

### Variante 3: Selezione Data con Orario
Descrizione: Consente all'utente di selezionare una data e un orario specifico.
Casi d'uso: Pianificazione riunioni, registrazione evento con orario preciso.

## BEST PRACTICES

* Utilizzare il componente in contesti dove la selezione della data è fondamentale per l'esperienza utente.
* Personalizzare i formati di data e le opzioni di configurazione per adattarsi alle esigenze specifiche dell'applicazione.
* Assicurarsi che il componente sia accessibile e rispetti le linee guida di accessibilità del progetto.

## COMPONENTI CORRELATI
Il componente di selezione data può essere utilizzato in combinazione con altri elementi per creare un'esperienza utente completa:

* Componente di input testuale per l'inserimento manuale della data.
* Componente di pulsanti per azioni specifiche relative alla data selezionata.

Note: Per ulteriori informazioni sulla personalizzazione e sull'utilizzo del componente, consultare la documentazione tecnica completa.

## ACCESSIBILITA'
Usare `<fieldset>` per raggruppare elementi form connessi per logica, anche per il raggruppamento dei radio button.
Per le select utilizzare `<optgroup>` per raggruppare semanticamente le option.
Prestare attenzione ad associare correttamente le label ad input o select. Agli elementi di input associare sempre le label, tranne sul submit/reset, image button, button, ridde. Si consiglia di disporre la label su una sola riga aumentando eventualmente la width del form-group.
Utilizzare l'attributo placeholder per agevolare l'utente nella compilazione dei campi.

Per la segnalazione degli errori, oltre all'utilizzo del colore rosso, è necessario fornire una descrizione testuale dell'errore, per consentire agli utenti di identificare il problema e agevolarli nella correzione.

Se il campo è “obbligatorio” devono essere inseriti: il simbolo `*` dopo dell'Etichetta (label) del Campo, l'attributo `aria-required="true"` nel tag input, select o textarea e,prima del form, la leggenda "I campi contrassegnati con l'asterisco (`*`) sono obbligatori."

Le larghezze e le distanze tra gli elementi del form sono totalmente adattabili utilizzando le classi bootstrap col- e le classi noPadding. 