## CARATTERISTICHE PRINCIPALI

Le caratteristiche principali del componente di un Form includono:

Ecco alcune delle principali caratteristiche e attributi dei moduli HTML:

* **Action**: Specifica la pagina o lo script che gestirà i dati inviati dal modulo.
* **Method**: Indica il metodo di invio dei dati (ad esempio, get, post, ecc.). Il valore predefinito è get.
* **Name**: Assegna un nome al modulo per poterlo identificare facilmente.
* **Id**: Identifica in modo univoco il modulo all'interno della pagina.
* **Caratteristiche di accessibilità**: il componente è progettato per essere accessibile aiutando le persone con disabilità a navigare tra i contenuti.

## VARIANTI

Le varianti del componente di carosello includono:

* **Base**: Permette agli utenti di visualizzare e compilare i campi del modulo in una forma organizzata.
	+ Caso d'uso specifico: utilizzare questo tipo di Form nella maggior parte dei casi quando si desidera cconsentire all'utente di inviare i dati.
* **Form Accordion**: Combina la funzionalità di un modulo Form con la struttura di un accordion, permettendo agli utenti di visualizzare e compilare i campi del modulo in una forma compatta e organizzata. 
	+ Caso d'uso specifico: utilizzare questo tipo di Form quando si desidera ottimizzare una pagina con molti contenuti in modo da facilitare la visualizzazione agli utenti.
* **Form Tabellare 1**: Questa variante organizza i campi di input in maniera tabellare per rendere più semplice l'inserimento all'utente.
	+ Caso d'uso specifico: utilizzare questo tipo di Form quando ci sono dati da inserire che possono essere organizzati come una tabella.
* **Form Tabellare 2**: Questa variante organizza i campi di input in maniera tabellare più complessa per rendere possibile l'inserimento all'utente.
	+ Caso d'uso specifico: utilizzare questo tipo di Form quando ci sono dati da inserire che possono essere organizzati come una tabella.
* **Form Tabellare 3**: Questa variante organizza i campi di input in maniera tabellare su piu colonne per rendere più semplice l'inserimento all'utente.
	+ Caso d'uso specifico: utilizzare questo tipo di Form quando ci sono dati da inserire che possono essere organizzati come una tabella.




## BEST PRACTICES

Le raccomandazioni per l'utilizzo del componente:

* Utilizzare la Form coerente ai dati che è necessario inserire.

Le linee guida implementative includono:

* Testare il componente su diverse piattaforme e dispositivi per garantire la compatibilità.

Le pratiche da evitare includono:

* Non inserire troppi campi per non rendere difficile l'immissione dei dati da parte dell'utente componente poco attraente.

## COMPONENTI CORRELATI

I componenti associati al componente di Form possono essere:

* **Checkbox**
* **Combobox**
* **Campi Data**
* **Campi Input**
* **Radio Button**
* **Select**
* **Text Area**
* **Carica File**

## ACCESSIBILITA'
Usare `<fieldset>` per raggruppare elementi form connessi per logica, anche per il raggruppamento dei radio button.
Per le select utilizzare `<optgroup>` per raggruppare semanticamente le option.
Prestare attenzione ad associare correttamente le label ad input o select. Agli elementi di input associare sempre le label, tranne sul submit/reset, image button, button, ridde. Si consiglia di disporre la label su una sola riga aumentando eventualmente la width del form-group.
Utilizzare l'attributo placeholder per agevolare l'utente nella compilazione dei campi.

Per la segnalazione degli errori, oltre all'utilizzo del colore rosso, è necessario fornire una descrizione testuale dell'errore, per consentire agli utenti di identificare il problema e agevolarli nella correzione.

Se il campo è “obbligatorio” devono essere inseriti: il simbolo “*” dopo dell'Etichetta (label) del Campo, l'attributo `aria-required="true"` nel tag input, select o textarea e,prima del form, la leggenda "I campi contrassegnati con l'asterisco (*) sono obbligatori."


Le larghezze e le distanze tra gli elementi del form sono totalmente adattabili utilizzando le classi bootstrap col- e le classi noPadding.