## CARATTERISTICHE PRINCIPALI

Le caratteristiche chiave del componente Actions Dropdown includono:

* La possibilità di personalizzare l'aspetto e il comportamento dell'elenco delle azioni
* La capacità di gestire gli eventi di clic sui singoli elementi dell'elenco

Gli aspetti tecnici rilevanti del componente Actions Dropdown includono:

* L'utilizzo di HTML, CSS e JavaScript per la creazione e la gestione dell'interfaccia utente
* La possibilità di integrare il componente con altre librerie o framework JavaScript

Le caratteristiche di accessibilità del componente Actions Dropdown includono:

* La conformità agli di accessibilità WCAG 2.1
* La possibilità di personalizzare l'accessibilità dell'interfaccia utente in base alle esigenze specifiche degli utenti

## VARIANTI

Le varianti disponibili per il componente Actions Dropdown includono:

* **Default**: la variante predefinita del componente, che visualizza un elenco di azioni o opzioni aggiuntive
* **N.D.**: non sono disponibili altre varianti specifiche per questo componente

## BEST PRACTICES

Le raccomandazioni d'uso per il componente Actions Dropdown includono:

* Utilizzare il componente per fornire agli utenti un modo efficiente per eseguire azioni specifiche
* Personalizzare l'aspetto e il comportamento dell'interfaccia utente in base alle esigenze specifiche degli utenti

Le linee guida implementative per il componente Actions Dropdown includono:

* Utilizzare HTML, CSS e JavaScript per la creazione e la gestione dell'interfaccia utente
* Integrare il componente con altre librerie o framework JavaScript per estendere le sue funzionalità

## COMPONENTI CORRELATI

I componenti associati al componente "Actions Dropdown" includono:

* **Componente di input**: un componente che consente agli utenti di inserire testo o altri dati
* **Componente di pulsante**: un componente che consente agli utenti di eseguire azioni specifiche

Le relazioni con altri elementi includono:

* Il componente "Actions Dropdown" può essere utilizzato in combinazione con il componente di input per fornire un'esperienza di utilizzo più completa
* Il componente "Actions Dropdown" può essere utilizzato in combinazione con il componente di pulsante per fornire un'esperienza di utilizzo più flessibile

## OVERVIEW

<div class="table-responsive">`import { ActionsDropdownComponent } from '@inail/intranet-webkit/buttons';`</div>


L'ActionDropdownComponent è un componente che consente di visualizzare un menu a discesa di azioni personalizzabili. È particolarmente utile per gestire un elenco di operazioni associate a un elemento o a un contesto specifico, con un'interfaccia flessibile e facilmente configurabile.

Il componente supporta funzionalità avanzate come la limitazione del numero massimo di azioni visibili, l'aggiunta di classi personalizzate e la gestione dei tooltip, rendendolo un'ottima soluzione per contesti dinamici e complessi.


## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Campo</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>model</code></td>
      <td> <code>@Input() model: any;</code><br /> Modello di dati associato al menu a discesa. Fornisce informazioni contestuali per personalizzare le azioni. </td>
    </tr>
    <tr>
      <td><code>maxAction</code></td>
      <td> <code>@Input() maxAction = 4;</code><br /> Numero massimo di azioni visibili nel menu prima di mostrare un'icona o un'opzione per visualizzare altre azioni.<br /> Valore predefinito: <code>4</code>. </td>
    </tr>
    <tr>
      <td><code>extraClass</code></td>
      <td> <code>@Input() extraClass!: string;</code><br /> Classe CSS aggiuntiva per personalizzare lo stile del menu a discesa. </td>
    </tr>
    <tr>
      <td><code>labeledMenu</code></td>
      <td> <code>@Input() labeledMenu = false;</code><br /> Booleano che determina se il menu a discesa deve mostrare le etichette descrittive accanto alle icone delle azioni.<br /> Valore predefinito: <code>false</code>. </td>
    </tr>
    <tr>
      <td><code>isSReadable</code></td>
      <td> <code>@Input() isSReadable: boolean | null;</code><br /> Booleano che indica se il menu a discesa è accessibile alle tecnologie assistive, come i lettori di schermo, includendo eventualmente etichette aggiuntive accanto alle icone delle azioni.<br /> Valore predefinito: <code>false</code>. </td>
    </tr>
    <tr>
      <td><code>actions</code></td>
      <td><code>@Input('actions') set calculateActionForRow(actionsInput: ActionItem[])  {...}</code><br /> Elenco di azioni configurabili per il menu a discesa. Le azioni vengono calcolate dinamicamente per ogni riga o contesto specifico.<br />
          <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>. </td>
    </tr>
    <tr>
      <td><code>tooltipPlacement</code></td>
      <td> <code>@Input() tooltipPlacement: TooltipPlaceType = TooltipPlacementEnum.LEFT;</code><br /> Specifica la posizione del tooltip rispetto all'azione. Il valore predefinito è <code>LEFT</code>. 
      <br />
      <ul>
      <li><a href="?path=/docs/resources-models-tooltipplacetype--docs">TooltipPlaceType</a></li>
      <li><a href="?path=/docs/resources-models-tooltipplacementenum--docs">TooltipPlacementEnum</a></li>
      </ul> </td>
    </tr>
  </tbody>
</table>
</div>

<br />
<br />

<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Event</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
  <tr>
      <td><code>focusOut</code></td>
      <td> <code>@Output() focusOut = new EventEmitter&lt;null&gt;;</code><br /> Evento emesso quando il componente perde il focus. Può essere utilizzato per gestire comportamenti personalizzati durante l'interazione con il dropdown. </td>
    </tr>
 </tbody>
 </table>
 </div>
