# AdvancedTab

Documentazione dettagliata dell' oggetto custom  **AdvancedTab**, usato nei componenti di Internet Webkit v17. 
**AdvancedTab** si usa per creare un tab con più attributi del <a href="?path=/docs/resources-models-tab--docs">Tab semplice</a>.

## Implementazione
<div class="table-responsive">`import { AdvancedTab } from '@inail/internet-webkit/tabs';`</div>
<br />

***Struttura:***
`constructor(
	id: number,
	title: string,
	hasError: boolean,
	disable: boolean,
	templateNo: any,
	options: AdvancedTabOptions = {}
) {
  super(id, title, hasError, disable, templateNo);
	this.icon = options.icon;
}`

***Esempio d'uso:***
`new AdvancedTab(1, 'TITLE.TAB_1', false, false, 1)`

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>id</code></td>
      <td>
        Campo numerico che imposta un ID al tab.
      </td>
    </tr>
    <tr>
      <td><code>title</code></td>
      <td>
        Campo di tipo `string` che imposta il titolo del tab creato.
      </td>
    </tr>
    <tr>
      <td><code>hasError</code></td>
      <td>
        Booleano che quando è `true` mostra un errore nel tab.
      </td>
    </tr>
    <tr>
      <td><code>disable</code></td>
      <td>
        Booleano che quando è  `true` disabilita il tab.
      </td>
    </tr>
    <tr>
      <td><code>templateNo</code></td>
      <td>
        Campo che imposta l' index (partendo da 1) del template che viene visualizzato nel tab corrente. I template sono in un array di `TemplateRef` che contiene referenze a degli `<ng-template #id>`, dove l' `#id` serve come referenza per il input `[templates]="[id]"`.
      </td>
    </tr>
    <tr>
      <td><code>options</code></td>
      <td>
        Oggetto di tipo `AdvancedTabOptions`. Questo è un' interfaccia semplice, che contiene solo un campo di tipo `string` che imposta un'icona al tab creato tramite la classe `AdvancedTab`.
        `interface AdvancedTabOptions {
	      icon?: string;
}`
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-tabs-tabs--tabs">Tabs</a>
