$(document).ready(function () {

    let $inputFrom = $('input[data-input-type="number-interval-from"]');
    let $inputTo = $('input[data-input-type="number-interval-to"]');
    let valueFrom;
    let valueTo;
    let $spanFrom = $("#span-from")
    let $spanTo = $("#span-to");
    let $labelFrom = $("#label-from")
    let $labelTo = $("#label-to");

    $inputFrom.on('input', function () {
        valueFrom = Number($inputFrom.val());
        if (/[^0-9.]/.test(valueFrom)) {
            $spanFrom.html(`<strong>ERRORE: Inserire solo valori numerici</strong>`);
            $labelFrom.css("color", "#C9291B");
            $labelFrom.css("fontWeight", "bold");
            $inputFrom.css("border","1px solid #C9291B")
        } else {
            $spanFrom.html(``);
            $labelFrom.css("color", "#000");
            $labelFrom.css("fontWeight", "normal");
            $inputFrom.css("border","1px solid #afafaf")
        }
        checkInterval()
    });

    $inputTo.on('input', function () {
        valueTo = Number($inputTo.val());
        if (/[^0-9.]/.test(valueTo)) {
            $spanTo.html(`ERRORE: Inserire solo valori numerici`);
            $labelTo.css("color", "#C9291B");
            $labelTo.css("fontWeight", "bold");
            $inputTo.css("border","1px solid #C9291B")
        } else {
            $spanTo.html(``);
            $labelTo.css("color", "#000");
            $labelTo.css("fontWeight", "normal");
            $inputTo.css("border","1px solid #afafaf")
        }
        checkInterval()
    });

    checkInterval = function () {
        let $errorMessage = $("#errorMessage");

        if (!/[^0-9.]/.test(valueFrom) && !/[^0-9.]/.test(valueTo)) {
            if (valueFrom > valueTo) {
            $errorMessage.html(`<i class="fa-solid fa-circle-exclamation"></i> ERRORE: Intervallo non corretto`)
            $labelTo.css("color", "#C9291B");
            $labelTo.css("fontWeight", "bold");
            $inputTo.css("border","1px solid #C9291B")
            $labelFrom.css("color", "#C9291B");
            $labelFrom.css("fontWeight", "bold");
            $inputFrom.css("border","1px solid #C9291B")
            }
            else {
            $errorMessage.html("")
            $labelTo.css("color", "#000");
            $labelTo.css("fontWeight", "normal");
            $inputTo.css("border","1px solid #afafaf")
            $labelFrom.css("color", "#000");
            $labelFrom.css("fontWeight", "normal");
            $inputFrom.css("border","1px solid #afafaf")
            }
        }
    }

})