/* $(document).ready(function() {
    // Inizializza il tooltip con posizionamento a destra
    $('#dropdownButton').tooltip({
        placement: "right"
    });

    let dropdownButton = $('#dropdownButton');
    let dropdown = $('.dropdown');

    // Gestisce l'apertura del dropdown con Enter o Space
    dropdownButton.on('keydown', function(e) {
        if (e.key === "Enter") {
            e.preventDefault();
            $(this).trigger("click"); // Simula il click per aprire il dropdown
        } else if (e.key === " ") {
            e.preventDefault();
            $(this).dropdown('toggle');
        }
    });

    dropdown.on('shown.bs.dropdown', function () {
        let items = $(this).find('.dropdown-item');
        let index = -1;

        $(this).on('keydown', function(e) {
            if (e.key === "ArrowDown") {
                e.preventDefault();
                index = (index + 1) % items.length;
                items.eq(index).focus();
            } else if (e.key === "ArrowUp") {
                e.preventDefault();
                index = (index - 1 + items.length) % items.length;
                items.eq(index).focus();
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (index >= 0) {
                    items.eq(index).click();
                }
            } else if (e.key === "Escape") {
                dropdownButton.dropdown('toggle'); // Chiude il menu
                dropdownButton.focus(); // Riporta il focus sul bottone
            }
        });
    });

    // Quando il dropdown si chiude, riassegna il focus al bottone
    dropdown.on('hidden.bs.dropdown', function () {
        dropdownButton.focus();
    }); 
    
});*/

















/* $(document).ready(function () {

    // Gestisce i dropdown manualmente
    $(".dropdown").each(function () {
        var $dropdown = $(this);
        var $button = $dropdown.find(".dropdown-toggle");
        var $menu = $dropdown.find(".dropdown-menu");

        $button.on("click", function (event) {
            event.stopPropagation();
            toggleDropdown($menu);
        });

        $(document).on("click", function () {
            closeAllDropdowns();
        });
    });

    function toggleDropdown($menu) {
        var isOpen = $menu.hasClass("show");
        closeAllDropdowns();
        if (!isOpen) {
            $menu.addClass("show").show();
        }
    }

    function closeAllDropdowns() {
        $(".dropdown-menu.show").removeClass("show").hide();
    }

}); */














$(document).ready(function () {
    // Gestisce i dropdown manualmente
    $(".dropdown").each(function () {
        var $dropdown = $(this);
        var $button = $dropdown.find(".dropdown-toggle");
        var $menu = $dropdown.find(".dropdown-menu");
        var $items = $menu.find(".dropdown-item");

        $button.on("click", function (event) {
            event.stopPropagation();
            toggleDropdown($menu);
            $items.first().focus(); // Focus sul primo elemento quando il dropdown si apre
        });

        $(document).on("click", function () {
            closeAllDropdowns();
        });

        $menu.on("keydown", function (event) {
            event.stopPropagation(); // Impedisce la chiusura del dropdown
            var $focusedItem = $(document.activeElement);
            switch (event.key) {
                case "ArrowUp":
                    event.preventDefault();
                    var nextItem = $focusedItem.next(".dropdown-item");
                    if (nextItem.length) {
                        nextItem.focus();
                    } else {
                        $items.first().focus(); // Torna al primo elemento se si è all'ultimo
                    }
                    break;
                case "ArrowDown":
                    event.preventDefault();
                    var prevItem = $focusedItem.prev(".dropdown-item");
                    if (prevItem.length) {
                        prevItem.focus();
                    } else {
                        $items.last().focus(); // Torna all'ultimo elemento se si è al primo
                    }
                    break;
                case "Escape":
                    closeAllDropdowns();
                    $button.focus();
                    break;
            }
        });
    });

    function toggleDropdown($menu) {
        var isOpen = $menu.hasClass("show");
        closeAllDropdowns();
        if (!isOpen) {
            $menu.addClass("show").show();
        }
    }

    function closeAllDropdowns() {
        $(".dropdown-menu.show").removeClass("show").hide();
    }
});


