## CARATTERISTICHE PRINCIPALI

### Funzionalità chiave

* Visualizzazione del calendario con giorni della settimana e date
* Selezione di una singola data o di un intervallo di date
* Supporto per la navigazione attraverso i mesi e gli anni

### Aspetti tecnici rilevanti

* Implementato utilizzando tecnologie web standard (HTML, CSS, JavaScript)
* Utilizza librerie Angular per il rendering dinamico del calendario
* Supporta la personalizzazione dei formati di data tramite l'utilizzo di pattern specifici

### Caratteristiche di accessibilità

* Il componente è progettato per essere accessibile aiutando gli utenti con disabilità motorie o visive.
* Supporta le funzionalità di accessibilità standard del browser, come la navigazione tramite tastiera e la lettura dello schermo.

## VARIANTI
Sono disponibili diverse varianti del componente per soddisfare esigenze specifiche:

### Variante 1: Selezione Data Singola
Descrizione: Consente all'utente di selezionare una singola data.
Casi d'uso: Registrazione evento, pianificazione appuntamento.

### Variante 2: Selezione Intervallo Date
Descrizione: Permette la selezione di un intervallo di date.
Casi d'uso: Prenotazione hotel, pianificazione viaggio.

### Variante 3: Selezione Data con Orario
Descrizione: Consente all'utente di selezionare una data e un orario specifico.
Casi d'uso: Pianificazione riunioni, registrazione evento con orario preciso.

## BEST PRACTICES

* Utilizzare il componente in contesti dove la selezione della data è fondamentale per l'esperienza utente.
* Personalizzare i formati di data e le opzioni di configurazione per adattarsi alle esigenze specifiche dell'applicazione.
* Assicurarsi che il componente sia accessibile e rispetti le linee guida di accessibilità del progetto.

## COMPONENTI CORRELATI
Il componente di selezione data può essere utilizzato in combinazione con altri elementi per creare un'esperienza utente completa:

* Componente di input testuale per l'inserimento manuale della data.
* Componente di pulsanti per azioni specifiche relative alla data selezionata.

Note: Per ulteriori informazioni sulla personalizzazione e sull'utilizzo del componente, consultare la documentazione tecnica completa.

## ACCESSIBILITA'
Quando un form presenta un titolo visibile a schermo, è necessario aggiungere al tag `<form>` un attributo aria-labelledby. Questo attributo dovrà essere valorizzato con l'ID del contenitore del titolo visibile del form stesso, collegando così il form al suo nome testuale. Qualora un form venga implementato senza un titolo visibile a schermo, dovrà comunque essere "nominato" per gli screen reader. In questo specifico caso, andrà aggiunto al tag `<form>` un attributo aria-label, valorizzato con il nome descrittivo che si intende assegnare al form. Il `<fieldset>` deve essere inserito solo se il form ha più sezioni, e deve essere accompagnato da un `<legend>` (visibile o meno a schermata a seconda dei casi). Esempio: `<form aria-labelledby=”x”> 
<fieldset> 
<legend> Dati anagrafici </legend> 
Contenuto della sezione “Dati anagrafici” 
</fieldset>
 <fieldset>
<legend>Dati fiscali </legend>
 Contenuto della sezione “Dati fiscali”
  </fieldset> 
  </form>` 
  Se i titoli delle sezioni non devono essere visibile andrà aggiunta la classe `sr-only` al TAG `<legend>`

  Sono presenti due varianti principali di validazione:

- **Validazione immediata**: i campi vengono validati durante la compilazione, ovvero al \`valueChanges\`, fornendo feedback in tempo reale all’utente.
- **Validazione su submit e durante la compilazione**: i messaggi di errore vengono mostrati sia in fase di compilazione dei campi, sia al momento del submit se i campi non sono validi.

Angular prevede anche una modalità di validazione più mirata, pensata per quei casi in cui **alcuni controlli debbano essere validati solo al momento del submit**.  
Questo approccio è utile quando si vogliono eseguire verifiche che hanno senso solo a form completo (es. validazioni incrociate o logiche condizionali), evitando di mostrare errori prematuramente durante la compilazione.
