## CARATTERISTICHE PRINCIPALI

Il componente Content Init presenta le seguenti caratteristiche principali:

* Funzionalità chiave: indica l'inizio della pagina e fornisce un punto di riferimento per il contenuto
* Aspetti tecnici rilevanti: non sono presenti aspetti tecnici particolarmente rilevanti
* Caratteristiche di accessibilità: non sono presenti caratteristiche di accessibilità specifiche

## VARIANTI

Il componente Content Init presenta le seguenti varianti:

| Variante | Descrizione | Caso d'uso |
| --- | --- | --- |
| N.D. | Non sono disponibili informazioni sulle varianti del componente | N.D. |

## BEST PRACTICES

Per utilizzare al meglio il componente Content Init, si consiglia di:

* Utilizzarlo come punto di partenza per il contenuto della pagina
* Posizionarlo sotto il header
* Evitare di utilizzarlo in modo improprio o fuori contesto

## COMPONENTI CORRELATI

Il componente Content Init non presenta componenti associati specifici.

Nota: poiché non sono disponibili informazioni sulle varianti e sui componenti correlati, queste sezioni sono state marcate come "N.D." (Non Disponibile).

## OVERVIEW
<div class="table-responsive">`import { ContentInitComponent } from '@inail/internet-webkit/page-sections';`</div>

Il componente ContentInitComponent è utilizzato per indicare l'inizio del contenuto principale di una pagina. Questo componente viene generalmente posizionato sotto l'header della pagina e funge da segnaposto per identificare l'inizio del contenuto accessibile agli utenti, inclusi quelli che utilizzano tecnologie assistive come screen reader.

## API
<div class="table-responsive">
  <table class="table">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>message</code></td>
         <td>
            `@Input() message = 'MESSAGES.MAIN_CONTENT_INIT';` <br />
            Il controllo message rappresenta il testo che sarà mostrato all'interno del componente. È possibile passare una stringa personalizzata o una chiave di traduzione (ad esempio, per il supporto i18n).
         </td>
      </tr>
   </tbody>
</table>
</div>