$(document).ready(function () {
  let $inputs = $('input[data-input-type="currency"]');

  $inputs.on('input', function () {
    let value = $(this).val().replace(/[^0-9.]/g, ''); // Remove non-numeric characters except dot

    // Ensure only one decimal point is allowed
    let parts = value.split('.');
    if (parts.length > 2) {
      value = parts[0] + '.' + parts.slice(1).join('');
    }

    if (value.includes('.')) {
      let parts = value.split('.');
      parts[1] = parts[1].slice(0, 2); // Limit decimal part to 2 digits
      value = parts.join('.');
    }

    $(this).val(value);
  });

  $inputs.on('blur', function () {
    let value = $(this).val();

    // Ensure two decimal places
    if (value && !value.includes('.')) {
      value += '.00';
    } else if (value && value.charAt(value.length - 1) === '.') {
      value += '00';
    } else if (value.includes('.') && value.split('.')[1].length === 1) {
      value += '0';
    }

    // Replace decimal point with a comma
    value = value.replace('.', ',');

    $(this).val(value);
  });

  $inputs.on('focus', function () {
    let value = $(this).val();

    // Remove trailing ".00" if present
    if (value.endsWith(',00')) {
      value = value.slice(0, -3);
    }

    // Remove trailing zero if it's a decimal number like "1.10" -> "1.1"
    if (value.includes(',') && value.endsWith('0')) {
      value = value.replace(/\.?0+$/, '');
    } else if (value.includes(',') && !value.endsWith('0')) {
      value = value.replace(',', '.');
    }

    $(this).val(value);
  });
});