## CARATTERISTICHE PRINCIPALI
Il componente Form Date presenta le seguenti caratteristiche chiave:

* Funzionalità di inserimento della data: il componente consente agli utenti di inserire una data nel formato desiderato.
* Aspetti tecnici rilevanti: il componente utilizza un campo di testo per la raccolta della data e può essere configurato per accettare formati di data specifici.
* Caratteristiche di accessibilità: il componente è progettato per essere accessibile agli utenti con disabilità, grazie all'utilizzo di attributi ARIA e alla possibilità di navigazione mediante tastiera.

## VARIANTI
Le varianti disponibili per il componente Form Date sono:

* **Test della descrizione del input date**: questa variante presenta un campo di testo con una descrizione che indica come inserire la data.
* **N.D.** (nessuna altra variante disponibile)

Per ogni variante, i casi d'uso specifici sono:

* **Test della descrizione del input date**: utilizzare questo componente quando si desidera fornire agli utenti una guida chiara su come inserire la data.

## BEST PRACTICES
Le raccomandazioni per l'utilizzo del componente Form Date sono:

* Utilizzare un formato di data standardizzato per evitare ambiguità.
* Fornire una descrizione chiara e concisa per il campo di testo della data.
* Testare il componente con diverse combinazioni di date per assicurarsi che funzioni correttamente.

## COMPONENTI CORRELATI
Il componente Form Date può essere utilizzato in combinazione con altri componenti, come ad esempio:

* **Componente Calendar**: può essere utilizzato per fornire una visualizzazione grafica delle date e consentire agli utenti di selezionare una data.
* **Componente Button**: può essere utilizzato per fornire un pulsante di invio per la forma.

## OVERVIEW
<div class="table-responsive">`import { InputDateComponent } from '@inail/intranet-webkit/form-controls';`</div>
Questo componente rappresenta un campo di input doppio per date, che permette agli utenti di inserire una data di inizio e una data di fine. È completamente configurabile attraverso diverse proprietà come etichette, placeholder, validazioni e dimensioni. 


## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
  <tr>
      <td><code>regex</code></td>
      <td>
        `@Input() regex!: RegExp | string | string[];` <br />
        Modello regex per convalidare l'input della data.
       <ul>
            <li>
              Se il valore è un oggetto `RegExp`, significa che si sta passando un' espressione regolare JavaScript. Le espressioni regolari sono utilizzate per cercare e fare il matching di pattern all'interno di stringhe.
              `regex = /^[a-zA-Z]+$/;`
            </li>
            <li>
              Se il valore è una stringa, verrà trattato come una rappresentazione di un pattern. Quando la stringa viene utilizzata come regex, viene convertita internamente in una `RegExp` per eseguire operazioni di matching. 
              `regex = "^abc";`
            </li>
             <li>
              Se il valore è un array di stringhe, ciascun elemento dell'array rappresenta un pattern  da utilizzare separatamente per il matching.
              `regex = ["^abc", "xyz$"];`
            </li>
       </ul>  
      </td>
    </tr>
    <tr>
      <td><code>format</code></td>
      <td>
        `@Input() format: string;` <br />
        Definisce il formato di output della data.
      </td>
    </tr>
  <tr>
      <td><code>inline</code></td>
      <td>
        `@Input() inline: boolean;` <br />
        Determina se il selettore data viene visualizzato in linea o come finestra popup modale.
      </td>
    </tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class InputDateComponent extends BaseInputComponent` <br />
        La classe `InputDateComponent` estende <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent</a>
      </td>
    </tr>
     <tr>
      <td><code>size</code></td>
      <td>
      `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
      La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni di schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
      </td>
    </tr>
  </tbody>
</table>
</div>