(self.webpackChunkangular_storybook_project=self.webpackChunkangular_storybook_project||[]).push([[8792],{"./.storybook/preview.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";__webpack_require__.r(__webpack_exports__),__webpack_require__.d(__webpack_exports__,{default:()=>_storybook_preview});var angular=__webpack_require__("./node_modules/@storybook/addon-docs/angular/index.js");const documentation_namespaceObject=JSON.parse('{"pipes":[],"interfaces":[{"name":"BoxModel","id":"interface-BoxModel-683849dbea1c23c473a766bd4428ed56d700f64f11698d2c47b640667457cd2a986b2c0752bbad7d7d4c4b5735cf598bf138ea3b9c58ed5cc71f77110ba741a3","file":"src/common/shared/CSSAnalyzer.tsx","deprecated":false,"deprecationMessage":"","type":"interface","sourceCode":"import React, { useState, useEffect } from \\"react\\";\\nimport { AddonPanel } from \\"@storybook/components\\";\\n\\n// Define types for props and data structures\\ninterface PropertyProps {\\n  label: string;\\n  value: string | number;\\n}\\n\\ninterface StyleSectionProps {\\n  title: string;\\n  data: Record<string, string>;\\n}\\n\\ninterface CSSAnalyzerProps {\\n  active: boolean;\\n}\\n\\ninterface BoxModel {\\n  margin: { top: string; right: string; bottom: string; left: string };\\n  border: { top: string; right: string; bottom: string; left: string };\\n  padding: { top: string; right: string; bottom: string; left: string };\\n  content: { width: string; height: string };\\n  boxSizing?: string;\\n  display?: string;\\n  float: string;\\n  lineHeight: string;\\n  position: string;\\n  zIndex: string;\\n}\\n\\ninterface TableBoxModelProps {\\n  boxModel: BoxModel;\\n}\\n\\n// Property Component\\nconst Property: React.FC<PropertyProps> = ({ label, value }) => (\\n  <>\\n    <td\\n      style={{ border: \\"1px solid black\\", padding: \\"8px\\", textAlign: \\"left\\" }}\\n    >\\n      <strong>{label}</strong>\\n    </td>\\n    <td\\n      style={{ border: \\"1px solid black\\", padding: \\"8px\\", textAlign: \\"left\\" }}\\n    >\\n      {value}\\n    </td>\\n  </>\\n);\\n\\n// StyleSection Component\\nconst StyleSection: React.FC<StyleSectionProps> = ({ title, data }) => {\\n  const [expanded, setExpanded] = useState(false);\\n\\n  return (\\n    <div style={{ marginBottom: \\"10px\\" }}>\\n      <button\\n        style={{\\n          background: \\"#f0f0f0\\",\\n          border: \\"1px solid black\\",\\n          padding: \\"8px\\",\\n          width: \\"100%\\",\\n          cursor: \\"pointer\\",\\n          display: \\"flex\\",\\n          justifyContent: \\"space-between\\",\\n        }}\\n        onClick={() => setExpanded(!expanded)}\\n      >\\n        <span>{title}</span>\\n        <span>{expanded ? \\"▼\\" : \\"▶\\"}</span>\\n      </button>\\n      {expanded && (\\n        <table style={{ width: \\"100%\\", borderCollapse: \\"collapse\\" }}>\\n          <thead>\\n            <tr>\\n              <th style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                Property\\n              </th>\\n              <th style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                Attribute\\n              </th>\\n            </tr>\\n          </thead>\\n          <tbody>\\n            {Object.entries(data).map(([key, value]) => (\\n              <tr key={key}>\\n                <Property label={key} value={value} />\\n              </tr>\\n            ))}\\n          </tbody>\\n        </table>\\n      )}\\n    </div>\\n  );\\n};\\n\\n// TableBoxModel Component\\nconst TableBoxModel: React.FC<TableBoxModelProps> = ({ boxModel }) => {\\n  if (!boxModel || !boxModel.content) return null;\\n\\n  const { margin, border, padding, content } = boxModel;\\n\\n  const styles: Record<string, React.CSSProperties> = {\\n    bodyTest: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"center\\",\\n\\n      margin: 0,\\n      padding: 0,\\n      backgroundColor: \\"lightgray\\",\\n      fontFamily: \\"Arial, sans-serif\\",\\n    },\\n    container: {\\n      display: \\"flex\\",\\n      flexDirection: \\"column\\",\\n      alignItems: \\"center\\",\\n      width: \\"100%\\",\\n    },\\n    boxContent: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"flex-start\\", // Align items at the top\\n      position: \\"relative\\",\\n    },\\n    margin: {\\n      backgroundColor: \\"#73764a\\",\\n      padding: \\"24px 32px\\",\\n      position: \\"relative\\",\\n      border: \\"2px dashed #bcc900\\",\\n    },\\n    border: {\\n      backgroundColor: \\"#38383D\\",\\n      padding: \\"24px 32px\\",\\n    },\\n    padding: {\\n      backgroundColor: \\"#6657A6\\",\\n      padding: \\"24px 32px\\",\\n    },\\n    content: {\\n      backgroundColor: \\"#407AA4\\",\\n      width: \\"140px\\",\\n      height: \\"20px\\",\\n      border: \\"2px dashed #00b8ff\\",\\n      color: \\"white\\",\\n      fontWeight: \\"bold\\",\\n      textAlign: \\"center\\",\\n    },\\n    label: {\\n      position: \\"absolute\\",\\n      fontSize: \\"12px\\",\\n      background: \\"rgba(255, 255, 255, 0.8)\\",\\n      padding: \\"2px 5px\\",\\n      border: \\"1px solid black\\",\\n      borderRadius: \\"3px\\",\\n      pointerEvents: \\"none\\",\\n    },\\n    labelTop: {\\n      top: \\"-10px\\",\\n      left: \\"50%\\",\\n      transform: \\"translateX(-50%)\\",\\n    },\\n    labelBottom: {\\n      bottom: \\"-10px\\",\\n      left: \\"50%\\",\\n      transform: \\"translateX(-50%)\\",\\n    },\\n    labelLeft: {\\n      left: \\"-20px\\",\\n      top: \\"50%\\",\\n      transform: \\"translateY(-50%)\\",\\n      marginLeft: \\"2px\\",\\n      marginRight: \\"100px\\",\\n    },\\n    labelRight: {\\n      right: \\"-20px\\",\\n      top: \\"50%\\",\\n      transform: \\"translateY(-50%)\\",\\n    },\\n    labelText: {\\n      fontSize: \\"12px\\",\\n      fontWeight: \\"bold\\",\\n      marginRight: \\"10px\\", // Space between text and box\\n      alignSelf: \\"flex-start\\",\\n      position: \\"absolute\\",\\n      top: \\"0px\\", // Move text above the box\\n      zIndex: 99, // Ensure text is on top\\n      left: \\"15%\\",\\n      transform: \\"translateX(-50%)\\", // Center label horizontally\\n      color: \\"white\\",\\n    },\\n    rowContent: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"flex-start\\", // Align items to the top of the boxes\\n      marginTop: \\"20px\\",\\n      marginBottom: \\"20px\\",\\n      gap: \\"20px\\", // Space between the sections\\n      flexWrap: \\"wrap\\", // Allow wrapping for smaller screens\\n      padding: \\"0 10px\\",\\n    },\\n  };\\n\\n  return (\\n    <div style={{ textAlign: \\"center\\" }}>\\n      <h3>Box Model Representation</h3>\\n      <div style={styles[\\"bodyTest\\"]}>\\n        <div style={styles[\\"container\\"]}>\\n          {/* Horizontal Flexbox for Besi, Ana, and Ina */}\\n          <div style={styles[\\"rowContent\\"]}>\\n            {/* Ana Section */}\\n            <div style={styles[\\"boxContent\\"]}>\\n              <span style={styles[\\"labelText\\"]}>Margin</span>\\n              <div style={styles[\\"margin\\"]}>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}>\\n                  {margin.top}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelBottom\\"] }}>\\n                  {margin.bottom}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}>\\n                  {margin.left}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelRight\\"] }}>\\n                  {margin.right}\\n                </span>\\n                <div style={styles[\\"boxContent\\"]}>\\n                  <span style={styles[\\"labelText\\"]}>Border</span>\\n                  <div style={styles[\\"border\\"]}>\\n                    <span style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}>\\n                      {border.top}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelBottom\\"] }}\\n                    >\\n                      {border.bottom}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}\\n                    >\\n                      {border.left}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelRight\\"] }}\\n                    >\\n                      {border.right}\\n                    </span>\\n                    <div style={styles[\\"boxContent\\"]}>\\n                      <span style={styles[\\"labelText\\"]}>Padding</span>\\n                      <div style={styles[\\"padding\\"]}>\\n                        <span\\n                          style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}\\n                        >\\n                          {padding.top}\\n                        </span>\\n                        <span\\n                          style={{\\n                            ...styles[\\"label\\"],\\n                            ...styles[\\"labelBottom\\"],\\n                          }}\\n                        >\\n                          {padding.bottom}\\n                        </span>\\n                        <span\\n                          style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}\\n                        >\\n                          {padding.left}\\n                        </span>\\n                        <span\\n                          style={{\\n                            ...styles[\\"label\\"],\\n                            ...styles[\\"labelRight\\"],\\n                          }}\\n                        >\\n                          {padding.right}\\n                        </span>\\n                        <div style={styles[\\"content\\"]}>\\n                          {content.width} × {content.height}\\n                        </div>\\n                      </div>\\n                    </div>\\n                  </div>\\n                </div>\\n              </div>\\n            </div>\\n          </div>\\n        </div>\\n      </div>\\n\\n      {/* Box Model Information */}\\n      <div style={{ marginTop: \\"1rem\\", textAlign: \\"left\\", fontSize: \\"14px\\" }}>\\n        <table style={{ width: \\"100%\\", borderCollapse: \\"collapse\\" }}>\\n          <thead>\\n            <tr>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Property\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Attribute\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Top\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Right\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Bottom\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Left\\n              </th>\\n            </tr>\\n          </thead>\\n          <tbody>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Margin</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Border</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Padding</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Content Dimensions</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {content.width} × {content.height}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Box-sizing</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {boxModel.boxSizing}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n            </tr>\\n          </tbody>\\n        </table>\\n      </div>\\n    </div>\\n  );\\n};\\n\\n// Main CSSAnalyzer Component\\nconst CSSAnalyzer: React.FC<CSSAnalyzerProps> = ({ active }) => {\\n  const [selectedElement, setSelectedElement] =\\n    useState<HTMLElement | null>(null);\\n  const [computedStyles, setComputedStyles] = useState<Record<string, string>>(\\n    {}\\n  );\\n  const [elementName, setElementName] = useState<string>(\\"\\");\\n  const [boxModel, setBoxModel] = useState<BoxModel | null>(null);\\n\\n  useEffect(() => {\\n    const handleElementClick = (event: MouseEvent) => {\\n      event.preventDefault();\\n      event.stopPropagation();\\n\\n      const element = event.target as HTMLElement;\\n\\n      if (selectedElement) {\\n        selectedElement.style.outline = \\"none\\";\\n      }\\n\\n      element.style.outline = \\"2px solid #007acc\\";\\n      setSelectedElement(element);\\n      setElementName(element.tagName.toLowerCase());\\n      fetchComputedStyles(element);\\n    };\\n\\n    const fetchComputedStyles = (element: HTMLElement) => {\\n      const computedStyle = window.getComputedStyle(element);\\n      const boxModelData: BoxModel = {\\n        margin: {\\n          top: computedStyle.marginTop,\\n          right: computedStyle.marginRight,\\n          bottom: computedStyle.marginBottom,\\n          left: computedStyle.marginLeft,\\n        },\\n        border: {\\n          top: computedStyle.borderTopWidth,\\n          right: computedStyle.borderRightWidth,\\n          bottom: computedStyle.borderBottomWidth,\\n          left: computedStyle.borderLeftWidth,\\n        },\\n        padding: {\\n          top: computedStyle.paddingTop,\\n          right: computedStyle.paddingRight,\\n          bottom: computedStyle.paddingBottom,\\n          left: computedStyle.paddingLeft,\\n        },\\n        content: {\\n          width: computedStyle.width,\\n          height: computedStyle.height,\\n        },\\n        boxSizing: computedStyle.boxSizing,\\n        display: computedStyle.display,\\n        float: computedStyle.cssFloat,\\n        lineHeight: computedStyle.lineHeight,\\n        position: computedStyle.position,\\n        zIndex: computedStyle.zIndex,\\n      };\\n      const styleMap: Record<string, string> = {};\\n\\n      Array.from(computedStyle).forEach((property) => {\\n        styleMap[property] = computedStyle.getPropertyValue(property);\\n      });\\n\\n      setBoxModel(boxModelData);\\n      setComputedStyles(styleMap);\\n    };\\n\\n    if (active) {\\n      const iframe = document.querySelector(\\n        \\"#storybook-preview-iframe\\"\\n      ) as HTMLIFrameElement;\\n\\n      if (iframe?.contentDocument) {\\n        iframe.contentDocument.addEventListener(\\n          \\"click\\",\\n          handleElementClick,\\n          true\\n        );\\n\\n        // Return cleanup function\\n        return () => {\\n          iframe.contentDocument?.removeEventListener(\\n            \\"click\\",\\n            handleElementClick,\\n            true\\n          );\\n        };\\n      }\\n    }\\n\\n    // Explicitly return `undefined` if no cleanup is required\\n    return undefined;\\n  }, [active, selectedElement]);\\n\\n  const groupedStyles = Object.entries(computedStyles).reduce(\\n    (acc, [key, value]) => {\\n      const category = key.startsWith(\\"--\\")\\n        ? \\"CSS Variables\\"\\n        : key.startsWith(\\"background\\")\\n        ? \\"Background\\"\\n        : key.startsWith(\\"margin\\")\\n        ? \\"Margin\\"\\n        : key.startsWith(\\"padding\\")\\n        ? \\"Padding\\"\\n        : key.startsWith(\\"font\\")\\n        ? \\"Font\\"\\n        : key.startsWith(\\"border\\")\\n        ? \\"Border\\"\\n        : key.startsWith(\\"grid\\")\\n        ? \\"Grid\\"\\n        : key.startsWith(\\"text\\")\\n        ? \\"Text\\"\\n        : key.startsWith(\\"scroll\\") ||\\n          key.startsWith(\\"overscroll\\") ||\\n          key.startsWith(\\"overflow\\")\\n        ? \\"Scroll & Overflow\\"\\n        : key.startsWith(\\"-m\\") || key.startsWith(\\"-w\\")\\n        ? \\"Webkit\\"\\n        : \\"Other\\";\\n\\n      acc[category] = acc[category] || {};\\n      acc[category][key] = value;\\n      return acc;\\n    },\\n    {} as Record<string, Record<string, string>>\\n  );\\n\\n  return (\\n    <AddonPanel active={active}>\\n      <div style={{ padding: \\"10px\\" }}>\\n        <div>\\n          <h2>CSS Analyzer</h2>\\n          {elementName ? (\\n            <p>\\n              Selected Element: <strong>{elementName}</strong>\\n            </p>\\n          ): (\\n            <p>\\n              Clicca su un elemento per analizzarlo.\\n            </p>\\n          )}\\n        </div>\\n        <div\\n          style={{\\n            display: \\"flex\\",\\n            flexWrap: \\"wrap\\",\\n            padding: \\"10px\\",\\n            gap: \\"10px\\",\\n            alignItems: \\"stretch\\",\\n          }}\\n        >\\n          {boxModel && (\\n            <div\\n              style={{\\n                flex: \\"1 1 calc(50% - 10px)\\", // 50% width minus the gap\\n                minWidth: \\"400px\\",\\n                boxSizing: \\"border-box\\",\\n                display: \\"flex\\", // Ensure content fills the height\\n                flexDirection: \\"column\\",\\n              }}\\n            >\\n              <div style={{ top: 0, position: \\"sticky\\" }}>\\n                <TableBoxModel boxModel={boxModel} />\\n              </div>\\n            </div>\\n          )}\\n          {Object.entries(groupedStyles).length > 0 && (\\n            <div\\n              style={{\\n                flex: \\"1 1 calc(50% - 10px)\\", // 50% width minus the gap\\n                minWidth: \\"400px\\",\\n                boxSizing: \\"border-box\\",\\n                display: \\"flex\\", // Ensure content fills the height\\n                flexDirection: \\"column\\",\\n                textAlign: \\"center\\",\\n              }}\\n            >\\n              <h3>Css Computed Style</h3>\\n\\n              {Object.entries(groupedStyles).map(([group, styles]) => (\\n                <StyleSection key={group} title={group} data={styles} />\\n              ))}\\n            </div>\\n          )}\\n        </div>\\n      </div>\\n    </AddonPanel>\\n  );\\n};\\n\\nexport default CSSAnalyzer;\\n","properties":[{"name":"border","deprecated":false,"deprecationMessage":"","type":"literal type","indexKey":"","optional":false,"description":"","line":21},{"name":"boxSizing","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":true,"description":"","line":24},{"name":"content","deprecated":false,"deprecationMessage":"","type":"literal type","indexKey":"","optional":false,"description":"","line":23},{"name":"display","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":true,"description":"","line":25},{"name":"float","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":26},{"name":"lineHeight","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":27},{"name":"margin","deprecated":false,"deprecationMessage":"","type":"literal type","indexKey":"","optional":false,"description":"","line":20},{"name":"padding","deprecated":false,"deprecationMessage":"","type":"literal type","indexKey":"","optional":false,"description":"","line":22},{"name":"position","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":28},{"name":"zIndex","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":29}],"indexSignatures":[],"kind":171,"methods":[],"extends":[]},{"name":"CSSAnalyzerProps","id":"interface-CSSAnalyzerProps-683849dbea1c23c473a766bd4428ed56d700f64f11698d2c47b640667457cd2a986b2c0752bbad7d7d4c4b5735cf598bf138ea3b9c58ed5cc71f77110ba741a3","file":"src/common/shared/CSSAnalyzer.tsx","deprecated":false,"deprecationMessage":"","type":"interface","sourceCode":"import React, { useState, useEffect } from \\"react\\";\\nimport { AddonPanel } from \\"@storybook/components\\";\\n\\n// Define types for props and data structures\\ninterface PropertyProps {\\n  label: string;\\n  value: string | number;\\n}\\n\\ninterface StyleSectionProps {\\n  title: string;\\n  data: Record<string, string>;\\n}\\n\\ninterface CSSAnalyzerProps {\\n  active: boolean;\\n}\\n\\ninterface BoxModel {\\n  margin: { top: string; right: string; bottom: string; left: string };\\n  border: { top: string; right: string; bottom: string; left: string };\\n  padding: { top: string; right: string; bottom: string; left: string };\\n  content: { width: string; height: string };\\n  boxSizing?: string;\\n  display?: string;\\n  float: string;\\n  lineHeight: string;\\n  position: string;\\n  zIndex: string;\\n}\\n\\ninterface TableBoxModelProps {\\n  boxModel: BoxModel;\\n}\\n\\n// Property Component\\nconst Property: React.FC<PropertyProps> = ({ label, value }) => (\\n  <>\\n    <td\\n      style={{ border: \\"1px solid black\\", padding: \\"8px\\", textAlign: \\"left\\" }}\\n    >\\n      <strong>{label}</strong>\\n    </td>\\n    <td\\n      style={{ border: \\"1px solid black\\", padding: \\"8px\\", textAlign: \\"left\\" }}\\n    >\\n      {value}\\n    </td>\\n  </>\\n);\\n\\n// StyleSection Component\\nconst StyleSection: React.FC<StyleSectionProps> = ({ title, data }) => {\\n  const [expanded, setExpanded] = useState(false);\\n\\n  return (\\n    <div style={{ marginBottom: \\"10px\\" }}>\\n      <button\\n        style={{\\n          background: \\"#f0f0f0\\",\\n          border: \\"1px solid black\\",\\n          padding: \\"8px\\",\\n          width: \\"100%\\",\\n          cursor: \\"pointer\\",\\n          display: \\"flex\\",\\n          justifyContent: \\"space-between\\",\\n        }}\\n        onClick={() => setExpanded(!expanded)}\\n      >\\n        <span>{title}</span>\\n        <span>{expanded ? \\"▼\\" : \\"▶\\"}</span>\\n      </button>\\n      {expanded && (\\n        <table style={{ width: \\"100%\\", borderCollapse: \\"collapse\\" }}>\\n          <thead>\\n            <tr>\\n              <th style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                Property\\n              </th>\\n              <th style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                Attribute\\n              </th>\\n            </tr>\\n          </thead>\\n          <tbody>\\n            {Object.entries(data).map(([key, value]) => (\\n              <tr key={key}>\\n                <Property label={key} value={value} />\\n              </tr>\\n            ))}\\n          </tbody>\\n        </table>\\n      )}\\n    </div>\\n  );\\n};\\n\\n// TableBoxModel Component\\nconst TableBoxModel: React.FC<TableBoxModelProps> = ({ boxModel }) => {\\n  if (!boxModel || !boxModel.content) return null;\\n\\n  const { margin, border, padding, content } = boxModel;\\n\\n  const styles: Record<string, React.CSSProperties> = {\\n    bodyTest: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"center\\",\\n\\n      margin: 0,\\n      padding: 0,\\n      backgroundColor: \\"lightgray\\",\\n      fontFamily: \\"Arial, sans-serif\\",\\n    },\\n    container: {\\n      display: \\"flex\\",\\n      flexDirection: \\"column\\",\\n      alignItems: \\"center\\",\\n      width: \\"100%\\",\\n    },\\n    boxContent: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"flex-start\\", // Align items at the top\\n      position: \\"relative\\",\\n    },\\n    margin: {\\n      backgroundColor: \\"#73764a\\",\\n      padding: \\"24px 32px\\",\\n      position: \\"relative\\",\\n      border: \\"2px dashed #bcc900\\",\\n    },\\n    border: {\\n      backgroundColor: \\"#38383D\\",\\n      padding: \\"24px 32px\\",\\n    },\\n    padding: {\\n      backgroundColor: \\"#6657A6\\",\\n      padding: \\"24px 32px\\",\\n    },\\n    content: {\\n      backgroundColor: \\"#407AA4\\",\\n      width: \\"140px\\",\\n      height: \\"20px\\",\\n      border: \\"2px dashed #00b8ff\\",\\n      color: \\"white\\",\\n      fontWeight: \\"bold\\",\\n      textAlign: \\"center\\",\\n    },\\n    label: {\\n      position: \\"absolute\\",\\n      fontSize: \\"12px\\",\\n      background: \\"rgba(255, 255, 255, 0.8)\\",\\n      padding: \\"2px 5px\\",\\n      border: \\"1px solid black\\",\\n      borderRadius: \\"3px\\",\\n      pointerEvents: \\"none\\",\\n    },\\n    labelTop: {\\n      top: \\"-10px\\",\\n      left: \\"50%\\",\\n      transform: \\"translateX(-50%)\\",\\n    },\\n    labelBottom: {\\n      bottom: \\"-10px\\",\\n      left: \\"50%\\",\\n      transform: \\"translateX(-50%)\\",\\n    },\\n    labelLeft: {\\n      left: \\"-20px\\",\\n      top: \\"50%\\",\\n      transform: \\"translateY(-50%)\\",\\n      marginLeft: \\"2px\\",\\n      marginRight: \\"100px\\",\\n    },\\n    labelRight: {\\n      right: \\"-20px\\",\\n      top: \\"50%\\",\\n      transform: \\"translateY(-50%)\\",\\n    },\\n    labelText: {\\n      fontSize: \\"12px\\",\\n      fontWeight: \\"bold\\",\\n      marginRight: \\"10px\\", // Space between text and box\\n      alignSelf: \\"flex-start\\",\\n      position: \\"absolute\\",\\n      top: \\"0px\\", // Move text above the box\\n      zIndex: 99, // Ensure text is on top\\n      left: \\"15%\\",\\n      transform: \\"translateX(-50%)\\", // Center label horizontally\\n      color: \\"white\\",\\n    },\\n    rowContent: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"flex-start\\", // Align items to the top of the boxes\\n      marginTop: \\"20px\\",\\n      marginBottom: \\"20px\\",\\n      gap: \\"20px\\", // Space between the sections\\n      flexWrap: \\"wrap\\", // Allow wrapping for smaller screens\\n      padding: \\"0 10px\\",\\n    },\\n  };\\n\\n  return (\\n    <div style={{ textAlign: \\"center\\" }}>\\n      <h3>Box Model Representation</h3>\\n      <div style={styles[\\"bodyTest\\"]}>\\n        <div style={styles[\\"container\\"]}>\\n          {/* Horizontal Flexbox for Besi, Ana, and Ina */}\\n          <div style={styles[\\"rowContent\\"]}>\\n            {/* Ana Section */}\\n            <div style={styles[\\"boxContent\\"]}>\\n              <span style={styles[\\"labelText\\"]}>Margin</span>\\n              <div style={styles[\\"margin\\"]}>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}>\\n                  {margin.top}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelBottom\\"] }}>\\n                  {margin.bottom}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}>\\n                  {margin.left}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelRight\\"] }}>\\n                  {margin.right}\\n                </span>\\n                <div style={styles[\\"boxContent\\"]}>\\n                  <span style={styles[\\"labelText\\"]}>Border</span>\\n                  <div style={styles[\\"border\\"]}>\\n                    <span style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}>\\n                      {border.top}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelBottom\\"] }}\\n                    >\\n                      {border.bottom}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}\\n                    >\\n                      {border.left}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelRight\\"] }}\\n                    >\\n                      {border.right}\\n                    </span>\\n                    <div style={styles[\\"boxContent\\"]}>\\n                      <span style={styles[\\"labelText\\"]}>Padding</span>\\n                      <div style={styles[\\"padding\\"]}>\\n                        <span\\n                          style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}\\n                        >\\n                          {padding.top}\\n                        </span>\\n                        <span\\n                          style={{\\n                            ...styles[\\"label\\"],\\n                            ...styles[\\"labelBottom\\"],\\n                          }}\\n                        >\\n                          {padding.bottom}\\n                        </span>\\n                        <span\\n                          style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}\\n                        >\\n                          {padding.left}\\n                        </span>\\n                        <span\\n                          style={{\\n                            ...styles[\\"label\\"],\\n                            ...styles[\\"labelRight\\"],\\n                          }}\\n                        >\\n                          {padding.right}\\n                        </span>\\n                        <div style={styles[\\"content\\"]}>\\n                          {content.width} × {content.height}\\n                        </div>\\n                      </div>\\n                    </div>\\n                  </div>\\n                </div>\\n              </div>\\n            </div>\\n          </div>\\n        </div>\\n      </div>\\n\\n      {/* Box Model Information */}\\n      <div style={{ marginTop: \\"1rem\\", textAlign: \\"left\\", fontSize: \\"14px\\" }}>\\n        <table style={{ width: \\"100%\\", borderCollapse: \\"collapse\\" }}>\\n          <thead>\\n            <tr>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Property\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Attribute\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Top\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Right\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Bottom\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Left\\n              </th>\\n            </tr>\\n          </thead>\\n          <tbody>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Margin</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Border</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Padding</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Content Dimensions</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {content.width} × {content.height}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Box-sizing</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {boxModel.boxSizing}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n            </tr>\\n          </tbody>\\n        </table>\\n      </div>\\n    </div>\\n  );\\n};\\n\\n// Main CSSAnalyzer Component\\nconst CSSAnalyzer: React.FC<CSSAnalyzerProps> = ({ active }) => {\\n  const [selectedElement, setSelectedElement] =\\n    useState<HTMLElement | null>(null);\\n  const [computedStyles, setComputedStyles] = useState<Record<string, string>>(\\n    {}\\n  );\\n  const [elementName, setElementName] = useState<string>(\\"\\");\\n  const [boxModel, setBoxModel] = useState<BoxModel | null>(null);\\n\\n  useEffect(() => {\\n    const handleElementClick = (event: MouseEvent) => {\\n      event.preventDefault();\\n      event.stopPropagation();\\n\\n      const element = event.target as HTMLElement;\\n\\n      if (selectedElement) {\\n        selectedElement.style.outline = \\"none\\";\\n      }\\n\\n      element.style.outline = \\"2px solid #007acc\\";\\n      setSelectedElement(element);\\n      setElementName(element.tagName.toLowerCase());\\n      fetchComputedStyles(element);\\n    };\\n\\n    const fetchComputedStyles = (element: HTMLElement) => {\\n      const computedStyle = window.getComputedStyle(element);\\n      const boxModelData: BoxModel = {\\n        margin: {\\n          top: computedStyle.marginTop,\\n          right: computedStyle.marginRight,\\n          bottom: computedStyle.marginBottom,\\n          left: computedStyle.marginLeft,\\n        },\\n        border: {\\n          top: computedStyle.borderTopWidth,\\n          right: computedStyle.borderRightWidth,\\n          bottom: computedStyle.borderBottomWidth,\\n          left: computedStyle.borderLeftWidth,\\n        },\\n        padding: {\\n          top: computedStyle.paddingTop,\\n          right: computedStyle.paddingRight,\\n          bottom: computedStyle.paddingBottom,\\n          left: computedStyle.paddingLeft,\\n        },\\n        content: {\\n          width: computedStyle.width,\\n          height: computedStyle.height,\\n        },\\n        boxSizing: computedStyle.boxSizing,\\n        display: computedStyle.display,\\n        float: computedStyle.cssFloat,\\n        lineHeight: computedStyle.lineHeight,\\n        position: computedStyle.position,\\n        zIndex: computedStyle.zIndex,\\n      };\\n      const styleMap: Record<string, string> = {};\\n\\n      Array.from(computedStyle).forEach((property) => {\\n        styleMap[property] = computedStyle.getPropertyValue(property);\\n      });\\n\\n      setBoxModel(boxModelData);\\n      setComputedStyles(styleMap);\\n    };\\n\\n    if (active) {\\n      const iframe = document.querySelector(\\n        \\"#storybook-preview-iframe\\"\\n      ) as HTMLIFrameElement;\\n\\n      if (iframe?.contentDocument) {\\n        iframe.contentDocument.addEventListener(\\n          \\"click\\",\\n          handleElementClick,\\n          true\\n        );\\n\\n        // Return cleanup function\\n        return () => {\\n          iframe.contentDocument?.removeEventListener(\\n            \\"click\\",\\n            handleElementClick,\\n            true\\n          );\\n        };\\n      }\\n    }\\n\\n    // Explicitly return `undefined` if no cleanup is required\\n    return undefined;\\n  }, [active, selectedElement]);\\n\\n  const groupedStyles = Object.entries(computedStyles).reduce(\\n    (acc, [key, value]) => {\\n      const category = key.startsWith(\\"--\\")\\n        ? \\"CSS Variables\\"\\n        : key.startsWith(\\"background\\")\\n        ? \\"Background\\"\\n        : key.startsWith(\\"margin\\")\\n        ? \\"Margin\\"\\n        : key.startsWith(\\"padding\\")\\n        ? \\"Padding\\"\\n        : key.startsWith(\\"font\\")\\n        ? \\"Font\\"\\n        : key.startsWith(\\"border\\")\\n        ? \\"Border\\"\\n        : key.startsWith(\\"grid\\")\\n        ? \\"Grid\\"\\n        : key.startsWith(\\"text\\")\\n        ? \\"Text\\"\\n        : key.startsWith(\\"scroll\\") ||\\n          key.startsWith(\\"overscroll\\") ||\\n          key.startsWith(\\"overflow\\")\\n        ? \\"Scroll & Overflow\\"\\n        : key.startsWith(\\"-m\\") || key.startsWith(\\"-w\\")\\n        ? \\"Webkit\\"\\n        : \\"Other\\";\\n\\n      acc[category] = acc[category] || {};\\n      acc[category][key] = value;\\n      return acc;\\n    },\\n    {} as Record<string, Record<string, string>>\\n  );\\n\\n  return (\\n    <AddonPanel active={active}>\\n      <div style={{ padding: \\"10px\\" }}>\\n        <div>\\n          <h2>CSS Analyzer</h2>\\n          {elementName ? (\\n            <p>\\n              Selected Element: <strong>{elementName}</strong>\\n            </p>\\n          ): (\\n            <p>\\n              Clicca su un elemento per analizzarlo.\\n            </p>\\n          )}\\n        </div>\\n        <div\\n          style={{\\n            display: \\"flex\\",\\n            flexWrap: \\"wrap\\",\\n            padding: \\"10px\\",\\n            gap: \\"10px\\",\\n            alignItems: \\"stretch\\",\\n          }}\\n        >\\n          {boxModel && (\\n            <div\\n              style={{\\n                flex: \\"1 1 calc(50% - 10px)\\", // 50% width minus the gap\\n                minWidth: \\"400px\\",\\n                boxSizing: \\"border-box\\",\\n                display: \\"flex\\", // Ensure content fills the height\\n                flexDirection: \\"column\\",\\n              }}\\n            >\\n              <div style={{ top: 0, position: \\"sticky\\" }}>\\n                <TableBoxModel boxModel={boxModel} />\\n              </div>\\n            </div>\\n          )}\\n          {Object.entries(groupedStyles).length > 0 && (\\n            <div\\n              style={{\\n                flex: \\"1 1 calc(50% - 10px)\\", // 50% width minus the gap\\n                minWidth: \\"400px\\",\\n                boxSizing: \\"border-box\\",\\n                display: \\"flex\\", // Ensure content fills the height\\n                flexDirection: \\"column\\",\\n                textAlign: \\"center\\",\\n              }}\\n            >\\n              <h3>Css Computed Style</h3>\\n\\n              {Object.entries(groupedStyles).map(([group, styles]) => (\\n                <StyleSection key={group} title={group} data={styles} />\\n              ))}\\n            </div>\\n          )}\\n        </div>\\n      </div>\\n    </AddonPanel>\\n  );\\n};\\n\\nexport default CSSAnalyzer;\\n","properties":[{"name":"active","deprecated":false,"deprecationMessage":"","type":"boolean","indexKey":"","optional":false,"description":"","line":16}],"indexSignatures":[],"kind":171,"methods":[],"extends":[]},{"name":"IColor","id":"interface-IColor-ac376a0c3520a56d22d156d273adb3a9bac0ca0c07e9b3f9009cf7985054a8e9d57fca27b6d95729e06c621260f432370e01e07d7d26684d34caa63081c6eb7d","file":"src/stories/graphicStyles/Colors.tsx","deprecated":false,"deprecationMessage":"","type":"interface","sourceCode":"import { Meta, ColorPalette, ColorItem } from \\"@storybook/blocks\\";\\nimport React from \\"react\\";\\n\\nexport interface IColor {\\n  title: string;\\n  subtitle: string;\\n  colors: {\\n    [name: string]: string | any;\\n  };\\n}\\n\\nexport interface IColorPalette {\\n  [group: string]: {\\n    [colorKey: string]: IColor;\\n  };\\n}\\n\\nexport const ColorPaletteInail: IColorPalette = {\\n  primary: {\\n    blue: {\\n      title: \\"BLUE INAIL\\",\\n      subtitle:\\n        \\"Sfondo del menu Istituzionale di primo livello, titolo della pagina, sfondo della utility box nel menu secondario, sfondo tasti generici, controlli del carousel abilitati e testo dei tasti disabilitati.\\",\\n      colors: {\\n        blueInail: \\"#002E5F\\",\\n      },\\n    },\\n    verde: {\\n      title: \\"VERDE INAIL\\",\\n      subtitle: `Sfondo del menu utente, link di guida alla pagina/sezione e tasto \\"cambia immagine\\" del profilo.`,\\n      colors: {\\n        verdeInail: \\"#116766\\",\\n      },\\n    },\\n    azzurro: {\\n      title: \\"AZZURRO\\",\\n      subtitle: \\"Link e tasti-link.\\",\\n      colors: {\\n        azzurro: \\"#106CDB\\",\\n      },\\n    },\\n  },\\n  background: {\\n    grigio: {\\n      title: \\"Sfondi\\",\\n      subtitle: \\"Colori di sfondo\\",\\n      colors: {\\n        Form: \\"#F2F2F2\\",\\n        \\"Menu secondario\\": \\"#EAEDF2\\",\\n        \\"Sfondo Tab non attiva, intestazioni tabelle\\": \\"#E4E5E9\\",\\n        Bianco: \\"#FFFFFF\\",\\n      },\\n    },\\n  },\\n  status: {\\n    verde: {\\n      title: \\"VERDE\\",\\n      subtitle:\\n        \\"Da utilizzare per i feedback positivi e tasto per completare il processo nell\'ultimo step.\\",\\n      colors: {\\n        verde: \\"#0E821A\\",\\n      },\\n    },\\n    rosso: {\\n      title: \\"ROSSO\\",\\n      subtitle:\\n        \\"Etichetta, descrizione e bordo dei campi con errore, sfondo dei feedback negativi.\\",\\n      colors: {\\n        rosso: \\"#C9291B\\",\\n      },\\n    },\\n    arancio: {\\n      title: \\"ARANCIO\\",\\n      subtitle: \\"Da utilizzare per indicare lo stato intermedio.\\",\\n      colors: {\\n        arancio: \\"#FFAA02\\",\\n      },\\n    },\\n    giallo: {\\n      title: \\"GIALLO\\",\\n      subtitle: \\"\\",\\n      colors: {\\n        giallo: \\"#FFE377\\",\\n      },\\n    },\\n  },\\n};\\n\\nexport const displayColors = (colors: { [colorKey: string]: IColor }) => {\\n  return (\\n    <ColorPalette>\\n      {Object.entries(colors).map((element, index) => {\\n        return <ColorItem key={`${element[0]}-${index}`} {...element[1]} />;\\n      })}\\n    </ColorPalette>\\n  );\\n};\\n\\nexport const PrimaryColors = () => {\\n  return displayColors(ColorPaletteInail[\\"primary\\"]);\\n};\\n\\nexport const BackgroundColors = () => {\\n  return displayColors(ColorPaletteInail[\\"background\\"]);\\n};\\n\\nexport const StatusColors = () => {\\n  return displayColors(ColorPaletteInail[\\"status\\"]);\\n};\\n\\nexport const AccessibilityColor = () => {\\n  return (\\n    <div style={{ display: \\"flex\\", justifyContent: \\"space-between\\" }}>\\n      <div className=\\"accessibilita col-xs-12 col-sm-5 col-md-5\\">\\n        <h2 id=\\"accessibilita\\">Accessibilità</h2>\\n\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span>\\n              <em>Testo</em>\\n            </span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span>\\n              <em>Sfondo</em>\\n            </span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#002E5F\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#002E5F</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#116766\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#116766</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#000000\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#000000</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#E4E5E9\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#E4E5E9</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#002E5F\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#002E5F</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#EAEDF2\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#EAEDF2</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#000000\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#000000</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#EAEDF2\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#EAEDF2</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#000000\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#000000</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#F2F2F2\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#F2F2F2</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#000000\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#000000</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n        </div>\\n      </div>\\n\\n      <div className=\\"accessibilita col-xs-12 col-sm-5 col-md-5\\">\\n        <h2 id=\\"abbinamenti-accessibili\\">Abbinamenti accessibili</h2>\\n\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span>\\n              <em>Testo</em>\\n            </span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span>\\n              <em>Sfondo</em>\\n            </span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc azzurroInail\\"\\n              style={{\\n                backgroundColor:\\n                  ColorPaletteInail[\\"primary\\"][\\"azzurro\\"].colors[\\"azzurro\\"],\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#106CDB</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc verdeColor\\"\\n              style={{\\n                backgroundColor: ColorPaletteInail[\\"status\\"][\\"verde\\"].colors[\\"verde\\"],\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#0E821A</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc rossoColor\\"\\n              style={{\\n                backgroundColor: ColorPaletteInail[\\"status\\"][\\"rosso\\"].colors[\\"rosso\\"],\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#C9291B</span>\\n          </div>\\n        </div>\\n      </div>\\n    </div>\\n  );\\n};\\n","properties":[{"name":"colors","deprecated":false,"deprecationMessage":"","type":"literal type","indexKey":"","optional":false,"description":"","line":7},{"name":"subtitle","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":6},{"name":"title","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":5}],"indexSignatures":[],"kind":171,"methods":[],"extends":[]},{"name":"IColorPalette","id":"interface-IColorPalette-ac376a0c3520a56d22d156d273adb3a9bac0ca0c07e9b3f9009cf7985054a8e9d57fca27b6d95729e06c621260f432370e01e07d7d26684d34caa63081c6eb7d","file":"src/stories/graphicStyles/Colors.tsx","deprecated":false,"deprecationMessage":"","type":"interface","sourceCode":"import { Meta, ColorPalette, ColorItem } from \\"@storybook/blocks\\";\\nimport React from \\"react\\";\\n\\nexport interface IColor {\\n  title: string;\\n  subtitle: string;\\n  colors: {\\n    [name: string]: string | any;\\n  };\\n}\\n\\nexport interface IColorPalette {\\n  [group: string]: {\\n    [colorKey: string]: IColor;\\n  };\\n}\\n\\nexport const ColorPaletteInail: IColorPalette = {\\n  primary: {\\n    blue: {\\n      title: \\"BLUE INAIL\\",\\n      subtitle:\\n        \\"Sfondo del menu Istituzionale di primo livello, titolo della pagina, sfondo della utility box nel menu secondario, sfondo tasti generici, controlli del carousel abilitati e testo dei tasti disabilitati.\\",\\n      colors: {\\n        blueInail: \\"#002E5F\\",\\n      },\\n    },\\n    verde: {\\n      title: \\"VERDE INAIL\\",\\n      subtitle: `Sfondo del menu utente, link di guida alla pagina/sezione e tasto \\"cambia immagine\\" del profilo.`,\\n      colors: {\\n        verdeInail: \\"#116766\\",\\n      },\\n    },\\n    azzurro: {\\n      title: \\"AZZURRO\\",\\n      subtitle: \\"Link e tasti-link.\\",\\n      colors: {\\n        azzurro: \\"#106CDB\\",\\n      },\\n    },\\n  },\\n  background: {\\n    grigio: {\\n      title: \\"Sfondi\\",\\n      subtitle: \\"Colori di sfondo\\",\\n      colors: {\\n        Form: \\"#F2F2F2\\",\\n        \\"Menu secondario\\": \\"#EAEDF2\\",\\n        \\"Sfondo Tab non attiva, intestazioni tabelle\\": \\"#E4E5E9\\",\\n        Bianco: \\"#FFFFFF\\",\\n      },\\n    },\\n  },\\n  status: {\\n    verde: {\\n      title: \\"VERDE\\",\\n      subtitle:\\n        \\"Da utilizzare per i feedback positivi e tasto per completare il processo nell\'ultimo step.\\",\\n      colors: {\\n        verde: \\"#0E821A\\",\\n      },\\n    },\\n    rosso: {\\n      title: \\"ROSSO\\",\\n      subtitle:\\n        \\"Etichetta, descrizione e bordo dei campi con errore, sfondo dei feedback negativi.\\",\\n      colors: {\\n        rosso: \\"#C9291B\\",\\n      },\\n    },\\n    arancio: {\\n      title: \\"ARANCIO\\",\\n      subtitle: \\"Da utilizzare per indicare lo stato intermedio.\\",\\n      colors: {\\n        arancio: \\"#FFAA02\\",\\n      },\\n    },\\n    giallo: {\\n      title: \\"GIALLO\\",\\n      subtitle: \\"\\",\\n      colors: {\\n        giallo: \\"#FFE377\\",\\n      },\\n    },\\n  },\\n};\\n\\nexport const displayColors = (colors: { [colorKey: string]: IColor }) => {\\n  return (\\n    <ColorPalette>\\n      {Object.entries(colors).map((element, index) => {\\n        return <ColorItem key={`${element[0]}-${index}`} {...element[1]} />;\\n      })}\\n    </ColorPalette>\\n  );\\n};\\n\\nexport const PrimaryColors = () => {\\n  return displayColors(ColorPaletteInail[\\"primary\\"]);\\n};\\n\\nexport const BackgroundColors = () => {\\n  return displayColors(ColorPaletteInail[\\"background\\"]);\\n};\\n\\nexport const StatusColors = () => {\\n  return displayColors(ColorPaletteInail[\\"status\\"]);\\n};\\n\\nexport const AccessibilityColor = () => {\\n  return (\\n    <div style={{ display: \\"flex\\", justifyContent: \\"space-between\\" }}>\\n      <div className=\\"accessibilita col-xs-12 col-sm-5 col-md-5\\">\\n        <h2 id=\\"accessibilita\\">Accessibilità</h2>\\n\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span>\\n              <em>Testo</em>\\n            </span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span>\\n              <em>Sfondo</em>\\n            </span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#002E5F\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#002E5F</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#116766\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#116766</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#000000\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#000000</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#E4E5E9\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#E4E5E9</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#002E5F\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#002E5F</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#EAEDF2\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#EAEDF2</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#000000\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#000000</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#EAEDF2\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#EAEDF2</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#000000\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#000000</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#F2F2F2\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#F2F2F2</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#000000\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#000000</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n        </div>\\n      </div>\\n\\n      <div className=\\"accessibilita col-xs-12 col-sm-5 col-md-5\\">\\n        <h2 id=\\"abbinamenti-accessibili\\">Abbinamenti accessibili</h2>\\n\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span>\\n              <em>Testo</em>\\n            </span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span>\\n              <em>Sfondo</em>\\n            </span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc azzurroInail\\"\\n              style={{\\n                backgroundColor:\\n                  ColorPaletteInail[\\"primary\\"][\\"azzurro\\"].colors[\\"azzurro\\"],\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#106CDB</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc verdeColor\\"\\n              style={{\\n                backgroundColor: ColorPaletteInail[\\"status\\"][\\"verde\\"].colors[\\"verde\\"],\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#0E821A</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc rossoColor\\"\\n              style={{\\n                backgroundColor: ColorPaletteInail[\\"status\\"][\\"rosso\\"].colors[\\"rosso\\"],\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#C9291B</span>\\n          </div>\\n        </div>\\n      </div>\\n    </div>\\n  );\\n};\\n","properties":[],"indexSignatures":[{"id":"index-declaration-ac376a0c3520a56d22d156d273adb3a9bac0ca0c07e9b3f9009cf7985054a8e9d57fca27b6d95729e06c621260f432370e01e07d7d26684d34caa63081c6eb7d","args":[{"name":"group","type":"string","deprecated":false,"deprecationMessage":""}],"returnType":"literal type","line":12,"deprecated":false,"deprecationMessage":""}],"kind":181,"methods":[],"extends":[]},{"name":"Icon","id":"interface-Icon-c64db8a87679f312a69a620e5692d774363798b79b73b27d94490d6797dc20596dbeee8ee5325b5796f4be611097bd0aabbf89d58d5ac021f032927830afdc53","file":"src/stories/graphicStyles/Icons.tsx","deprecated":false,"deprecationMessage":"","type":"interface","sourceCode":"import { IconGallery, IconItem } from \\"@storybook/blocks\\";\\nimport React from \\"react\\";\\n\\nexport interface IconDetails {\\n  class: string;\\n  functionality: string;\\n}\\n\\nexport interface Icon {\\n  [name: string]: IconDetails;\\n}\\n\\nexport const ShowIcons: Icon = {\\n  trash: {\\n    class: \\"i-trash icon\\",\\n    functionality: \\"Rimuovi elemento\\",\\n  },\\n  pencil: {\\n    class: \\"i-pencil icon\\",\\n    functionality: \\"Modifica elemento\\",\\n  },\\n  question: {\\n    class: \\"i-question-circle icon\\",\\n    functionality: \\"Visualizza informazioni\\",\\n  },\\n  eye: {\\n    class: \\"i-eye icon\\",\\n    functionality: \\"Visualizza nel dettaglio l\'elemento\\",\\n  },\\n  chevronDown: {\\n    class: \\"i-chevron-down icon\\",\\n    functionality: \\"Espandi/Riduci la riga\\",\\n  },\\n  plus: {\\n    class: \\"i-plus icon\\",\\n    functionality: \\"Aggiungi elementi\\",\\n  },\\n  plusCircle: {\\n    class: \\"i-plus-circle icon\\",\\n    functionality: \\"Espandi elemento\\",\\n  },\\n  download: {\\n    class: \\"i-download icon\\",\\n    functionality: \\"Scarica elemento\\",\\n  },\\n  triangle: {\\n    class: \\"i-exclamation-triangle icon\\",\\n    functionality:\\n      \\"Attenzione (warning). Il conflitto/errore è visualizzabile tramite tooltip al click sull\'icona\\",\\n  },\\n  euro: {\\n    class: \\"i-eur icon\\",\\n    functionality: \\"Visualizza pagamenti\\",\\n  },\\n  fileText: {\\n    class: \\"i-file-text-o icon\\",\\n    functionality: \\"Visualizza provvedimenti\\",\\n  },\\n  filePdf: {\\n    class: \\"i-file-pdf-o icon\\",\\n    functionality: \\"Scarica .PDF\\",\\n  },\\n  fileDoc: {\\n    class: \\"i-file-word-o icon\\",\\n    functionality: \\"Scarica .DOC\\",\\n  },\\n  fileExcel: {\\n    class: \\"i-file-excel-o icon\\",\\n    functionality: \\"Scarica .XLS\\",\\n  },\\n  filePowerpoint: {\\n    class: \\"i-file-powerpoint-o icon\\",\\n    functionality: \\"Scarica .PPT\\",\\n  },\\n  star: {\\n    class: \\"i-star icon\\",\\n    functionality:\\n      \\"Aggiungi/rimuovi dai preferiti. Selezionabile e deselezionabile come una checkbox\\",\\n  },\\n  paperclip: {\\n    class: \\"i-paperclip icon\\",\\n    functionality: \\"Presenza di allegati\\",\\n  },\\n};\\n\\nconst Icons = () => {\\n  return (\\n    <IconGallery>\\n      {Object.entries(ShowIcons).map((element, index) => {\\n        return (\\n          <IconItem name={element[1].class}>\\n            {/* <div\\n              title={element[1].functionality}\\n              style={{\\n                content: \\"\\",\\n                position: \\"absolute\\",\\n                top: 0,\\n                left: 0,\\n                width: \\"100%\\",\\n                height: \\"100%\\",\\n              }}\\n            /> */}\\n\\n            <i\\n              className={element[1].class}\\n              title={element[1].functionality}\\n            ></i>\\n          </IconItem>\\n        );\\n      })}\\n    </IconGallery>\\n  );\\n};\\n\\nexport default Icons;\\n","properties":[],"indexSignatures":[{"id":"index-declaration-c64db8a87679f312a69a620e5692d774363798b79b73b27d94490d6797dc20596dbeee8ee5325b5796f4be611097bd0aabbf89d58d5ac021f032927830afdc53","args":[{"name":"name","type":"string","deprecated":false,"deprecationMessage":""}],"returnType":"IconDetails","line":9,"deprecated":false,"deprecationMessage":""}],"kind":181,"methods":[],"extends":[]},{"name":"IconDetails","id":"interface-IconDetails-c64db8a87679f312a69a620e5692d774363798b79b73b27d94490d6797dc20596dbeee8ee5325b5796f4be611097bd0aabbf89d58d5ac021f032927830afdc53","file":"src/stories/graphicStyles/Icons.tsx","deprecated":false,"deprecationMessage":"","type":"interface","sourceCode":"import { IconGallery, IconItem } from \\"@storybook/blocks\\";\\nimport React from \\"react\\";\\n\\nexport interface IconDetails {\\n  class: string;\\n  functionality: string;\\n}\\n\\nexport interface Icon {\\n  [name: string]: IconDetails;\\n}\\n\\nexport const ShowIcons: Icon = {\\n  trash: {\\n    class: \\"i-trash icon\\",\\n    functionality: \\"Rimuovi elemento\\",\\n  },\\n  pencil: {\\n    class: \\"i-pencil icon\\",\\n    functionality: \\"Modifica elemento\\",\\n  },\\n  question: {\\n    class: \\"i-question-circle icon\\",\\n    functionality: \\"Visualizza informazioni\\",\\n  },\\n  eye: {\\n    class: \\"i-eye icon\\",\\n    functionality: \\"Visualizza nel dettaglio l\'elemento\\",\\n  },\\n  chevronDown: {\\n    class: \\"i-chevron-down icon\\",\\n    functionality: \\"Espandi/Riduci la riga\\",\\n  },\\n  plus: {\\n    class: \\"i-plus icon\\",\\n    functionality: \\"Aggiungi elementi\\",\\n  },\\n  plusCircle: {\\n    class: \\"i-plus-circle icon\\",\\n    functionality: \\"Espandi elemento\\",\\n  },\\n  download: {\\n    class: \\"i-download icon\\",\\n    functionality: \\"Scarica elemento\\",\\n  },\\n  triangle: {\\n    class: \\"i-exclamation-triangle icon\\",\\n    functionality:\\n      \\"Attenzione (warning). Il conflitto/errore è visualizzabile tramite tooltip al click sull\'icona\\",\\n  },\\n  euro: {\\n    class: \\"i-eur icon\\",\\n    functionality: \\"Visualizza pagamenti\\",\\n  },\\n  fileText: {\\n    class: \\"i-file-text-o icon\\",\\n    functionality: \\"Visualizza provvedimenti\\",\\n  },\\n  filePdf: {\\n    class: \\"i-file-pdf-o icon\\",\\n    functionality: \\"Scarica .PDF\\",\\n  },\\n  fileDoc: {\\n    class: \\"i-file-word-o icon\\",\\n    functionality: \\"Scarica .DOC\\",\\n  },\\n  fileExcel: {\\n    class: \\"i-file-excel-o icon\\",\\n    functionality: \\"Scarica .XLS\\",\\n  },\\n  filePowerpoint: {\\n    class: \\"i-file-powerpoint-o icon\\",\\n    functionality: \\"Scarica .PPT\\",\\n  },\\n  star: {\\n    class: \\"i-star icon\\",\\n    functionality:\\n      \\"Aggiungi/rimuovi dai preferiti. Selezionabile e deselezionabile come una checkbox\\",\\n  },\\n  paperclip: {\\n    class: \\"i-paperclip icon\\",\\n    functionality: \\"Presenza di allegati\\",\\n  },\\n};\\n\\nconst Icons = () => {\\n  return (\\n    <IconGallery>\\n      {Object.entries(ShowIcons).map((element, index) => {\\n        return (\\n          <IconItem name={element[1].class}>\\n            {/* <div\\n              title={element[1].functionality}\\n              style={{\\n                content: \\"\\",\\n                position: \\"absolute\\",\\n                top: 0,\\n                left: 0,\\n                width: \\"100%\\",\\n                height: \\"100%\\",\\n              }}\\n            /> */}\\n\\n            <i\\n              className={element[1].class}\\n              title={element[1].functionality}\\n            ></i>\\n          </IconItem>\\n        );\\n      })}\\n    </IconGallery>\\n  );\\n};\\n\\nexport default Icons;\\n","properties":[{"name":"class","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":5},{"name":"functionality","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":6}],"indexSignatures":[],"kind":171,"methods":[],"extends":[]},{"name":"IMockData","id":"interface-IMockData-08b3deb30db36316f1bb69782c961d4fa5f825073298cd2167b351dcacc9b631fb128df4b633c555ba20992671dd8de8d17f336aca351521de68cc11c610b9cf","file":"src/stories/table/utils.ts","deprecated":false,"deprecationMessage":"","type":"interface","sourceCode":"export interface IMockData {\\n    id: number,\\n    name: string,\\n    lastName: string,\\n    age:number\\n}\\nexport function isIMockDataKey(key: string): key is keyof IMockData {\\n  return [\'id\', \'name\', \'lastName\', \'age\'].includes(key);\\n}\\nexport function generateRandomData(num: number) {\\n    const firstNames = [\\n      \'Giovanni\', \'Maria\', \'Luigi\', \'Francesca\', \'Alessandro\',\\n      \'Sofia\', \'Marco\', \'Giulia\', \'Lorenzo\', \'Chiara\',\\n      \'Giorgio\', \'Elena\', \'Paolo\', \'Serena\', \'Matteo\'\\n    ]; // 15 unique Italian first names\\n  \\n    const lastNames = [\\n      \'Rossi\', \'Bianchi\', \'Esposito\', \'Ricci\', \'Marino\',\\n      \'Greco\', \'Bruno\', \'Gallo\', \'Conti\', \'De Luca\',\\n      \'Costa\', \'Giordano\', \'Mancini\', \'Rizzo\', \'Lombardi\'\\n    ]; // 15 unique Italian last names\\n  \\n    // Generate all unique combinations of first and last names\\n    const combinations = [];\\n    for (const firstName of firstNames) {\\n      for (const lastName of lastNames) {\\n        combinations.push({ firstName, lastName });\\n      }\\n    }\\n  \\n    // Shuffle combinations to introduce randomness\\n    for (let i = combinations.length - 1; i > 0; i--) {\\n      const j = Math.floor(Math.random() * (i + 1));\\n      [combinations[i], combinations[j]] = [combinations[j], combinations[i]];\\n    }\\n  \\n    // Ensure we don\'t exceed the available unique combinations\\n    const totalCombinations = Math.min(num, combinations.length);\\n  \\n    const randomData: IMockData[] = [];\\n    for (let i = 1; i <= totalCombinations; i++) {\\n      const { firstName, lastName } = combinations[i - 1]; // Get the unique combination\\n      randomData.push({\\n        id: i,\\n        name: firstName,\\n        lastName: lastName,\\n        age: Math.floor(Math.random() * 50) + 20, // Random age between 20 and 69\\n      });\\n    }\\n  \\n    return randomData;\\n  }","properties":[{"name":"age","deprecated":false,"deprecationMessage":"","type":"number","indexKey":"","optional":false,"description":"","line":5},{"name":"id","deprecated":false,"deprecationMessage":"","type":"number","indexKey":"","optional":false,"description":"","line":2},{"name":"lastName","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":4},{"name":"name","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":3}],"indexSignatures":[],"kind":171,"methods":[],"extends":[]},{"name":"MdxReaderProps","id":"interface-MdxReaderProps-373d0861d3776f4d3297da2ff46a1f4da004b8d97a775ed80b65da965db712b8b8cd2e2e41cb006c3e810364cda14c619b8545a3a344595b6a1d9d527a5d0d96","file":"src/common/shared/mdx-reader-component/mdx-reader.tsx","deprecated":false,"deprecationMessage":"","type":"interface","sourceCode":"import { Markdown } from \\"@storybook/blocks\\";\\nimport React, { useEffect, useState } from \\"react\\";\\n\\ninterface MdxReaderProps {\\n  mdxPage: string;\\n}\\n\\nexport const MdxReader: React.FC<MdxReaderProps> = ({ mdxPage }) => {\\n  const [isExpanded, setIsExpanded] = useState(false);\\n  const [mdxContent, setMdxContent] = useState<string>(\\"\\");\\n\\n  useEffect(() => {\\n    setMdxContent(mdxPage);\\n  }, [mdxPage]);\\n\\n  return (\\n    <div\\n      id=\\"user-experience-carousel-box\\"\\n      className=\\"row accordion-gray content\\"\\n    >\\n      {/* Accordion Header */}\\n      <div\\n        className={`row head-accordion-gray ${!isExpanded ? \\"collapsed\\" : \\"\\"}`}\\n        aria-expanded={isExpanded}\\n        onClick={() => setIsExpanded(!isExpanded)}\\n      >\\n        <img\\n          src=\\"static-webkit/img/user_experience.png\\"\\n          alt=\\"Icona user experience\\"\\n        />\\n\\n        <div className=\\"accordion-title col-xs-7\\">\\n          <strong>User Experience</strong>\\n        </div>\\n\\n        <em\\n          className={`fa fa-2x expand-icon pull-right fa-${isExpanded ? \\"minus\\" : \\"plus\\"}-circle`}\\n          title={isExpanded ? \\"Comprimi elemento\\" : \\"Espandi elemento\\"}\\n        />\\n      </div>\\n\\n      {/* Accordion Content */}\\n      <div\\n        id=\\"user-experience-carousel-box-panel\\"\\n        className={`row panel-body collapse ${isExpanded ? \\"in\\" : \\"\\"}`}\\n        aria-expanded={isExpanded}\\n      >\\n        <div className=\\"panel-content\\">\\n          <Markdown>{mdxContent}</Markdown>\\n        </div>\\n      </div>\\n    </div>\\n  );\\n};\\n\\nexport default MdxReader;\\n","properties":[{"name":"mdxPage","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":5}],"indexSignatures":[],"kind":171,"methods":[],"extends":[]},{"name":"PropertyProps","id":"interface-PropertyProps-683849dbea1c23c473a766bd4428ed56d700f64f11698d2c47b640667457cd2a986b2c0752bbad7d7d4c4b5735cf598bf138ea3b9c58ed5cc71f77110ba741a3","file":"src/common/shared/CSSAnalyzer.tsx","deprecated":false,"deprecationMessage":"","type":"interface","sourceCode":"import React, { useState, useEffect } from \\"react\\";\\nimport { AddonPanel } from \\"@storybook/components\\";\\n\\n// Define types for props and data structures\\ninterface PropertyProps {\\n  label: string;\\n  value: string | number;\\n}\\n\\ninterface StyleSectionProps {\\n  title: string;\\n  data: Record<string, string>;\\n}\\n\\ninterface CSSAnalyzerProps {\\n  active: boolean;\\n}\\n\\ninterface BoxModel {\\n  margin: { top: string; right: string; bottom: string; left: string };\\n  border: { top: string; right: string; bottom: string; left: string };\\n  padding: { top: string; right: string; bottom: string; left: string };\\n  content: { width: string; height: string };\\n  boxSizing?: string;\\n  display?: string;\\n  float: string;\\n  lineHeight: string;\\n  position: string;\\n  zIndex: string;\\n}\\n\\ninterface TableBoxModelProps {\\n  boxModel: BoxModel;\\n}\\n\\n// Property Component\\nconst Property: React.FC<PropertyProps> = ({ label, value }) => (\\n  <>\\n    <td\\n      style={{ border: \\"1px solid black\\", padding: \\"8px\\", textAlign: \\"left\\" }}\\n    >\\n      <strong>{label}</strong>\\n    </td>\\n    <td\\n      style={{ border: \\"1px solid black\\", padding: \\"8px\\", textAlign: \\"left\\" }}\\n    >\\n      {value}\\n    </td>\\n  </>\\n);\\n\\n// StyleSection Component\\nconst StyleSection: React.FC<StyleSectionProps> = ({ title, data }) => {\\n  const [expanded, setExpanded] = useState(false);\\n\\n  return (\\n    <div style={{ marginBottom: \\"10px\\" }}>\\n      <button\\n        style={{\\n          background: \\"#f0f0f0\\",\\n          border: \\"1px solid black\\",\\n          padding: \\"8px\\",\\n          width: \\"100%\\",\\n          cursor: \\"pointer\\",\\n          display: \\"flex\\",\\n          justifyContent: \\"space-between\\",\\n        }}\\n        onClick={() => setExpanded(!expanded)}\\n      >\\n        <span>{title}</span>\\n        <span>{expanded ? \\"▼\\" : \\"▶\\"}</span>\\n      </button>\\n      {expanded && (\\n        <table style={{ width: \\"100%\\", borderCollapse: \\"collapse\\" }}>\\n          <thead>\\n            <tr>\\n              <th style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                Property\\n              </th>\\n              <th style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                Attribute\\n              </th>\\n            </tr>\\n          </thead>\\n          <tbody>\\n            {Object.entries(data).map(([key, value]) => (\\n              <tr key={key}>\\n                <Property label={key} value={value} />\\n              </tr>\\n            ))}\\n          </tbody>\\n        </table>\\n      )}\\n    </div>\\n  );\\n};\\n\\n// TableBoxModel Component\\nconst TableBoxModel: React.FC<TableBoxModelProps> = ({ boxModel }) => {\\n  if (!boxModel || !boxModel.content) return null;\\n\\n  const { margin, border, padding, content } = boxModel;\\n\\n  const styles: Record<string, React.CSSProperties> = {\\n    bodyTest: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"center\\",\\n\\n      margin: 0,\\n      padding: 0,\\n      backgroundColor: \\"lightgray\\",\\n      fontFamily: \\"Arial, sans-serif\\",\\n    },\\n    container: {\\n      display: \\"flex\\",\\n      flexDirection: \\"column\\",\\n      alignItems: \\"center\\",\\n      width: \\"100%\\",\\n    },\\n    boxContent: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"flex-start\\", // Align items at the top\\n      position: \\"relative\\",\\n    },\\n    margin: {\\n      backgroundColor: \\"#73764a\\",\\n      padding: \\"24px 32px\\",\\n      position: \\"relative\\",\\n      border: \\"2px dashed #bcc900\\",\\n    },\\n    border: {\\n      backgroundColor: \\"#38383D\\",\\n      padding: \\"24px 32px\\",\\n    },\\n    padding: {\\n      backgroundColor: \\"#6657A6\\",\\n      padding: \\"24px 32px\\",\\n    },\\n    content: {\\n      backgroundColor: \\"#407AA4\\",\\n      width: \\"140px\\",\\n      height: \\"20px\\",\\n      border: \\"2px dashed #00b8ff\\",\\n      color: \\"white\\",\\n      fontWeight: \\"bold\\",\\n      textAlign: \\"center\\",\\n    },\\n    label: {\\n      position: \\"absolute\\",\\n      fontSize: \\"12px\\",\\n      background: \\"rgba(255, 255, 255, 0.8)\\",\\n      padding: \\"2px 5px\\",\\n      border: \\"1px solid black\\",\\n      borderRadius: \\"3px\\",\\n      pointerEvents: \\"none\\",\\n    },\\n    labelTop: {\\n      top: \\"-10px\\",\\n      left: \\"50%\\",\\n      transform: \\"translateX(-50%)\\",\\n    },\\n    labelBottom: {\\n      bottom: \\"-10px\\",\\n      left: \\"50%\\",\\n      transform: \\"translateX(-50%)\\",\\n    },\\n    labelLeft: {\\n      left: \\"-20px\\",\\n      top: \\"50%\\",\\n      transform: \\"translateY(-50%)\\",\\n      marginLeft: \\"2px\\",\\n      marginRight: \\"100px\\",\\n    },\\n    labelRight: {\\n      right: \\"-20px\\",\\n      top: \\"50%\\",\\n      transform: \\"translateY(-50%)\\",\\n    },\\n    labelText: {\\n      fontSize: \\"12px\\",\\n      fontWeight: \\"bold\\",\\n      marginRight: \\"10px\\", // Space between text and box\\n      alignSelf: \\"flex-start\\",\\n      position: \\"absolute\\",\\n      top: \\"0px\\", // Move text above the box\\n      zIndex: 99, // Ensure text is on top\\n      left: \\"15%\\",\\n      transform: \\"translateX(-50%)\\", // Center label horizontally\\n      color: \\"white\\",\\n    },\\n    rowContent: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"flex-start\\", // Align items to the top of the boxes\\n      marginTop: \\"20px\\",\\n      marginBottom: \\"20px\\",\\n      gap: \\"20px\\", // Space between the sections\\n      flexWrap: \\"wrap\\", // Allow wrapping for smaller screens\\n      padding: \\"0 10px\\",\\n    },\\n  };\\n\\n  return (\\n    <div style={{ textAlign: \\"center\\" }}>\\n      <h3>Box Model Representation</h3>\\n      <div style={styles[\\"bodyTest\\"]}>\\n        <div style={styles[\\"container\\"]}>\\n          {/* Horizontal Flexbox for Besi, Ana, and Ina */}\\n          <div style={styles[\\"rowContent\\"]}>\\n            {/* Ana Section */}\\n            <div style={styles[\\"boxContent\\"]}>\\n              <span style={styles[\\"labelText\\"]}>Margin</span>\\n              <div style={styles[\\"margin\\"]}>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}>\\n                  {margin.top}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelBottom\\"] }}>\\n                  {margin.bottom}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}>\\n                  {margin.left}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelRight\\"] }}>\\n                  {margin.right}\\n                </span>\\n                <div style={styles[\\"boxContent\\"]}>\\n                  <span style={styles[\\"labelText\\"]}>Border</span>\\n                  <div style={styles[\\"border\\"]}>\\n                    <span style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}>\\n                      {border.top}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelBottom\\"] }}\\n                    >\\n                      {border.bottom}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}\\n                    >\\n                      {border.left}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelRight\\"] }}\\n                    >\\n                      {border.right}\\n                    </span>\\n                    <div style={styles[\\"boxContent\\"]}>\\n                      <span style={styles[\\"labelText\\"]}>Padding</span>\\n                      <div style={styles[\\"padding\\"]}>\\n                        <span\\n                          style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}\\n                        >\\n                          {padding.top}\\n                        </span>\\n                        <span\\n                          style={{\\n                            ...styles[\\"label\\"],\\n                            ...styles[\\"labelBottom\\"],\\n                          }}\\n                        >\\n                          {padding.bottom}\\n                        </span>\\n                        <span\\n                          style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}\\n                        >\\n                          {padding.left}\\n                        </span>\\n                        <span\\n                          style={{\\n                            ...styles[\\"label\\"],\\n                            ...styles[\\"labelRight\\"],\\n                          }}\\n                        >\\n                          {padding.right}\\n                        </span>\\n                        <div style={styles[\\"content\\"]}>\\n                          {content.width} × {content.height}\\n                        </div>\\n                      </div>\\n                    </div>\\n                  </div>\\n                </div>\\n              </div>\\n            </div>\\n          </div>\\n        </div>\\n      </div>\\n\\n      {/* Box Model Information */}\\n      <div style={{ marginTop: \\"1rem\\", textAlign: \\"left\\", fontSize: \\"14px\\" }}>\\n        <table style={{ width: \\"100%\\", borderCollapse: \\"collapse\\" }}>\\n          <thead>\\n            <tr>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Property\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Attribute\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Top\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Right\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Bottom\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Left\\n              </th>\\n            </tr>\\n          </thead>\\n          <tbody>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Margin</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Border</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Padding</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Content Dimensions</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {content.width} × {content.height}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Box-sizing</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {boxModel.boxSizing}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n            </tr>\\n          </tbody>\\n        </table>\\n      </div>\\n    </div>\\n  );\\n};\\n\\n// Main CSSAnalyzer Component\\nconst CSSAnalyzer: React.FC<CSSAnalyzerProps> = ({ active }) => {\\n  const [selectedElement, setSelectedElement] =\\n    useState<HTMLElement | null>(null);\\n  const [computedStyles, setComputedStyles] = useState<Record<string, string>>(\\n    {}\\n  );\\n  const [elementName, setElementName] = useState<string>(\\"\\");\\n  const [boxModel, setBoxModel] = useState<BoxModel | null>(null);\\n\\n  useEffect(() => {\\n    const handleElementClick = (event: MouseEvent) => {\\n      event.preventDefault();\\n      event.stopPropagation();\\n\\n      const element = event.target as HTMLElement;\\n\\n      if (selectedElement) {\\n        selectedElement.style.outline = \\"none\\";\\n      }\\n\\n      element.style.outline = \\"2px solid #007acc\\";\\n      setSelectedElement(element);\\n      setElementName(element.tagName.toLowerCase());\\n      fetchComputedStyles(element);\\n    };\\n\\n    const fetchComputedStyles = (element: HTMLElement) => {\\n      const computedStyle = window.getComputedStyle(element);\\n      const boxModelData: BoxModel = {\\n        margin: {\\n          top: computedStyle.marginTop,\\n          right: computedStyle.marginRight,\\n          bottom: computedStyle.marginBottom,\\n          left: computedStyle.marginLeft,\\n        },\\n        border: {\\n          top: computedStyle.borderTopWidth,\\n          right: computedStyle.borderRightWidth,\\n          bottom: computedStyle.borderBottomWidth,\\n          left: computedStyle.borderLeftWidth,\\n        },\\n        padding: {\\n          top: computedStyle.paddingTop,\\n          right: computedStyle.paddingRight,\\n          bottom: computedStyle.paddingBottom,\\n          left: computedStyle.paddingLeft,\\n        },\\n        content: {\\n          width: computedStyle.width,\\n          height: computedStyle.height,\\n        },\\n        boxSizing: computedStyle.boxSizing,\\n        display: computedStyle.display,\\n        float: computedStyle.cssFloat,\\n        lineHeight: computedStyle.lineHeight,\\n        position: computedStyle.position,\\n        zIndex: computedStyle.zIndex,\\n      };\\n      const styleMap: Record<string, string> = {};\\n\\n      Array.from(computedStyle).forEach((property) => {\\n        styleMap[property] = computedStyle.getPropertyValue(property);\\n      });\\n\\n      setBoxModel(boxModelData);\\n      setComputedStyles(styleMap);\\n    };\\n\\n    if (active) {\\n      const iframe = document.querySelector(\\n        \\"#storybook-preview-iframe\\"\\n      ) as HTMLIFrameElement;\\n\\n      if (iframe?.contentDocument) {\\n        iframe.contentDocument.addEventListener(\\n          \\"click\\",\\n          handleElementClick,\\n          true\\n        );\\n\\n        // Return cleanup function\\n        return () => {\\n          iframe.contentDocument?.removeEventListener(\\n            \\"click\\",\\n            handleElementClick,\\n            true\\n          );\\n        };\\n      }\\n    }\\n\\n    // Explicitly return `undefined` if no cleanup is required\\n    return undefined;\\n  }, [active, selectedElement]);\\n\\n  const groupedStyles = Object.entries(computedStyles).reduce(\\n    (acc, [key, value]) => {\\n      const category = key.startsWith(\\"--\\")\\n        ? \\"CSS Variables\\"\\n        : key.startsWith(\\"background\\")\\n        ? \\"Background\\"\\n        : key.startsWith(\\"margin\\")\\n        ? \\"Margin\\"\\n        : key.startsWith(\\"padding\\")\\n        ? \\"Padding\\"\\n        : key.startsWith(\\"font\\")\\n        ? \\"Font\\"\\n        : key.startsWith(\\"border\\")\\n        ? \\"Border\\"\\n        : key.startsWith(\\"grid\\")\\n        ? \\"Grid\\"\\n        : key.startsWith(\\"text\\")\\n        ? \\"Text\\"\\n        : key.startsWith(\\"scroll\\") ||\\n          key.startsWith(\\"overscroll\\") ||\\n          key.startsWith(\\"overflow\\")\\n        ? \\"Scroll & Overflow\\"\\n        : key.startsWith(\\"-m\\") || key.startsWith(\\"-w\\")\\n        ? \\"Webkit\\"\\n        : \\"Other\\";\\n\\n      acc[category] = acc[category] || {};\\n      acc[category][key] = value;\\n      return acc;\\n    },\\n    {} as Record<string, Record<string, string>>\\n  );\\n\\n  return (\\n    <AddonPanel active={active}>\\n      <div style={{ padding: \\"10px\\" }}>\\n        <div>\\n          <h2>CSS Analyzer</h2>\\n          {elementName ? (\\n            <p>\\n              Selected Element: <strong>{elementName}</strong>\\n            </p>\\n          ): (\\n            <p>\\n              Clicca su un elemento per analizzarlo.\\n            </p>\\n          )}\\n        </div>\\n        <div\\n          style={{\\n            display: \\"flex\\",\\n            flexWrap: \\"wrap\\",\\n            padding: \\"10px\\",\\n            gap: \\"10px\\",\\n            alignItems: \\"stretch\\",\\n          }}\\n        >\\n          {boxModel && (\\n            <div\\n              style={{\\n                flex: \\"1 1 calc(50% - 10px)\\", // 50% width minus the gap\\n                minWidth: \\"400px\\",\\n                boxSizing: \\"border-box\\",\\n                display: \\"flex\\", // Ensure content fills the height\\n                flexDirection: \\"column\\",\\n              }}\\n            >\\n              <div style={{ top: 0, position: \\"sticky\\" }}>\\n                <TableBoxModel boxModel={boxModel} />\\n              </div>\\n            </div>\\n          )}\\n          {Object.entries(groupedStyles).length > 0 && (\\n            <div\\n              style={{\\n                flex: \\"1 1 calc(50% - 10px)\\", // 50% width minus the gap\\n                minWidth: \\"400px\\",\\n                boxSizing: \\"border-box\\",\\n                display: \\"flex\\", // Ensure content fills the height\\n                flexDirection: \\"column\\",\\n                textAlign: \\"center\\",\\n              }}\\n            >\\n              <h3>Css Computed Style</h3>\\n\\n              {Object.entries(groupedStyles).map(([group, styles]) => (\\n                <StyleSection key={group} title={group} data={styles} />\\n              ))}\\n            </div>\\n          )}\\n        </div>\\n      </div>\\n    </AddonPanel>\\n  );\\n};\\n\\nexport default CSSAnalyzer;\\n","properties":[{"name":"label","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":6},{"name":"value","deprecated":false,"deprecationMessage":"","type":"string | number","indexKey":"","optional":false,"description":"","line":7}],"indexSignatures":[],"kind":171,"methods":[],"extends":[]},{"name":"ShowCodeProps","id":"interface-ShowCodeProps-acea77b6839dee8f35aba9a2a8472211d68f00e3fa6d9680b23d668d16c983d3f7f9087bb02193f251e5e8f3e87519d99a9cd3b81aceae31033de8bceb07a479","file":"src/common/shared/show-code-addon/show-code.tsx","deprecated":false,"deprecationMessage":"","type":"interface","sourceCode":"import React, { useEffect, useState } from \\"react\\";\\nimport { useStorybookApi } from \\"@storybook/manager-api\\";\\nimport { AddonPanel } from \\"storybook/internal/components\\";\\nimport { Markdown } from \\"@storybook/blocks\\"; // Importa Markdown per la visualizzazione\\n\\ninterface ShowCodeProps {\\n  active: boolean;\\n}\\n\\nexport const ShowCodeAddon: React.FC<ShowCodeProps> = ({ active }) => {\\n  const [generatedHTML, setGeneratedHTML] = useState<string>(\\"\\");\\n  const api = useStorybookApi();\\n\\n  useEffect(() => {\\n    const generateHTML = () => {\\n      const storyData = api.getCurrentStoryData() as any;\\n      if (storyData?.parameters?.codeFixed) {\\n        setGeneratedHTML(storyData.parameters.codeFixed);\\n      } else {\\n        if (storyData && storyData.args) {\\n          const componentName = storyData.parameters.componentName;\\n          const args = storyData.args;\\n          const outputList: string[] = storyData.parameters.outputList || [];\\n          const customInputList: string[] =\\n            storyData.parameters.customElements || [];\\n          const directive = storyData.parameters.directive || \\"\\";\\n          const additionalCode = storyData.parameters.additionalCode || \\"\\";\\n\\n          // Trasformo gli argomenti in attributi HTML\\n          const argsString = Object.entries(args)\\n            .map(([key, value]) => {\\n              if (typeof value === \\"string\\") {\\n                return `  [${key}]=\\"\'${value}\'\\"`;\\n              } else if (\\n                typeof value === \\"boolean\\" ||\\n                value === null ||\\n                value === undefined\\n              ) {\\n                return `  [${key}]=\\"${value}\\"`;\\n              } else if (typeof value === \\"number\\") {\\n                return `  [${key}]=\\"${value}\\"`;\\n              } else if (Array.isArray(value)) {\\n                const isArrayOfObjects = value.every(\\n                  (item) => typeof item === \\"object\\"\\n                );\\n                if (!isArrayOfObjects) {\\n                  return `  [${key}]=\\"${JSON.stringify(value)}\\"`;\\n                }\\n                return \\"\\";\\n              } else if (typeof value === \\"object\\") {\\n                return \\"\\";\\n              }\\n              return \\"\\";\\n            })\\n            .filter(Boolean)\\n            .join(\\"\\\\n\\");\\n\\n          const customInput = customInputList.join(\\"\\\\n\\");\\n\\n          const outputContent = outputList.join(\\"\\\\n\\");\\n\\n          const finalHTML = `<${componentName}${\\n            directive ? `\\\\n${directive}` : \\"\\"\\n          }${argsString ? `\\\\n${argsString}` : \\"\\"}${\\n            customInput ? `\\\\n${customInput}` : \\"\\"\\n          }${outputContent ? `\\\\n  ${outputContent}` : \\"\\"}>\\\\n${\\n            additionalCode ? `${additionalCode}\\\\n` : \\"\\"\\n          }</${componentName}>`;\\n\\n          setGeneratedHTML(finalHTML);\\n        }\\n      }\\n    };\\n\\n    if (active) {\\n      generateHTML();\\n    }\\n  }, [api, active]);\\n\\n  return (\\n    <AddonPanel active={active}>\\n      <Markdown\\n        components={{\\n          pre: (props: any) => (\\n            <pre\\n              style={{\\n                whiteSpace: \\"pre-wrap\\",\\n                fontFamily: \\"monospace\\",\\n                fontSize: \\"14px\\",\\n                background: \\"#f5f5f5\\",\\n                padding: \\"10px\\",\\n                borderRadius: \\"4px\\",\\n                overflow: \\"auto\\",\\n                lineHeight: \\"1.5\\",\\n              }}\\n              {...props}\\n            />\\n          ),\\n        }}\\n      >\\n        {`\\\\`\\\\`\\\\`html\\\\n${generatedHTML}\\\\n\\\\`\\\\`\\\\``}\\n      </Markdown>\\n    </AddonPanel>\\n  );\\n};\\n","properties":[{"name":"active","deprecated":false,"deprecationMessage":"","type":"boolean","indexKey":"","optional":false,"description":"","line":7}],"indexSignatures":[],"kind":171,"methods":[],"extends":[]},{"name":"StyleSectionProps","id":"interface-StyleSectionProps-683849dbea1c23c473a766bd4428ed56d700f64f11698d2c47b640667457cd2a986b2c0752bbad7d7d4c4b5735cf598bf138ea3b9c58ed5cc71f77110ba741a3","file":"src/common/shared/CSSAnalyzer.tsx","deprecated":false,"deprecationMessage":"","type":"interface","sourceCode":"import React, { useState, useEffect } from \\"react\\";\\nimport { AddonPanel } from \\"@storybook/components\\";\\n\\n// Define types for props and data structures\\ninterface PropertyProps {\\n  label: string;\\n  value: string | number;\\n}\\n\\ninterface StyleSectionProps {\\n  title: string;\\n  data: Record<string, string>;\\n}\\n\\ninterface CSSAnalyzerProps {\\n  active: boolean;\\n}\\n\\ninterface BoxModel {\\n  margin: { top: string; right: string; bottom: string; left: string };\\n  border: { top: string; right: string; bottom: string; left: string };\\n  padding: { top: string; right: string; bottom: string; left: string };\\n  content: { width: string; height: string };\\n  boxSizing?: string;\\n  display?: string;\\n  float: string;\\n  lineHeight: string;\\n  position: string;\\n  zIndex: string;\\n}\\n\\ninterface TableBoxModelProps {\\n  boxModel: BoxModel;\\n}\\n\\n// Property Component\\nconst Property: React.FC<PropertyProps> = ({ label, value }) => (\\n  <>\\n    <td\\n      style={{ border: \\"1px solid black\\", padding: \\"8px\\", textAlign: \\"left\\" }}\\n    >\\n      <strong>{label}</strong>\\n    </td>\\n    <td\\n      style={{ border: \\"1px solid black\\", padding: \\"8px\\", textAlign: \\"left\\" }}\\n    >\\n      {value}\\n    </td>\\n  </>\\n);\\n\\n// StyleSection Component\\nconst StyleSection: React.FC<StyleSectionProps> = ({ title, data }) => {\\n  const [expanded, setExpanded] = useState(false);\\n\\n  return (\\n    <div style={{ marginBottom: \\"10px\\" }}>\\n      <button\\n        style={{\\n          background: \\"#f0f0f0\\",\\n          border: \\"1px solid black\\",\\n          padding: \\"8px\\",\\n          width: \\"100%\\",\\n          cursor: \\"pointer\\",\\n          display: \\"flex\\",\\n          justifyContent: \\"space-between\\",\\n        }}\\n        onClick={() => setExpanded(!expanded)}\\n      >\\n        <span>{title}</span>\\n        <span>{expanded ? \\"▼\\" : \\"▶\\"}</span>\\n      </button>\\n      {expanded && (\\n        <table style={{ width: \\"100%\\", borderCollapse: \\"collapse\\" }}>\\n          <thead>\\n            <tr>\\n              <th style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                Property\\n              </th>\\n              <th style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                Attribute\\n              </th>\\n            </tr>\\n          </thead>\\n          <tbody>\\n            {Object.entries(data).map(([key, value]) => (\\n              <tr key={key}>\\n                <Property label={key} value={value} />\\n              </tr>\\n            ))}\\n          </tbody>\\n        </table>\\n      )}\\n    </div>\\n  );\\n};\\n\\n// TableBoxModel Component\\nconst TableBoxModel: React.FC<TableBoxModelProps> = ({ boxModel }) => {\\n  if (!boxModel || !boxModel.content) return null;\\n\\n  const { margin, border, padding, content } = boxModel;\\n\\n  const styles: Record<string, React.CSSProperties> = {\\n    bodyTest: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"center\\",\\n\\n      margin: 0,\\n      padding: 0,\\n      backgroundColor: \\"lightgray\\",\\n      fontFamily: \\"Arial, sans-serif\\",\\n    },\\n    container: {\\n      display: \\"flex\\",\\n      flexDirection: \\"column\\",\\n      alignItems: \\"center\\",\\n      width: \\"100%\\",\\n    },\\n    boxContent: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"flex-start\\", // Align items at the top\\n      position: \\"relative\\",\\n    },\\n    margin: {\\n      backgroundColor: \\"#73764a\\",\\n      padding: \\"24px 32px\\",\\n      position: \\"relative\\",\\n      border: \\"2px dashed #bcc900\\",\\n    },\\n    border: {\\n      backgroundColor: \\"#38383D\\",\\n      padding: \\"24px 32px\\",\\n    },\\n    padding: {\\n      backgroundColor: \\"#6657A6\\",\\n      padding: \\"24px 32px\\",\\n    },\\n    content: {\\n      backgroundColor: \\"#407AA4\\",\\n      width: \\"140px\\",\\n      height: \\"20px\\",\\n      border: \\"2px dashed #00b8ff\\",\\n      color: \\"white\\",\\n      fontWeight: \\"bold\\",\\n      textAlign: \\"center\\",\\n    },\\n    label: {\\n      position: \\"absolute\\",\\n      fontSize: \\"12px\\",\\n      background: \\"rgba(255, 255, 255, 0.8)\\",\\n      padding: \\"2px 5px\\",\\n      border: \\"1px solid black\\",\\n      borderRadius: \\"3px\\",\\n      pointerEvents: \\"none\\",\\n    },\\n    labelTop: {\\n      top: \\"-10px\\",\\n      left: \\"50%\\",\\n      transform: \\"translateX(-50%)\\",\\n    },\\n    labelBottom: {\\n      bottom: \\"-10px\\",\\n      left: \\"50%\\",\\n      transform: \\"translateX(-50%)\\",\\n    },\\n    labelLeft: {\\n      left: \\"-20px\\",\\n      top: \\"50%\\",\\n      transform: \\"translateY(-50%)\\",\\n      marginLeft: \\"2px\\",\\n      marginRight: \\"100px\\",\\n    },\\n    labelRight: {\\n      right: \\"-20px\\",\\n      top: \\"50%\\",\\n      transform: \\"translateY(-50%)\\",\\n    },\\n    labelText: {\\n      fontSize: \\"12px\\",\\n      fontWeight: \\"bold\\",\\n      marginRight: \\"10px\\", // Space between text and box\\n      alignSelf: \\"flex-start\\",\\n      position: \\"absolute\\",\\n      top: \\"0px\\", // Move text above the box\\n      zIndex: 99, // Ensure text is on top\\n      left: \\"15%\\",\\n      transform: \\"translateX(-50%)\\", // Center label horizontally\\n      color: \\"white\\",\\n    },\\n    rowContent: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"flex-start\\", // Align items to the top of the boxes\\n      marginTop: \\"20px\\",\\n      marginBottom: \\"20px\\",\\n      gap: \\"20px\\", // Space between the sections\\n      flexWrap: \\"wrap\\", // Allow wrapping for smaller screens\\n      padding: \\"0 10px\\",\\n    },\\n  };\\n\\n  return (\\n    <div style={{ textAlign: \\"center\\" }}>\\n      <h3>Box Model Representation</h3>\\n      <div style={styles[\\"bodyTest\\"]}>\\n        <div style={styles[\\"container\\"]}>\\n          {/* Horizontal Flexbox for Besi, Ana, and Ina */}\\n          <div style={styles[\\"rowContent\\"]}>\\n            {/* Ana Section */}\\n            <div style={styles[\\"boxContent\\"]}>\\n              <span style={styles[\\"labelText\\"]}>Margin</span>\\n              <div style={styles[\\"margin\\"]}>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}>\\n                  {margin.top}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelBottom\\"] }}>\\n                  {margin.bottom}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}>\\n                  {margin.left}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelRight\\"] }}>\\n                  {margin.right}\\n                </span>\\n                <div style={styles[\\"boxContent\\"]}>\\n                  <span style={styles[\\"labelText\\"]}>Border</span>\\n                  <div style={styles[\\"border\\"]}>\\n                    <span style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}>\\n                      {border.top}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelBottom\\"] }}\\n                    >\\n                      {border.bottom}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}\\n                    >\\n                      {border.left}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelRight\\"] }}\\n                    >\\n                      {border.right}\\n                    </span>\\n                    <div style={styles[\\"boxContent\\"]}>\\n                      <span style={styles[\\"labelText\\"]}>Padding</span>\\n                      <div style={styles[\\"padding\\"]}>\\n                        <span\\n                          style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}\\n                        >\\n                          {padding.top}\\n                        </span>\\n                        <span\\n                          style={{\\n                            ...styles[\\"label\\"],\\n                            ...styles[\\"labelBottom\\"],\\n                          }}\\n                        >\\n                          {padding.bottom}\\n                        </span>\\n                        <span\\n                          style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}\\n                        >\\n                          {padding.left}\\n                        </span>\\n                        <span\\n                          style={{\\n                            ...styles[\\"label\\"],\\n                            ...styles[\\"labelRight\\"],\\n                          }}\\n                        >\\n                          {padding.right}\\n                        </span>\\n                        <div style={styles[\\"content\\"]}>\\n                          {content.width} × {content.height}\\n                        </div>\\n                      </div>\\n                    </div>\\n                  </div>\\n                </div>\\n              </div>\\n            </div>\\n          </div>\\n        </div>\\n      </div>\\n\\n      {/* Box Model Information */}\\n      <div style={{ marginTop: \\"1rem\\", textAlign: \\"left\\", fontSize: \\"14px\\" }}>\\n        <table style={{ width: \\"100%\\", borderCollapse: \\"collapse\\" }}>\\n          <thead>\\n            <tr>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Property\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Attribute\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Top\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Right\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Bottom\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Left\\n              </th>\\n            </tr>\\n          </thead>\\n          <tbody>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Margin</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Border</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Padding</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Content Dimensions</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {content.width} × {content.height}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Box-sizing</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {boxModel.boxSizing}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n            </tr>\\n          </tbody>\\n        </table>\\n      </div>\\n    </div>\\n  );\\n};\\n\\n// Main CSSAnalyzer Component\\nconst CSSAnalyzer: React.FC<CSSAnalyzerProps> = ({ active }) => {\\n  const [selectedElement, setSelectedElement] =\\n    useState<HTMLElement | null>(null);\\n  const [computedStyles, setComputedStyles] = useState<Record<string, string>>(\\n    {}\\n  );\\n  const [elementName, setElementName] = useState<string>(\\"\\");\\n  const [boxModel, setBoxModel] = useState<BoxModel | null>(null);\\n\\n  useEffect(() => {\\n    const handleElementClick = (event: MouseEvent) => {\\n      event.preventDefault();\\n      event.stopPropagation();\\n\\n      const element = event.target as HTMLElement;\\n\\n      if (selectedElement) {\\n        selectedElement.style.outline = \\"none\\";\\n      }\\n\\n      element.style.outline = \\"2px solid #007acc\\";\\n      setSelectedElement(element);\\n      setElementName(element.tagName.toLowerCase());\\n      fetchComputedStyles(element);\\n    };\\n\\n    const fetchComputedStyles = (element: HTMLElement) => {\\n      const computedStyle = window.getComputedStyle(element);\\n      const boxModelData: BoxModel = {\\n        margin: {\\n          top: computedStyle.marginTop,\\n          right: computedStyle.marginRight,\\n          bottom: computedStyle.marginBottom,\\n          left: computedStyle.marginLeft,\\n        },\\n        border: {\\n          top: computedStyle.borderTopWidth,\\n          right: computedStyle.borderRightWidth,\\n          bottom: computedStyle.borderBottomWidth,\\n          left: computedStyle.borderLeftWidth,\\n        },\\n        padding: {\\n          top: computedStyle.paddingTop,\\n          right: computedStyle.paddingRight,\\n          bottom: computedStyle.paddingBottom,\\n          left: computedStyle.paddingLeft,\\n        },\\n        content: {\\n          width: computedStyle.width,\\n          height: computedStyle.height,\\n        },\\n        boxSizing: computedStyle.boxSizing,\\n        display: computedStyle.display,\\n        float: computedStyle.cssFloat,\\n        lineHeight: computedStyle.lineHeight,\\n        position: computedStyle.position,\\n        zIndex: computedStyle.zIndex,\\n      };\\n      const styleMap: Record<string, string> = {};\\n\\n      Array.from(computedStyle).forEach((property) => {\\n        styleMap[property] = computedStyle.getPropertyValue(property);\\n      });\\n\\n      setBoxModel(boxModelData);\\n      setComputedStyles(styleMap);\\n    };\\n\\n    if (active) {\\n      const iframe = document.querySelector(\\n        \\"#storybook-preview-iframe\\"\\n      ) as HTMLIFrameElement;\\n\\n      if (iframe?.contentDocument) {\\n        iframe.contentDocument.addEventListener(\\n          \\"click\\",\\n          handleElementClick,\\n          true\\n        );\\n\\n        // Return cleanup function\\n        return () => {\\n          iframe.contentDocument?.removeEventListener(\\n            \\"click\\",\\n            handleElementClick,\\n            true\\n          );\\n        };\\n      }\\n    }\\n\\n    // Explicitly return `undefined` if no cleanup is required\\n    return undefined;\\n  }, [active, selectedElement]);\\n\\n  const groupedStyles = Object.entries(computedStyles).reduce(\\n    (acc, [key, value]) => {\\n      const category = key.startsWith(\\"--\\")\\n        ? \\"CSS Variables\\"\\n        : key.startsWith(\\"background\\")\\n        ? \\"Background\\"\\n        : key.startsWith(\\"margin\\")\\n        ? \\"Margin\\"\\n        : key.startsWith(\\"padding\\")\\n        ? \\"Padding\\"\\n        : key.startsWith(\\"font\\")\\n        ? \\"Font\\"\\n        : key.startsWith(\\"border\\")\\n        ? \\"Border\\"\\n        : key.startsWith(\\"grid\\")\\n        ? \\"Grid\\"\\n        : key.startsWith(\\"text\\")\\n        ? \\"Text\\"\\n        : key.startsWith(\\"scroll\\") ||\\n          key.startsWith(\\"overscroll\\") ||\\n          key.startsWith(\\"overflow\\")\\n        ? \\"Scroll & Overflow\\"\\n        : key.startsWith(\\"-m\\") || key.startsWith(\\"-w\\")\\n        ? \\"Webkit\\"\\n        : \\"Other\\";\\n\\n      acc[category] = acc[category] || {};\\n      acc[category][key] = value;\\n      return acc;\\n    },\\n    {} as Record<string, Record<string, string>>\\n  );\\n\\n  return (\\n    <AddonPanel active={active}>\\n      <div style={{ padding: \\"10px\\" }}>\\n        <div>\\n          <h2>CSS Analyzer</h2>\\n          {elementName ? (\\n            <p>\\n              Selected Element: <strong>{elementName}</strong>\\n            </p>\\n          ): (\\n            <p>\\n              Clicca su un elemento per analizzarlo.\\n            </p>\\n          )}\\n        </div>\\n        <div\\n          style={{\\n            display: \\"flex\\",\\n            flexWrap: \\"wrap\\",\\n            padding: \\"10px\\",\\n            gap: \\"10px\\",\\n            alignItems: \\"stretch\\",\\n          }}\\n        >\\n          {boxModel && (\\n            <div\\n              style={{\\n                flex: \\"1 1 calc(50% - 10px)\\", // 50% width minus the gap\\n                minWidth: \\"400px\\",\\n                boxSizing: \\"border-box\\",\\n                display: \\"flex\\", // Ensure content fills the height\\n                flexDirection: \\"column\\",\\n              }}\\n            >\\n              <div style={{ top: 0, position: \\"sticky\\" }}>\\n                <TableBoxModel boxModel={boxModel} />\\n              </div>\\n            </div>\\n          )}\\n          {Object.entries(groupedStyles).length > 0 && (\\n            <div\\n              style={{\\n                flex: \\"1 1 calc(50% - 10px)\\", // 50% width minus the gap\\n                minWidth: \\"400px\\",\\n                boxSizing: \\"border-box\\",\\n                display: \\"flex\\", // Ensure content fills the height\\n                flexDirection: \\"column\\",\\n                textAlign: \\"center\\",\\n              }}\\n            >\\n              <h3>Css Computed Style</h3>\\n\\n              {Object.entries(groupedStyles).map(([group, styles]) => (\\n                <StyleSection key={group} title={group} data={styles} />\\n              ))}\\n            </div>\\n          )}\\n        </div>\\n      </div>\\n    </AddonPanel>\\n  );\\n};\\n\\nexport default CSSAnalyzer;\\n","properties":[{"name":"data","deprecated":false,"deprecationMessage":"","type":"Record<string | string>","indexKey":"","optional":false,"description":"","line":12},{"name":"title","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":11}],"indexSignatures":[],"kind":171,"methods":[],"extends":[]},{"name":"TableBoxModelProps","id":"interface-TableBoxModelProps-683849dbea1c23c473a766bd4428ed56d700f64f11698d2c47b640667457cd2a986b2c0752bbad7d7d4c4b5735cf598bf138ea3b9c58ed5cc71f77110ba741a3","file":"src/common/shared/CSSAnalyzer.tsx","deprecated":false,"deprecationMessage":"","type":"interface","sourceCode":"import React, { useState, useEffect } from \\"react\\";\\nimport { AddonPanel } from \\"@storybook/components\\";\\n\\n// Define types for props and data structures\\ninterface PropertyProps {\\n  label: string;\\n  value: string | number;\\n}\\n\\ninterface StyleSectionProps {\\n  title: string;\\n  data: Record<string, string>;\\n}\\n\\ninterface CSSAnalyzerProps {\\n  active: boolean;\\n}\\n\\ninterface BoxModel {\\n  margin: { top: string; right: string; bottom: string; left: string };\\n  border: { top: string; right: string; bottom: string; left: string };\\n  padding: { top: string; right: string; bottom: string; left: string };\\n  content: { width: string; height: string };\\n  boxSizing?: string;\\n  display?: string;\\n  float: string;\\n  lineHeight: string;\\n  position: string;\\n  zIndex: string;\\n}\\n\\ninterface TableBoxModelProps {\\n  boxModel: BoxModel;\\n}\\n\\n// Property Component\\nconst Property: React.FC<PropertyProps> = ({ label, value }) => (\\n  <>\\n    <td\\n      style={{ border: \\"1px solid black\\", padding: \\"8px\\", textAlign: \\"left\\" }}\\n    >\\n      <strong>{label}</strong>\\n    </td>\\n    <td\\n      style={{ border: \\"1px solid black\\", padding: \\"8px\\", textAlign: \\"left\\" }}\\n    >\\n      {value}\\n    </td>\\n  </>\\n);\\n\\n// StyleSection Component\\nconst StyleSection: React.FC<StyleSectionProps> = ({ title, data }) => {\\n  const [expanded, setExpanded] = useState(false);\\n\\n  return (\\n    <div style={{ marginBottom: \\"10px\\" }}>\\n      <button\\n        style={{\\n          background: \\"#f0f0f0\\",\\n          border: \\"1px solid black\\",\\n          padding: \\"8px\\",\\n          width: \\"100%\\",\\n          cursor: \\"pointer\\",\\n          display: \\"flex\\",\\n          justifyContent: \\"space-between\\",\\n        }}\\n        onClick={() => setExpanded(!expanded)}\\n      >\\n        <span>{title}</span>\\n        <span>{expanded ? \\"▼\\" : \\"▶\\"}</span>\\n      </button>\\n      {expanded && (\\n        <table style={{ width: \\"100%\\", borderCollapse: \\"collapse\\" }}>\\n          <thead>\\n            <tr>\\n              <th style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                Property\\n              </th>\\n              <th style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                Attribute\\n              </th>\\n            </tr>\\n          </thead>\\n          <tbody>\\n            {Object.entries(data).map(([key, value]) => (\\n              <tr key={key}>\\n                <Property label={key} value={value} />\\n              </tr>\\n            ))}\\n          </tbody>\\n        </table>\\n      )}\\n    </div>\\n  );\\n};\\n\\n// TableBoxModel Component\\nconst TableBoxModel: React.FC<TableBoxModelProps> = ({ boxModel }) => {\\n  if (!boxModel || !boxModel.content) return null;\\n\\n  const { margin, border, padding, content } = boxModel;\\n\\n  const styles: Record<string, React.CSSProperties> = {\\n    bodyTest: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"center\\",\\n\\n      margin: 0,\\n      padding: 0,\\n      backgroundColor: \\"lightgray\\",\\n      fontFamily: \\"Arial, sans-serif\\",\\n    },\\n    container: {\\n      display: \\"flex\\",\\n      flexDirection: \\"column\\",\\n      alignItems: \\"center\\",\\n      width: \\"100%\\",\\n    },\\n    boxContent: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"flex-start\\", // Align items at the top\\n      position: \\"relative\\",\\n    },\\n    margin: {\\n      backgroundColor: \\"#73764a\\",\\n      padding: \\"24px 32px\\",\\n      position: \\"relative\\",\\n      border: \\"2px dashed #bcc900\\",\\n    },\\n    border: {\\n      backgroundColor: \\"#38383D\\",\\n      padding: \\"24px 32px\\",\\n    },\\n    padding: {\\n      backgroundColor: \\"#6657A6\\",\\n      padding: \\"24px 32px\\",\\n    },\\n    content: {\\n      backgroundColor: \\"#407AA4\\",\\n      width: \\"140px\\",\\n      height: \\"20px\\",\\n      border: \\"2px dashed #00b8ff\\",\\n      color: \\"white\\",\\n      fontWeight: \\"bold\\",\\n      textAlign: \\"center\\",\\n    },\\n    label: {\\n      position: \\"absolute\\",\\n      fontSize: \\"12px\\",\\n      background: \\"rgba(255, 255, 255, 0.8)\\",\\n      padding: \\"2px 5px\\",\\n      border: \\"1px solid black\\",\\n      borderRadius: \\"3px\\",\\n      pointerEvents: \\"none\\",\\n    },\\n    labelTop: {\\n      top: \\"-10px\\",\\n      left: \\"50%\\",\\n      transform: \\"translateX(-50%)\\",\\n    },\\n    labelBottom: {\\n      bottom: \\"-10px\\",\\n      left: \\"50%\\",\\n      transform: \\"translateX(-50%)\\",\\n    },\\n    labelLeft: {\\n      left: \\"-20px\\",\\n      top: \\"50%\\",\\n      transform: \\"translateY(-50%)\\",\\n      marginLeft: \\"2px\\",\\n      marginRight: \\"100px\\",\\n    },\\n    labelRight: {\\n      right: \\"-20px\\",\\n      top: \\"50%\\",\\n      transform: \\"translateY(-50%)\\",\\n    },\\n    labelText: {\\n      fontSize: \\"12px\\",\\n      fontWeight: \\"bold\\",\\n      marginRight: \\"10px\\", // Space between text and box\\n      alignSelf: \\"flex-start\\",\\n      position: \\"absolute\\",\\n      top: \\"0px\\", // Move text above the box\\n      zIndex: 99, // Ensure text is on top\\n      left: \\"15%\\",\\n      transform: \\"translateX(-50%)\\", // Center label horizontally\\n      color: \\"white\\",\\n    },\\n    rowContent: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"flex-start\\", // Align items to the top of the boxes\\n      marginTop: \\"20px\\",\\n      marginBottom: \\"20px\\",\\n      gap: \\"20px\\", // Space between the sections\\n      flexWrap: \\"wrap\\", // Allow wrapping for smaller screens\\n      padding: \\"0 10px\\",\\n    },\\n  };\\n\\n  return (\\n    <div style={{ textAlign: \\"center\\" }}>\\n      <h3>Box Model Representation</h3>\\n      <div style={styles[\\"bodyTest\\"]}>\\n        <div style={styles[\\"container\\"]}>\\n          {/* Horizontal Flexbox for Besi, Ana, and Ina */}\\n          <div style={styles[\\"rowContent\\"]}>\\n            {/* Ana Section */}\\n            <div style={styles[\\"boxContent\\"]}>\\n              <span style={styles[\\"labelText\\"]}>Margin</span>\\n              <div style={styles[\\"margin\\"]}>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}>\\n                  {margin.top}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelBottom\\"] }}>\\n                  {margin.bottom}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}>\\n                  {margin.left}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelRight\\"] }}>\\n                  {margin.right}\\n                </span>\\n                <div style={styles[\\"boxContent\\"]}>\\n                  <span style={styles[\\"labelText\\"]}>Border</span>\\n                  <div style={styles[\\"border\\"]}>\\n                    <span style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}>\\n                      {border.top}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelBottom\\"] }}\\n                    >\\n                      {border.bottom}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}\\n                    >\\n                      {border.left}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelRight\\"] }}\\n                    >\\n                      {border.right}\\n                    </span>\\n                    <div style={styles[\\"boxContent\\"]}>\\n                      <span style={styles[\\"labelText\\"]}>Padding</span>\\n                      <div style={styles[\\"padding\\"]}>\\n                        <span\\n                          style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}\\n                        >\\n                          {padding.top}\\n                        </span>\\n                        <span\\n                          style={{\\n                            ...styles[\\"label\\"],\\n                            ...styles[\\"labelBottom\\"],\\n                          }}\\n                        >\\n                          {padding.bottom}\\n                        </span>\\n                        <span\\n                          style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}\\n                        >\\n                          {padding.left}\\n                        </span>\\n                        <span\\n                          style={{\\n                            ...styles[\\"label\\"],\\n                            ...styles[\\"labelRight\\"],\\n                          }}\\n                        >\\n                          {padding.right}\\n                        </span>\\n                        <div style={styles[\\"content\\"]}>\\n                          {content.width} × {content.height}\\n                        </div>\\n                      </div>\\n                    </div>\\n                  </div>\\n                </div>\\n              </div>\\n            </div>\\n          </div>\\n        </div>\\n      </div>\\n\\n      {/* Box Model Information */}\\n      <div style={{ marginTop: \\"1rem\\", textAlign: \\"left\\", fontSize: \\"14px\\" }}>\\n        <table style={{ width: \\"100%\\", borderCollapse: \\"collapse\\" }}>\\n          <thead>\\n            <tr>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Property\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Attribute\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Top\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Right\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Bottom\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Left\\n              </th>\\n            </tr>\\n          </thead>\\n          <tbody>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Margin</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Border</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Padding</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Content Dimensions</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {content.width} × {content.height}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Box-sizing</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {boxModel.boxSizing}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n            </tr>\\n          </tbody>\\n        </table>\\n      </div>\\n    </div>\\n  );\\n};\\n\\n// Main CSSAnalyzer Component\\nconst CSSAnalyzer: React.FC<CSSAnalyzerProps> = ({ active }) => {\\n  const [selectedElement, setSelectedElement] =\\n    useState<HTMLElement | null>(null);\\n  const [computedStyles, setComputedStyles] = useState<Record<string, string>>(\\n    {}\\n  );\\n  const [elementName, setElementName] = useState<string>(\\"\\");\\n  const [boxModel, setBoxModel] = useState<BoxModel | null>(null);\\n\\n  useEffect(() => {\\n    const handleElementClick = (event: MouseEvent) => {\\n      event.preventDefault();\\n      event.stopPropagation();\\n\\n      const element = event.target as HTMLElement;\\n\\n      if (selectedElement) {\\n        selectedElement.style.outline = \\"none\\";\\n      }\\n\\n      element.style.outline = \\"2px solid #007acc\\";\\n      setSelectedElement(element);\\n      setElementName(element.tagName.toLowerCase());\\n      fetchComputedStyles(element);\\n    };\\n\\n    const fetchComputedStyles = (element: HTMLElement) => {\\n      const computedStyle = window.getComputedStyle(element);\\n      const boxModelData: BoxModel = {\\n        margin: {\\n          top: computedStyle.marginTop,\\n          right: computedStyle.marginRight,\\n          bottom: computedStyle.marginBottom,\\n          left: computedStyle.marginLeft,\\n        },\\n        border: {\\n          top: computedStyle.borderTopWidth,\\n          right: computedStyle.borderRightWidth,\\n          bottom: computedStyle.borderBottomWidth,\\n          left: computedStyle.borderLeftWidth,\\n        },\\n        padding: {\\n          top: computedStyle.paddingTop,\\n          right: computedStyle.paddingRight,\\n          bottom: computedStyle.paddingBottom,\\n          left: computedStyle.paddingLeft,\\n        },\\n        content: {\\n          width: computedStyle.width,\\n          height: computedStyle.height,\\n        },\\n        boxSizing: computedStyle.boxSizing,\\n        display: computedStyle.display,\\n        float: computedStyle.cssFloat,\\n        lineHeight: computedStyle.lineHeight,\\n        position: computedStyle.position,\\n        zIndex: computedStyle.zIndex,\\n      };\\n      const styleMap: Record<string, string> = {};\\n\\n      Array.from(computedStyle).forEach((property) => {\\n        styleMap[property] = computedStyle.getPropertyValue(property);\\n      });\\n\\n      setBoxModel(boxModelData);\\n      setComputedStyles(styleMap);\\n    };\\n\\n    if (active) {\\n      const iframe = document.querySelector(\\n        \\"#storybook-preview-iframe\\"\\n      ) as HTMLIFrameElement;\\n\\n      if (iframe?.contentDocument) {\\n        iframe.contentDocument.addEventListener(\\n          \\"click\\",\\n          handleElementClick,\\n          true\\n        );\\n\\n        // Return cleanup function\\n        return () => {\\n          iframe.contentDocument?.removeEventListener(\\n            \\"click\\",\\n            handleElementClick,\\n            true\\n          );\\n        };\\n      }\\n    }\\n\\n    // Explicitly return `undefined` if no cleanup is required\\n    return undefined;\\n  }, [active, selectedElement]);\\n\\n  const groupedStyles = Object.entries(computedStyles).reduce(\\n    (acc, [key, value]) => {\\n      const category = key.startsWith(\\"--\\")\\n        ? \\"CSS Variables\\"\\n        : key.startsWith(\\"background\\")\\n        ? \\"Background\\"\\n        : key.startsWith(\\"margin\\")\\n        ? \\"Margin\\"\\n        : key.startsWith(\\"padding\\")\\n        ? \\"Padding\\"\\n        : key.startsWith(\\"font\\")\\n        ? \\"Font\\"\\n        : key.startsWith(\\"border\\")\\n        ? \\"Border\\"\\n        : key.startsWith(\\"grid\\")\\n        ? \\"Grid\\"\\n        : key.startsWith(\\"text\\")\\n        ? \\"Text\\"\\n        : key.startsWith(\\"scroll\\") ||\\n          key.startsWith(\\"overscroll\\") ||\\n          key.startsWith(\\"overflow\\")\\n        ? \\"Scroll & Overflow\\"\\n        : key.startsWith(\\"-m\\") || key.startsWith(\\"-w\\")\\n        ? \\"Webkit\\"\\n        : \\"Other\\";\\n\\n      acc[category] = acc[category] || {};\\n      acc[category][key] = value;\\n      return acc;\\n    },\\n    {} as Record<string, Record<string, string>>\\n  );\\n\\n  return (\\n    <AddonPanel active={active}>\\n      <div style={{ padding: \\"10px\\" }}>\\n        <div>\\n          <h2>CSS Analyzer</h2>\\n          {elementName ? (\\n            <p>\\n              Selected Element: <strong>{elementName}</strong>\\n            </p>\\n          ): (\\n            <p>\\n              Clicca su un elemento per analizzarlo.\\n            </p>\\n          )}\\n        </div>\\n        <div\\n          style={{\\n            display: \\"flex\\",\\n            flexWrap: \\"wrap\\",\\n            padding: \\"10px\\",\\n            gap: \\"10px\\",\\n            alignItems: \\"stretch\\",\\n          }}\\n        >\\n          {boxModel && (\\n            <div\\n              style={{\\n                flex: \\"1 1 calc(50% - 10px)\\", // 50% width minus the gap\\n                minWidth: \\"400px\\",\\n                boxSizing: \\"border-box\\",\\n                display: \\"flex\\", // Ensure content fills the height\\n                flexDirection: \\"column\\",\\n              }}\\n            >\\n              <div style={{ top: 0, position: \\"sticky\\" }}>\\n                <TableBoxModel boxModel={boxModel} />\\n              </div>\\n            </div>\\n          )}\\n          {Object.entries(groupedStyles).length > 0 && (\\n            <div\\n              style={{\\n                flex: \\"1 1 calc(50% - 10px)\\", // 50% width minus the gap\\n                minWidth: \\"400px\\",\\n                boxSizing: \\"border-box\\",\\n                display: \\"flex\\", // Ensure content fills the height\\n                flexDirection: \\"column\\",\\n                textAlign: \\"center\\",\\n              }}\\n            >\\n              <h3>Css Computed Style</h3>\\n\\n              {Object.entries(groupedStyles).map(([group, styles]) => (\\n                <StyleSection key={group} title={group} data={styles} />\\n              ))}\\n            </div>\\n          )}\\n        </div>\\n      </div>\\n    </AddonPanel>\\n  );\\n};\\n\\nexport default CSSAnalyzer;\\n","properties":[{"name":"boxModel","deprecated":false,"deprecationMessage":"","type":"BoxModel","indexKey":"","optional":false,"description":"","line":33}],"indexSignatures":[],"kind":171,"methods":[],"extends":[]},{"name":"TitleDocsProps","id":"interface-TitleDocsProps-5f1e2c65d26544a410da53a9c3a841ccae631f2f0f9c9e4b97a55c81219e30660ed06842054d9ea506e8e4eb5f0a0803c80d6bc933321508327bde9f7d47ff8c","file":"src/common/shared/custom-title-docs.tsx","deprecated":false,"deprecationMessage":"","type":"interface","sourceCode":"import React from \\"react\\";\\n\\ninterface TitleDocsProps {\\n  title: string;\\n  links: { href: string; text: string }[];\\n}\\n\\nexport const TitleDoc: React.FC<TitleDocsProps> = ({ title, links }) => {\\n  return (\\n    <div\\n      style={{\\n        width: \\"auto\\",\\n        minHeight: \\"128px\\",\\n        backgroundImage: \'url(\\"background.png\\")\',\\n        backgroundRepeat: \\"no-repeat\\",\\n        backgroundSize: \\"cover\\",\\n        backgroundPosition: \\"right center\\",\\n        borderRadius: \\"4px\\",\\n        display: \\"flex\\",\\n        flexDirection: \\"column\\",\\n        justifyContent: \\"center\\",\\n        alignItems: \\"flex-start\\",\\n        padding: \\"32px\\",\\n        boxSizing: \\"border-box\\",\\n        marginBottom: \\"5%\\",\\n      }}\\n    >\\n      <h1\\n        style={{\\n          textAlign: \\"left\\",\\n          width: \\"100%\\",\\n          marginBottom: \\"20px\\",\\n          lineHeight: \\"1\\", // Riduce lo spazio extra\\n        }}\\n      >\\n        {title}\\n      </h1>\\n      <nav style={{ width: \\"100%\\" }}>\\n        <ul\\n          style={{\\n            listStyleType: \\"none\\",\\n            padding: 0,\\n            flexWrap: \\"wrap\\",\\n            display: \\"flex\\",\\n            alignItems: \\"center\\", // Allinea verticalmente\\n            gap: \\"15px\\", // Spazio tra i link\\n            margin: 0,\\n          }}\\n        >\\n          {links.map((link, index) => (\\n            <li\\n              key={link?.href}\\n              style={{\\n                display: \\"flex\\",\\n                alignItems: \\"center\\",\\n                height: \\"100%\\", // Assicura altezza uniforme\\n                whiteSpace: \\"nowrap\\", // Impedisce il wrap della pipe\\n              }}\\n            >\\n              <a\\n                href={link?.href}\\n                target=\\"_self\\"\\n                style={{\\n                  fontSize: \\"1.2em\\",\\n                  color: \\"blue\\",\\n                  textDecoration: \\"none\\",\\n                  display: \\"flex\\",\\n                  alignItems: \\"center\\", // Centra verticalmente il testo del link\\n                  height: \\"100%\\",\\n                }}\\n              >\\n                {link?.text}\\n              </a>\\n              {/* Aggiungi la pipe dinamicamente solo dopo ogni link tranne l\'ultimo */}\\n              {index < links.length - 1 && (\\n                <span\\n                  style={{\\n                    marginLeft: \\"10px\\",\\n                    whiteSpace: \\"nowrap\\", // Impedisce che la pipe vada a capo\\n                  }}\\n                >\\n                  |\\n                </span>\\n              )}\\n            </li>\\n          ))}\\n        </ul>\\n      </nav>\\n    </div>\\n  );\\n};\\n\\nexport default TitleDoc;\\n","properties":[{"name":"links","deprecated":false,"deprecationMessage":"","type":"literal type[]","indexKey":"","optional":false,"description":"","line":5},{"name":"title","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":4}],"indexSignatures":[],"kind":171,"methods":[],"extends":[]},{"name":"TitleWithNavigationProps","id":"interface-TitleWithNavigationProps-6b1b85d10459cc9ba7777e9f85ec335883cfa4ce77bcfb196ae139ca44f6f565e13b3d5ffe03d4497cbe6d4e8a66fa976fdec659e4e1716a1b626a1cec42179c","file":"src/common/shared/custom-title.tsx","deprecated":false,"deprecationMessage":"","type":"interface","sourceCode":"import React from \\"react\\";\\n\\ninterface TitleWithNavigationProps {\\n  title: string;\\n  showCode: boolean;\\n  showAccessibility: boolean;\\n}\\n\\nexport const TitleWithNavigation: React.FC<TitleWithNavigationProps> = ({\\n  title,\\n  showCode,\\n  showAccessibility\\n}) => {\\n  // Estrae l\'ultimo segmento del titolo dopo l\'ultimo \'/\'\\n  const extractedTitle = title.split(\\"/\\").pop() || title;\\n\\n  const links = [\\n    { href: \\"#panoramica\\", text: \\"Panoramica\\" },\\n    { href: \\"#caratteristiche-principali\\", text: \\"Caratteristiche Principali\\" },\\n    { href: \\"#varianti\\", text: \\"Varianti\\" },\\n    { href: \\"#best-practices\\", text: \\"Best Practices\\" },\\n    { href: \\"#componenti-correlati\\", text: \\"Componenti Correlati\\" },\\n    showAccessibility ? { href: \\"#accessibilita\\", text: \\"Accessibilità\\" } : null,\\n    showCode ? { href: \\"#codice\\", text: \\"Codice\\" } : null,\\n    { href: \\"#user-experience\\", text: \\"User Experience\\" },\\n    { href: \\"#overview\\", text: \\"Overview\\" },\\n   \\n  ].filter(Boolean);\\n\\n  return (\\n    <div\\n      style={{\\n        width: \\"auto\\",\\n        minHeight: \\"128px\\",\\n        backgroundImage: \'url(\\"background.png\\")\',\\n        backgroundRepeat: \\"no-repeat\\",\\n        backgroundSize: \\"cover\\",\\n        backgroundPosition: \\"right center\\",\\n        borderRadius: \\"4px\\",\\n        display: \\"flex\\",\\n        flexDirection: \\"column\\",\\n        justifyContent: \\"center\\",\\n        alignItems: \\"flex-start\\",\\n        padding: \\"32px\\",\\n        boxSizing: \\"border-box\\",\\n        marginBottom: \\"5%\\",\\n      }}\\n    >\\n      <h1\\n        style={{\\n          textAlign: \\"left\\",\\n          width: \\"100%\\",\\n          marginBottom: \\"20px\\",\\n          lineHeight: \\"1\\", // Riduce lo spazio extra\\n        }}\\n      >\\n        {extractedTitle}\\n      </h1>\\n      <nav style={{ width: \\"100%\\" }}>\\n        <ul\\n          style={{\\n            listStyleType: \\"none\\",\\n            padding: 0,\\n            flexWrap: \\"wrap\\",\\n            display: \\"flex\\",\\n            alignItems: \\"center\\", // Allinea verticalmente\\n            gap: \\"15px\\", // Spazio tra i link\\n            margin: 0,\\n          }}\\n        >\\n          {[\\n            { href: \\"#panoramica\\", text: \\"Panoramica\\" },\\n            { href: \\"#caratteristiche-principali\\", text: \\"Caratteristiche Principali\\" },\\n            { href: \\"#varianti\\", text: \\"Varianti\\" },\\n            { href: \\"#best-practices\\", text: \\"Best Practices\\" },\\n            { href: \\"#componenti-correlati\\", text: \\"Componenti Correlati\\" },\\n            { href: \\"#overview\\", text: \\"Overview\\" },\\n            { href: \\"#api\\", text: \\"API\\" },\\n          ].map((link, index) => (\\n            <li \\n              key={link.href}\\n              style={{\\n                display: \\"flex\\",\\n                alignItems: \\"center\\",\\n                height: \\"100%\\", // Assicura altezza uniforme\\n                whiteSpace: \\"nowrap\\", // Impedisce il wrap della pipe\\n              }}\\n            >\\n              <a\\n                href={link?.href}\\n                target=\\"_self\\"\\n                style={{\\n                  fontSize: \\"1.2em\\",\\n                  color: \\"blue\\",\\n                  textDecoration: \\"none\\",\\n                  display: \\"flex\\",\\n                  alignItems: \\"center\\", // Centra verticalmente il testo del link\\n                  height: \\"100%\\",\\n                }}\\n              >\\n                {link?.text}\\n              </a>\\n              {/* Aggiungi la pipe dinamicamente solo dopo ogni link tranne l\'ultimo */}\\n              {index < links.length - 1 && (\\n                <span\\n                  style={{\\n                    marginLeft: \\"10px\\",\\n                    whiteSpace: \\"nowrap\\", // Impedisce che la pipe vada a capo\\n                  }}\\n                >\\n                  |\\n                </span>\\n              )}\\n            </li>\\n          ))}\\n        </ul>\\n      </nav>\\n    </div>\\n  );\\n};\\n\\nexport default TitleWithNavigation;\\n","properties":[{"name":"showAccessibility","deprecated":false,"deprecationMessage":"","type":"boolean","indexKey":"","optional":false,"description":"","line":6},{"name":"showCode","deprecated":false,"deprecationMessage":"","type":"boolean","indexKey":"","optional":false,"description":"","line":5},{"name":"title","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":4}],"indexSignatures":[],"kind":171,"methods":[],"extends":[]},{"name":"User","id":"interface-User-d4821beac0e4a852e513391b7470981c4353fdd95a18628bb68136c8695b489ee15b926e2e5031bc26cf30e1508e0a362c3ee13a06734702b4d15af140e485d5","file":"src/stories/user.ts","deprecated":false,"deprecationMessage":"","type":"interface","sourceCode":"export interface User {\\n  name: string;\\n}\\n","properties":[{"name":"name","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":2}],"indexSignatures":[],"kind":171,"methods":[],"extends":[]}],"injectables":[{"name":"UtenteService","id":"injectable-UtenteService-f5b4569519563fd70db6281b5e732db9fc369bb7934eba9f4415fc25cd41b75e40168f21fffe61906d2373a174c7f7e01492321c4d64b5945e7d113cf9b7d996","file":"src/stories/wizard-spa/services/utente.service.ts","properties":[{"name":"saveSubj","deprecated":false,"deprecationMessage":"","type":"BehaviorSubject<boolean>","indexKey":"","optional":false,"description":"","line":14,"modifierKind":[123]},{"name":"utenteConverter","defaultValue":"new UtenteConverter()","deprecated":false,"deprecationMessage":"","type":"","indexKey":"","optional":false,"description":"","line":15,"modifierKind":[123]}],"methods":[{"name":"addUtente","args":[{"name":"utente","type":"Utente","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"Observable<Utente>","typeParameters":[],"line":52,"deprecated":false,"deprecationMessage":"","jsdoctags":[{"name":"utente","type":"Utente","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"deleteUtente","args":[{"name":"utente","type":"Utente","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"Observable<boolean>","typeParameters":[],"line":76,"deprecated":false,"deprecationMessage":"","jsdoctags":[{"name":"utente","type":"Utente","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"findUtenti","args":[{"name":"criteriaDto","type":"any","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"Observable<SearchResult<Utente>>","typeParameters":[],"line":34,"deprecated":false,"deprecationMessage":"","jsdoctags":[{"name":"criteriaDto","type":"any","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"get","args":[{"name":"id","type":"string","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"Observable<Utente>","typeParameters":[],"line":45,"deprecated":false,"deprecationMessage":"","jsdoctags":[{"name":"id","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"getSaveSubj","args":[],"optional":false,"returnType":"BehaviorSubject<boolean>","typeParameters":[],"line":26,"deprecated":false,"deprecationMessage":""},{"name":"getServiceName","args":[],"optional":false,"returnType":"string","typeParameters":[],"line":22,"deprecated":false,"deprecationMessage":""},{"name":"setSaveSubj","args":[{"name":"value","type":"boolean","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"void","typeParameters":[],"line":30,"deprecated":false,"deprecationMessage":"","jsdoctags":[{"name":"value","type":"boolean","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"updateUtente","args":[{"name":"utente","type":"Utente","deprecated":false,"deprecationMessage":""},{"name":"needFeedback","type":"boolean","deprecated":false,"deprecationMessage":"","defaultValue":"true"}],"optional":false,"returnType":"Observable<Utente>","typeParameters":[],"line":62,"deprecated":false,"deprecationMessage":"","jsdoctags":[{"name":"utente","type":"Utente","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"needFeedback","type":"boolean","deprecated":false,"deprecationMessage":"","defaultValue":"true","tagName":{"text":"param"}}]}],"deprecated":false,"deprecationMessage":"","description":"","rawdescription":"\\n","sourceCode":"import { HttpClient } from \\"@angular/common/http\\";\\nimport { Injectable } from \\"@angular/core\\";\\nimport { BaseHttpService, ConfigurationService, SearchResult } from \'@inail/internet-webkit\';\\nimport { BehaviorSubject, Observable } from \\"rxjs\\";\\nimport { map } from \\"rxjs/operators\\";\\nimport { UtenteConverter } from \\"../converters/utente.converter\\";\\nimport { Utente } from \\"../model/utente.model\\";\\n\\n\\n@Injectable({\\n\\tprovidedIn: \'root\',\\n})\\nexport class UtenteService extends BaseHttpService {\\n\\tprivate saveSubj: BehaviorSubject<boolean>;\\n\\tprivate utenteConverter = new UtenteConverter();\\n\\n\\tconstructor() {\\n\\t\\tsuper();\\n\\t\\tthis.saveSubj = new BehaviorSubject<boolean>(false);\\n\\t}\\n\\n\\tgetServiceName(): string {\\n\\t\\treturn \'UtenteService\';\\n\\t}\\n\\n\\tgetSaveSubj() {\\n\\t\\treturn this.saveSubj;\\n\\t}\\n\\n\\tsetSaveSubj(value: boolean) {\\n\\t\\tthis.saveSubj.next(value);\\n\\t}\\n\\n\\tfindUtenti(criteriaDto: any): Observable<SearchResult<Utente>> {\\n\\t\\tconst url = this.conf.getApi(\'utentiRicerca.ricerca\');\\n\\t\\tconst params = this.getPaginationParamsFromCriteria(criteriaDto);\\n\\n\\t\\treturn this.httpClient.post(url, criteriaDto, { params: params }).pipe(\\n\\t\\t\\tmap((response: any) => {\\n\\t\\t\\t\\treturn this.utenteConverter.convertSearchResult(response);\\n\\t\\t\\t})\\n\\t\\t);\\n\\t}\\n\\n\\tget(id: string): Observable<Utente> {\\n\\t\\tconst url = this.conf.getApi(\'utenti.utenti\') + `/${id}`;\\n\\t\\treturn this.httpClient\\n\\t\\t\\t.get(url)\\n\\t\\t\\t.pipe(map((response: any) => this.utenteConverter.convertToModel(response)));\\n\\t}\\n\\n\\taddUtente(utente: Utente): Observable<Utente> {\\n\\t\\tconst url = this.conf.getApi(\'utenti.utenti\');\\n\\t\\treturn this.httpClient\\n\\t\\t\\t.post(url, this.utenteConverter.convertToDto(utente))\\n\\t\\t\\t.pipe(map((response: any) => {\\n\\t\\t\\t\\tthis.saveSubj.next(true);\\n\\t\\t\\t\\treturn this.utenteConverter.convertToModel(response)\\n\\t\\t\\t}));\\n\\t}\\n\\n\\tupdateUtente(utente: Utente, needFeedback: boolean = true): Observable<Utente> {\\n\\t\\tconst url = this.conf.getApi(\'utenti.utenti\') + `/${utente.id}`;\\n\\t\\treturn this.httpClient\\n\\t\\t\\t.put(url, this.utenteConverter.convertToDto(utente))\\n\\t\\t\\t.pipe(map(\\n\\t\\t\\t\\t(response: any) => {\\n\\t\\t\\t\\t\\tif(needFeedback) {\\n\\t\\t\\t\\t\\t\\tthis.saveSubj.next(true);\\n\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\treturn this.utenteConverter.convertToModel(response);\\n\\t\\t\\t\\t}\\n\\t\\t\\t));\\n\\t}\\n\\n\\tdeleteUtente(utente: Utente): Observable<boolean> {\\n\\t\\tconst url = this.conf.getApi(\'utenti.utenti\') + `/${utente.id}`;\\n\\t\\treturn this.httpClient\\n\\t\\t\\t.delete(url)\\n\\t\\t\\t.pipe(map((response: any) => true));\\n\\t}\\n\\n}\\n","constructorObj":{"name":"constructor","description":"","deprecated":false,"deprecationMessage":"","args":[],"line":15},"extends":["BaseHttpService"],"type":"injectable"},{"name":"WizardService","id":"injectable-WizardService-03f43226cbe03e2576a063b6f0e596ea4b148ffa2f0d0d874aeb64636313f56223fd9720915493d4129108eb8af7eaeffc8ea736fa698055e1e8277d6c0c0a17","file":"src/stories/wizard-spa/services/wizard.service.ts","properties":[{"name":"draftConverter","defaultValue":"new DraftConverter()","deprecated":false,"deprecationMessage":"","type":"","indexKey":"","optional":false,"description":"","line":16,"modifierKind":[123]},{"name":"mock","defaultValue":"false","deprecated":false,"deprecationMessage":"","type":"","indexKey":"","optional":false,"description":"","line":14},{"name":"wizardConverter","defaultValue":"new WizardConverter()","deprecated":false,"deprecationMessage":"","type":"","indexKey":"","optional":false,"description":"","line":15,"modifierKind":[123]}],"methods":[{"name":"getDraft","args":[{"name":"id","type":"string","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"Observable<Draft>","typeParameters":[],"line":47,"deprecated":false,"deprecationMessage":"","jsdoctags":[{"name":"id","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"getServiceName","args":[],"optional":false,"returnType":"string","typeParameters":[],"line":17,"deprecated":false,"deprecationMessage":""},{"name":"init","args":[{"name":"id","type":"string","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"Observable<WizardModel>","typeParameters":[],"line":21,"deprecated":false,"deprecationMessage":"","jsdoctags":[{"name":"id","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"saveDraft","args":[{"name":"id","type":"any","deprecated":false,"deprecationMessage":""},{"name":"draft","type":"Draft","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"Observable<Draft>","typeParameters":[],"line":54,"deprecated":false,"deprecationMessage":"","jsdoctags":[{"name":"id","type":"any","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"draft","type":"Draft","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"saveWizard","args":[{"name":"wizard","type":"WizardModel","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"Observable<WizardModel>","typeParameters":[],"line":28,"deprecated":false,"deprecationMessage":"","jsdoctags":[{"name":"wizard","type":"WizardModel","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]}],"deprecated":false,"deprecationMessage":"","description":"","rawdescription":"\\n","sourceCode":"import {Injectable} from \'@angular/core\';\\nimport {BaseHttpService, Draft, DraftConverter, DraftDTO} from \'@inail/internet-webkit\';\\nimport {Observable} from \'rxjs\';\\nimport {map} from \'rxjs/operators\';\\nimport {WizardConverter} from \'../converters/wizard.converter\';\\n\\nimport { createUniqueId } from \'@inail/internet-webkit/utils\';\\nimport { WizardModel } from \'../model/wizard.model\';\\n\\n@Injectable({\\n\\tprovidedIn: \'root\',\\n})\\nexport class WizardService extends BaseHttpService {\\n\\tmock = false;\\n\\tprivate wizardConverter = new WizardConverter();\\n\\tprivate draftConverter = new DraftConverter();\\n\\tgetServiceName(): string {\\n\\t\\treturn \'WizardService\';\\n\\t}\\n\\n\\tinit(id: string): Observable<WizardModel> {\\n\\t\\tlet url = this.conf.getApi(\'wizard.wizard\', this.mock) + `/${id}`;\\n\\t\\treturn this.httpClient\\n\\t\\t\\t.get(url)\\n\\t\\t\\t.pipe(map((response: any) => this.wizardConverter.convertToModel(response)));\\n\\t}\\n\\n\\tsaveWizard(wizard: WizardModel): Observable<WizardModel> {\\n\\t\\tlet url = this.conf.getApi(\'wizard.wizard\', this.mock);\\n\\t\\tlet dto: any = this.wizardConverter.convertToDto(wizard);\\n\\t\\tdto = {\\n\\t\\t\\t...dto,\\n\\t\\t\\tstep1: {\\n\\t\\t\\t\\t...dto.step1,\\n\\t\\t\\t\\taddress: {\\n\\t\\t\\t\\t\\t...dto.step1?.address,\\n\\t\\t\\t\\t\\tcomune: dto.step1?.address.comune?.id ?? \'\',\\n\\t\\t\\t\\t\\tprovincia: dto.step1?.address.provincia?.id ?? \'\'\\n\\t\\t\\t\\t}\\n\\t\\t\\t}\\n\\t\\t};\\n\\t\\treturn this.httpClient\\n\\t\\t\\t.post(url, dto)\\n\\t\\t\\t.pipe(map((response: any) => this.wizardConverter.convertToModel(response)));\\n\\t}\\n\\n\\tgetDraft(id: string): Observable<Draft> {\\n\\t\\tlet url = this.conf.getApi(\'wizard.draft\', this.mock) + `?id=${id}`;\\n\\t\\treturn this.httpClient\\n\\t\\t\\t.get(url)\\n\\t\\t\\t.pipe(map((response: DraftDTO) => this.draftConverter.convertToModel(response)));\\n\\t}\\n\\n\\tsaveDraft(id: any, draft: Draft): Observable<Draft> {\\n\\t\\tlet url = this.conf.getApi(\'wizard.draft\');\\n\\t\\tlet dto: any = this.draftConverter.convertToDto(draft);\\n\\t\\tdto = {\\n\\t\\t\\t...dto,\\n\\t\\t\\tdto: {\\n\\t\\t\\t\\t...dto.dto,\\n\\t\\t\\t\\tstep1: {\\n\\t\\t\\t\\t\\t...dto.dto.step1,\\n\\t\\t\\t\\t\\taddress: {\\n\\t\\t\\t\\t\\t\\t...dto.step1?.address,\\n\\t\\t\\t\\t\\t\\tcomune: \'\',\\n\\t\\t\\t\\t\\t\\tprovincia: \'\'\\n\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t}\\n\\t\\t\\t}\\n\\t\\t};\\n\\t\\tif (draft.id) {\\n\\t\\t\\turl += `/${id}`;\\n\\t\\t\\treturn this.httpClient\\n\\t\\t\\t\\t.put(url, dto)\\n\\t\\t\\t\\t.pipe(\\n\\t\\t\\t\\t\\tmap((response: DraftDTO) => this.draftConverter.convertToModel(response))\\n\\t\\t\\t\\t);\\n\\t\\t} else {\\n\\t\\t\\tdto[\'id\'] = createUniqueId(); //only for jsonserver\\n\\t\\t\\treturn this.httpClient\\n\\t\\t\\t\\t.post(url, dto)\\n\\t\\t\\t\\t.pipe(\\n\\t\\t\\t\\t\\tmap((response: DraftDTO) => this.draftConverter.convertToModel(response)));\\n\\t\\t}\\n\\t}\\n}\\n","extends":["BaseHttpService"],"type":"injectable"}],"guards":[],"interceptors":[],"classes":[{"name":"CarConverter","id":"class-CarConverter-5aae0f3e27fc93f09045c13ee613f7cf54c25da2e4960a4f6b753e63f557925f1a4f544b6748c7f4f6d08930b7007f5defe8ce3083655551d567a8083878a1f5","file":"src/stories/wizard-spa/converters/step3.converter.ts","deprecated":false,"deprecationMessage":"","type":"class","sourceCode":"import { BaseConverter } from \'@inail/internet-webkit\';\\nimport { Step3Dto } from \'../dtos/step3.dto\';\\nimport { Step3 } from \'../model/step3.model\';\\n\\n\\nexport class CarConverter extends BaseConverter<Step3, Step3Dto> {\\n\\tpublic convertToModel(dto: Step3Dto): Step3 {\\n\\t\\treturn new Step3(dto.biografia);\\n\\t}\\n\\tpublic convertToDto(model: Step3): Step3Dto {\\n\\t\\treturn new Step3Dto(model.biografia);\\n\\t}\\n}\\n","inputsClass":[],"outputsClass":[],"properties":[],"methods":[{"name":"convertToDto","args":[{"name":"model","type":"Step3","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"Step3Dto","typeParameters":[],"line":10,"deprecated":false,"deprecationMessage":"","modifierKind":[125],"jsdoctags":[{"name":"model","type":"Step3","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"convertToModel","args":[{"name":"dto","type":"Step3Dto","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"Step3","typeParameters":[],"line":7,"deprecated":false,"deprecationMessage":"","modifierKind":[125],"jsdoctags":[{"name":"dto","type":"Step3Dto","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]}],"indexSignatures":[],"extends":["BaseConverter"],"hostBindings":[],"hostListeners":[]},{"name":"ErrorLabelConstantsExtended","id":"class-ErrorLabelConstantsExtended-6811c4a724701d98a11d637155e02ebc71bade430d1802eb68a235e358c06773a23015156a0607512d0eeb2378bf6ba65652338a9be604e5f518ac11d26936bb","file":"src/stories/form-controls/form-example/error-label.const.ts","deprecated":false,"deprecationMessage":"","type":"class","sourceCode":"import { ErrorLabel, ErrorLabelConstants } from \'@inail/internet-webkit\';\\n\\nexport class ErrorLabelConstantsExtended extends ErrorLabelConstants {\\n    public static EMAIL_PATTERN = new ErrorLabel(\\n        (control) => control ? control.hasError(\'pattern\') : false,\\n        \'ERROR.EMAIL_INVALID_PATTERN\',\\n    );\\n\\n    public static REQUIRED_WITH_NAME = (itemLabel: string) => new ErrorLabel(\\n        (control) => control ? control.hasError(\'required\') : false,\\n        \'ERROR.REQUIRED_WITH_NAME\',\\n        { name: itemLabel }\\n    );\\n\\n    public static MAX_LENGTH_WITH_NAME = (length: number, itemLabel: string) => new ErrorLabel(\\n        (control) => control ? control.hasError(\'maxlength\') : false,\\n        \'ERROR.MAX_LENGTH_WITH_NAME\',\\n        {\\n            maxValue: length,\\n            name: itemLabel\\n        }\\n    );\\n}\\n","inputsClass":[],"outputsClass":[],"properties":[{"name":"EMAIL_PATTERN","defaultValue":"new ErrorLabel(\\n        (control) => control ? control.hasError(\'pattern\') : false,\\n        \'ERROR.EMAIL_INVALID_PATTERN\',\\n    )","deprecated":false,"deprecationMessage":"","type":"","indexKey":"","optional":false,"description":"","line":6,"modifierKind":[126]},{"name":"MAX_LENGTH_WITH_NAME","defaultValue":"() => {...}","deprecated":false,"deprecationMessage":"","type":"","indexKey":"","optional":false,"description":"","line":17,"modifierKind":[126]},{"name":"REQUIRED_WITH_NAME","defaultValue":"() => {...}","deprecated":false,"deprecationMessage":"","type":"","indexKey":"","optional":false,"description":"","line":11,"modifierKind":[126]}],"methods":[],"indexSignatures":[],"extends":["ErrorLabelConstants"],"hostBindings":[],"hostListeners":[]},{"name":"HeaderFooterComponent","id":"class-HeaderFooterComponent-4940adc99b61c35db42cee22c2a365f1fcf8fb3b541af75261a618fff1d1821366d212d7b6e59d245617eb22d27aba3fb05c7f51aa2f07f1e1f7cd69ba67f1d7","file":"src/common/shared/header-footer.component.ts","deprecated":false,"deprecationMessage":"","type":"class","sourceCode":"export class HeaderFooterComponent {\\n    async fetchData(): Promise<any> {\\n        //   const url = \'/api/hf_intra/public/fullhtml?rewrite=true&lang=it&nome_applicazione=storybook_angular_17_internet\';\\n        const urlInternet = \'/api/hf/public/fullhtml_rw?lang=it&isHeadSimple=false\'\\n        let responseHtml!: any;\\n        let responseHead!: any;\\n\\n        try {\\n            const response = await fetch(urlInternet, {\\n                //   headers: {\\n                //     \'client_id\': \'ClientHF_v3\',\\n                //     \'tipo_ambiente\': \'intranet\',\\n                //     \'nome_applicazione\': \'storybook_angular_17_internet\',\\n                //   }\\n                headers: {\\n                    \'client_id\': \'ClientHF_v4\',\\n                    // \'tipo_ambiente\': \'internet\',\\n                    // \'isHeadSimple\': \'false\',\\n                }\\n            });\\n\\n            const json = await response.json();\\n            const headContent = json[\'htmlHead\'];\\n            responseHtml = json;\\n            responseHead = headContent\\n\\n\\n        } catch (error) {\\n            console.error(\'Error fetching header data:\', error);\\n        }\\n        finally {\\n            this.addHeadScripts(responseHead);\\n            return new Promise((resolve) => {\\n                resolve(responseHtml);\\n            });\\n        }\\n    }\\n\\n    addHeadScripts(script: string) {\\n        const start = \'\x3c!--SB-START--\x3e\'\\n        const end = \'\x3c!--SB-END--\x3e\'\\n        const headElement = document.getElementsByTagName(\'head\').item(0);\\n        const body = document.getElementsByTagName(\'body\').item(0);\\n        body?.classList.add(\'container\');\\n        if (headElement) {\\n            const tempDiv = document.createElement(\'div\');\\n            tempDiv.innerHTML = start + script + end;\\n\\n            while (tempDiv.firstChild) {\\n                headElement.appendChild(tempDiv.firstChild);\\n            }\\n        }\\n    }\\n\\n    async CreateHeader(): Promise<string> {\\n        const html = await this.fetchData();\\n        return html.htmlLogo + html.htmlHeader;\\n    }\\n\\n    async CreateFooter(): Promise<string> {\\n        const html = await this.fetchData();\\n        return html.htmlFooter;\\n    }\\n}\\n","inputsClass":[],"outputsClass":[],"properties":[],"methods":[{"name":"addHeadScripts","args":[{"name":"script","type":"string","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"void","typeParameters":[],"line":39,"deprecated":false,"deprecationMessage":"","jsdoctags":[{"name":"script","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"CreateFooter","args":[],"optional":false,"returnType":"Promise<string>","typeParameters":[],"line":60,"deprecated":false,"deprecationMessage":"","modifierKind":[134]},{"name":"CreateHeader","args":[],"optional":false,"returnType":"Promise<string>","typeParameters":[],"line":55,"deprecated":false,"deprecationMessage":"","modifierKind":[134]},{"name":"fetchData","args":[],"optional":false,"returnType":"Promise<any>","typeParameters":[],"line":2,"deprecated":false,"deprecationMessage":"","modifierKind":[134]}],"indexSignatures":[],"extends":[],"hostBindings":[],"hostListeners":[]},{"name":"Step1","id":"class-Step1-51f9d71d296b66dd22a5ed7d299447c186634455f152dc73adeca8c03abfc877804cc7d4545331152df9facfbbf5362b0e22b20abbf96ccff03a4c9f849f1ed2","file":"src/stories/wizard-spa/model/step1.model.ts","deprecated":false,"deprecationMessage":"","type":"class","sourceCode":"import { BaseModel } from \'@inail/internet-webkit\';\\n\\nexport class Step1 extends BaseModel {\\n\\n\\tconstructor(\\n\\t\\tpublic name: string,\\n\\t\\tpublic surname: string,\\n\\t\\tpublic indirizzo: { via: string, cap: number, provincia: string, comune: string },\\n\\t\\tpublic hasCar: boolean\\n\\t) {\\n\\t\\tsuper();\\n\\t\\tthis.id = name;\\n\\t}\\n\\n\\t/**\\n\\t * Getter id\\n\\t * @return\\n\\t */\\n\\tpublic get id(): any {\\n\\t\\treturn this.name;\\n\\t}\\n\\n\\t/**\\n\\t * Setter id\\n\\t * @param value\\n\\t */\\n\\tpublic set id(value: any) {\\n\\t\\tthis.name = value;\\n\\t}\\n}\\n","constructorObj":{"name":"constructor","description":"","deprecated":false,"deprecationMessage":"","args":[{"name":"name","type":"string","deprecated":false,"deprecationMessage":""},{"name":"surname","type":"string","deprecated":false,"deprecationMessage":""},{"name":"indirizzo","type":"literal type","deprecated":false,"deprecationMessage":""},{"name":"hasCar","type":"boolean","deprecated":false,"deprecationMessage":""}],"line":3,"jsdoctags":[{"name":"name","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"surname","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"indirizzo","type":"literal type","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"hasCar","type":"boolean","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},"inputsClass":[],"outputsClass":[],"properties":[{"name":"hasCar","deprecated":false,"deprecationMessage":"","type":"boolean","indexKey":"","optional":false,"description":"","line":9,"modifierKind":[125]},{"name":"indirizzo","deprecated":false,"deprecationMessage":"","type":"literal type","indexKey":"","optional":false,"description":"","line":8,"modifierKind":[125]},{"name":"name","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":6,"modifierKind":[125]},{"name":"surname","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":7,"modifierKind":[125]}],"methods":[],"indexSignatures":[],"extends":["BaseModel"],"accessors":{"id":{"name":"id","setSignature":{"name":"id","type":"void","deprecated":false,"deprecationMessage":"","args":[{"name":"value","type":"any","deprecated":false,"deprecationMessage":""}],"returnType":"void","line":27,"rawdescription":"\\n\\nSetter id\\n","description":"<p>Setter id</p>\\n","jsdoctags":[{"name":{"pos":418,"end":423,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"value"},"type":"any","deprecated":false,"deprecationMessage":"","tagName":{"pos":412,"end":417,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"param"},"comment":""}]},"getSignature":{"name":"id","type":"any","returnType":"any","line":19,"rawdescription":"\\n\\nGetter id\\n","description":"<p>Getter id</p>\\n","jsdoctags":[{"pos":327,"end":337,"kind":342,"id":0,"flags":16842752,"modifierFlagsCache":0,"transformFlags":0,"tagName":{"pos":328,"end":334,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"return"},"comment":""}]}}},"hostBindings":[],"hostListeners":[]},{"name":"Step1Converter","id":"class-Step1Converter-1b9b0eaa3d3507c4bb993e5f5c0e27b560ceade62eece92dc2aae662ed5e62a950637b23ee37d85f77570a92a9c8aaaaa64f392e20de3ec4062e151456c1be92","file":"src/stories/wizard-spa/converters/step1.converter.ts","deprecated":false,"deprecationMessage":"","type":"class","sourceCode":"import { BaseConverter } from \'@inail/internet-webkit\';\\nimport { Step1Dto } from \'../dtos/step1.dto\';\\nimport { Step1 } from \'../model/step1.model\';\\n\\n\\nexport class Step1Converter extends BaseConverter<Step1, Step1Dto> {\\n\\tpublic convertToModel(dto: Step1Dto): Step1 {\\n\\t\\treturn new Step1(dto.name, dto.surname, dto.address, dto.hasCar);\\n\\t}\\n\\tpublic convertToDto(model: Step1): Step1Dto {\\n\\t\\treturn new Step1Dto(model.name, model.indirizzo, model.surname, model.hasCar);\\n\\t}\\n}\\n","inputsClass":[],"outputsClass":[],"properties":[],"methods":[{"name":"convertToDto","args":[{"name":"model","type":"Step1","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"Step1Dto","typeParameters":[],"line":10,"deprecated":false,"deprecationMessage":"","modifierKind":[125],"jsdoctags":[{"name":"model","type":"Step1","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"convertToModel","args":[{"name":"dto","type":"Step1Dto","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"Step1","typeParameters":[],"line":7,"deprecated":false,"deprecationMessage":"","modifierKind":[125],"jsdoctags":[{"name":"dto","type":"Step1Dto","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]}],"indexSignatures":[],"extends":["BaseConverter"],"hostBindings":[],"hostListeners":[]},{"name":"Step1Dto","id":"class-Step1Dto-87527fd4242c6b3eadd219333ad5cd0e463a958603e5405b46b3c4247c94ccf28333b7ef55fcb459c380e23e7927638ac796ed55c2f307b1910e60b9866a100e","file":"src/stories/wizard-spa/dtos/step1.dto.ts","deprecated":false,"deprecationMessage":"","type":"class","sourceCode":"export class Step1Dto {\\n\\tconstructor(public name: string,\\n\\t\\tpublic address: { via: string, cap: number, provincia: string, comune: string },\\n\\t\\tpublic surname: string,\\n\\t\\tpublic hasCar: boolean) { }\\n}\\n","constructorObj":{"name":"constructor","description":"","deprecated":false,"deprecationMessage":"","args":[{"name":"name","type":"string","deprecated":false,"deprecationMessage":""},{"name":"address","type":"literal type","deprecated":false,"deprecationMessage":""},{"name":"surname","type":"string","deprecated":false,"deprecationMessage":""},{"name":"hasCar","type":"boolean","deprecated":false,"deprecationMessage":""}],"line":1,"jsdoctags":[{"name":"name","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"address","type":"literal type","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"surname","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"hasCar","type":"boolean","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},"inputsClass":[],"outputsClass":[],"properties":[{"name":"address","deprecated":false,"deprecationMessage":"","type":"literal type","indexKey":"","optional":false,"description":"","line":3,"modifierKind":[125]},{"name":"hasCar","deprecated":false,"deprecationMessage":"","type":"boolean","indexKey":"","optional":false,"description":"","line":5,"modifierKind":[125]},{"name":"name","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":2,"modifierKind":[125]},{"name":"surname","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":4,"modifierKind":[125]}],"methods":[],"indexSignatures":[],"extends":[],"hostBindings":[],"hostListeners":[]},{"name":"Step2","id":"class-Step2-3846d5bc0ae8078ea0c8df32fe53a59df647b6a500c4c417f09b11d4d0b157592d51c287a1acc953df0a42036e2d88d8690ddb957d63add74773f37cf325feb3","file":"src/stories/wizard-spa/model/step2.model.ts","deprecated":false,"deprecationMessage":"","type":"class","sourceCode":"import { BaseModel } from \'@inail/internet-webkit\';\\n\\nexport class Step2 extends BaseModel {\\n\\tconstructor(\\n\\t\\tpublic tipo: string,\\n\\t\\tpublic marca: string,\\n\\t\\tpublic modello: string,\\n\\t\\tpublic targa: string,\\n\\t) {\\n\\t\\tsuper();\\n\\t\\tthis.id = targa;\\n\\t}\\n\\n\\t/**\\n\\t * Getter id\\n\\t * @return\\n\\t */\\n\\tpublic get id(): any {\\n\\t\\treturn this.targa;\\n\\t}\\n\\n\\t/**\\n\\t * Setter id\\n\\t * @param value\\n\\t */\\n\\tpublic set id(value: any) {\\n\\t\\tthis.targa = value;\\n\\t}\\n}\\n","constructorObj":{"name":"constructor","description":"","deprecated":false,"deprecationMessage":"","args":[{"name":"tipo","type":"string","deprecated":false,"deprecationMessage":""},{"name":"marca","type":"string","deprecated":false,"deprecationMessage":""},{"name":"modello","type":"string","deprecated":false,"deprecationMessage":""},{"name":"targa","type":"string","deprecated":false,"deprecationMessage":""}],"line":3,"jsdoctags":[{"name":"tipo","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"marca","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"modello","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"targa","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},"inputsClass":[],"outputsClass":[],"properties":[{"name":"marca","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":6,"modifierKind":[125]},{"name":"modello","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":7,"modifierKind":[125]},{"name":"targa","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":8,"modifierKind":[125]},{"name":"tipo","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":5,"modifierKind":[125]}],"methods":[],"indexSignatures":[],"extends":["BaseModel"],"accessors":{"id":{"name":"id","setSignature":{"name":"id","type":"void","deprecated":false,"deprecationMessage":"","args":[{"name":"value","type":"any","deprecated":false,"deprecationMessage":""}],"returnType":"void","line":26,"rawdescription":"\\n\\nSetter id\\n","description":"<p>Setter id</p>\\n","jsdoctags":[{"name":{"pos":357,"end":362,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"value"},"type":"any","deprecated":false,"deprecationMessage":"","tagName":{"pos":351,"end":356,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"param"},"comment":""}]},"getSignature":{"name":"id","type":"any","returnType":"any","line":18,"rawdescription":"\\n\\nGetter id\\n","description":"<p>Getter id</p>\\n","jsdoctags":[{"pos":265,"end":275,"kind":342,"id":0,"flags":16842752,"modifierFlagsCache":0,"transformFlags":0,"tagName":{"pos":266,"end":272,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"return"},"comment":""}]}}},"hostBindings":[],"hostListeners":[]},{"name":"Step2Converter","id":"class-Step2Converter-fdd1fcdfb28d3168bb9e21d9afaa40797c7dfe0c2f98a6a36e970ba45941e8a064fa5c9c8cfc8adad7bf8dc8659b21666349c78ba4edce84c4c76a42e2aced0a","file":"src/stories/wizard-spa/converters/step2.converter.ts","deprecated":false,"deprecationMessage":"","type":"class","sourceCode":"import { BaseConverter } from \'@inail/internet-webkit\';\\nimport { Step2Dto } from \'../dtos/step2.dto\';\\nimport { Step2 } from \'../model/step2.model\';\\n\\n\\nexport class Step2Converter extends BaseConverter<Step2, Step2Dto> {\\n\\tpublic convertToModel(dto: Step2Dto): Step2 {\\n\\t\\treturn new Step2(dto.tipo,\\n\\t\\t\\tdto.marca,\\n\\t\\t\\tdto.modello,\\n\\t\\t\\tdto.targa);\\n\\t}\\n\\tpublic convertToDto(model: Step2): Step2Dto {\\n\\t\\tlet tipo = \'\';\\n\\t\\tif(model.tipo && model.tipo.length) {\\n\\t\\t\\ttipo = (model.tipo as unknown as []).reduce(\\n\\t\\t\\t\\t(prev, curr) =>\\n\\t\\t\\t\\t\\t`${prev}${curr};`\\n\\t\\t\\t, \'\');\\n\\t\\t}\\n\\t\\treturn new Step2Dto(tipo,\\n\\t\\t\\tmodel.marca,\\n\\t\\t\\tmodel.modello,\\n\\t\\t\\tmodel.targa);\\n\\t}\\n}\\n","inputsClass":[],"outputsClass":[],"properties":[],"methods":[{"name":"convertToDto","args":[{"name":"model","type":"Step2","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"Step2Dto","typeParameters":[],"line":13,"deprecated":false,"deprecationMessage":"","modifierKind":[125],"jsdoctags":[{"name":"model","type":"Step2","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"convertToModel","args":[{"name":"dto","type":"Step2Dto","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"Step2","typeParameters":[],"line":7,"deprecated":false,"deprecationMessage":"","modifierKind":[125],"jsdoctags":[{"name":"dto","type":"Step2Dto","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]}],"indexSignatures":[],"extends":["BaseConverter"],"hostBindings":[],"hostListeners":[]},{"name":"Step2Dto","id":"class-Step2Dto-9086c036a411c8cd13aad7e46f7d65514fcff49ca4a7812569e613cdd121f9a58bcc44e9a6e8b8f791a4c3e6c98f635db11024cc2f6082cb1000d6a005904167","file":"src/stories/wizard-spa/dtos/step2.dto.ts","deprecated":false,"deprecationMessage":"","type":"class","sourceCode":"export class Step2Dto {\\n\\tconstructor(public tipo: string,\\n\\t\\tpublic marca: string,\\n\\t\\tpublic modello: string,\\n\\t\\tpublic targa: string) { }\\n}\\n","constructorObj":{"name":"constructor","description":"","deprecated":false,"deprecationMessage":"","args":[{"name":"tipo","type":"string","deprecated":false,"deprecationMessage":""},{"name":"marca","type":"string","deprecated":false,"deprecationMessage":""},{"name":"modello","type":"string","deprecated":false,"deprecationMessage":""},{"name":"targa","type":"string","deprecated":false,"deprecationMessage":""}],"line":1,"jsdoctags":[{"name":"tipo","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"marca","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"modello","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"targa","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},"inputsClass":[],"outputsClass":[],"properties":[{"name":"marca","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":3,"modifierKind":[125]},{"name":"modello","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":4,"modifierKind":[125]},{"name":"targa","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":5,"modifierKind":[125]},{"name":"tipo","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":2,"modifierKind":[125]}],"methods":[],"indexSignatures":[],"extends":[],"hostBindings":[],"hostListeners":[]},{"name":"Step3","id":"class-Step3-3b0443cdda3ea43e5f90c167888942b53f4d9f468623559156b91526a725ed95554c66693ca49a69d9e30dc2c96237c2808f0a3cd15bcfdf680fe3f4230080c2","file":"src/stories/wizard-spa/model/step3.model.ts","deprecated":false,"deprecationMessage":"","type":"class","sourceCode":"import { BaseModel } from \'@inail/internet-webkit\';\\n\\nexport class Step3 extends BaseModel {\\n\\tconstructor(public biografia: string) {\\n\\t\\tsuper();\\n\\t\\tthis.id = biografia;\\n\\t}\\n\\n\\t/**\\n\\t * Getter id\\n\\t * @return\\n\\t */\\n\\tpublic get id(): any {\\n\\t\\treturn this.biografia;\\n\\t}\\n\\n\\t/**\\n\\t * Setter id\\n\\t * @param value\\n\\t */\\n\\tpublic set id(value: any) {\\n\\t\\tthis.biografia = value;\\n\\t}\\n}\\n","constructorObj":{"name":"constructor","description":"","deprecated":false,"deprecationMessage":"","args":[{"name":"biografia","type":"string","deprecated":false,"deprecationMessage":""}],"line":3,"jsdoctags":[{"name":"biografia","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},"inputsClass":[],"outputsClass":[],"properties":[{"name":"biografia","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":4,"modifierKind":[125]}],"methods":[],"indexSignatures":[],"extends":["BaseModel"],"accessors":{"id":{"name":"id","setSignature":{"name":"id","type":"void","deprecated":false,"deprecationMessage":"","args":[{"name":"value","type":"any","deprecated":false,"deprecationMessage":""}],"returnType":"void","line":21,"rawdescription":"\\n\\nSetter id\\n","description":"<p>Setter id</p>\\n","jsdoctags":[{"name":{"pos":290,"end":295,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"value"},"type":"any","deprecated":false,"deprecationMessage":"","tagName":{"pos":284,"end":289,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"param"},"comment":""}]},"getSignature":{"name":"id","type":"any","returnType":"any","line":13,"rawdescription":"\\n\\nGetter id\\n","description":"<p>Getter id</p>\\n","jsdoctags":[{"pos":194,"end":204,"kind":342,"id":0,"flags":16842752,"modifierFlagsCache":0,"transformFlags":0,"tagName":{"pos":195,"end":201,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"return"},"comment":""}]}}},"hostBindings":[],"hostListeners":[]},{"name":"Step3Dto","id":"class-Step3Dto-4ecdbbe2b51eb075d0098cbe32e4f69185e1f536c27696fcd23ee6d2f7fc59822ec64c4f736fe5726e5c42b47351ad3ee9304fefb416c480ec149abe5d710d89","file":"src/stories/wizard-spa/dtos/step3.dto.ts","deprecated":false,"deprecationMessage":"","type":"class","sourceCode":"export class Step3Dto {\\n\\tconstructor(public biografia: string) { }\\n}\\n","constructorObj":{"name":"constructor","description":"","deprecated":false,"deprecationMessage":"","args":[{"name":"biografia","type":"string","deprecated":false,"deprecationMessage":""}],"line":1,"jsdoctags":[{"name":"biografia","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},"inputsClass":[],"outputsClass":[],"properties":[{"name":"biografia","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":2,"modifierKind":[125]}],"methods":[],"indexSignatures":[],"extends":[],"hostBindings":[],"hostListeners":[]},{"name":"Utente","id":"class-Utente-d6bdf017e0aa559df0c67c8156919784f1cc993a31e2203ae29a49575219b8b1d1f4a7a581cc94c141fd2dc0e3d7ee7adaf8b0a58d83d1a5629c581f8addd1c5","file":"src/stories/wizard-spa/model/utente.model.ts","deprecated":false,"deprecationMessage":"","type":"class","sourceCode":"import { BaseModel, DateModel } from \'@inail/internet-webkit\';\\n\\nexport class Utente extends BaseModel {\\n\\n  private _id!: string;\\n  private _nome: string;\\n  private _cognome: string;\\n  private _email: string;\\n  private _sesso: string;\\n  private _dataNascita: DateModel | undefined;\\n  private _biografia: string;\\n  private _numero: string;\\n  private _via: string;\\n  private _cap: number;\\n  private _citta: string;\\n\\n  constructor(\\n    nome: string,\\n    cognome: string,\\n    email: string,\\n    sesso?: string | any,\\n    dataNascita?: DateModel,\\n    biografia?: string | any,\\n    numero?: string | any,\\n    via?: string | any,\\n    cap?: number | any,\\n    citta?: string | any,\\n    id?: string | any,\\n    public progress?: number | undefined,\\n  ) {\\n    super();\\n    this._nome = nome;\\n    this._cognome = cognome;\\n    this._email = email;\\n    this._sesso = sesso;\\n    this._dataNascita = dataNascita;\\n    this._biografia = biografia;\\n    this._numero = numero;\\n    this._via = via;\\n    this._cap = cap;\\n    this._citta = citta;\\n    this.id = id;\\n  }\\n\\n  set id(id: string) {\\n    this._id = id;\\n  }\\n\\n  get id() {\\n    return this._id;\\n  }\\n\\n  /**\\n   * Getter nome\\n   * @return\\n   */\\n  public get nome(): string {\\n    return this._nome;\\n  }\\n\\n  /**\\n   * Getter cognome\\n   * @return\\n   */\\n  public get cognome(): string {\\n    return this._cognome;\\n  }\\n\\n  /**\\n   * Getter email\\n   * @return\\n   */\\n  public get email(): string {\\n    return this._email;\\n  }\\n\\n  /**\\n   * Getter sesso\\n   * @return\\n   */\\n  public get sesso(): string {\\n    return this._sesso;\\n  }\\n\\n  /**\\n   * Getter dataNascita\\n   * @return\\n   */\\n  public get dataNascita(): DateModel | undefined {\\n    return this._dataNascita;\\n  }\\n\\n  /**\\n   * Getter biografia\\n   * @return\\n   */\\n  public get biografia(): string {\\n    return this._biografia;\\n  }\\n\\n  /**\\n   * Getter numero\\n   * @return\\n   */\\n  public get numero(): string {\\n    return this._numero;\\n  }\\n\\n  /**\\n   * Getter via\\n   * @return\\n   */\\n  public get via(): string {\\n    return this._via;\\n  }\\n\\n  /**\\n   * Getter cap\\n   * @return\\n   */\\n  public get cap(): number {\\n    return this._cap;\\n  }\\n\\n  /**\\n   * Getter citta\\n   * @return\\n   */\\n  public get citta(): string {\\n    return this._citta;\\n  }\\n\\n}\\n","constructorObj":{"name":"constructor","description":"","deprecated":false,"deprecationMessage":"","args":[{"name":"nome","type":"string","deprecated":false,"deprecationMessage":""},{"name":"cognome","type":"string","deprecated":false,"deprecationMessage":""},{"name":"email","type":"string","deprecated":false,"deprecationMessage":""},{"name":"sesso","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true},{"name":"dataNascita","type":"DateModel","deprecated":false,"deprecationMessage":"","optional":true},{"name":"biografia","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true},{"name":"numero","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true},{"name":"via","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true},{"name":"cap","type":"number | any","deprecated":false,"deprecationMessage":"","optional":true},{"name":"citta","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true},{"name":"id","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true},{"name":"progress","type":"number | undefined","deprecated":false,"deprecationMessage":"","optional":true}],"line":15,"jsdoctags":[{"name":"nome","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"cognome","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"email","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"sesso","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true,"tagName":{"text":"param"}},{"name":"dataNascita","type":"DateModel","deprecated":false,"deprecationMessage":"","optional":true,"tagName":{"text":"param"}},{"name":"biografia","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true,"tagName":{"text":"param"}},{"name":"numero","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true,"tagName":{"text":"param"}},{"name":"via","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true,"tagName":{"text":"param"}},{"name":"cap","type":"number | any","deprecated":false,"deprecationMessage":"","optional":true,"tagName":{"text":"param"}},{"name":"citta","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true,"tagName":{"text":"param"}},{"name":"id","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true,"tagName":{"text":"param"}},{"name":"progress","type":"number | undefined","deprecated":false,"deprecationMessage":"","optional":true,"tagName":{"text":"param"}}]},"inputsClass":[],"outputsClass":[],"properties":[{"name":"_biografia","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":11,"modifierKind":[123]},{"name":"_cap","deprecated":false,"deprecationMessage":"","type":"number","indexKey":"","optional":false,"description":"","line":14,"modifierKind":[123]},{"name":"_citta","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":15,"modifierKind":[123]},{"name":"_cognome","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":7,"modifierKind":[123]},{"name":"_dataNascita","deprecated":false,"deprecationMessage":"","type":"DateModel | undefined","indexKey":"","optional":false,"description":"","line":10,"modifierKind":[123]},{"name":"_email","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":8,"modifierKind":[123]},{"name":"_id","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":5,"modifierKind":[123]},{"name":"_nome","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":6,"modifierKind":[123]},{"name":"_numero","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":12,"modifierKind":[123]},{"name":"_sesso","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":9,"modifierKind":[123]},{"name":"_via","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":13,"modifierKind":[123]},{"name":"progress","deprecated":false,"deprecationMessage":"","type":"number | undefined","indexKey":"","optional":true,"description":"","line":29,"modifierKind":[125]}],"methods":[],"indexSignatures":[],"extends":["BaseModel"],"accessors":{"id":{"name":"id","setSignature":{"name":"id","type":"void","deprecated":false,"deprecationMessage":"","args":[{"name":"id","type":"string","deprecated":false,"deprecationMessage":""}],"returnType":"void","line":45,"jsdoctags":[{"name":"id","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},"getSignature":{"name":"id","type":"","returnType":"","line":49}},"nome":{"name":"nome","getSignature":{"name":"nome","type":"string","returnType":"string","line":57,"rawdescription":"\\n\\nGetter nome\\n","description":"<p>Getter nome</p>\\n","jsdoctags":[{"pos":1159,"end":1170,"kind":342,"id":0,"flags":16842752,"modifierFlagsCache":0,"transformFlags":0,"tagName":{"pos":1160,"end":1166,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"return"},"comment":""}]}},"cognome":{"name":"cognome","getSignature":{"name":"cognome","type":"string","returnType":"string","line":65,"rawdescription":"\\n\\nGetter cognome\\n","description":"<p>Getter cognome</p>\\n","jsdoctags":[{"pos":1262,"end":1273,"kind":342,"id":0,"flags":16842752,"modifierFlagsCache":0,"transformFlags":0,"tagName":{"pos":1263,"end":1269,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"return"},"comment":""}]}},"email":{"name":"email","getSignature":{"name":"email","type":"string","returnType":"string","line":73,"rawdescription":"\\n\\nGetter email\\n","description":"<p>Getter email</p>\\n","jsdoctags":[{"pos":1369,"end":1380,"kind":342,"id":0,"flags":16842752,"modifierFlagsCache":0,"transformFlags":0,"tagName":{"pos":1370,"end":1376,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"return"},"comment":""}]}},"sesso":{"name":"sesso","getSignature":{"name":"sesso","type":"string","returnType":"string","line":81,"rawdescription":"\\n\\nGetter sesso\\n","description":"<p>Getter sesso</p>\\n","jsdoctags":[{"pos":1472,"end":1483,"kind":342,"id":0,"flags":16842752,"modifierFlagsCache":0,"transformFlags":0,"tagName":{"pos":1473,"end":1479,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"return"},"comment":""}]}},"dataNascita":{"name":"dataNascita","getSignature":{"name":"dataNascita","type":"","returnType":"DateModel | undefined","line":89,"rawdescription":"\\n\\nGetter dataNascita\\n","description":"<p>Getter dataNascita</p>\\n","jsdoctags":[{"pos":1581,"end":1592,"kind":342,"id":0,"flags":16842752,"modifierFlagsCache":0,"transformFlags":0,"tagName":{"pos":1582,"end":1588,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"return"},"comment":""}]}},"biografia":{"name":"biografia","getSignature":{"name":"biografia","type":"string","returnType":"string","line":97,"rawdescription":"\\n\\nGetter biografia\\n","description":"<p>Getter biografia</p>\\n","jsdoctags":[{"pos":1715,"end":1726,"kind":342,"id":0,"flags":16842752,"modifierFlagsCache":0,"transformFlags":0,"tagName":{"pos":1716,"end":1722,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"return"},"comment":""}]}},"numero":{"name":"numero","getSignature":{"name":"numero","type":"string","returnType":"string","line":105,"rawdescription":"\\n\\nGetter numero\\n","description":"<p>Getter numero</p>\\n","jsdoctags":[{"pos":1827,"end":1838,"kind":342,"id":0,"flags":16842752,"modifierFlagsCache":0,"transformFlags":0,"tagName":{"pos":1828,"end":1834,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"return"},"comment":""}]}},"via":{"name":"via","getSignature":{"name":"via","type":"string","returnType":"string","line":113,"rawdescription":"\\n\\nGetter via\\n","description":"<p>Getter via</p>\\n","jsdoctags":[{"pos":1930,"end":1941,"kind":342,"id":0,"flags":16842752,"modifierFlagsCache":0,"transformFlags":0,"tagName":{"pos":1931,"end":1937,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"return"},"comment":""}]}},"cap":{"name":"cap","getSignature":{"name":"cap","type":"number","returnType":"number","line":121,"rawdescription":"\\n\\nGetter cap\\n","description":"<p>Getter cap</p>\\n","jsdoctags":[{"pos":2027,"end":2038,"kind":342,"id":0,"flags":16842752,"modifierFlagsCache":0,"transformFlags":0,"tagName":{"pos":2028,"end":2034,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"return"},"comment":""}]}},"citta":{"name":"citta","getSignature":{"name":"citta","type":"string","returnType":"string","line":129,"rawdescription":"\\n\\nGetter citta\\n","description":"<p>Getter citta</p>\\n","jsdoctags":[{"pos":2126,"end":2137,"kind":342,"id":0,"flags":16842752,"modifierFlagsCache":0,"transformFlags":0,"tagName":{"pos":2127,"end":2133,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"return"},"comment":""}]}}},"hostBindings":[],"hostListeners":[]},{"name":"UtenteConverter","id":"class-UtenteConverter-eae37e32a7b25e7a735aa61872cb1476986b2f6b55847e02e85b49927feeba3ad0678cfb8e2ec5c5094f546abfbb7c2b1f784944f524d4f27c5bb96186e0bf80","file":"src/stories/wizard-spa/converters/utente.converter.ts","deprecated":false,"deprecationMessage":"","type":"class","sourceCode":"import { BaseConverter } from \'@inail/internet-webkit\';\\nimport { UtenteDto } from \\"../dtos/utente.dto\\";\\nimport {convertDtoToDateModel} from \'@inail/internet-webkit/utils\';\\nimport { Utente } from \'../model/utente.model\';\\n\\nexport class UtenteConverter extends BaseConverter<Utente, UtenteDto> {\\n\\n  convertToModel(dto: UtenteDto): Utente {\\n    return new Utente(\\n      dto.nome,\\n      dto.cognome,\\n      dto.email?.replace(\' \', \'\'),\\n      dto.sesso,\\n      convertDtoToDateModel(dto.dataNascita),\\n      dto.biografia,\\n      dto.numero,\\n      dto.via,\\n      dto.cap,\\n      dto.citta,\\n      dto.id,\\n      dto.progress,\\n    );\\n  }\\n\\n  convertToDto(model: Utente): UtenteDto {\\n    return new UtenteDto(\\n      model.nome,\\n      model.cognome,\\n      model.email,\\n      model.sesso,\\n      model.dataNascita ? model.dataNascita.toDate() : undefined,\\n      model.biografia,\\n      model.numero,\\n      model.via,\\n      model.cap,\\n      model.citta,\\n    );\\n  }\\n\\n}\\n","inputsClass":[],"outputsClass":[],"properties":[],"methods":[{"name":"convertToDto","args":[{"name":"model","type":"Utente","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"UtenteDto","typeParameters":[],"line":25,"deprecated":false,"deprecationMessage":"","jsdoctags":[{"name":"model","type":"Utente","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"convertToModel","args":[{"name":"dto","type":"UtenteDto","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"Utente","typeParameters":[],"line":8,"deprecated":false,"deprecationMessage":"","jsdoctags":[{"name":"dto","type":"UtenteDto","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]}],"indexSignatures":[],"extends":["BaseConverter"],"hostBindings":[],"hostListeners":[]},{"name":"UtenteDto","id":"class-UtenteDto-677e1b74f1a0f89bc6df625efb99bea0ae86670595500c5b3c1e4803f2e1ee0d22076c30bd38245d7190e23fee1c4d85c39318d4031d32c1571533cac450cc09","file":"src/stories/wizard-spa/dtos/utente.dto.ts","deprecated":false,"deprecationMessage":"","type":"class","sourceCode":"import { createUniqueId } from \'@inail/internet-webkit/utils\';\\n\\nexport class UtenteDto {\\n  id: string;\\n  nome: string;\\n  cognome: string;\\n  email: string;\\n  sesso: string;\\n  dataNascita: Date;\\n  biografia: string;\\n  numero: string;\\n  via: string;\\n  cap: number;\\n  citta: string;\\n\\n  constructor(\\n    nome: string,\\n    cognome: string,\\n    email?: string | any,\\n    sesso?: string | any,\\n    dataNascita?: Date | any,\\n    biografia?: string | any,\\n    numero?: string | any,\\n    via?: string | any,\\n    cap?: number | any,\\n    citta?: string | any,\\n    public progress?: number,\\n  ) {\\n    this.id = createUniqueId();\\n    this.nome = nome;\\n    this.cognome = cognome;\\n    this.email = email;\\n    this.sesso = sesso;\\n    this.dataNascita = dataNascita;\\n    this.biografia = biografia;\\n    this.numero = numero;\\n    this.via = via;\\n    this.cap = cap;\\n    this.citta = citta.id ? citta.id : citta;\\n  }\\n}\\n","constructorObj":{"name":"constructor","description":"","deprecated":false,"deprecationMessage":"","args":[{"name":"nome","type":"string","deprecated":false,"deprecationMessage":""},{"name":"cognome","type":"string","deprecated":false,"deprecationMessage":""},{"name":"email","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true},{"name":"sesso","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true},{"name":"dataNascita","type":"Date | any","deprecated":false,"deprecationMessage":"","optional":true},{"name":"biografia","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true},{"name":"numero","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true},{"name":"via","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true},{"name":"cap","type":"number | any","deprecated":false,"deprecationMessage":"","optional":true},{"name":"citta","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true},{"name":"progress","type":"number","deprecated":false,"deprecationMessage":"","optional":true}],"line":14,"jsdoctags":[{"name":"nome","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"cognome","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"email","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true,"tagName":{"text":"param"}},{"name":"sesso","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true,"tagName":{"text":"param"}},{"name":"dataNascita","type":"Date | any","deprecated":false,"deprecationMessage":"","optional":true,"tagName":{"text":"param"}},{"name":"biografia","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true,"tagName":{"text":"param"}},{"name":"numero","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true,"tagName":{"text":"param"}},{"name":"via","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true,"tagName":{"text":"param"}},{"name":"cap","type":"number | any","deprecated":false,"deprecationMessage":"","optional":true,"tagName":{"text":"param"}},{"name":"citta","type":"string | any","deprecated":false,"deprecationMessage":"","optional":true,"tagName":{"text":"param"}},{"name":"progress","type":"number","deprecated":false,"deprecationMessage":"","optional":true,"tagName":{"text":"param"}}]},"inputsClass":[],"outputsClass":[],"properties":[{"name":"biografia","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":10},{"name":"cap","deprecated":false,"deprecationMessage":"","type":"number","indexKey":"","optional":false,"description":"","line":13},{"name":"citta","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":14},{"name":"cognome","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":6},{"name":"dataNascita","deprecated":false,"deprecationMessage":"","type":"Date","indexKey":"","optional":false,"description":"","line":9},{"name":"email","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":7},{"name":"id","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":4},{"name":"nome","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":5},{"name":"numero","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":11},{"name":"progress","deprecated":false,"deprecationMessage":"","type":"number","indexKey":"","optional":true,"description":"","line":27,"modifierKind":[125]},{"name":"sesso","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":8},{"name":"via","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":12}],"methods":[],"indexSignatures":[],"extends":[],"hostBindings":[],"hostListeners":[]},{"name":"WizardConverter","id":"class-WizardConverter-9e0f82baf010becda47148e5e6b2bd389b020d2a6db5c2994376ba8a9191c311d6da057d6affc8cb485aff3986fe7c739e1862fbb5178dc2ae19c07e13570008","file":"src/stories/wizard-spa/converters/wizard.converter.ts","deprecated":false,"deprecationMessage":"","type":"class","sourceCode":"import { BaseConverter } from \'@inail/internet-webkit\';\\nimport { WizardDTO } from \'../dtos/wizard.dto\';\\n\\nimport { CarConverter } from \'./step3.converter\';\\nimport { Step1Converter } from \'./step1.converter\';\\nimport { Step2Converter } from \'./step2.converter\';\\nimport { WizardModel } from \'../model/wizard.model\';\\n\\nexport class WizardConverter extends BaseConverter<WizardModel, WizardDTO> {\\n\\tstep1Converter = new Step1Converter();\\n\\tstep2Converter = new Step2Converter();\\n\\tcarConverter = new CarConverter();\\n\\n\\tpublic convertToModel(dto: WizardDTO): WizardModel {\\n\\t\\treturn new WizardModel(\\n\\t\\t\\tthis.step1Converter.convertToModel(dto.step1),\\n\\t\\t\\tthis.step2Converter.convertToModel(dto.step2),\\n\\t\\t\\tthis.carConverter.convertToModel(dto.step3),\\n\\t\\t);\\n\\t}\\n\\tpublic convertToDto(model: WizardModel): WizardDTO {\\n\\t\\treturn new WizardDTO(\\n\\t\\t\\tthis.step1Converter.convertToDto(model.step1),\\n\\t\\t\\tthis.step2Converter.convertToDto(model.step2),\\n\\t\\t\\tthis.carConverter.convertToDto(model.step3),\\n\\t\\t);\\n\\t}\\n}\\n","inputsClass":[],"outputsClass":[],"properties":[{"name":"carConverter","defaultValue":"new CarConverter()","deprecated":false,"deprecationMessage":"","type":"","indexKey":"","optional":false,"description":"","line":12},{"name":"step1Converter","defaultValue":"new Step1Converter()","deprecated":false,"deprecationMessage":"","type":"","indexKey":"","optional":false,"description":"","line":10},{"name":"step2Converter","defaultValue":"new Step2Converter()","deprecated":false,"deprecationMessage":"","type":"","indexKey":"","optional":false,"description":"","line":11}],"methods":[{"name":"convertToDto","args":[{"name":"model","type":"WizardModel","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"WizardDTO","typeParameters":[],"line":21,"deprecated":false,"deprecationMessage":"","modifierKind":[125],"jsdoctags":[{"name":"model","type":"WizardModel","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"convertToModel","args":[{"name":"dto","type":"WizardDTO","deprecated":false,"deprecationMessage":""}],"optional":false,"returnType":"WizardModel","typeParameters":[],"line":14,"deprecated":false,"deprecationMessage":"","modifierKind":[125],"jsdoctags":[{"name":"dto","type":"WizardDTO","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]}],"indexSignatures":[],"extends":["BaseConverter"],"hostBindings":[],"hostListeners":[]},{"name":"WizardDTO","id":"class-WizardDTO-f738666e46f11a61a809718f2866efa7c7bb97c8f2fcd5f2c16ca92ff1716af1b2b70cfa855a905bcfe170b8bf46b129f658b2030847cdfb70ef8fcaeee4e182","file":"src/stories/wizard-spa/dtos/wizard.dto.ts","deprecated":false,"deprecationMessage":"","type":"class","sourceCode":"import { Step1Dto } from \'./step1.dto\';\\nimport { Step2Dto } from \'./step2.dto\';\\nimport { Step3Dto } from \'./step3.dto\';\\n\\nexport class WizardDTO {\\n\\tconstructor(public step1: Step1Dto, public step2: Step2Dto, public step3: Step3Dto) { }\\n}\\n","constructorObj":{"name":"constructor","description":"","deprecated":false,"deprecationMessage":"","args":[{"name":"step1","type":"Step1Dto","deprecated":false,"deprecationMessage":""},{"name":"step2","type":"Step2Dto","deprecated":false,"deprecationMessage":""},{"name":"step3","type":"Step3Dto","deprecated":false,"deprecationMessage":""}],"line":5,"jsdoctags":[{"name":"step1","type":"Step1Dto","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"step2","type":"Step2Dto","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"step3","type":"Step3Dto","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},"inputsClass":[],"outputsClass":[],"properties":[{"name":"step1","deprecated":false,"deprecationMessage":"","type":"Step1Dto","indexKey":"","optional":false,"description":"","line":6,"modifierKind":[125]},{"name":"step2","deprecated":false,"deprecationMessage":"","type":"Step2Dto","indexKey":"","optional":false,"description":"","line":6,"modifierKind":[125]},{"name":"step3","deprecated":false,"deprecationMessage":"","type":"Step3Dto","indexKey":"","optional":false,"description":"","line":6,"modifierKind":[125]}],"methods":[],"indexSignatures":[],"extends":[],"hostBindings":[],"hostListeners":[]},{"name":"WizardModel","id":"class-WizardModel-1ecb3b87e882311a0c4a38441413a279bf9a53d9522d3c1a29db7f6d29f16076c9c8bc0edae50f0c282849fb517eb2879898a69e7fd5d94c2c1d09177b0474d5","file":"src/stories/wizard-spa/model/wizard.model.ts","deprecated":false,"deprecationMessage":"","type":"class","sourceCode":"import { BaseModel } from \'@inail/internet-webkit\';\\nimport { composeUniqueId } from \'@inail/internet-webkit/utils\';\\nimport { Step1 } from \'./step1.model\';\\nimport { Step2 } from \'./step2.model\';\\nimport { Step3 } from \'./step3.model\';\\n\\nexport class WizardModel extends BaseModel {\\n\\tprivate _id: any;\\n\\tconstructor(public step1: Step1, public step2: Step2, public step3: Step3) {\\n\\t\\tsuper();\\n\\t\\tthis.id = composeUniqueId(\'wizard_\');\\n\\t}\\n\\t/**\\n\\t * Getter id\\n\\t * @return\\n\\t */\\n\\tpublic get id(): any {\\n\\t\\treturn this._id;\\n\\t}\\n\\n\\t/**\\n\\t * Setter id\\n\\t * @param value\\n\\t */\\n\\tpublic set id(value: any) {\\n\\t\\tthis._id = value;\\n\\t}\\n}\\n","constructorObj":{"name":"constructor","description":"","deprecated":false,"deprecationMessage":"","args":[{"name":"step1","type":"Step1","deprecated":false,"deprecationMessage":""},{"name":"step2","type":"Step2","deprecated":false,"deprecationMessage":""},{"name":"step3","type":"Step3","deprecated":false,"deprecationMessage":""}],"line":8,"jsdoctags":[{"name":"step1","type":"Step1","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"step2","type":"Step2","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}},{"name":"step3","type":"Step3","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},"inputsClass":[],"outputsClass":[],"properties":[{"name":"_id","deprecated":false,"deprecationMessage":"","type":"any","indexKey":"","optional":false,"description":"","line":8,"modifierKind":[123]},{"name":"step1","deprecated":false,"deprecationMessage":"","type":"Step1","indexKey":"","optional":false,"description":"","line":9,"modifierKind":[125]},{"name":"step2","deprecated":false,"deprecationMessage":"","type":"Step2","indexKey":"","optional":false,"description":"","line":9,"modifierKind":[125]},{"name":"step3","deprecated":false,"deprecationMessage":"","type":"Step3","indexKey":"","optional":false,"description":"","line":9,"modifierKind":[125]}],"methods":[],"indexSignatures":[],"extends":["BaseModel"],"accessors":{"id":{"name":"id","setSignature":{"name":"id","type":"void","deprecated":false,"deprecationMessage":"","args":[{"name":"value","type":"any","deprecated":false,"deprecationMessage":""}],"returnType":"void","line":25,"rawdescription":"\\n\\nSetter id\\n","description":"<p>Setter id</p>\\n","jsdoctags":[{"name":{"pos":543,"end":548,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"value"},"type":"any","deprecated":false,"deprecationMessage":"","tagName":{"pos":537,"end":542,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"param"},"comment":""}]},"getSignature":{"name":"id","type":"any","returnType":"any","line":17,"rawdescription":"\\n\\nGetter id\\n","description":"<p>Getter id</p>\\n","jsdoctags":[{"pos":453,"end":463,"kind":342,"id":0,"flags":16842752,"modifierFlagsCache":0,"transformFlags":0,"tagName":{"pos":454,"end":460,"kind":80,"id":0,"flags":16842752,"transformFlags":0,"escapedText":"return"},"comment":""}]}}},"hostBindings":[],"hostListeners":[]}],"directives":[],"components":[{"name":"AppComponent","id":"component-AppComponent-9a3f97152babf1c6a64b993a62f0c2a5996d18fbb6810aaa23d98bb14123217274700784e175bf7c544ed6ef3dc65f56fef816e4d13f4cf5326fd4f612d539d8","file":"src/app/app.component.ts","encapsulation":[],"entryComponents":[],"inputs":[],"outputs":[],"providers":[],"selector":"app-root","styleUrls":[],"styles":[],"templateUrl":["./app.component.html"],"viewProviders":[],"hostDirectives":[],"inputsClass":[],"outputsClass":[],"propertiesClass":[{"name":"title","defaultValue":"\'angular-storybook-project\'","deprecated":false,"deprecationMessage":"","type":"string","indexKey":"","optional":false,"description":"","line":12}],"methodsClass":[],"deprecated":false,"deprecationMessage":"","hostBindings":[],"hostListeners":[],"standalone":true,"imports":[{"name":"RouterOutlet"}],"description":"","rawdescription":"\\n","type":"component","sourceCode":"import { Component } from \'@angular/core\';\\nimport { RouterOutlet } from \'@angular/router\';\\n\\n@Component({\\n  selector: \'app-root\',\\n  standalone: true,\\n  imports: [RouterOutlet],\\n  templateUrl: \'./app.component.html\',\\n  styleUrl: \'./app.component.css\'\\n})\\nexport class AppComponent {\\n  title = \'angular-storybook-project\';\\n}\\n","styleUrl":"./app.component.css","assetsDirs":[],"styleUrlsData":"","stylesData":"","extends":[],"templateData":"\x3c!-- * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * --\x3e\\n\x3c!-- * * * * * * * * * * * The content below * * * * * * * * * * * --\x3e\\n\x3c!-- * * * * * * * * * * is only a placeholder * * * * * * * * * * --\x3e\\n\x3c!-- * * * * * * * * * * and can be replaced.  * * * * * * * * * * --\x3e\\n\x3c!-- * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * --\x3e\\n\x3c!-- * * * * * * * * * Delete the template below * * * * * * * * * --\x3e\\n\x3c!-- * * * * * * * to get started with your project! * * * * * * * --\x3e\\n\x3c!-- * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * --\x3e\\n\\n<style>\\n  :host {\\n    --bright-blue: oklch(51.01% 0.274 263.83);\\n    --electric-violet: oklch(53.18% 0.28 296.97);\\n    --french-violet: oklch(47.66% 0.246 305.88);\\n    --vivid-pink: oklch(69.02% 0.277 332.77);\\n    --hot-red: oklch(61.42% 0.238 15.34);\\n    --orange-red: oklch(63.32% 0.24 31.68);\\n\\n    --gray-900: oklch(19.37% 0.006 300.98);\\n    --gray-700: oklch(36.98% 0.014 302.71);\\n    --gray-400: oklch(70.9% 0.015 304.04);\\n\\n    --red-to-pink-to-purple-vertical-gradient: linear-gradient(\\n      180deg,\\n      var(--orange-red) 0%,\\n      var(--vivid-pink) 50%,\\n      var(--electric-violet) 100%\\n    );\\n\\n    --red-to-pink-to-purple-horizontal-gradient: linear-gradient(\\n      90deg,\\n      var(--orange-red) 0%,\\n      var(--vivid-pink) 50%,\\n      var(--electric-violet) 100%\\n    );\\n\\n    --pill-accent: var(--bright-blue);\\n\\n    font-family: \\"Inter\\", -apple-system, BlinkMacSystemFont, \\"Segoe UI\\", Roboto,\\n      Helvetica, Arial, sans-serif, \\"Apple Color Emoji\\", \\"Segoe UI Emoji\\",\\n      \\"Segoe UI Symbol\\";\\n    box-sizing: border-box;\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n  }\\n\\n  h1 {\\n    font-size: 3.125rem;\\n    color: var(--gray-900);\\n    font-weight: 500;\\n    line-height: 100%;\\n    letter-spacing: -0.125rem;\\n    margin: 0;\\n    font-family: \\"Inter Tight\\", -apple-system, BlinkMacSystemFont, \\"Segoe UI\\", Roboto,\\n      Helvetica, Arial, sans-serif, \\"Apple Color Emoji\\", \\"Segoe UI Emoji\\",\\n      \\"Segoe UI Symbol\\";\\n  }\\n\\n  p {\\n    margin: 0;\\n    color: var(--gray-700);\\n  }\\n\\n  main {\\n    width: 100%;\\n    min-height: 100%;\\n    display: flex;\\n    justify-content: center;\\n    align-items: center;\\n    padding: 1rem;\\n    box-sizing: inherit;\\n    position: relative;\\n  }\\n\\n  .angular-logo {\\n    max-width: 9.2rem;\\n  }\\n\\n  .content {\\n    display: flex;\\n    justify-content: space-around;\\n    width: 100%;\\n    max-width: 700px;\\n    margin-bottom: 3rem;\\n  }\\n\\n  .content h1 {\\n    margin-top: 1.75rem;\\n  }\\n\\n  .content p {\\n    margin-top: 1.5rem;\\n  }\\n\\n  .divider {\\n    width: 1px;\\n    background: var(--red-to-pink-to-purple-vertical-gradient);\\n    margin-inline: 0.5rem;\\n  }\\n\\n  .pill-group {\\n    display: flex;\\n    flex-direction: column;\\n    align-items: start;\\n    flex-wrap: wrap;\\n    gap: 1.25rem;\\n  }\\n\\n  .pill {\\n    display: flex;\\n    align-items: center;\\n    --pill-accent: var(--bright-blue);\\n    background: color-mix(in srgb, var(--pill-accent) 5%, transparent);\\n    color: var(--pill-accent);\\n    padding-inline: 0.75rem;\\n    padding-block: 0.375rem;\\n    border-radius: 2.75rem;\\n    border: 0;\\n    transition: background 0.3s ease;\\n    font-family: var(--inter-font);\\n    font-size: 0.875rem;\\n    font-style: normal;\\n    font-weight: 500;\\n    line-height: 1.4rem;\\n    letter-spacing: -0.00875rem;\\n    text-decoration: none;\\n  }\\n\\n  .pill:hover {\\n    background: color-mix(in srgb, var(--pill-accent) 15%, transparent);\\n  }\\n\\n  .pill-group .pill:nth-child(6n + 1) {\\n    --pill-accent: var(--bright-blue);\\n  }\\n  .pill-group .pill:nth-child(6n + 2) {\\n    --pill-accent: var(--french-violet);\\n  }\\n  .pill-group .pill:nth-child(6n + 3),\\n  .pill-group .pill:nth-child(6n + 4),\\n  .pill-group .pill:nth-child(6n + 5) {\\n    --pill-accent: var(--hot-red);\\n  }\\n\\n  .pill-group svg {\\n    margin-inline-start: 0.25rem;\\n  }\\n\\n  .social-links {\\n    display: flex;\\n    align-items: center;\\n    gap: 0.73rem;\\n    margin-top: 1.5rem;\\n  }\\n\\n  .social-links path {\\n    transition: fill 0.3s ease;\\n    fill: var(--gray-400);\\n  }\\n\\n  .social-links a:hover svg path {\\n    fill: var(--gray-900);\\n  }\\n\\n  @media screen and (max-width: 650px) {\\n    .content {\\n      flex-direction: column;\\n      width: max-content;\\n    }\\n\\n    .divider {\\n      height: 1px;\\n      width: 100%;\\n      background: var(--red-to-pink-to-purple-horizontal-gradient);\\n      margin-block: 1.5rem;\\n    }\\n  }\\n</style>\\n\\n<main class=\\"main\\">\\n  <div class=\\"content\\">\\n    <div class=\\"left-side\\">\\n      <svg\\n        xmlns=\\"http://www.w3.org/2000/svg\\"\\n        viewBox=\\"0 0 982 239\\"\\n        fill=\\"none\\"\\n        class=\\"angular-logo\\"\\n      >\\n        <g clip-path=\\"url(#a)\\">\\n          <path\\n            fill=\\"url(#b)\\"\\n            d=\\"M388.676 191.625h30.849L363.31 31.828h-35.758l-56.215 159.797h30.848l13.174-39.356h60.061l13.256 39.356Zm-65.461-62.675 21.602-64.311h1.227l21.602 64.311h-44.431Zm126.831-7.527v70.202h-28.23V71.839h27.002v20.374h1.392c2.782-6.71 7.2-12.028 13.255-15.956 6.056-3.927 13.584-5.89 22.503-5.89 8.264 0 15.465 1.8 21.684 5.318 6.137 3.518 10.964 8.673 14.319 15.382 3.437 6.71 5.074 14.81 4.992 24.383v76.175h-28.23v-71.92c0-8.019-2.046-14.237-6.219-18.819-4.173-4.5-9.819-6.791-17.102-6.791-4.91 0-9.328 1.063-13.174 3.272-3.846 2.128-6.792 5.237-9.001 9.328-2.046 4.009-3.191 8.918-3.191 14.728ZM589.233 239c-10.147 0-18.82-1.391-26.103-4.091-7.282-2.7-13.092-6.382-17.511-10.964-4.418-4.582-7.528-9.655-9.164-15.219l25.448-6.136c1.145 2.372 2.782 4.663 4.991 6.954 2.209 2.291 5.155 4.255 8.837 5.81 3.683 1.554 8.428 2.291 14.074 2.291 8.019 0 14.647-1.964 19.884-5.81 5.237-3.845 7.856-10.227 7.856-19.064v-22.665h-1.391c-1.473 2.946-3.601 5.892-6.383 9.001-2.782 3.109-6.464 5.645-10.965 7.691-4.582 2.046-10.228 3.109-17.101 3.109-9.165 0-17.511-2.209-25.039-6.545-7.446-4.337-13.42-10.883-17.757-19.474-4.418-8.673-6.628-19.473-6.628-32.565 0-13.091 2.21-24.301 6.628-33.383 4.419-9.082 10.311-15.955 17.839-20.7 7.528-4.746 15.874-7.037 25.039-7.037 7.037 0 12.846 1.145 17.347 3.518 4.582 2.373 8.182 5.236 10.883 8.51 2.7 3.272 4.746 6.382 6.137 9.327h1.554v-19.8h27.821v121.749c0 10.228-2.454 18.737-7.364 25.447-4.91 6.709-11.538 11.7-20.048 15.055-8.509 3.355-18.165 4.991-28.884 4.991Zm.245-71.266c5.974 0 11.047-1.473 15.302-4.337 4.173-2.945 7.446-7.118 9.573-12.519 2.21-5.482 3.274-12.027 3.274-19.637 0-7.609-1.064-14.155-3.274-19.8-2.127-5.646-5.318-10.064-9.491-13.255-4.174-3.11-9.329-4.746-15.384-4.746s-11.537 1.636-15.792 4.91c-4.173 3.272-7.365 7.772-9.492 13.418-2.128 5.727-3.191 12.191-3.191 19.392 0 7.2 1.063 13.745 3.273 19.228 2.127 5.482 5.318 9.736 9.573 12.764 4.174 3.027 9.41 4.582 15.629 4.582Zm141.56-26.51V71.839h28.23v119.786h-27.412v-21.273h-1.227c-2.7 6.709-7.119 12.191-13.338 16.446-6.137 4.255-13.747 6.382-22.748 6.382-7.855 0-14.81-1.718-20.783-5.237-5.974-3.518-10.72-8.591-14.075-15.382-3.355-6.709-5.073-14.891-5.073-24.464V71.839h28.312v71.921c0 7.609 2.046 13.664 6.219 18.083 4.173 4.5 9.655 6.709 16.365 6.709 4.173 0 8.183-.982 12.111-3.028 3.927-2.045 7.118-5.072 9.655-9.082 2.537-4.091 3.764-9.164 3.764-15.218Zm65.707-109.395v159.796h-28.23V31.828h28.23Zm44.841 162.169c-7.61 0-14.402-1.391-20.457-4.091-6.055-2.7-10.883-6.791-14.32-12.109-3.518-5.319-5.237-11.946-5.237-19.801 0-6.791 1.228-12.355 3.765-16.773 2.536-4.419 5.891-7.937 10.228-10.637 4.337-2.618 9.164-4.664 14.647-6.055 5.4-1.391 11.046-2.373 16.856-3.027 7.037-.737 12.683-1.391 17.102-1.964 4.337-.573 7.528-1.555 9.574-2.782 1.963-1.309 3.027-3.273 3.027-5.973v-.491c0-5.891-1.718-10.391-5.237-13.664-3.518-3.191-8.51-4.828-15.056-4.828-6.955 0-12.356 1.473-16.447 4.5-4.009 3.028-6.71 6.546-8.183 10.719l-26.348-3.764c2.046-7.282 5.483-13.336 10.31-18.328 4.746-4.909 10.638-8.59 17.511-11.045 6.955-2.455 14.565-3.682 22.912-3.682 5.809 0 11.537.654 17.265 2.045s10.965 3.6 15.711 6.71c4.746 3.109 8.51 7.282 11.455 12.6 2.864 5.318 4.337 11.946 4.337 19.883v80.184h-27.166v-16.446h-.9c-1.719 3.355-4.092 6.464-7.201 9.328-3.109 2.864-6.955 5.237-11.619 6.955-4.828 1.718-10.229 2.536-16.529 2.536Zm7.364-20.701c5.646 0 10.556-1.145 14.729-3.354 4.173-2.291 7.364-5.237 9.655-9.001 2.292-3.763 3.355-7.854 3.355-12.273v-14.155c-.9.737-2.373 1.391-4.5 2.046-2.128.654-4.419 1.145-7.037 1.636-2.619.491-5.155.9-7.692 1.227-2.537.328-4.746.655-6.628.901-4.173.572-8.019 1.472-11.292 2.781-3.355 1.31-5.973 3.11-7.855 5.401-1.964 2.291-2.864 5.318-2.864 8.918 0 5.237 1.882 9.164 5.728 11.782 3.682 2.782 8.51 4.091 14.401 4.091Zm64.643 18.328V71.839h27.412v19.965h1.227c2.21-6.955 5.974-12.274 11.292-16.038 5.319-3.763 11.456-5.645 18.329-5.645 1.555 0 3.355.082 5.237.163 1.964.164 3.601.328 4.91.573v25.938c-1.227-.41-3.109-.819-5.646-1.146a58.814 58.814 0 0 0-7.446-.49c-5.155 0-9.738 1.145-13.829 3.354-4.091 2.209-7.282 5.236-9.655 9.164-2.373 3.927-3.519 8.427-3.519 13.5v70.448h-28.312ZM222.077 39.192l-8.019 125.923L137.387 0l84.69 39.192Zm-53.105 162.825-57.933 33.056-57.934-33.056 11.783-28.556h92.301l11.783 28.556ZM111.039 62.675l30.357 73.803H80.681l30.358-73.803ZM7.937 165.115 0 39.192 84.69 0 7.937 165.115Z\\"\\n          />\\n          <path\\n            fill=\\"url(#c)\\"\\n            d=\\"M388.676 191.625h30.849L363.31 31.828h-35.758l-56.215 159.797h30.848l13.174-39.356h60.061l13.256 39.356Zm-65.461-62.675 21.602-64.311h1.227l21.602 64.311h-44.431Zm126.831-7.527v70.202h-28.23V71.839h27.002v20.374h1.392c2.782-6.71 7.2-12.028 13.255-15.956 6.056-3.927 13.584-5.89 22.503-5.89 8.264 0 15.465 1.8 21.684 5.318 6.137 3.518 10.964 8.673 14.319 15.382 3.437 6.71 5.074 14.81 4.992 24.383v76.175h-28.23v-71.92c0-8.019-2.046-14.237-6.219-18.819-4.173-4.5-9.819-6.791-17.102-6.791-4.91 0-9.328 1.063-13.174 3.272-3.846 2.128-6.792 5.237-9.001 9.328-2.046 4.009-3.191 8.918-3.191 14.728ZM589.233 239c-10.147 0-18.82-1.391-26.103-4.091-7.282-2.7-13.092-6.382-17.511-10.964-4.418-4.582-7.528-9.655-9.164-15.219l25.448-6.136c1.145 2.372 2.782 4.663 4.991 6.954 2.209 2.291 5.155 4.255 8.837 5.81 3.683 1.554 8.428 2.291 14.074 2.291 8.019 0 14.647-1.964 19.884-5.81 5.237-3.845 7.856-10.227 7.856-19.064v-22.665h-1.391c-1.473 2.946-3.601 5.892-6.383 9.001-2.782 3.109-6.464 5.645-10.965 7.691-4.582 2.046-10.228 3.109-17.101 3.109-9.165 0-17.511-2.209-25.039-6.545-7.446-4.337-13.42-10.883-17.757-19.474-4.418-8.673-6.628-19.473-6.628-32.565 0-13.091 2.21-24.301 6.628-33.383 4.419-9.082 10.311-15.955 17.839-20.7 7.528-4.746 15.874-7.037 25.039-7.037 7.037 0 12.846 1.145 17.347 3.518 4.582 2.373 8.182 5.236 10.883 8.51 2.7 3.272 4.746 6.382 6.137 9.327h1.554v-19.8h27.821v121.749c0 10.228-2.454 18.737-7.364 25.447-4.91 6.709-11.538 11.7-20.048 15.055-8.509 3.355-18.165 4.991-28.884 4.991Zm.245-71.266c5.974 0 11.047-1.473 15.302-4.337 4.173-2.945 7.446-7.118 9.573-12.519 2.21-5.482 3.274-12.027 3.274-19.637 0-7.609-1.064-14.155-3.274-19.8-2.127-5.646-5.318-10.064-9.491-13.255-4.174-3.11-9.329-4.746-15.384-4.746s-11.537 1.636-15.792 4.91c-4.173 3.272-7.365 7.772-9.492 13.418-2.128 5.727-3.191 12.191-3.191 19.392 0 7.2 1.063 13.745 3.273 19.228 2.127 5.482 5.318 9.736 9.573 12.764 4.174 3.027 9.41 4.582 15.629 4.582Zm141.56-26.51V71.839h28.23v119.786h-27.412v-21.273h-1.227c-2.7 6.709-7.119 12.191-13.338 16.446-6.137 4.255-13.747 6.382-22.748 6.382-7.855 0-14.81-1.718-20.783-5.237-5.974-3.518-10.72-8.591-14.075-15.382-3.355-6.709-5.073-14.891-5.073-24.464V71.839h28.312v71.921c0 7.609 2.046 13.664 6.219 18.083 4.173 4.5 9.655 6.709 16.365 6.709 4.173 0 8.183-.982 12.111-3.028 3.927-2.045 7.118-5.072 9.655-9.082 2.537-4.091 3.764-9.164 3.764-15.218Zm65.707-109.395v159.796h-28.23V31.828h28.23Zm44.841 162.169c-7.61 0-14.402-1.391-20.457-4.091-6.055-2.7-10.883-6.791-14.32-12.109-3.518-5.319-5.237-11.946-5.237-19.801 0-6.791 1.228-12.355 3.765-16.773 2.536-4.419 5.891-7.937 10.228-10.637 4.337-2.618 9.164-4.664 14.647-6.055 5.4-1.391 11.046-2.373 16.856-3.027 7.037-.737 12.683-1.391 17.102-1.964 4.337-.573 7.528-1.555 9.574-2.782 1.963-1.309 3.027-3.273 3.027-5.973v-.491c0-5.891-1.718-10.391-5.237-13.664-3.518-3.191-8.51-4.828-15.056-4.828-6.955 0-12.356 1.473-16.447 4.5-4.009 3.028-6.71 6.546-8.183 10.719l-26.348-3.764c2.046-7.282 5.483-13.336 10.31-18.328 4.746-4.909 10.638-8.59 17.511-11.045 6.955-2.455 14.565-3.682 22.912-3.682 5.809 0 11.537.654 17.265 2.045s10.965 3.6 15.711 6.71c4.746 3.109 8.51 7.282 11.455 12.6 2.864 5.318 4.337 11.946 4.337 19.883v80.184h-27.166v-16.446h-.9c-1.719 3.355-4.092 6.464-7.201 9.328-3.109 2.864-6.955 5.237-11.619 6.955-4.828 1.718-10.229 2.536-16.529 2.536Zm7.364-20.701c5.646 0 10.556-1.145 14.729-3.354 4.173-2.291 7.364-5.237 9.655-9.001 2.292-3.763 3.355-7.854 3.355-12.273v-14.155c-.9.737-2.373 1.391-4.5 2.046-2.128.654-4.419 1.145-7.037 1.636-2.619.491-5.155.9-7.692 1.227-2.537.328-4.746.655-6.628.901-4.173.572-8.019 1.472-11.292 2.781-3.355 1.31-5.973 3.11-7.855 5.401-1.964 2.291-2.864 5.318-2.864 8.918 0 5.237 1.882 9.164 5.728 11.782 3.682 2.782 8.51 4.091 14.401 4.091Zm64.643 18.328V71.839h27.412v19.965h1.227c2.21-6.955 5.974-12.274 11.292-16.038 5.319-3.763 11.456-5.645 18.329-5.645 1.555 0 3.355.082 5.237.163 1.964.164 3.601.328 4.91.573v25.938c-1.227-.41-3.109-.819-5.646-1.146a58.814 58.814 0 0 0-7.446-.49c-5.155 0-9.738 1.145-13.829 3.354-4.091 2.209-7.282 5.236-9.655 9.164-2.373 3.927-3.519 8.427-3.519 13.5v70.448h-28.312ZM222.077 39.192l-8.019 125.923L137.387 0l84.69 39.192Zm-53.105 162.825-57.933 33.056-57.934-33.056 11.783-28.556h92.301l11.783 28.556ZM111.039 62.675l30.357 73.803H80.681l30.358-73.803ZM7.937 165.115 0 39.192 84.69 0 7.937 165.115Z\\"\\n          />\\n        </g>\\n        <defs>\\n          <radialGradient\\n            id=\\"c\\"\\n            cx=\\"0\\"\\n            cy=\\"0\\"\\n            r=\\"1\\"\\n            gradientTransform=\\"rotate(118.122 171.182 60.81) scale(205.794)\\"\\n            gradientUnits=\\"userSpaceOnUse\\"\\n          >\\n            <stop stop-color=\\"#FF41F8\\" />\\n            <stop offset=\\".707\\" stop-color=\\"#FF41F8\\" stop-opacity=\\".5\\" />\\n            <stop offset=\\"1\\" stop-color=\\"#FF41F8\\" stop-opacity=\\"0\\" />\\n          </radialGradient>\\n          <linearGradient\\n            id=\\"b\\"\\n            x1=\\"0\\"\\n            x2=\\"982\\"\\n            y1=\\"192\\"\\n            y2=\\"192\\"\\n            gradientUnits=\\"userSpaceOnUse\\"\\n          >\\n            <stop stop-color=\\"#F0060B\\" />\\n            <stop offset=\\"0\\" stop-color=\\"#F0070C\\" />\\n            <stop offset=\\".526\\" stop-color=\\"#CC26D5\\" />\\n            <stop offset=\\"1\\" stop-color=\\"#7702FF\\" />\\n          </linearGradient>\\n          <clipPath id=\\"a\\"><path fill=\\"#fff\\" d=\\"M0 0h982v239H0z\\" /></clipPath>\\n        </defs>\\n      </svg>\\n      <h1>Hello, {{ title }}</h1>\\n      <p>Congratulations! Your app is running. 🎉</p>\\n    </div>\\n    <div class=\\"divider\\" role=\\"separator\\" aria-label=\\"Divider\\"></div>\\n    <div class=\\"right-side\\">\\n      <div class=\\"pill-group\\">\\n        @for (item of [\\n          { title: \'Explore the Docs\', link: \'https://angular.dev\' },\\n          { title: \'Learn with Tutorials\', link: \'https://angular.dev/tutorials\' },\\n          { title: \'CLI Docs\', link: \'https://angular.dev/tools/cli\' },\\n          { title: \'Angular Language Service\', link: \'https://angular.dev/tools/language-service\' },\\n          { title: \'Angular DevTools\', link: \'https://angular.dev/tools/devtools\' },\\n        ]; track item.title) {\\n          <a\\n            class=\\"pill\\"\\n            [href]=\\"item.link\\"\\n            target=\\"_blank\\"\\n            rel=\\"noopener\\"\\n          >\\n            <span>{{ item.title }}</span>\\n            <svg\\n              xmlns=\\"http://www.w3.org/2000/svg\\"\\n              height=\\"14\\"\\n              viewBox=\\"0 -960 960 960\\"\\n              width=\\"14\\"\\n              fill=\\"currentColor\\"\\n            >\\n              <path\\n                d=\\"M200-120q-33 0-56.5-23.5T120-200v-560q0-33 23.5-56.5T200-840h280v80H200v560h560v-280h80v280q0 33-23.5 56.5T760-120H200Zm188-212-56-56 372-372H560v-80h280v280h-80v-144L388-332Z\\"\\n              />\\n            </svg>\\n          </a>\\n        }\\n      </div>\\n      <div class=\\"social-links\\">\\n        <a\\n          href=\\"https://github.com/angular/angular\\"\\n          aria-label=\\"Github\\"\\n          target=\\"_blank\\"\\n          rel=\\"noopener\\"\\n        >\\n          <svg\\n            width=\\"25\\"\\n            height=\\"24\\"\\n            viewBox=\\"0 0 25 24\\"\\n            fill=\\"none\\"\\n            xmlns=\\"http://www.w3.org/2000/svg\\"\\n            alt=\\"Github\\"\\n          >\\n            <path\\n              d=\\"M12.3047 0C5.50634 0 0 5.50942 0 12.3047C0 17.7423 3.52529 22.3535 8.41332 23.9787C9.02856 24.0946 9.25414 23.7142 9.25414 23.3871C9.25414 23.0949 9.24389 22.3207 9.23876 21.2953C5.81601 22.0377 5.09414 19.6444 5.09414 19.6444C4.53427 18.2243 3.72524 17.8449 3.72524 17.8449C2.61064 17.082 3.81137 17.0973 3.81137 17.0973C5.04697 17.1835 5.69604 18.3647 5.69604 18.3647C6.79321 20.2463 8.57636 19.7029 9.27978 19.3881C9.39052 18.5924 9.70736 18.0499 10.0591 17.7423C7.32641 17.4347 4.45429 16.3765 4.45429 11.6618C4.45429 10.3185 4.9311 9.22133 5.72065 8.36C5.58222 8.04931 5.16694 6.79833 5.82831 5.10337C5.82831 5.10337 6.85883 4.77319 9.2121 6.36459C10.1965 6.09082 11.2424 5.95546 12.2883 5.94931C13.3342 5.95546 14.3801 6.09082 15.3644 6.36459C17.7023 4.77319 18.7328 5.10337 18.7328 5.10337C19.3942 6.79833 18.9789 8.04931 18.8559 8.36C19.6403 9.22133 20.1171 10.3185 20.1171 11.6618C20.1171 16.3888 17.2409 17.4296 14.5031 17.7321C14.9338 18.1012 15.3337 18.8559 15.3337 20.0084C15.3337 21.6552 15.3183 22.978 15.3183 23.3779C15.3183 23.7009 15.5336 24.0854 16.1642 23.9623C21.0871 22.3484 24.6094 17.7341 24.6094 12.3047C24.6094 5.50942 19.0999 0 12.3047 0Z\\"\\n            />\\n          </svg>\\n        </a>\\n        <a\\n          href=\\"https://twitter.com/angular\\"\\n          aria-label=\\"Twitter\\"\\n          target=\\"_blank\\"\\n          rel=\\"noopener\\"\\n        >\\n          <svg\\n            width=\\"24\\"\\n            height=\\"24\\"\\n            viewBox=\\"0 0 24 24\\"\\n            fill=\\"none\\"\\n            xmlns=\\"http://www.w3.org/2000/svg\\"\\n            alt=\\"Twitter\\"\\n          >\\n            <path\\n              d=\\"M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z\\"\\n            />\\n          </svg>\\n        </a>\\n        <a\\n          href=\\"https://www.youtube.com/channel/UCbn1OgGei-DV7aSRo_HaAiw\\"\\n          aria-label=\\"Youtube\\"\\n          target=\\"_blank\\"\\n          rel=\\"noopener\\"\\n        >\\n          <svg\\n            width=\\"29\\"\\n            height=\\"20\\"\\n            viewBox=\\"0 0 29 20\\"\\n            fill=\\"none\\"\\n            xmlns=\\"http://www.w3.org/2000/svg\\"\\n            alt=\\"Youtube\\"\\n          >\\n            <path\\n              fill-rule=\\"evenodd\\"\\n              clip-rule=\\"evenodd\\"\\n              d=\\"M27.4896 1.52422C27.9301 1.96749 28.2463 2.51866 28.4068 3.12258C29.0004 5.35161 29.0004 10 29.0004 10C29.0004 10 29.0004 14.6484 28.4068 16.8774C28.2463 17.4813 27.9301 18.0325 27.4896 18.4758C27.0492 18.9191 26.5 19.2389 25.8972 19.4032C23.6778 20 14.8068 20 14.8068 20C14.8068 20 5.93586 20 3.71651 19.4032C3.11363 19.2389 2.56449 18.9191 2.12405 18.4758C1.68361 18.0325 1.36732 17.4813 1.20683 16.8774C0.613281 14.6484 0.613281 10 0.613281 10C0.613281 10 0.613281 5.35161 1.20683 3.12258C1.36732 2.51866 1.68361 1.96749 2.12405 1.52422C2.56449 1.08095 3.11363 0.76113 3.71651 0.596774C5.93586 0 14.8068 0 14.8068 0C14.8068 0 23.6778 0 25.8972 0.596774C26.5 0.76113 27.0492 1.08095 27.4896 1.52422ZM19.3229 10L11.9036 5.77905V14.221L19.3229 10Z\\"\\n            />\\n          </svg>\\n        </a>\\n      </div>\\n    </div>\\n  </div>\\n</main>\\n\\n\x3c!-- * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * --\x3e\\n\x3c!-- * * * * * * * * * * * The content above * * * * * * * * * * * * --\x3e\\n\x3c!-- * * * * * * * * * * is only a placeholder * * * * * * * * * * * --\x3e\\n\x3c!-- * * * * * * * * * * and can be replaced.  * * * * * * * * * * * --\x3e\\n\x3c!-- * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * --\x3e\\n\x3c!-- * * * * * * * * * * End of Placeholder  * * * * * * * * * * * * --\x3e\\n\x3c!-- * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * --\x3e\\n\\n\\n<router-outlet />\\n"},{"name":"FirstStepComponent","id":"component-FirstStepComponent-3b30da94e6009c4840026817a5fbbd42baf40769024f44cdbe809030b0943714dbaaf927e5401aa8d7c1acef62c57c652f8511638c438764d05aa76c662634ee","file":"src/stories/wizard-spa/first-step/first-step.component.ts","encapsulation":["ViewEncapsulation.None"],"entryComponents":[],"inputs":[],"outputs":[],"providers":[],"selector":"spa-first-step","styleUrls":[],"styles":[],"templateUrl":["./first-step.component.html"],"viewProviders":[],"hostDirectives":[],"inputsClass":[],"outputsClass":[],"propertiesClass":[],"methodsClass":[{"name":"getPathKeyForTakeId","args":[],"optional":false,"returnType":"string","typeParameters":[],"line":14,"deprecated":false,"deprecationMessage":"","modifierKind":[124]},{"name":"ngOnDestroyForChildren","args":[],"optional":false,"returnType":"void","typeParameters":[],"line":25,"deprecated":false,"deprecationMessage":""},{"name":"pageName","args":[],"optional":false,"returnType":"string","typeParameters":[],"line":19,"deprecated":false,"deprecationMessage":""}],"deprecated":false,"deprecationMessage":"","hostBindings":[],"hostListeners":[],"standalone":true,"imports":[],"description":"","rawdescription":"\\n","type":"component","sourceCode":"import { Component, ViewEncapsulation } from \'@angular/core\';\\n\\n\\n\\n@Component({\\n  selector: \'spa-first-step\',\\n  templateUrl: \'./first-step.component.html\',\\n  standalone:true,\\n  encapsulation: ViewEncapsulation.None\\n})\\nexport class FirstStepComponent  {\\n\\n  \\n  protected getPathKeyForTakeId(): string {\\n    //non lo usciamo uin questo caso\\n    return \'Step1\';\\n  }\\n\\n  pageName(): string {\\n    return \'Step1\';\\n  }\\n\\n  \\n\\n  ngOnDestroyForChildren() {\\n    // This is intentional\\n  }\\n\\n\\n\\n}\\n","assetsDirs":[],"styleUrlsData":"","stylesData":"","extends":[],"templateData":"\x3c!-- the begin of the form --\x3e\\n<div>\\n  Test1\\n</div>\\n"},{"name":"SecondStepComponent","id":"component-SecondStepComponent-bb0ee699067f8b020799fd678ad43b3c1de0189909dd306ae831360385e66a05e62e88f0be5cdd070151a95cfd9e8b3e5d491831f4bc30a120e80a651df2d62d","file":"src/stories/wizard-spa/second-step/second-step.component.ts","encapsulation":["ViewEncapsulation.None"],"entryComponents":[],"inputs":[],"outputs":[],"providers":[],"selector":"spa-second-step","styleUrls":[],"styles":[],"templateUrl":["./second-step.component.html"],"viewProviders":[],"hostDirectives":[],"inputsClass":[],"outputsClass":[],"propertiesClass":[],"methodsClass":[{"name":"getPathKeyForTakeId","args":[],"optional":false,"returnType":"string","typeParameters":[],"line":13,"deprecated":false,"deprecationMessage":"","modifierKind":[124]},{"name":"ngOnDestroyForChildren","args":[],"optional":false,"returnType":"void","typeParameters":[],"line":26,"deprecated":false,"deprecationMessage":""},{"name":"ngOnInitForChildren","args":[],"optional":false,"returnType":"void","typeParameters":[],"line":22,"deprecated":false,"deprecationMessage":""},{"name":"pageName","args":[],"optional":false,"returnType":"string","typeParameters":[],"line":18,"deprecated":false,"deprecationMessage":""}],"deprecated":false,"deprecationMessage":"","hostBindings":[],"hostListeners":[],"standalone":true,"imports":[],"description":"","rawdescription":"\\n","type":"component","sourceCode":"import {Component, ViewEncapsulation} from \'@angular/core\';\\n\\n\\n\\n@Component({\\n\\tselector: \'spa-second-step\',\\n\\ttemplateUrl: \'./second-step.component.html\',\\n\\tstandalone:true,\\n\\tencapsulation: ViewEncapsulation.None\\n})\\nexport class SecondStepComponent  {\\n\\t\\n\\tprotected getPathKeyForTakeId(): string {\\n\\t\\t//non lo usciamo uin questo caso\\n\\t\\treturn \'Step2\';\\n\\t}\\n\\n\\tpageName(): string {\\n\\t\\treturn \'Step2\';\\n\\t}\\n\\n\\tngOnInitForChildren() {\\n\\t\\t// This is intentional\\n\\t}\\n\\n\\tngOnDestroyForChildren() {\\n\\t\\t// This is intentional\\n\\t}\\n\\n}\\n","assetsDirs":[],"styleUrlsData":"","stylesData":"","extends":[],"templateData":"<div>Test2</div>"},{"name":"ThirdStepComponent","id":"component-ThirdStepComponent-32b93807b54919ccce0e965dc06affcf6a1a220cbbc0c75d244fb8aed39a8c877101666ad42a92322fa91fac3587dfd5e63339e7fba02e357e5efc0ee162011b","file":"src/stories/wizard-spa/third-step/third-step.component.ts","encapsulation":["ViewEncapsulation.None"],"entryComponents":[],"inputs":[],"outputs":[],"providers":[],"selector":"spa-third-step","styleUrls":[],"styles":[],"templateUrl":["./third-step.component.html"],"viewProviders":[],"hostDirectives":[],"inputsClass":[],"outputsClass":[],"propertiesClass":[],"methodsClass":[{"name":"getPathKeyForTakeId","args":[],"optional":false,"returnType":"string","typeParameters":[],"line":14,"deprecated":false,"deprecationMessage":"","modifierKind":[124]},{"name":"ngOnDestroyForChildren","args":[],"optional":false,"returnType":"void","typeParameters":[],"line":26,"deprecated":false,"deprecationMessage":""},{"name":"ngOnInitForChildren","args":[],"optional":false,"returnType":"void","typeParameters":[],"line":22,"deprecated":false,"deprecationMessage":""},{"name":"pageName","args":[],"optional":false,"returnType":"string","typeParameters":[],"line":18,"deprecated":false,"deprecationMessage":""}],"deprecated":false,"deprecationMessage":"","hostBindings":[],"hostListeners":[],"standalone":true,"imports":[],"description":"","rawdescription":"\\n","type":"component","sourceCode":"import {Component, ViewEncapsulation} from \'@angular/core\';\\n\\n\\n@Component({\\n\\tselector: \'spa-third-step\',\\n\\ttemplateUrl: \'./third-step.component.html\',\\n\\tstandalone:true,\\n\\tencapsulation: ViewEncapsulation.None,\\n})\\n\\nexport class ThirdStepComponent  {\\n\\n\\n\\tprotected getPathKeyForTakeId(): string {\\n\\t\\treturn \'Step3\';\\n\\t}\\n\\n\\tpageName(): string {\\n\\t\\treturn \'Step3\';\\n\\t}\\n\\n\\tngOnInitForChildren() {\\n\\t\\t// This is intentional\\n\\t}\\n\\n\\tngOnDestroyForChildren() {\\n\\t\\t// This is intentional\\n\\t }\\n\\n}\\n","assetsDirs":[],"styleUrlsData":"","stylesData":"","extends":[],"templateData":"<div>Test3</div>\\n"}],"modules":[{"name":"AppModule","id":"module-AppModule-8d3f77f80de5df10a34b8a70577138386af7dd81dca6c0f99d9de9d986d2d28367149329ebca65d79caafc36523ed347d43d2bb54047decde15e4770e458ad60","description":"","deprecationMessage":"","deprecated":false,"file":"src/app/app.module.ts","methods":[],"sourceCode":"import { NgModule } from \'@angular/core\';\\nimport { I18nModule } from \'../stories/shared/utils/i18n.module\';\\nimport { WebkitModule } from \'@inail/internet-webkit\';\\n\\nimport { CarouselBasicComponent } from \'../stories/carousel/carousel.stories\';\\nimport { ExpandablePageComponent } from \'../stories/exapdable-panel/expandable-panel.stories\';\\nimport { ModalBasicComponent } from \'../stories/modal/modal-basic.stories\';\\nimport { ModalConfirmComponent } from \'../stories/modal/modal-confirm.stories\';\\nimport { ModalFormComponent } from \'../stories/modal/modal-form.stories\';\\n\\n@NgModule({\\n  declarations: [\\n    CarouselBasicComponent,\\n    ExpandablePageComponent,\\n    ModalBasicComponent,\\n    ModalConfirmComponent,\\n    ModalFormComponent,\\n  ],\\n  imports: [WebkitModule, I18nModule],\\n  providers: [WebkitModule, I18nModule],\\n  bootstrap: [],\\n  exports: [WebkitModule],\\n})\\nexport class AppModule {}\\n","children":[{"type":"providers","elements":[]},{"type":"declarations","elements":[]},{"type":"imports","elements":[{"name":"I18nModule"}]},{"type":"exports","elements":[]},{"type":"bootstrap","elements":[]},{"type":"classes","elements":[]}]},{"name":"I18nModule","id":"module-I18nModule-fc45c61ff2d3359ee4e18bb962f52cd9b8224b3ba7f5d811e32133fbe0bf4493545a5e6b5af8c32f0169c11e2d376715bdd82ef7dd4ac55ad82113005f43da42","description":"","deprecationMessage":"","deprecated":false,"file":"src/stories/shared/utils/i18n.module.ts","methods":[],"sourceCode":"import { APP_INITIALIZER, NgModule } from \'@angular/core\';\\nimport { HttpClientModule, HttpClient } from \'@angular/common/http\';\\nimport { TranslateModule, TranslateLoader, TranslateService } from \'@ngx-translate/core\';\\nimport { TranslateHttpLoader } from \'@ngx-translate/http-loader\';\\nimport { LoggerService, WEBKIT_CONFIG } from \'@inail/angular-core\';\\nimport { loadWebkitAndAssetsFromInailCall } from \'@inail/internet-webkit/configuration\' ;\\n\\n// AoT requires an exported function for factories\\nexport function HttpLoaderFactory(http: HttpClient) {\\n    //return new TranslateHttpLoader(http, \'./static/media/src/stories/assets/i18n/\', \'.json\');\\n    //return new TranslateHttpLoader(http, \'./assets/i18n/\', \'.json\');\\n    return new TranslateHttpLoader(http, \'./\', \'.json\');\\n    // http://localhost:6007/static/media/src/stories/assets/docs.png\\n    //return new TranslateHttpLoader(http);\\n}\\n\\nconst CDN_ENDPOINT=\'https://cdn.inailcloud.it\';\\nconst CLIENT_OIDC =\'ClientWkinte\';\\n\\n@NgModule({\\n  declarations: [],\\n  imports: [\\n    HttpClientModule,\\n    TranslateModule.forRoot({\\n      loader: {\\n        provide: TranslateLoader,\\n        useFactory: HttpLoaderFactory,\\n        deps: [HttpClient]\\n      }\\n    })\\n  ],\\n  \\n  providers: [\\n    {\\n      provide: WEBKIT_CONFIG,\\n        useValue: {footerUrl: {url: \\"/api/hf/public/footer\\", property: \\"html\\"} }\\n    },\\n    {\\n       provide: APP_INITIALIZER,\\n       useValue: () => loadWebkitAndAssetsFromInailCall(CDN_ENDPOINT, \\n                        undefined, undefined, undefined, CLIENT_OIDC,\\n                       {url: \'/api/hf/public/head_rw\', property: \'html\'}),\\n       //deps: [InailContext, InailContextService],\\n       multi: true\\n    },\\n  ],\\n\\n  exports: [TranslateModule]\\n})\\nexport class I18nModule {\\n  constructor(translate: TranslateService) {\\n    translate.setDefaultLang(\'it\');\\n    translate.use(\'it\');\\n    LoggerService.getInstance().activeAll();\\n  }\\n}\\n\\n","children":[{"type":"providers","elements":[]},{"type":"declarations","elements":[]},{"type":"imports","elements":[]},{"type":"exports","elements":[]},{"type":"bootstrap","elements":[]},{"type":"classes","elements":[]}]}],"miscellaneous":{"variables":[{"name":"AccessibilityColor","ctype":"miscellaneous","subtype":"variable","file":"src/stories/graphicStyles/Colors.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  return (\\n    <div style={{ display: \\"flex\\", justifyContent: \\"space-between\\" }}>\\n      <div className=\\"accessibilita col-xs-12 col-sm-5 col-md-5\\">\\n        <h2 id=\\"accessibilita\\">Accessibilità</h2>\\n\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span>\\n              <em>Testo</em>\\n            </span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span>\\n              <em>Sfondo</em>\\n            </span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#002E5F\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#002E5F</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#116766\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#116766</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#000000\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#000000</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#E4E5E9\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#E4E5E9</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#002E5F\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#002E5F</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#EAEDF2\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#EAEDF2</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#000000\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#000000</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#EAEDF2\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#EAEDF2</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#000000\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#000000</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#F2F2F2\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#F2F2F2</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#000000\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#000000</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n        </div>\\n      </div>\\n\\n      <div className=\\"accessibilita col-xs-12 col-sm-5 col-md-5\\">\\n        <h2 id=\\"abbinamenti-accessibili\\">Abbinamenti accessibili</h2>\\n\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span>\\n              <em>Testo</em>\\n            </span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span>\\n              <em>Sfondo</em>\\n            </span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc azzurroInail\\"\\n              style={{\\n                backgroundColor:\\n                  ColorPaletteInail[\\"primary\\"][\\"azzurro\\"].colors[\\"azzurro\\"],\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#106CDB</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc verdeColor\\"\\n              style={{\\n                backgroundColor: ColorPaletteInail[\\"status\\"][\\"verde\\"].colors[\\"verde\\"],\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#0E821A</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc rossoColor\\"\\n              style={{\\n                backgroundColor: ColorPaletteInail[\\"status\\"][\\"rosso\\"].colors[\\"rosso\\"],\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#C9291B</span>\\n          </div>\\n        </div>\\n      </div>\\n    </div>\\n  );\\n}"},{"name":"ActionItemReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/actionItem-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{ActionItem}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"ActionsFieldReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/actionsField-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{ActionsField}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"addBodyClass","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/Utilities.ts","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  const body = document.getElementsByTagName(\'body\').item(0);\\n  body?.classList.add(\'background-inail\');\\n}"},{"name":"AdvancedTabReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/advancedTab-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{AdvancedTab}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"AngularSchematics","ctype":"miscellaneous","subtype":"variable","file":"src/stories/angular-schematics/angular-schematics.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  return (\\n    <div>\\n      <Markdown>{Readme}</Markdown>\\n      <Markdown>{Premessa}</Markdown>\\n      <Markdown>{Installazione}</Markdown>\\n      <Markdown>{Generazione}</Markdown>\\n      <Markdown>{Start}</Markdown>\\n      <Markdown>{Configurazione}</Markdown>\\n      <Markdown>{Riferimento}</Markdown>\\n      <Markdown>{Sequenza}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"appConfig","ctype":"miscellaneous","subtype":"variable","file":"src/app/app.config.ts","deprecated":false,"deprecationMessage":"","type":"ApplicationConfig","defaultValue":"{\\n  providers: [provideRouter(routes)]\\n}"},{"name":"BackgroundColors","ctype":"miscellaneous","subtype":"variable","file":"src/stories/graphicStyles/Colors.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  return displayColors(ColorPaletteInail[\\"background\\"]);\\n}"},{"name":"BaseInputComponentReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/baseInputComponent-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{BaseInputComponent}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"BaseModelReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/baseModel-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{BaseModel}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"BootstrapSizeReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/bootstrapSize-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{BootstrapSize}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"BrowserSupport","ctype":"miscellaneous","subtype":"variable","file":"src/stories/browser-support/browser-support.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  return (\\n    <>\\n      {/* <h1 id=\\"browser-support\\" className=\\"css-wzniqs\\">\\n        <a\\n          aria-hidden=\\"true\\"\\n          href=\\"#browser-support\\"\\n          target=\\"_self\\"\\n          className=\\"css-1ofkq6d\\"\\n        >\\n          <svg\\n            width=\\"14\\"\\n            height=\\"14\\"\\n            viewBox=\\"0 0 14 14\\"\\n            fill=\\"none\\"\\n            xmlns=\\"http://www.w3.org/2000/svg\\"\\n          >\\n            <path\\n              d=\\"M11.841 2.159a2.25 2.25 0 00-3.182 0l-2.5 2.5a2.25 2.25 0 000 3.182.5.5 0 01-.707.707 3.25 3.25 0 010-4.596l2.5-2.5a3.25 3.25 0 014.596 4.596l-2.063 2.063a4.27 4.27 0 00-.094-1.32l1.45-1.45a2.25 2.25 0 000-3.182z\\"\\n              fill=\\"currentColor\\"\\n            ></path>\\n            <path\\n              d=\\"M3.61 7.21c-.1-.434-.132-.88-.095-1.321L1.452 7.952a3.25 3.25 0 104.596 4.596l2.5-2.5a3.25 3.25 0 000-4.596.5.5 0 00-.707.707 2.25 2.25 0 010 3.182l-2.5 2.5A2.25 2.25 0 112.159 8.66l1.45-1.45z\\"\\n              fill=\\"currentColor\\"\\n            ></path>\\n          </svg>\\n        </a>\\n      </h1> */}\\n      {/* <p>\\n        UNDP Design system\'s components are compatible and tested in major\\n        modern browsers. Browsers and devices we support as follow.\\n      </p> */}\\n      <h3 id=\\"desktop\\" className=\\"css-wzniqs\\">\\n        <a\\n          aria-hidden=\\"true\\"\\n          href=\\"#desktop\\"\\n          target=\\"_self\\"\\n          className=\\"css-1ofkq6d\\"\\n        >\\n          <svg\\n            width=\\"14\\"\\n            height=\\"14\\"\\n            viewBox=\\"0 0 14 14\\"\\n            fill=\\"none\\"\\n            xmlns=\\"http://www.w3.org/2000/svg\\"\\n          >\\n            <path\\n              d=\\"M11.841 2.159a2.25 2.25 0 00-3.182 0l-2.5 2.5a2.25 2.25 0 000 3.182.5.5 0 01-.707.707 3.25 3.25 0 010-4.596l2.5-2.5a3.25 3.25 0 014.596 4.596l-2.063 2.063a4.27 4.27 0 00-.094-1.32l1.45-1.45a2.25 2.25 0 000-3.182z\\"\\n              fill=\\"currentColor\\"\\n            ></path>\\n            <path\\n              d=\\"M3.61 7.21c-.1-.434-.132-.88-.095-1.321L1.452 7.952a3.25 3.25 0 104.596 4.596l2.5-2.5a3.25 3.25 0 000-4.596.5.5 0 00-.707.707 2.25 2.25 0 010 3.182l-2.5 2.5A2.25 2.25 0 112.159 8.66l1.45-1.45z\\"\\n              fill=\\"currentColor\\"\\n            ></path>\\n          </svg>\\n        </a>\\n        Desktop\\n      </h3>\\n      <p>List of desktop browsers and OS supported.</p>\\n      <table>\\n        <tr>\\n          <th>Browser</th>\\n          <th>Version</th>\\n          <th>OS</th>\\n        </tr>\\n        <tr>\\n          <td>Chrome</td>\\n          <td>Latest stable and 2 lower version</td>\\n          <td>Windows, macOS</td>\\n        </tr>\\n        <tr>\\n          <td>Safari</td>\\n          <td>Latest stable and 2 lower version</td>\\n          <td>macOS</td>\\n        </tr>\\n        <tr>\\n          <td>Firefox</td>\\n          <td>Latest stable and 2 lower version</td>\\n          <td>Windows</td>\\n        </tr>\\n        <tr>\\n          <td>Edge</td>\\n          <td>Latest stable and 2 lower version</td>\\n          <td>Windows</td>\\n        </tr>\\n      </table>\\n      <h3 id=\\"mobile\\" className=\\"css-wzniqs\\">\\n        <a\\n          aria-hidden=\\"true\\"\\n          href=\\"#mobile\\"\\n          target=\\"_self\\"\\n          className=\\"css-1ofkq6d\\"\\n        >\\n          <svg\\n            width=\\"14\\"\\n            height=\\"14\\"\\n            viewBox=\\"0 0 14 14\\"\\n            fill=\\"none\\"\\n            xmlns=\\"http://www.w3.org/2000/svg\\"\\n          >\\n            <path\\n              d=\\"M11.841 2.159a2.25 2.25 0 00-3.182 0l-2.5 2.5a2.25 2.25 0 000 3.182.5.5 0 01-.707.707 3.25 3.25 0 010-4.596l2.5-2.5a3.25 3.25 0 014.596 4.596l-2.063 2.063a4.27 4.27 0 00-.094-1.32l1.45-1.45a2.25 2.25 0 000-3.182z\\"\\n              fill=\\"currentColor\\"\\n            ></path>\\n            <path\\n              d=\\"M3.61 7.21c-.1-.434-.132-.88-.095-1.321L1.452 7.952a3.25 3.25 0 104.596 4.596l2.5-2.5a3.25 3.25 0 000-4.596.5.5 0 00-.707.707 2.25 2.25 0 010 3.182l-2.5 2.5A2.25 2.25 0 112.159 8.66l1.45-1.45z\\"\\n              fill=\\"currentColor\\"\\n            ></path>\\n          </svg>\\n        </a>\\n        Mobile\\n      </h3>\\n      <p>List of mobile browsers and OS supported.</p>\\n      <table>\\n        <tr>\\n          <th>Browser</th>\\n          <th>Version</th>\\n          <th>OS</th>\\n        </tr>\\n        <tr>\\n          <td>Chrome</td>\\n          <td>Latest stable</td>\\n          <td>Android and iOS</td>\\n        </tr>\\n        <tr>\\n          <td>Safari</td>\\n          <td>Latest stable</td>\\n          <td>Android and iOS</td>\\n        </tr>\\n      </table>\\n    </>\\n  );\\n}"},{"name":"CarouselConfigReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/carouselConfig-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{CarouselConfig}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"CDN_ENDPOINT","ctype":"miscellaneous","subtype":"variable","file":"src/stories/shared/utils/i18n.module.ts","deprecated":false,"deprecationMessage":"","type":"string","defaultValue":"\'https://cdn.inailcloud.it\'"},{"name":"cleanHead","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/Utilities.ts","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  const head = document.querySelector(\'head\');\\n  if (head) {\\n    const nodes = Array.from(head.childNodes);\\n    let startIndex = -1;\\n    let endIndex = -1;\\n\\n    nodes.forEach((node, index) => {\\n      if (node.nodeType === Node.COMMENT_NODE) {\\n        const commentNode = node as Comment;\\n        if (commentNode.textContent?.trim() === \'SB-START\') {\\n          startIndex = index;\\n        } else if (commentNode.textContent?.trim() === \'SB-END\') {\\n          endIndex = index;\\n        }\\n      }\\n    });\\n\\n    if (startIndex !== -1 && endIndex !== -1) {\\n      nodes.slice(startIndex, endIndex + 1).forEach(node => node.remove());\\n    }\\n  }\\n\\n  const body = document.getElementsByTagName(\'body\').item(0);\\n  body?.classList.remove(\'container\');\\n}"},{"name":"CLIENT_OIDC","ctype":"miscellaneous","subtype":"variable","file":"src/stories/shared/utils/i18n.module.ts","deprecated":false,"deprecationMessage":"","type":"string","defaultValue":"\'ClientWkinte\'"},{"name":"ColorPaletteInail","ctype":"miscellaneous","subtype":"variable","file":"src/stories/graphicStyles/Colors.tsx","deprecated":false,"deprecationMessage":"","type":"IColorPalette","defaultValue":"{\\n  primary: {\\n    blue: {\\n      title: \\"BLUE INAIL\\",\\n      subtitle:\\n        \\"Sfondo del menu Istituzionale di primo livello, titolo della pagina, sfondo della utility box nel menu secondario, sfondo tasti generici, controlli del carousel abilitati e testo dei tasti disabilitati.\\",\\n      colors: {\\n        blueInail: \\"#002E5F\\",\\n      },\\n    },\\n    verde: {\\n      title: \\"VERDE INAIL\\",\\n      subtitle: `Sfondo del menu utente, link di guida alla pagina/sezione e tasto \\"cambia immagine\\" del profilo.`,\\n      colors: {\\n        verdeInail: \\"#116766\\",\\n      },\\n    },\\n    azzurro: {\\n      title: \\"AZZURRO\\",\\n      subtitle: \\"Link e tasti-link.\\",\\n      colors: {\\n        azzurro: \\"#106CDB\\",\\n      },\\n    },\\n  },\\n  background: {\\n    grigio: {\\n      title: \\"Sfondi\\",\\n      subtitle: \\"Colori di sfondo\\",\\n      colors: {\\n        Form: \\"#F2F2F2\\",\\n        \\"Menu secondario\\": \\"#EAEDF2\\",\\n        \\"Sfondo Tab non attiva, intestazioni tabelle\\": \\"#E4E5E9\\",\\n        Bianco: \\"#FFFFFF\\",\\n      },\\n    },\\n  },\\n  status: {\\n    verde: {\\n      title: \\"VERDE\\",\\n      subtitle:\\n        \\"Da utilizzare per i feedback positivi e tasto per completare il processo nell\'ultimo step.\\",\\n      colors: {\\n        verde: \\"#0E821A\\",\\n      },\\n    },\\n    rosso: {\\n      title: \\"ROSSO\\",\\n      subtitle:\\n        \\"Etichetta, descrizione e bordo dei campi con errore, sfondo dei feedback negativi.\\",\\n      colors: {\\n        rosso: \\"#C9291B\\",\\n      },\\n    },\\n    arancio: {\\n      title: \\"ARANCIO\\",\\n      subtitle: \\"Da utilizzare per indicare lo stato intermedio.\\",\\n      colors: {\\n        arancio: \\"#FFAA02\\",\\n      },\\n    },\\n    giallo: {\\n      title: \\"GIALLO\\",\\n      subtitle: \\"\\",\\n      colors: {\\n        giallo: \\"#FFE377\\",\\n      },\\n    },\\n  },\\n}"},{"name":"CSSAnalyzer","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/CSSAnalyzer.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<CSSAnalyzerProps>","defaultValue":"({ active }) => {\\n  const [selectedElement, setSelectedElement] =\\n    useState<HTMLElement | null>(null);\\n  const [computedStyles, setComputedStyles] = useState<Record<string, string>>(\\n    {}\\n  );\\n  const [elementName, setElementName] = useState<string>(\\"\\");\\n  const [boxModel, setBoxModel] = useState<BoxModel | null>(null);\\n\\n  useEffect(() => {\\n    const handleElementClick = (event: MouseEvent) => {\\n      event.preventDefault();\\n      event.stopPropagation();\\n\\n      const element = event.target as HTMLElement;\\n\\n      if (selectedElement) {\\n        selectedElement.style.outline = \\"none\\";\\n      }\\n\\n      element.style.outline = \\"2px solid #007acc\\";\\n      setSelectedElement(element);\\n      setElementName(element.tagName.toLowerCase());\\n      fetchComputedStyles(element);\\n    };\\n\\n    const fetchComputedStyles = (element: HTMLElement) => {\\n      const computedStyle = window.getComputedStyle(element);\\n      const boxModelData: BoxModel = {\\n        margin: {\\n          top: computedStyle.marginTop,\\n          right: computedStyle.marginRight,\\n          bottom: computedStyle.marginBottom,\\n          left: computedStyle.marginLeft,\\n        },\\n        border: {\\n          top: computedStyle.borderTopWidth,\\n          right: computedStyle.borderRightWidth,\\n          bottom: computedStyle.borderBottomWidth,\\n          left: computedStyle.borderLeftWidth,\\n        },\\n        padding: {\\n          top: computedStyle.paddingTop,\\n          right: computedStyle.paddingRight,\\n          bottom: computedStyle.paddingBottom,\\n          left: computedStyle.paddingLeft,\\n        },\\n        content: {\\n          width: computedStyle.width,\\n          height: computedStyle.height,\\n        },\\n        boxSizing: computedStyle.boxSizing,\\n        display: computedStyle.display,\\n        float: computedStyle.cssFloat,\\n        lineHeight: computedStyle.lineHeight,\\n        position: computedStyle.position,\\n        zIndex: computedStyle.zIndex,\\n      };\\n      const styleMap: Record<string, string> = {};\\n\\n      Array.from(computedStyle).forEach((property) => {\\n        styleMap[property] = computedStyle.getPropertyValue(property);\\n      });\\n\\n      setBoxModel(boxModelData);\\n      setComputedStyles(styleMap);\\n    };\\n\\n    if (active) {\\n      const iframe = document.querySelector(\\n        \\"#storybook-preview-iframe\\"\\n      ) as HTMLIFrameElement;\\n\\n      if (iframe?.contentDocument) {\\n        iframe.contentDocument.addEventListener(\\n          \\"click\\",\\n          handleElementClick,\\n          true\\n        );\\n\\n        // Return cleanup function\\n        return () => {\\n          iframe.contentDocument?.removeEventListener(\\n            \\"click\\",\\n            handleElementClick,\\n            true\\n          );\\n        };\\n      }\\n    }\\n\\n    // Explicitly return `undefined` if no cleanup is required\\n    return undefined;\\n  }, [active, selectedElement]);\\n\\n  const groupedStyles = Object.entries(computedStyles).reduce(\\n    (acc, [key, value]) => {\\n      const category = key.startsWith(\\"--\\")\\n        ? \\"CSS Variables\\"\\n        : key.startsWith(\\"background\\")\\n        ? \\"Background\\"\\n        : key.startsWith(\\"margin\\")\\n        ? \\"Margin\\"\\n        : key.startsWith(\\"padding\\")\\n        ? \\"Padding\\"\\n        : key.startsWith(\\"font\\")\\n        ? \\"Font\\"\\n        : key.startsWith(\\"border\\")\\n        ? \\"Border\\"\\n        : key.startsWith(\\"grid\\")\\n        ? \\"Grid\\"\\n        : key.startsWith(\\"text\\")\\n        ? \\"Text\\"\\n        : key.startsWith(\\"scroll\\") ||\\n          key.startsWith(\\"overscroll\\") ||\\n          key.startsWith(\\"overflow\\")\\n        ? \\"Scroll & Overflow\\"\\n        : key.startsWith(\\"-m\\") || key.startsWith(\\"-w\\")\\n        ? \\"Webkit\\"\\n        : \\"Other\\";\\n\\n      acc[category] = acc[category] || {};\\n      acc[category][key] = value;\\n      return acc;\\n    },\\n    {} as Record<string, Record<string, string>>\\n  );\\n\\n  return (\\n    <AddonPanel active={active}>\\n      <div style={{ padding: \\"10px\\" }}>\\n        <div>\\n          <h2>CSS Analyzer</h2>\\n          {elementName ? (\\n            <p>\\n              Selected Element: <strong>{elementName}</strong>\\n            </p>\\n          ): (\\n            <p>\\n              Clicca su un elemento per analizzarlo.\\n            </p>\\n          )}\\n        </div>\\n        <div\\n          style={{\\n            display: \\"flex\\",\\n            flexWrap: \\"wrap\\",\\n            padding: \\"10px\\",\\n            gap: \\"10px\\",\\n            alignItems: \\"stretch\\",\\n          }}\\n        >\\n          {boxModel && (\\n            <div\\n              style={{\\n                flex: \\"1 1 calc(50% - 10px)\\", // 50% width minus the gap\\n                minWidth: \\"400px\\",\\n                boxSizing: \\"border-box\\",\\n                display: \\"flex\\", // Ensure content fills the height\\n                flexDirection: \\"column\\",\\n              }}\\n            >\\n              <div style={{ top: 0, position: \\"sticky\\" }}>\\n                <TableBoxModel boxModel={boxModel} />\\n              </div>\\n            </div>\\n          )}\\n          {Object.entries(groupedStyles).length > 0 && (\\n            <div\\n              style={{\\n                flex: \\"1 1 calc(50% - 10px)\\", // 50% width minus the gap\\n                minWidth: \\"400px\\",\\n                boxSizing: \\"border-box\\",\\n                display: \\"flex\\", // Ensure content fills the height\\n                flexDirection: \\"column\\",\\n                textAlign: \\"center\\",\\n              }}\\n            >\\n              <h3>Css Computed Style</h3>\\n\\n              {Object.entries(groupedStyles).map(([group, styles]) => (\\n                <StyleSection key={group} title={group} data={styles} />\\n              ))}\\n            </div>\\n          )}\\n        </div>\\n      </div>\\n    </AddonPanel>\\n  );\\n}"},{"name":"DateModelReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/dateModel-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{DateModel}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"displayColors","ctype":"miscellaneous","subtype":"variable","file":"src/stories/graphicStyles/Colors.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"(colors: { [colorKey: string]: IColor }) => {\\n  return (\\n    <ColorPalette>\\n      {Object.entries(colors).map((element, index) => {\\n        return <ColorItem key={`${element[0]}-${index}`} {...element[1]} />;\\n      })}\\n    </ColorPalette>\\n  );\\n}"},{"name":"DocumentationReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/documentation-reader/documentation-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<literal type>","defaultValue":"({ type }) => {\\n  const [mdxContent, setMdxContent] = useState<string>(\\"\\");\\n  const [currentDoc, setCurrentDoc] = useState<string>(\\"\\");\\n  const channel = addons.getChannel();\\n  channel.once(\\"docsRendered\\", (doc) => {\\n    setCurrentDoc(doc);\\n  });\\n\\n  useEffect(() => {\\n    if (currentDoc) {\\n      const fetchMdx = async () => {\\n        try {\\n          const response = await fetch(`docs/${currentDoc}-${type}.md`);\\n          if (!response.ok)\\n            throw new Error(`Errore nel caricamento: ${response.statusText}`);\\n          const text = await response.text();\\n          setMdxContent(text);\\n        } catch (error) {\\n          console.error(`Errore nel caricamento del file MDX ${type}:`, error);\\n          setMdxContent(`Errore nel caricamento del contenuto ${type}.`);\\n        }\\n      };\\n      fetchMdx();\\n    }\\n  }, [currentDoc, type]);\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{mdxContent}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"DocumentationReaderDown","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/documentation-reader/documentation-reader.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => (\\n  <DocumentationReader type=\\"down\\" />\\n)"},{"name":"DocumentationReaderTop","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/documentation-reader/documentation-reader.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => <DocumentationReader type=\\"top\\" />"},{"name":"ErrorLabelReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/errorLabel-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{ErrorLabel}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"ExpandablePanelElementSizesReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/expandablePanelElementSizes-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{ExpandablePanelElementSizes}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"ExpandableTabReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/expandableTab-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{ExpandableTab}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"FilterTextReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/filterText-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{FilterText}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"FormTabellareConfigReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/formTabellareConfig-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{FormTabellareConfig}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"Icons","ctype":"miscellaneous","subtype":"variable","file":"src/stories/graphicStyles/Icons.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  return (\\n    <IconGallery>\\n      {Object.entries(ShowIcons).map((element, index) => {\\n        return (\\n          <IconItem name={element[1].class}>\\n            {/* <div\\n              title={element[1].functionality}\\n              style={{\\n                content: \\"\\",\\n                position: \\"absolute\\",\\n                top: 0,\\n                left: 0,\\n                width: \\"100%\\",\\n                height: \\"100%\\",\\n              }}\\n            /> */}\\n\\n            <i\\n              className={element[1].class}\\n              title={element[1].functionality}\\n            ></i>\\n          </IconItem>\\n        );\\n      })}\\n    </IconGallery>\\n  );\\n}"},{"name":"MdxReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/mdx-reader-component/mdx-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<MdxReaderProps>","defaultValue":"({ mdxPage }) => {\\n  const [isExpanded, setIsExpanded] = useState(false);\\n  const [mdxContent, setMdxContent] = useState<string>(\\"\\");\\n\\n  useEffect(() => {\\n    setMdxContent(mdxPage);\\n  }, [mdxPage]);\\n\\n  return (\\n    <div\\n      id=\\"user-experience-carousel-box\\"\\n      className=\\"row accordion-gray content\\"\\n    >\\n      {/* Accordion Header */}\\n      <div\\n        className={`row head-accordion-gray ${!isExpanded ? \\"collapsed\\" : \\"\\"}`}\\n        aria-expanded={isExpanded}\\n        onClick={() => setIsExpanded(!isExpanded)}\\n      >\\n        <img\\n          src=\\"static-webkit/img/user_experience.png\\"\\n          alt=\\"Icona user experience\\"\\n        />\\n\\n        <div className=\\"accordion-title col-xs-7\\">\\n          <strong>User Experience</strong>\\n        </div>\\n\\n        <em\\n          className={`fa fa-2x expand-icon pull-right fa-${isExpanded ? \\"minus\\" : \\"plus\\"}-circle`}\\n          title={isExpanded ? \\"Comprimi elemento\\" : \\"Espandi elemento\\"}\\n        />\\n      </div>\\n\\n      {/* Accordion Content */}\\n      <div\\n        id=\\"user-experience-carousel-box-panel\\"\\n        className={`row panel-body collapse ${isExpanded ? \\"in\\" : \\"\\"}`}\\n        aria-expanded={isExpanded}\\n      >\\n        <div className=\\"panel-content\\">\\n          <Markdown>{mdxContent}</Markdown>\\n        </div>\\n      </div>\\n    </div>\\n  );\\n}"},{"name":"ModalActionItemReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/modalActionItem-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{ModalActionItem}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"MultipleSelectLiveSearchStyleReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/multipleSelectLiveSearchStyle-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{MultipleSelectLiveSearchStyle}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"OptionsReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/options-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{Options}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"PrimaryColors","ctype":"miscellaneous","subtype":"variable","file":"src/stories/graphicStyles/Colors.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  return displayColors(ColorPaletteInail[\\"primary\\"]);\\n}"},{"name":"Property","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/CSSAnalyzer.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<PropertyProps>","defaultValue":"({ label, value }) => (\\n  <>\\n    <td\\n      style={{ border: \\"1px solid black\\", padding: \\"8px\\", textAlign: \\"left\\" }}\\n    >\\n      <strong>{label}</strong>\\n    </td>\\n    <td\\n      style={{ border: \\"1px solid black\\", padding: \\"8px\\", textAlign: \\"left\\" }}\\n    >\\n      {value}\\n    </td>\\n  </>\\n)"},{"name":"RadioOptionReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/radioOption-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{RadioOption}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"RadioTableFormStructureReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/radioTableFormStructure-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{RadioTableFormStructure}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"removeFooter","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/Utilities.ts","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  const footer = document.querySelector(\'footer\');\\n  if (footer) {\\n    footer.remove();\\n  }\\n}"},{"name":"removeHeader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/Utilities.ts","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  const header = document.querySelector(\'header\');\\n  if (header) {\\n    header.remove();\\n  }\\n}"},{"name":"ResultsReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/results-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{Results}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"RoleAlertModelReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/roleAlertModel-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{RoleAlertModel}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"ShowCodeAddon","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/show-code-addon/show-code.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<ShowCodeProps>","defaultValue":"({ active }) => {\\n  const [generatedHTML, setGeneratedHTML] = useState<string>(\\"\\");\\n  const api = useStorybookApi();\\n\\n  useEffect(() => {\\n    const generateHTML = () => {\\n      const storyData = api.getCurrentStoryData() as any;\\n      if (storyData?.parameters?.codeFixed) {\\n        setGeneratedHTML(storyData.parameters.codeFixed);\\n      } else {\\n        if (storyData && storyData.args) {\\n          const componentName = storyData.parameters.componentName;\\n          const args = storyData.args;\\n          const outputList: string[] = storyData.parameters.outputList || [];\\n          const customInputList: string[] =\\n            storyData.parameters.customElements || [];\\n          const directive = storyData.parameters.directive || \\"\\";\\n          const additionalCode = storyData.parameters.additionalCode || \\"\\";\\n\\n          // Trasformo gli argomenti in attributi HTML\\n          const argsString = Object.entries(args)\\n            .map(([key, value]) => {\\n              if (typeof value === \\"string\\") {\\n                return `  [${key}]=\\"\'${value}\'\\"`;\\n              } else if (\\n                typeof value === \\"boolean\\" ||\\n                value === null ||\\n                value === undefined\\n              ) {\\n                return `  [${key}]=\\"${value}\\"`;\\n              } else if (typeof value === \\"number\\") {\\n                return `  [${key}]=\\"${value}\\"`;\\n              } else if (Array.isArray(value)) {\\n                const isArrayOfObjects = value.every(\\n                  (item) => typeof item === \\"object\\"\\n                );\\n                if (!isArrayOfObjects) {\\n                  return `  [${key}]=\\"${JSON.stringify(value)}\\"`;\\n                }\\n                return \\"\\";\\n              } else if (typeof value === \\"object\\") {\\n                return \\"\\";\\n              }\\n              return \\"\\";\\n            })\\n            .filter(Boolean)\\n            .join(\\"\\\\n\\");\\n\\n          const customInput = customInputList.join(\\"\\\\n\\");\\n\\n          const outputContent = outputList.join(\\"\\\\n\\");\\n\\n          const finalHTML = `<${componentName}${\\n            directive ? `\\\\n${directive}` : \\"\\"\\n          }${argsString ? `\\\\n${argsString}` : \\"\\"}${\\n            customInput ? `\\\\n${customInput}` : \\"\\"\\n          }${outputContent ? `\\\\n  ${outputContent}` : \\"\\"}>\\\\n${\\n            additionalCode ? `${additionalCode}\\\\n` : \\"\\"\\n          }</${componentName}>`;\\n\\n          setGeneratedHTML(finalHTML);\\n        }\\n      }\\n    };\\n\\n    if (active) {\\n      generateHTML();\\n    }\\n  }, [api, active]);\\n\\n  return (\\n    <AddonPanel active={active}>\\n      <Markdown\\n        components={{\\n          pre: (props: any) => (\\n            <pre\\n              style={{\\n                whiteSpace: \\"pre-wrap\\",\\n                fontFamily: \\"monospace\\",\\n                fontSize: \\"14px\\",\\n                background: \\"#f5f5f5\\",\\n                padding: \\"10px\\",\\n                borderRadius: \\"4px\\",\\n                overflow: \\"auto\\",\\n                lineHeight: \\"1.5\\",\\n              }}\\n              {...props}\\n            />\\n          ),\\n        }}\\n      >\\n        {`\\\\`\\\\`\\\\`html\\\\n${generatedHTML}\\\\n\\\\`\\\\`\\\\``}\\n      </Markdown>\\n    </AddonPanel>\\n  );\\n}"},{"name":"ShowIcons","ctype":"miscellaneous","subtype":"variable","file":"src/stories/graphicStyles/Icons.tsx","deprecated":false,"deprecationMessage":"","type":"Icon","defaultValue":"{\\n  trash: {\\n    class: \\"i-trash icon\\",\\n    functionality: \\"Rimuovi elemento\\",\\n  },\\n  pencil: {\\n    class: \\"i-pencil icon\\",\\n    functionality: \\"Modifica elemento\\",\\n  },\\n  question: {\\n    class: \\"i-question-circle icon\\",\\n    functionality: \\"Visualizza informazioni\\",\\n  },\\n  eye: {\\n    class: \\"i-eye icon\\",\\n    functionality: \\"Visualizza nel dettaglio l\'elemento\\",\\n  },\\n  chevronDown: {\\n    class: \\"i-chevron-down icon\\",\\n    functionality: \\"Espandi/Riduci la riga\\",\\n  },\\n  plus: {\\n    class: \\"i-plus icon\\",\\n    functionality: \\"Aggiungi elementi\\",\\n  },\\n  plusCircle: {\\n    class: \\"i-plus-circle icon\\",\\n    functionality: \\"Espandi elemento\\",\\n  },\\n  download: {\\n    class: \\"i-download icon\\",\\n    functionality: \\"Scarica elemento\\",\\n  },\\n  triangle: {\\n    class: \\"i-exclamation-triangle icon\\",\\n    functionality:\\n      \\"Attenzione (warning). Il conflitto/errore è visualizzabile tramite tooltip al click sull\'icona\\",\\n  },\\n  euro: {\\n    class: \\"i-eur icon\\",\\n    functionality: \\"Visualizza pagamenti\\",\\n  },\\n  fileText: {\\n    class: \\"i-file-text-o icon\\",\\n    functionality: \\"Visualizza provvedimenti\\",\\n  },\\n  filePdf: {\\n    class: \\"i-file-pdf-o icon\\",\\n    functionality: \\"Scarica .PDF\\",\\n  },\\n  fileDoc: {\\n    class: \\"i-file-word-o icon\\",\\n    functionality: \\"Scarica .DOC\\",\\n  },\\n  fileExcel: {\\n    class: \\"i-file-excel-o icon\\",\\n    functionality: \\"Scarica .XLS\\",\\n  },\\n  filePowerpoint: {\\n    class: \\"i-file-powerpoint-o icon\\",\\n    functionality: \\"Scarica .PPT\\",\\n  },\\n  star: {\\n    class: \\"i-star icon\\",\\n    functionality:\\n      \\"Aggiungi/rimuovi dai preferiti. Selezionabile e deselezionabile come una checkbox\\",\\n  },\\n  paperclip: {\\n    class: \\"i-paperclip icon\\",\\n    functionality: \\"Presenza di allegati\\",\\n  },\\n}"},{"name":"StatusColors","ctype":"miscellaneous","subtype":"variable","file":"src/stories/graphicStyles/Colors.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  return displayColors(ColorPaletteInail[\\"status\\"]);\\n}"},{"name":"StepReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/step-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{Step}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"StyleSection","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/CSSAnalyzer.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<StyleSectionProps>","defaultValue":"({ title, data }) => {\\n  const [expanded, setExpanded] = useState(false);\\n\\n  return (\\n    <div style={{ marginBottom: \\"10px\\" }}>\\n      <button\\n        style={{\\n          background: \\"#f0f0f0\\",\\n          border: \\"1px solid black\\",\\n          padding: \\"8px\\",\\n          width: \\"100%\\",\\n          cursor: \\"pointer\\",\\n          display: \\"flex\\",\\n          justifyContent: \\"space-between\\",\\n        }}\\n        onClick={() => setExpanded(!expanded)}\\n      >\\n        <span>{title}</span>\\n        <span>{expanded ? \\"▼\\" : \\"▶\\"}</span>\\n      </button>\\n      {expanded && (\\n        <table style={{ width: \\"100%\\", borderCollapse: \\"collapse\\" }}>\\n          <thead>\\n            <tr>\\n              <th style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                Property\\n              </th>\\n              <th style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                Attribute\\n              </th>\\n            </tr>\\n          </thead>\\n          <tbody>\\n            {Object.entries(data).map(([key, value]) => (\\n              <tr key={key}>\\n                <Property label={key} value={value} />\\n              </tr>\\n            ))}\\n          </tbody>\\n        </table>\\n      )}\\n    </div>\\n  );\\n}"},{"name":"TableBoxModel","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/CSSAnalyzer.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<TableBoxModelProps>","defaultValue":"({ boxModel }) => {\\n  if (!boxModel || !boxModel.content) return null;\\n\\n  const { margin, border, padding, content } = boxModel;\\n\\n  const styles: Record<string, React.CSSProperties> = {\\n    bodyTest: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"center\\",\\n\\n      margin: 0,\\n      padding: 0,\\n      backgroundColor: \\"lightgray\\",\\n      fontFamily: \\"Arial, sans-serif\\",\\n    },\\n    container: {\\n      display: \\"flex\\",\\n      flexDirection: \\"column\\",\\n      alignItems: \\"center\\",\\n      width: \\"100%\\",\\n    },\\n    boxContent: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"flex-start\\", // Align items at the top\\n      position: \\"relative\\",\\n    },\\n    margin: {\\n      backgroundColor: \\"#73764a\\",\\n      padding: \\"24px 32px\\",\\n      position: \\"relative\\",\\n      border: \\"2px dashed #bcc900\\",\\n    },\\n    border: {\\n      backgroundColor: \\"#38383D\\",\\n      padding: \\"24px 32px\\",\\n    },\\n    padding: {\\n      backgroundColor: \\"#6657A6\\",\\n      padding: \\"24px 32px\\",\\n    },\\n    content: {\\n      backgroundColor: \\"#407AA4\\",\\n      width: \\"140px\\",\\n      height: \\"20px\\",\\n      border: \\"2px dashed #00b8ff\\",\\n      color: \\"white\\",\\n      fontWeight: \\"bold\\",\\n      textAlign: \\"center\\",\\n    },\\n    label: {\\n      position: \\"absolute\\",\\n      fontSize: \\"12px\\",\\n      background: \\"rgba(255, 255, 255, 0.8)\\",\\n      padding: \\"2px 5px\\",\\n      border: \\"1px solid black\\",\\n      borderRadius: \\"3px\\",\\n      pointerEvents: \\"none\\",\\n    },\\n    labelTop: {\\n      top: \\"-10px\\",\\n      left: \\"50%\\",\\n      transform: \\"translateX(-50%)\\",\\n    },\\n    labelBottom: {\\n      bottom: \\"-10px\\",\\n      left: \\"50%\\",\\n      transform: \\"translateX(-50%)\\",\\n    },\\n    labelLeft: {\\n      left: \\"-20px\\",\\n      top: \\"50%\\",\\n      transform: \\"translateY(-50%)\\",\\n      marginLeft: \\"2px\\",\\n      marginRight: \\"100px\\",\\n    },\\n    labelRight: {\\n      right: \\"-20px\\",\\n      top: \\"50%\\",\\n      transform: \\"translateY(-50%)\\",\\n    },\\n    labelText: {\\n      fontSize: \\"12px\\",\\n      fontWeight: \\"bold\\",\\n      marginRight: \\"10px\\", // Space between text and box\\n      alignSelf: \\"flex-start\\",\\n      position: \\"absolute\\",\\n      top: \\"0px\\", // Move text above the box\\n      zIndex: 99, // Ensure text is on top\\n      left: \\"15%\\",\\n      transform: \\"translateX(-50%)\\", // Center label horizontally\\n      color: \\"white\\",\\n    },\\n    rowContent: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"flex-start\\", // Align items to the top of the boxes\\n      marginTop: \\"20px\\",\\n      marginBottom: \\"20px\\",\\n      gap: \\"20px\\", // Space between the sections\\n      flexWrap: \\"wrap\\", // Allow wrapping for smaller screens\\n      padding: \\"0 10px\\",\\n    },\\n  };\\n\\n  return (\\n    <div style={{ textAlign: \\"center\\" }}>\\n      <h3>Box Model Representation</h3>\\n      <div style={styles[\\"bodyTest\\"]}>\\n        <div style={styles[\\"container\\"]}>\\n          {/* Horizontal Flexbox for Besi, Ana, and Ina */}\\n          <div style={styles[\\"rowContent\\"]}>\\n            {/* Ana Section */}\\n            <div style={styles[\\"boxContent\\"]}>\\n              <span style={styles[\\"labelText\\"]}>Margin</span>\\n              <div style={styles[\\"margin\\"]}>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}>\\n                  {margin.top}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelBottom\\"] }}>\\n                  {margin.bottom}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}>\\n                  {margin.left}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelRight\\"] }}>\\n                  {margin.right}\\n                </span>\\n                <div style={styles[\\"boxContent\\"]}>\\n                  <span style={styles[\\"labelText\\"]}>Border</span>\\n                  <div style={styles[\\"border\\"]}>\\n                    <span style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}>\\n                      {border.top}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelBottom\\"] }}\\n                    >\\n                      {border.bottom}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}\\n                    >\\n                      {border.left}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelRight\\"] }}\\n                    >\\n                      {border.right}\\n                    </span>\\n                    <div style={styles[\\"boxContent\\"]}>\\n                      <span style={styles[\\"labelText\\"]}>Padding</span>\\n                      <div style={styles[\\"padding\\"]}>\\n                        <span\\n                          style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}\\n                        >\\n                          {padding.top}\\n                        </span>\\n                        <span\\n                          style={{\\n                            ...styles[\\"label\\"],\\n                            ...styles[\\"labelBottom\\"],\\n                          }}\\n                        >\\n                          {padding.bottom}\\n                        </span>\\n                        <span\\n                          style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}\\n                        >\\n                          {padding.left}\\n                        </span>\\n                        <span\\n                          style={{\\n                            ...styles[\\"label\\"],\\n                            ...styles[\\"labelRight\\"],\\n                          }}\\n                        >\\n                          {padding.right}\\n                        </span>\\n                        <div style={styles[\\"content\\"]}>\\n                          {content.width} × {content.height}\\n                        </div>\\n                      </div>\\n                    </div>\\n                  </div>\\n                </div>\\n              </div>\\n            </div>\\n          </div>\\n        </div>\\n      </div>\\n\\n      {/* Box Model Information */}\\n      <div style={{ marginTop: \\"1rem\\", textAlign: \\"left\\", fontSize: \\"14px\\" }}>\\n        <table style={{ width: \\"100%\\", borderCollapse: \\"collapse\\" }}>\\n          <thead>\\n            <tr>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Property\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Attribute\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Top\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Right\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Bottom\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Left\\n              </th>\\n            </tr>\\n          </thead>\\n          <tbody>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Margin</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Border</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Padding</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Content Dimensions</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {content.width} × {content.height}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Box-sizing</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {boxModel.boxSizing}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n            </tr>\\n          </tbody>\\n        </table>\\n      </div>\\n    </div>\\n  );\\n}"},{"name":"TableFieldReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/tableField-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{TableField}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"TabReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/tab-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{Tab}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"TagReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/tag-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{Tag}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"TitleDoc","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/custom-title-docs.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<TitleDocsProps>","defaultValue":"({ title, links }) => {\\n  return (\\n    <div\\n      style={{\\n        width: \\"auto\\",\\n        minHeight: \\"128px\\",\\n        backgroundImage: \'url(\\"background.png\\")\',\\n        backgroundRepeat: \\"no-repeat\\",\\n        backgroundSize: \\"cover\\",\\n        backgroundPosition: \\"right center\\",\\n        borderRadius: \\"4px\\",\\n        display: \\"flex\\",\\n        flexDirection: \\"column\\",\\n        justifyContent: \\"center\\",\\n        alignItems: \\"flex-start\\",\\n        padding: \\"32px\\",\\n        boxSizing: \\"border-box\\",\\n        marginBottom: \\"5%\\",\\n      }}\\n    >\\n      <h1\\n        style={{\\n          textAlign: \\"left\\",\\n          width: \\"100%\\",\\n          marginBottom: \\"20px\\",\\n          lineHeight: \\"1\\", // Riduce lo spazio extra\\n        }}\\n      >\\n        {title}\\n      </h1>\\n      <nav style={{ width: \\"100%\\" }}>\\n        <ul\\n          style={{\\n            listStyleType: \\"none\\",\\n            padding: 0,\\n            flexWrap: \\"wrap\\",\\n            display: \\"flex\\",\\n            alignItems: \\"center\\", // Allinea verticalmente\\n            gap: \\"15px\\", // Spazio tra i link\\n            margin: 0,\\n          }}\\n        >\\n          {links.map((link, index) => (\\n            <li\\n              key={link?.href}\\n              style={{\\n                display: \\"flex\\",\\n                alignItems: \\"center\\",\\n                height: \\"100%\\", // Assicura altezza uniforme\\n                whiteSpace: \\"nowrap\\", // Impedisce il wrap della pipe\\n              }}\\n            >\\n              <a\\n                href={link?.href}\\n                target=\\"_self\\"\\n                style={{\\n                  fontSize: \\"1.2em\\",\\n                  color: \\"blue\\",\\n                  textDecoration: \\"none\\",\\n                  display: \\"flex\\",\\n                  alignItems: \\"center\\", // Centra verticalmente il testo del link\\n                  height: \\"100%\\",\\n                }}\\n              >\\n                {link?.text}\\n              </a>\\n              {/* Aggiungi la pipe dinamicamente solo dopo ogni link tranne l\'ultimo */}\\n              {index < links.length - 1 && (\\n                <span\\n                  style={{\\n                    marginLeft: \\"10px\\",\\n                    whiteSpace: \\"nowrap\\", // Impedisce che la pipe vada a capo\\n                  }}\\n                >\\n                  |\\n                </span>\\n              )}\\n            </li>\\n          ))}\\n        </ul>\\n      </nav>\\n    </div>\\n  );\\n}"},{"name":"TitleWithNavigation","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/custom-title.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<TitleWithNavigationProps>","defaultValue":"({\\n  title,\\n  showCode,\\n  showAccessibility\\n}) => {\\n  // Estrae l\'ultimo segmento del titolo dopo l\'ultimo \'/\'\\n  const extractedTitle = title.split(\\"/\\").pop() || title;\\n\\n  const links = [\\n    { href: \\"#panoramica\\", text: \\"Panoramica\\" },\\n    { href: \\"#caratteristiche-principali\\", text: \\"Caratteristiche Principali\\" },\\n    { href: \\"#varianti\\", text: \\"Varianti\\" },\\n    { href: \\"#best-practices\\", text: \\"Best Practices\\" },\\n    { href: \\"#componenti-correlati\\", text: \\"Componenti Correlati\\" },\\n    showAccessibility ? { href: \\"#accessibilita\\", text: \\"Accessibilità\\" } : null,\\n    showCode ? { href: \\"#codice\\", text: \\"Codice\\" } : null,\\n    { href: \\"#user-experience\\", text: \\"User Experience\\" },\\n    { href: \\"#overview\\", text: \\"Overview\\" },\\n   \\n  ].filter(Boolean);\\n\\n  return (\\n    <div\\n      style={{\\n        width: \\"auto\\",\\n        minHeight: \\"128px\\",\\n        backgroundImage: \'url(\\"background.png\\")\',\\n        backgroundRepeat: \\"no-repeat\\",\\n        backgroundSize: \\"cover\\",\\n        backgroundPosition: \\"right center\\",\\n        borderRadius: \\"4px\\",\\n        display: \\"flex\\",\\n        flexDirection: \\"column\\",\\n        justifyContent: \\"center\\",\\n        alignItems: \\"flex-start\\",\\n        padding: \\"32px\\",\\n        boxSizing: \\"border-box\\",\\n        marginBottom: \\"5%\\",\\n      }}\\n    >\\n      <h1\\n        style={{\\n          textAlign: \\"left\\",\\n          width: \\"100%\\",\\n          marginBottom: \\"20px\\",\\n          lineHeight: \\"1\\", // Riduce lo spazio extra\\n        }}\\n      >\\n        {extractedTitle}\\n      </h1>\\n      <nav style={{ width: \\"100%\\" }}>\\n        <ul\\n          style={{\\n            listStyleType: \\"none\\",\\n            padding: 0,\\n            flexWrap: \\"wrap\\",\\n            display: \\"flex\\",\\n            alignItems: \\"center\\", // Allinea verticalmente\\n            gap: \\"15px\\", // Spazio tra i link\\n            margin: 0,\\n          }}\\n        >\\n          {[\\n            { href: \\"#panoramica\\", text: \\"Panoramica\\" },\\n            { href: \\"#caratteristiche-principali\\", text: \\"Caratteristiche Principali\\" },\\n            { href: \\"#varianti\\", text: \\"Varianti\\" },\\n            { href: \\"#best-practices\\", text: \\"Best Practices\\" },\\n            { href: \\"#componenti-correlati\\", text: \\"Componenti Correlati\\" },\\n            { href: \\"#overview\\", text: \\"Overview\\" },\\n            { href: \\"#api\\", text: \\"API\\" },\\n          ].map((link, index) => (\\n            <li \\n              key={link.href}\\n              style={{\\n                display: \\"flex\\",\\n                alignItems: \\"center\\",\\n                height: \\"100%\\", // Assicura altezza uniforme\\n                whiteSpace: \\"nowrap\\", // Impedisce il wrap della pipe\\n              }}\\n            >\\n              <a\\n                href={link?.href}\\n                target=\\"_self\\"\\n                style={{\\n                  fontSize: \\"1.2em\\",\\n                  color: \\"blue\\",\\n                  textDecoration: \\"none\\",\\n                  display: \\"flex\\",\\n                  alignItems: \\"center\\", // Centra verticalmente il testo del link\\n                  height: \\"100%\\",\\n                }}\\n              >\\n                {link?.text}\\n              </a>\\n              {/* Aggiungi la pipe dinamicamente solo dopo ogni link tranne l\'ultimo */}\\n              {index < links.length - 1 && (\\n                <span\\n                  style={{\\n                    marginLeft: \\"10px\\",\\n                    whiteSpace: \\"nowrap\\", // Impedisce che la pipe vada a capo\\n                  }}\\n                >\\n                  |\\n                </span>\\n              )}\\n            </li>\\n          ))}\\n        </ul>\\n      </nav>\\n    </div>\\n  );\\n}"},{"name":"TooltipModelReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/tooltipModel-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{TooltipModel}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"TooltipPlacementEnumReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/tooltipPlacementEnum-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{TooltipPlacementEnum}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"TooltipPlaceTypeReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/tooltipPlaceType-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{TooltipPlaceType}</Markdown>\\n    </div>\\n  );\\n}"}],"functions":[{"name":"createRenderFunction","file":"src/common/shared/Utilities.ts","ctype":"miscellaneous","subtype":"function","deprecated":false,"deprecationMessage":"","description":"","args":[{"name":"componentName","type":"string","deprecated":false,"deprecationMessage":""}],"jsdoctags":[{"name":"componentName","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"createTranslateLoader","file":"src/stories/shared/utils/translate-loader.ts","ctype":"miscellaneous","subtype":"function","deprecated":false,"deprecationMessage":"","description":"","args":[{"name":"http","type":"HttpClient","deprecated":false,"deprecationMessage":""}],"jsdoctags":[{"name":"http","type":"HttpClient","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"generateRandomData","file":"src/stories/table/utils.ts","ctype":"miscellaneous","subtype":"function","deprecated":false,"deprecationMessage":"","description":"","args":[{"name":"num","type":"number","deprecated":false,"deprecationMessage":""}],"jsdoctags":[{"name":"num","type":"number","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"HttpLoaderFactory","file":"src/stories/shared/utils/i18n.module.ts","ctype":"miscellaneous","subtype":"function","deprecated":false,"deprecationMessage":"","description":"","args":[{"name":"http","type":"HttpClient","deprecated":false,"deprecationMessage":""}],"jsdoctags":[{"name":"http","type":"HttpClient","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"injectInjectorToProps","file":"src/stories/inject-injector-to-props.decorator.ts","ctype":"miscellaneous","subtype":"function","deprecated":false,"deprecationMessage":"","description":"","args":[],"returnType":"DecoratorFunction<AngularRenderer, TArgs>"},{"name":"isIMockDataKey","file":"src/stories/table/utils.ts","ctype":"miscellaneous","subtype":"function","deprecated":false,"deprecationMessage":"","description":"","args":[{"name":"key","type":"string","deprecated":false,"deprecationMessage":""}],"jsdoctags":[{"name":"key","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"playFunction","file":"src/common/shared/Utilities.ts","ctype":"miscellaneous","subtype":"function","deprecated":false,"deprecationMessage":"","description":"","args":[{"name":"canvasElement","type":"any","deprecated":false,"deprecationMessage":""}],"jsdoctags":[{"name":"canvasElement","type":"any","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]}],"typealiases":[],"enumerations":[],"groupedVariables":{"src/stories/graphicStyles/Colors.tsx":[{"name":"AccessibilityColor","ctype":"miscellaneous","subtype":"variable","file":"src/stories/graphicStyles/Colors.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  return (\\n    <div style={{ display: \\"flex\\", justifyContent: \\"space-between\\" }}>\\n      <div className=\\"accessibilita col-xs-12 col-sm-5 col-md-5\\">\\n        <h2 id=\\"accessibilita\\">Accessibilità</h2>\\n\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span>\\n              <em>Testo</em>\\n            </span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span>\\n              <em>Sfondo</em>\\n            </span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#002E5F\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#002E5F</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#116766\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#116766</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#000000\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#000000</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#E4E5E9\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#E4E5E9</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#002E5F\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#002E5F</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#EAEDF2\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#EAEDF2</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#000000\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#000000</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#EAEDF2\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#EAEDF2</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#000000\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#000000</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#F2F2F2\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#F2F2F2</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{ backgroundColor: \\"#000000\\" }}\\n            ></span>\\n            <span className=\\"color-example\\">#000000</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n        </div>\\n      </div>\\n\\n      <div className=\\"accessibilita col-xs-12 col-sm-5 col-md-5\\">\\n        <h2 id=\\"abbinamenti-accessibili\\">Abbinamenti accessibili</h2>\\n\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span>\\n              <em>Testo</em>\\n            </span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span>\\n              <em>Sfondo</em>\\n            </span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc azzurroInail\\"\\n              style={{\\n                backgroundColor:\\n                  ColorPaletteInail[\\"primary\\"][\\"azzurro\\"].colors[\\"azzurro\\"],\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#106CDB</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc verdeColor\\"\\n              style={{\\n                backgroundColor: ColorPaletteInail[\\"status\\"][\\"verde\\"].colors[\\"verde\\"],\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#0E821A</span>\\n          </div>\\n        </div>\\n        <div className=\\"row\\">\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc\\"\\n              style={{\\n                backgroundColor: \\"#FFFFFF\\",\\n                border: \\"1px solid #767676\\",\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#FFFFFF</span>\\n          </div>\\n          <div className=\\"col-sm-6\\">\\n            <span\\n              className=\\"color-desc rossoColor\\"\\n              style={{\\n                backgroundColor: ColorPaletteInail[\\"status\\"][\\"rosso\\"].colors[\\"rosso\\"],\\n              }}\\n            ></span>\\n            <span className=\\"color-example\\">#C9291B</span>\\n          </div>\\n        </div>\\n      </div>\\n    </div>\\n  );\\n}"},{"name":"BackgroundColors","ctype":"miscellaneous","subtype":"variable","file":"src/stories/graphicStyles/Colors.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  return displayColors(ColorPaletteInail[\\"background\\"]);\\n}"},{"name":"ColorPaletteInail","ctype":"miscellaneous","subtype":"variable","file":"src/stories/graphicStyles/Colors.tsx","deprecated":false,"deprecationMessage":"","type":"IColorPalette","defaultValue":"{\\n  primary: {\\n    blue: {\\n      title: \\"BLUE INAIL\\",\\n      subtitle:\\n        \\"Sfondo del menu Istituzionale di primo livello, titolo della pagina, sfondo della utility box nel menu secondario, sfondo tasti generici, controlli del carousel abilitati e testo dei tasti disabilitati.\\",\\n      colors: {\\n        blueInail: \\"#002E5F\\",\\n      },\\n    },\\n    verde: {\\n      title: \\"VERDE INAIL\\",\\n      subtitle: `Sfondo del menu utente, link di guida alla pagina/sezione e tasto \\"cambia immagine\\" del profilo.`,\\n      colors: {\\n        verdeInail: \\"#116766\\",\\n      },\\n    },\\n    azzurro: {\\n      title: \\"AZZURRO\\",\\n      subtitle: \\"Link e tasti-link.\\",\\n      colors: {\\n        azzurro: \\"#106CDB\\",\\n      },\\n    },\\n  },\\n  background: {\\n    grigio: {\\n      title: \\"Sfondi\\",\\n      subtitle: \\"Colori di sfondo\\",\\n      colors: {\\n        Form: \\"#F2F2F2\\",\\n        \\"Menu secondario\\": \\"#EAEDF2\\",\\n        \\"Sfondo Tab non attiva, intestazioni tabelle\\": \\"#E4E5E9\\",\\n        Bianco: \\"#FFFFFF\\",\\n      },\\n    },\\n  },\\n  status: {\\n    verde: {\\n      title: \\"VERDE\\",\\n      subtitle:\\n        \\"Da utilizzare per i feedback positivi e tasto per completare il processo nell\'ultimo step.\\",\\n      colors: {\\n        verde: \\"#0E821A\\",\\n      },\\n    },\\n    rosso: {\\n      title: \\"ROSSO\\",\\n      subtitle:\\n        \\"Etichetta, descrizione e bordo dei campi con errore, sfondo dei feedback negativi.\\",\\n      colors: {\\n        rosso: \\"#C9291B\\",\\n      },\\n    },\\n    arancio: {\\n      title: \\"ARANCIO\\",\\n      subtitle: \\"Da utilizzare per indicare lo stato intermedio.\\",\\n      colors: {\\n        arancio: \\"#FFAA02\\",\\n      },\\n    },\\n    giallo: {\\n      title: \\"GIALLO\\",\\n      subtitle: \\"\\",\\n      colors: {\\n        giallo: \\"#FFE377\\",\\n      },\\n    },\\n  },\\n}"},{"name":"displayColors","ctype":"miscellaneous","subtype":"variable","file":"src/stories/graphicStyles/Colors.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"(colors: { [colorKey: string]: IColor }) => {\\n  return (\\n    <ColorPalette>\\n      {Object.entries(colors).map((element, index) => {\\n        return <ColorItem key={`${element[0]}-${index}`} {...element[1]} />;\\n      })}\\n    </ColorPalette>\\n  );\\n}"},{"name":"PrimaryColors","ctype":"miscellaneous","subtype":"variable","file":"src/stories/graphicStyles/Colors.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  return displayColors(ColorPaletteInail[\\"primary\\"]);\\n}"},{"name":"StatusColors","ctype":"miscellaneous","subtype":"variable","file":"src/stories/graphicStyles/Colors.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  return displayColors(ColorPaletteInail[\\"status\\"]);\\n}"}],"src/common/shared/models-reader/actionItem-reader.tsx":[{"name":"ActionItemReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/actionItem-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{ActionItem}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/actionsField-reader.tsx":[{"name":"ActionsFieldReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/actionsField-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{ActionsField}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/Utilities.ts":[{"name":"addBodyClass","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/Utilities.ts","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  const body = document.getElementsByTagName(\'body\').item(0);\\n  body?.classList.add(\'background-inail\');\\n}"},{"name":"cleanHead","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/Utilities.ts","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  const head = document.querySelector(\'head\');\\n  if (head) {\\n    const nodes = Array.from(head.childNodes);\\n    let startIndex = -1;\\n    let endIndex = -1;\\n\\n    nodes.forEach((node, index) => {\\n      if (node.nodeType === Node.COMMENT_NODE) {\\n        const commentNode = node as Comment;\\n        if (commentNode.textContent?.trim() === \'SB-START\') {\\n          startIndex = index;\\n        } else if (commentNode.textContent?.trim() === \'SB-END\') {\\n          endIndex = index;\\n        }\\n      }\\n    });\\n\\n    if (startIndex !== -1 && endIndex !== -1) {\\n      nodes.slice(startIndex, endIndex + 1).forEach(node => node.remove());\\n    }\\n  }\\n\\n  const body = document.getElementsByTagName(\'body\').item(0);\\n  body?.classList.remove(\'container\');\\n}"},{"name":"removeFooter","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/Utilities.ts","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  const footer = document.querySelector(\'footer\');\\n  if (footer) {\\n    footer.remove();\\n  }\\n}"},{"name":"removeHeader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/Utilities.ts","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  const header = document.querySelector(\'header\');\\n  if (header) {\\n    header.remove();\\n  }\\n}"}],"src/common/shared/models-reader/advancedTab-reader.tsx":[{"name":"AdvancedTabReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/advancedTab-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{AdvancedTab}</Markdown>\\n    </div>\\n  );\\n}"}],"src/stories/angular-schematics/angular-schematics.tsx":[{"name":"AngularSchematics","ctype":"miscellaneous","subtype":"variable","file":"src/stories/angular-schematics/angular-schematics.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  return (\\n    <div>\\n      <Markdown>{Readme}</Markdown>\\n      <Markdown>{Premessa}</Markdown>\\n      <Markdown>{Installazione}</Markdown>\\n      <Markdown>{Generazione}</Markdown>\\n      <Markdown>{Start}</Markdown>\\n      <Markdown>{Configurazione}</Markdown>\\n      <Markdown>{Riferimento}</Markdown>\\n      <Markdown>{Sequenza}</Markdown>\\n    </div>\\n  );\\n}"}],"src/app/app.config.ts":[{"name":"appConfig","ctype":"miscellaneous","subtype":"variable","file":"src/app/app.config.ts","deprecated":false,"deprecationMessage":"","type":"ApplicationConfig","defaultValue":"{\\n  providers: [provideRouter(routes)]\\n}"}],"src/common/shared/models-reader/baseInputComponent-reader.tsx":[{"name":"BaseInputComponentReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/baseInputComponent-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{BaseInputComponent}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/baseModel-reader.tsx":[{"name":"BaseModelReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/baseModel-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{BaseModel}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/bootstrapSize-reader.tsx":[{"name":"BootstrapSizeReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/bootstrapSize-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{BootstrapSize}</Markdown>\\n    </div>\\n  );\\n}"}],"src/stories/browser-support/browser-support.tsx":[{"name":"BrowserSupport","ctype":"miscellaneous","subtype":"variable","file":"src/stories/browser-support/browser-support.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  return (\\n    <>\\n      {/* <h1 id=\\"browser-support\\" className=\\"css-wzniqs\\">\\n        <a\\n          aria-hidden=\\"true\\"\\n          href=\\"#browser-support\\"\\n          target=\\"_self\\"\\n          className=\\"css-1ofkq6d\\"\\n        >\\n          <svg\\n            width=\\"14\\"\\n            height=\\"14\\"\\n            viewBox=\\"0 0 14 14\\"\\n            fill=\\"none\\"\\n            xmlns=\\"http://www.w3.org/2000/svg\\"\\n          >\\n            <path\\n              d=\\"M11.841 2.159a2.25 2.25 0 00-3.182 0l-2.5 2.5a2.25 2.25 0 000 3.182.5.5 0 01-.707.707 3.25 3.25 0 010-4.596l2.5-2.5a3.25 3.25 0 014.596 4.596l-2.063 2.063a4.27 4.27 0 00-.094-1.32l1.45-1.45a2.25 2.25 0 000-3.182z\\"\\n              fill=\\"currentColor\\"\\n            ></path>\\n            <path\\n              d=\\"M3.61 7.21c-.1-.434-.132-.88-.095-1.321L1.452 7.952a3.25 3.25 0 104.596 4.596l2.5-2.5a3.25 3.25 0 000-4.596.5.5 0 00-.707.707 2.25 2.25 0 010 3.182l-2.5 2.5A2.25 2.25 0 112.159 8.66l1.45-1.45z\\"\\n              fill=\\"currentColor\\"\\n            ></path>\\n          </svg>\\n        </a>\\n      </h1> */}\\n      {/* <p>\\n        UNDP Design system\'s components are compatible and tested in major\\n        modern browsers. Browsers and devices we support as follow.\\n      </p> */}\\n      <h3 id=\\"desktop\\" className=\\"css-wzniqs\\">\\n        <a\\n          aria-hidden=\\"true\\"\\n          href=\\"#desktop\\"\\n          target=\\"_self\\"\\n          className=\\"css-1ofkq6d\\"\\n        >\\n          <svg\\n            width=\\"14\\"\\n            height=\\"14\\"\\n            viewBox=\\"0 0 14 14\\"\\n            fill=\\"none\\"\\n            xmlns=\\"http://www.w3.org/2000/svg\\"\\n          >\\n            <path\\n              d=\\"M11.841 2.159a2.25 2.25 0 00-3.182 0l-2.5 2.5a2.25 2.25 0 000 3.182.5.5 0 01-.707.707 3.25 3.25 0 010-4.596l2.5-2.5a3.25 3.25 0 014.596 4.596l-2.063 2.063a4.27 4.27 0 00-.094-1.32l1.45-1.45a2.25 2.25 0 000-3.182z\\"\\n              fill=\\"currentColor\\"\\n            ></path>\\n            <path\\n              d=\\"M3.61 7.21c-.1-.434-.132-.88-.095-1.321L1.452 7.952a3.25 3.25 0 104.596 4.596l2.5-2.5a3.25 3.25 0 000-4.596.5.5 0 00-.707.707 2.25 2.25 0 010 3.182l-2.5 2.5A2.25 2.25 0 112.159 8.66l1.45-1.45z\\"\\n              fill=\\"currentColor\\"\\n            ></path>\\n          </svg>\\n        </a>\\n        Desktop\\n      </h3>\\n      <p>List of desktop browsers and OS supported.</p>\\n      <table>\\n        <tr>\\n          <th>Browser</th>\\n          <th>Version</th>\\n          <th>OS</th>\\n        </tr>\\n        <tr>\\n          <td>Chrome</td>\\n          <td>Latest stable and 2 lower version</td>\\n          <td>Windows, macOS</td>\\n        </tr>\\n        <tr>\\n          <td>Safari</td>\\n          <td>Latest stable and 2 lower version</td>\\n          <td>macOS</td>\\n        </tr>\\n        <tr>\\n          <td>Firefox</td>\\n          <td>Latest stable and 2 lower version</td>\\n          <td>Windows</td>\\n        </tr>\\n        <tr>\\n          <td>Edge</td>\\n          <td>Latest stable and 2 lower version</td>\\n          <td>Windows</td>\\n        </tr>\\n      </table>\\n      <h3 id=\\"mobile\\" className=\\"css-wzniqs\\">\\n        <a\\n          aria-hidden=\\"true\\"\\n          href=\\"#mobile\\"\\n          target=\\"_self\\"\\n          className=\\"css-1ofkq6d\\"\\n        >\\n          <svg\\n            width=\\"14\\"\\n            height=\\"14\\"\\n            viewBox=\\"0 0 14 14\\"\\n            fill=\\"none\\"\\n            xmlns=\\"http://www.w3.org/2000/svg\\"\\n          >\\n            <path\\n              d=\\"M11.841 2.159a2.25 2.25 0 00-3.182 0l-2.5 2.5a2.25 2.25 0 000 3.182.5.5 0 01-.707.707 3.25 3.25 0 010-4.596l2.5-2.5a3.25 3.25 0 014.596 4.596l-2.063 2.063a4.27 4.27 0 00-.094-1.32l1.45-1.45a2.25 2.25 0 000-3.182z\\"\\n              fill=\\"currentColor\\"\\n            ></path>\\n            <path\\n              d=\\"M3.61 7.21c-.1-.434-.132-.88-.095-1.321L1.452 7.952a3.25 3.25 0 104.596 4.596l2.5-2.5a3.25 3.25 0 000-4.596.5.5 0 00-.707.707 2.25 2.25 0 010 3.182l-2.5 2.5A2.25 2.25 0 112.159 8.66l1.45-1.45z\\"\\n              fill=\\"currentColor\\"\\n            ></path>\\n          </svg>\\n        </a>\\n        Mobile\\n      </h3>\\n      <p>List of mobile browsers and OS supported.</p>\\n      <table>\\n        <tr>\\n          <th>Browser</th>\\n          <th>Version</th>\\n          <th>OS</th>\\n        </tr>\\n        <tr>\\n          <td>Chrome</td>\\n          <td>Latest stable</td>\\n          <td>Android and iOS</td>\\n        </tr>\\n        <tr>\\n          <td>Safari</td>\\n          <td>Latest stable</td>\\n          <td>Android and iOS</td>\\n        </tr>\\n      </table>\\n    </>\\n  );\\n}"}],"src/common/shared/models-reader/carouselConfig-reader.tsx":[{"name":"CarouselConfigReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/carouselConfig-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{CarouselConfig}</Markdown>\\n    </div>\\n  );\\n}"}],"src/stories/shared/utils/i18n.module.ts":[{"name":"CDN_ENDPOINT","ctype":"miscellaneous","subtype":"variable","file":"src/stories/shared/utils/i18n.module.ts","deprecated":false,"deprecationMessage":"","type":"string","defaultValue":"\'https://cdn.inailcloud.it\'"},{"name":"CLIENT_OIDC","ctype":"miscellaneous","subtype":"variable","file":"src/stories/shared/utils/i18n.module.ts","deprecated":false,"deprecationMessage":"","type":"string","defaultValue":"\'ClientWkinte\'"}],"src/common/shared/CSSAnalyzer.tsx":[{"name":"CSSAnalyzer","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/CSSAnalyzer.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<CSSAnalyzerProps>","defaultValue":"({ active }) => {\\n  const [selectedElement, setSelectedElement] =\\n    useState<HTMLElement | null>(null);\\n  const [computedStyles, setComputedStyles] = useState<Record<string, string>>(\\n    {}\\n  );\\n  const [elementName, setElementName] = useState<string>(\\"\\");\\n  const [boxModel, setBoxModel] = useState<BoxModel | null>(null);\\n\\n  useEffect(() => {\\n    const handleElementClick = (event: MouseEvent) => {\\n      event.preventDefault();\\n      event.stopPropagation();\\n\\n      const element = event.target as HTMLElement;\\n\\n      if (selectedElement) {\\n        selectedElement.style.outline = \\"none\\";\\n      }\\n\\n      element.style.outline = \\"2px solid #007acc\\";\\n      setSelectedElement(element);\\n      setElementName(element.tagName.toLowerCase());\\n      fetchComputedStyles(element);\\n    };\\n\\n    const fetchComputedStyles = (element: HTMLElement) => {\\n      const computedStyle = window.getComputedStyle(element);\\n      const boxModelData: BoxModel = {\\n        margin: {\\n          top: computedStyle.marginTop,\\n          right: computedStyle.marginRight,\\n          bottom: computedStyle.marginBottom,\\n          left: computedStyle.marginLeft,\\n        },\\n        border: {\\n          top: computedStyle.borderTopWidth,\\n          right: computedStyle.borderRightWidth,\\n          bottom: computedStyle.borderBottomWidth,\\n          left: computedStyle.borderLeftWidth,\\n        },\\n        padding: {\\n          top: computedStyle.paddingTop,\\n          right: computedStyle.paddingRight,\\n          bottom: computedStyle.paddingBottom,\\n          left: computedStyle.paddingLeft,\\n        },\\n        content: {\\n          width: computedStyle.width,\\n          height: computedStyle.height,\\n        },\\n        boxSizing: computedStyle.boxSizing,\\n        display: computedStyle.display,\\n        float: computedStyle.cssFloat,\\n        lineHeight: computedStyle.lineHeight,\\n        position: computedStyle.position,\\n        zIndex: computedStyle.zIndex,\\n      };\\n      const styleMap: Record<string, string> = {};\\n\\n      Array.from(computedStyle).forEach((property) => {\\n        styleMap[property] = computedStyle.getPropertyValue(property);\\n      });\\n\\n      setBoxModel(boxModelData);\\n      setComputedStyles(styleMap);\\n    };\\n\\n    if (active) {\\n      const iframe = document.querySelector(\\n        \\"#storybook-preview-iframe\\"\\n      ) as HTMLIFrameElement;\\n\\n      if (iframe?.contentDocument) {\\n        iframe.contentDocument.addEventListener(\\n          \\"click\\",\\n          handleElementClick,\\n          true\\n        );\\n\\n        // Return cleanup function\\n        return () => {\\n          iframe.contentDocument?.removeEventListener(\\n            \\"click\\",\\n            handleElementClick,\\n            true\\n          );\\n        };\\n      }\\n    }\\n\\n    // Explicitly return `undefined` if no cleanup is required\\n    return undefined;\\n  }, [active, selectedElement]);\\n\\n  const groupedStyles = Object.entries(computedStyles).reduce(\\n    (acc, [key, value]) => {\\n      const category = key.startsWith(\\"--\\")\\n        ? \\"CSS Variables\\"\\n        : key.startsWith(\\"background\\")\\n        ? \\"Background\\"\\n        : key.startsWith(\\"margin\\")\\n        ? \\"Margin\\"\\n        : key.startsWith(\\"padding\\")\\n        ? \\"Padding\\"\\n        : key.startsWith(\\"font\\")\\n        ? \\"Font\\"\\n        : key.startsWith(\\"border\\")\\n        ? \\"Border\\"\\n        : key.startsWith(\\"grid\\")\\n        ? \\"Grid\\"\\n        : key.startsWith(\\"text\\")\\n        ? \\"Text\\"\\n        : key.startsWith(\\"scroll\\") ||\\n          key.startsWith(\\"overscroll\\") ||\\n          key.startsWith(\\"overflow\\")\\n        ? \\"Scroll & Overflow\\"\\n        : key.startsWith(\\"-m\\") || key.startsWith(\\"-w\\")\\n        ? \\"Webkit\\"\\n        : \\"Other\\";\\n\\n      acc[category] = acc[category] || {};\\n      acc[category][key] = value;\\n      return acc;\\n    },\\n    {} as Record<string, Record<string, string>>\\n  );\\n\\n  return (\\n    <AddonPanel active={active}>\\n      <div style={{ padding: \\"10px\\" }}>\\n        <div>\\n          <h2>CSS Analyzer</h2>\\n          {elementName ? (\\n            <p>\\n              Selected Element: <strong>{elementName}</strong>\\n            </p>\\n          ): (\\n            <p>\\n              Clicca su un elemento per analizzarlo.\\n            </p>\\n          )}\\n        </div>\\n        <div\\n          style={{\\n            display: \\"flex\\",\\n            flexWrap: \\"wrap\\",\\n            padding: \\"10px\\",\\n            gap: \\"10px\\",\\n            alignItems: \\"stretch\\",\\n          }}\\n        >\\n          {boxModel && (\\n            <div\\n              style={{\\n                flex: \\"1 1 calc(50% - 10px)\\", // 50% width minus the gap\\n                minWidth: \\"400px\\",\\n                boxSizing: \\"border-box\\",\\n                display: \\"flex\\", // Ensure content fills the height\\n                flexDirection: \\"column\\",\\n              }}\\n            >\\n              <div style={{ top: 0, position: \\"sticky\\" }}>\\n                <TableBoxModel boxModel={boxModel} />\\n              </div>\\n            </div>\\n          )}\\n          {Object.entries(groupedStyles).length > 0 && (\\n            <div\\n              style={{\\n                flex: \\"1 1 calc(50% - 10px)\\", // 50% width minus the gap\\n                minWidth: \\"400px\\",\\n                boxSizing: \\"border-box\\",\\n                display: \\"flex\\", // Ensure content fills the height\\n                flexDirection: \\"column\\",\\n                textAlign: \\"center\\",\\n              }}\\n            >\\n              <h3>Css Computed Style</h3>\\n\\n              {Object.entries(groupedStyles).map(([group, styles]) => (\\n                <StyleSection key={group} title={group} data={styles} />\\n              ))}\\n            </div>\\n          )}\\n        </div>\\n      </div>\\n    </AddonPanel>\\n  );\\n}"},{"name":"Property","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/CSSAnalyzer.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<PropertyProps>","defaultValue":"({ label, value }) => (\\n  <>\\n    <td\\n      style={{ border: \\"1px solid black\\", padding: \\"8px\\", textAlign: \\"left\\" }}\\n    >\\n      <strong>{label}</strong>\\n    </td>\\n    <td\\n      style={{ border: \\"1px solid black\\", padding: \\"8px\\", textAlign: \\"left\\" }}\\n    >\\n      {value}\\n    </td>\\n  </>\\n)"},{"name":"StyleSection","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/CSSAnalyzer.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<StyleSectionProps>","defaultValue":"({ title, data }) => {\\n  const [expanded, setExpanded] = useState(false);\\n\\n  return (\\n    <div style={{ marginBottom: \\"10px\\" }}>\\n      <button\\n        style={{\\n          background: \\"#f0f0f0\\",\\n          border: \\"1px solid black\\",\\n          padding: \\"8px\\",\\n          width: \\"100%\\",\\n          cursor: \\"pointer\\",\\n          display: \\"flex\\",\\n          justifyContent: \\"space-between\\",\\n        }}\\n        onClick={() => setExpanded(!expanded)}\\n      >\\n        <span>{title}</span>\\n        <span>{expanded ? \\"▼\\" : \\"▶\\"}</span>\\n      </button>\\n      {expanded && (\\n        <table style={{ width: \\"100%\\", borderCollapse: \\"collapse\\" }}>\\n          <thead>\\n            <tr>\\n              <th style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                Property\\n              </th>\\n              <th style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                Attribute\\n              </th>\\n            </tr>\\n          </thead>\\n          <tbody>\\n            {Object.entries(data).map(([key, value]) => (\\n              <tr key={key}>\\n                <Property label={key} value={value} />\\n              </tr>\\n            ))}\\n          </tbody>\\n        </table>\\n      )}\\n    </div>\\n  );\\n}"},{"name":"TableBoxModel","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/CSSAnalyzer.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<TableBoxModelProps>","defaultValue":"({ boxModel }) => {\\n  if (!boxModel || !boxModel.content) return null;\\n\\n  const { margin, border, padding, content } = boxModel;\\n\\n  const styles: Record<string, React.CSSProperties> = {\\n    bodyTest: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"center\\",\\n\\n      margin: 0,\\n      padding: 0,\\n      backgroundColor: \\"lightgray\\",\\n      fontFamily: \\"Arial, sans-serif\\",\\n    },\\n    container: {\\n      display: \\"flex\\",\\n      flexDirection: \\"column\\",\\n      alignItems: \\"center\\",\\n      width: \\"100%\\",\\n    },\\n    boxContent: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"flex-start\\", // Align items at the top\\n      position: \\"relative\\",\\n    },\\n    margin: {\\n      backgroundColor: \\"#73764a\\",\\n      padding: \\"24px 32px\\",\\n      position: \\"relative\\",\\n      border: \\"2px dashed #bcc900\\",\\n    },\\n    border: {\\n      backgroundColor: \\"#38383D\\",\\n      padding: \\"24px 32px\\",\\n    },\\n    padding: {\\n      backgroundColor: \\"#6657A6\\",\\n      padding: \\"24px 32px\\",\\n    },\\n    content: {\\n      backgroundColor: \\"#407AA4\\",\\n      width: \\"140px\\",\\n      height: \\"20px\\",\\n      border: \\"2px dashed #00b8ff\\",\\n      color: \\"white\\",\\n      fontWeight: \\"bold\\",\\n      textAlign: \\"center\\",\\n    },\\n    label: {\\n      position: \\"absolute\\",\\n      fontSize: \\"12px\\",\\n      background: \\"rgba(255, 255, 255, 0.8)\\",\\n      padding: \\"2px 5px\\",\\n      border: \\"1px solid black\\",\\n      borderRadius: \\"3px\\",\\n      pointerEvents: \\"none\\",\\n    },\\n    labelTop: {\\n      top: \\"-10px\\",\\n      left: \\"50%\\",\\n      transform: \\"translateX(-50%)\\",\\n    },\\n    labelBottom: {\\n      bottom: \\"-10px\\",\\n      left: \\"50%\\",\\n      transform: \\"translateX(-50%)\\",\\n    },\\n    labelLeft: {\\n      left: \\"-20px\\",\\n      top: \\"50%\\",\\n      transform: \\"translateY(-50%)\\",\\n      marginLeft: \\"2px\\",\\n      marginRight: \\"100px\\",\\n    },\\n    labelRight: {\\n      right: \\"-20px\\",\\n      top: \\"50%\\",\\n      transform: \\"translateY(-50%)\\",\\n    },\\n    labelText: {\\n      fontSize: \\"12px\\",\\n      fontWeight: \\"bold\\",\\n      marginRight: \\"10px\\", // Space between text and box\\n      alignSelf: \\"flex-start\\",\\n      position: \\"absolute\\",\\n      top: \\"0px\\", // Move text above the box\\n      zIndex: 99, // Ensure text is on top\\n      left: \\"15%\\",\\n      transform: \\"translateX(-50%)\\", // Center label horizontally\\n      color: \\"white\\",\\n    },\\n    rowContent: {\\n      display: \\"flex\\",\\n      justifyContent: \\"center\\",\\n      alignItems: \\"flex-start\\", // Align items to the top of the boxes\\n      marginTop: \\"20px\\",\\n      marginBottom: \\"20px\\",\\n      gap: \\"20px\\", // Space between the sections\\n      flexWrap: \\"wrap\\", // Allow wrapping for smaller screens\\n      padding: \\"0 10px\\",\\n    },\\n  };\\n\\n  return (\\n    <div style={{ textAlign: \\"center\\" }}>\\n      <h3>Box Model Representation</h3>\\n      <div style={styles[\\"bodyTest\\"]}>\\n        <div style={styles[\\"container\\"]}>\\n          {/* Horizontal Flexbox for Besi, Ana, and Ina */}\\n          <div style={styles[\\"rowContent\\"]}>\\n            {/* Ana Section */}\\n            <div style={styles[\\"boxContent\\"]}>\\n              <span style={styles[\\"labelText\\"]}>Margin</span>\\n              <div style={styles[\\"margin\\"]}>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}>\\n                  {margin.top}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelBottom\\"] }}>\\n                  {margin.bottom}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}>\\n                  {margin.left}\\n                </span>\\n                <span style={{ ...styles[\\"label\\"], ...styles[\\"labelRight\\"] }}>\\n                  {margin.right}\\n                </span>\\n                <div style={styles[\\"boxContent\\"]}>\\n                  <span style={styles[\\"labelText\\"]}>Border</span>\\n                  <div style={styles[\\"border\\"]}>\\n                    <span style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}>\\n                      {border.top}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelBottom\\"] }}\\n                    >\\n                      {border.bottom}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}\\n                    >\\n                      {border.left}\\n                    </span>\\n                    <span\\n                      style={{ ...styles[\\"label\\"], ...styles[\\"labelRight\\"] }}\\n                    >\\n                      {border.right}\\n                    </span>\\n                    <div style={styles[\\"boxContent\\"]}>\\n                      <span style={styles[\\"labelText\\"]}>Padding</span>\\n                      <div style={styles[\\"padding\\"]}>\\n                        <span\\n                          style={{ ...styles[\\"label\\"], ...styles[\\"labelTop\\"] }}\\n                        >\\n                          {padding.top}\\n                        </span>\\n                        <span\\n                          style={{\\n                            ...styles[\\"label\\"],\\n                            ...styles[\\"labelBottom\\"],\\n                          }}\\n                        >\\n                          {padding.bottom}\\n                        </span>\\n                        <span\\n                          style={{ ...styles[\\"label\\"], ...styles[\\"labelLeft\\"] }}\\n                        >\\n                          {padding.left}\\n                        </span>\\n                        <span\\n                          style={{\\n                            ...styles[\\"label\\"],\\n                            ...styles[\\"labelRight\\"],\\n                          }}\\n                        >\\n                          {padding.right}\\n                        </span>\\n                        <div style={styles[\\"content\\"]}>\\n                          {content.width} × {content.height}\\n                        </div>\\n                      </div>\\n                    </div>\\n                  </div>\\n                </div>\\n              </div>\\n            </div>\\n          </div>\\n        </div>\\n      </div>\\n\\n      {/* Box Model Information */}\\n      <div style={{ marginTop: \\"1rem\\", textAlign: \\"left\\", fontSize: \\"14px\\" }}>\\n        <table style={{ width: \\"100%\\", borderCollapse: \\"collapse\\" }}>\\n          <thead>\\n            <tr>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Property\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Attribute\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Top\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Right\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Bottom\\n              </th>\\n              <th\\n                style={{\\n                  border: \\"1px solid black\\",\\n                  padding: \\"8px\\",\\n                  textAlign: \\"left\\",\\n                }}\\n              >\\n                Left\\n              </th>\\n            </tr>\\n          </thead>\\n          <tbody>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Margin</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {margin.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Border</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {border.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Padding</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.top}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.right}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.bottom}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {padding.left}\\n              </td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Content Dimensions</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {content.width} × {content.height}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n            </tr>\\n            <tr>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                <strong>Box-sizing</strong>\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>\\n                {boxModel.boxSizing}\\n              </td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n              <td style={{ border: \\"1px solid black\\", padding: \\"8px\\" }}>-</td>\\n            </tr>\\n          </tbody>\\n        </table>\\n      </div>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/dateModel-reader.tsx":[{"name":"DateModelReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/dateModel-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{DateModel}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/documentation-reader/documentation-reader.tsx":[{"name":"DocumentationReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/documentation-reader/documentation-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<literal type>","defaultValue":"({ type }) => {\\n  const [mdxContent, setMdxContent] = useState<string>(\\"\\");\\n  const [currentDoc, setCurrentDoc] = useState<string>(\\"\\");\\n  const channel = addons.getChannel();\\n  channel.once(\\"docsRendered\\", (doc) => {\\n    setCurrentDoc(doc);\\n  });\\n\\n  useEffect(() => {\\n    if (currentDoc) {\\n      const fetchMdx = async () => {\\n        try {\\n          const response = await fetch(`docs/${currentDoc}-${type}.md`);\\n          if (!response.ok)\\n            throw new Error(`Errore nel caricamento: ${response.statusText}`);\\n          const text = await response.text();\\n          setMdxContent(text);\\n        } catch (error) {\\n          console.error(`Errore nel caricamento del file MDX ${type}:`, error);\\n          setMdxContent(`Errore nel caricamento del contenuto ${type}.`);\\n        }\\n      };\\n      fetchMdx();\\n    }\\n  }, [currentDoc, type]);\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{mdxContent}</Markdown>\\n    </div>\\n  );\\n}"},{"name":"DocumentationReaderDown","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/documentation-reader/documentation-reader.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => (\\n  <DocumentationReader type=\\"down\\" />\\n)"},{"name":"DocumentationReaderTop","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/documentation-reader/documentation-reader.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => <DocumentationReader type=\\"top\\" />"}],"src/common/shared/models-reader/errorLabel-reader.tsx":[{"name":"ErrorLabelReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/errorLabel-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{ErrorLabel}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/expandablePanelElementSizes-reader.tsx":[{"name":"ExpandablePanelElementSizesReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/expandablePanelElementSizes-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{ExpandablePanelElementSizes}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/expandableTab-reader.tsx":[{"name":"ExpandableTabReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/expandableTab-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{ExpandableTab}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/filterText-reader.tsx":[{"name":"FilterTextReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/filterText-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{FilterText}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/formTabellareConfig-reader.tsx":[{"name":"FormTabellareConfigReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/formTabellareConfig-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{FormTabellareConfig}</Markdown>\\n    </div>\\n  );\\n}"}],"src/stories/graphicStyles/Icons.tsx":[{"name":"Icons","ctype":"miscellaneous","subtype":"variable","file":"src/stories/graphicStyles/Icons.tsx","deprecated":false,"deprecationMessage":"","type":"","defaultValue":"() => {\\n  return (\\n    <IconGallery>\\n      {Object.entries(ShowIcons).map((element, index) => {\\n        return (\\n          <IconItem name={element[1].class}>\\n            {/* <div\\n              title={element[1].functionality}\\n              style={{\\n                content: \\"\\",\\n                position: \\"absolute\\",\\n                top: 0,\\n                left: 0,\\n                width: \\"100%\\",\\n                height: \\"100%\\",\\n              }}\\n            /> */}\\n\\n            <i\\n              className={element[1].class}\\n              title={element[1].functionality}\\n            ></i>\\n          </IconItem>\\n        );\\n      })}\\n    </IconGallery>\\n  );\\n}"},{"name":"ShowIcons","ctype":"miscellaneous","subtype":"variable","file":"src/stories/graphicStyles/Icons.tsx","deprecated":false,"deprecationMessage":"","type":"Icon","defaultValue":"{\\n  trash: {\\n    class: \\"i-trash icon\\",\\n    functionality: \\"Rimuovi elemento\\",\\n  },\\n  pencil: {\\n    class: \\"i-pencil icon\\",\\n    functionality: \\"Modifica elemento\\",\\n  },\\n  question: {\\n    class: \\"i-question-circle icon\\",\\n    functionality: \\"Visualizza informazioni\\",\\n  },\\n  eye: {\\n    class: \\"i-eye icon\\",\\n    functionality: \\"Visualizza nel dettaglio l\'elemento\\",\\n  },\\n  chevronDown: {\\n    class: \\"i-chevron-down icon\\",\\n    functionality: \\"Espandi/Riduci la riga\\",\\n  },\\n  plus: {\\n    class: \\"i-plus icon\\",\\n    functionality: \\"Aggiungi elementi\\",\\n  },\\n  plusCircle: {\\n    class: \\"i-plus-circle icon\\",\\n    functionality: \\"Espandi elemento\\",\\n  },\\n  download: {\\n    class: \\"i-download icon\\",\\n    functionality: \\"Scarica elemento\\",\\n  },\\n  triangle: {\\n    class: \\"i-exclamation-triangle icon\\",\\n    functionality:\\n      \\"Attenzione (warning). Il conflitto/errore è visualizzabile tramite tooltip al click sull\'icona\\",\\n  },\\n  euro: {\\n    class: \\"i-eur icon\\",\\n    functionality: \\"Visualizza pagamenti\\",\\n  },\\n  fileText: {\\n    class: \\"i-file-text-o icon\\",\\n    functionality: \\"Visualizza provvedimenti\\",\\n  },\\n  filePdf: {\\n    class: \\"i-file-pdf-o icon\\",\\n    functionality: \\"Scarica .PDF\\",\\n  },\\n  fileDoc: {\\n    class: \\"i-file-word-o icon\\",\\n    functionality: \\"Scarica .DOC\\",\\n  },\\n  fileExcel: {\\n    class: \\"i-file-excel-o icon\\",\\n    functionality: \\"Scarica .XLS\\",\\n  },\\n  filePowerpoint: {\\n    class: \\"i-file-powerpoint-o icon\\",\\n    functionality: \\"Scarica .PPT\\",\\n  },\\n  star: {\\n    class: \\"i-star icon\\",\\n    functionality:\\n      \\"Aggiungi/rimuovi dai preferiti. Selezionabile e deselezionabile come una checkbox\\",\\n  },\\n  paperclip: {\\n    class: \\"i-paperclip icon\\",\\n    functionality: \\"Presenza di allegati\\",\\n  },\\n}"}],"src/common/shared/mdx-reader-component/mdx-reader.tsx":[{"name":"MdxReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/mdx-reader-component/mdx-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<MdxReaderProps>","defaultValue":"({ mdxPage }) => {\\n  const [isExpanded, setIsExpanded] = useState(false);\\n  const [mdxContent, setMdxContent] = useState<string>(\\"\\");\\n\\n  useEffect(() => {\\n    setMdxContent(mdxPage);\\n  }, [mdxPage]);\\n\\n  return (\\n    <div\\n      id=\\"user-experience-carousel-box\\"\\n      className=\\"row accordion-gray content\\"\\n    >\\n      {/* Accordion Header */}\\n      <div\\n        className={`row head-accordion-gray ${!isExpanded ? \\"collapsed\\" : \\"\\"}`}\\n        aria-expanded={isExpanded}\\n        onClick={() => setIsExpanded(!isExpanded)}\\n      >\\n        <img\\n          src=\\"static-webkit/img/user_experience.png\\"\\n          alt=\\"Icona user experience\\"\\n        />\\n\\n        <div className=\\"accordion-title col-xs-7\\">\\n          <strong>User Experience</strong>\\n        </div>\\n\\n        <em\\n          className={`fa fa-2x expand-icon pull-right fa-${isExpanded ? \\"minus\\" : \\"plus\\"}-circle`}\\n          title={isExpanded ? \\"Comprimi elemento\\" : \\"Espandi elemento\\"}\\n        />\\n      </div>\\n\\n      {/* Accordion Content */}\\n      <div\\n        id=\\"user-experience-carousel-box-panel\\"\\n        className={`row panel-body collapse ${isExpanded ? \\"in\\" : \\"\\"}`}\\n        aria-expanded={isExpanded}\\n      >\\n        <div className=\\"panel-content\\">\\n          <Markdown>{mdxContent}</Markdown>\\n        </div>\\n      </div>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/modalActionItem-reader.tsx":[{"name":"ModalActionItemReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/modalActionItem-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{ModalActionItem}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/multipleSelectLiveSearchStyle-reader.tsx":[{"name":"MultipleSelectLiveSearchStyleReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/multipleSelectLiveSearchStyle-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{MultipleSelectLiveSearchStyle}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/options-reader.tsx":[{"name":"OptionsReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/options-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{Options}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/radioOption-reader.tsx":[{"name":"RadioOptionReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/radioOption-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{RadioOption}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/radioTableFormStructure-reader.tsx":[{"name":"RadioTableFormStructureReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/radioTableFormStructure-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{RadioTableFormStructure}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/results-reader.tsx":[{"name":"ResultsReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/results-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{Results}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/roleAlertModel-reader.tsx":[{"name":"RoleAlertModelReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/roleAlertModel-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{RoleAlertModel}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/show-code-addon/show-code.tsx":[{"name":"ShowCodeAddon","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/show-code-addon/show-code.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<ShowCodeProps>","defaultValue":"({ active }) => {\\n  const [generatedHTML, setGeneratedHTML] = useState<string>(\\"\\");\\n  const api = useStorybookApi();\\n\\n  useEffect(() => {\\n    const generateHTML = () => {\\n      const storyData = api.getCurrentStoryData() as any;\\n      if (storyData?.parameters?.codeFixed) {\\n        setGeneratedHTML(storyData.parameters.codeFixed);\\n      } else {\\n        if (storyData && storyData.args) {\\n          const componentName = storyData.parameters.componentName;\\n          const args = storyData.args;\\n          const outputList: string[] = storyData.parameters.outputList || [];\\n          const customInputList: string[] =\\n            storyData.parameters.customElements || [];\\n          const directive = storyData.parameters.directive || \\"\\";\\n          const additionalCode = storyData.parameters.additionalCode || \\"\\";\\n\\n          // Trasformo gli argomenti in attributi HTML\\n          const argsString = Object.entries(args)\\n            .map(([key, value]) => {\\n              if (typeof value === \\"string\\") {\\n                return `  [${key}]=\\"\'${value}\'\\"`;\\n              } else if (\\n                typeof value === \\"boolean\\" ||\\n                value === null ||\\n                value === undefined\\n              ) {\\n                return `  [${key}]=\\"${value}\\"`;\\n              } else if (typeof value === \\"number\\") {\\n                return `  [${key}]=\\"${value}\\"`;\\n              } else if (Array.isArray(value)) {\\n                const isArrayOfObjects = value.every(\\n                  (item) => typeof item === \\"object\\"\\n                );\\n                if (!isArrayOfObjects) {\\n                  return `  [${key}]=\\"${JSON.stringify(value)}\\"`;\\n                }\\n                return \\"\\";\\n              } else if (typeof value === \\"object\\") {\\n                return \\"\\";\\n              }\\n              return \\"\\";\\n            })\\n            .filter(Boolean)\\n            .join(\\"\\\\n\\");\\n\\n          const customInput = customInputList.join(\\"\\\\n\\");\\n\\n          const outputContent = outputList.join(\\"\\\\n\\");\\n\\n          const finalHTML = `<${componentName}${\\n            directive ? `\\\\n${directive}` : \\"\\"\\n          }${argsString ? `\\\\n${argsString}` : \\"\\"}${\\n            customInput ? `\\\\n${customInput}` : \\"\\"\\n          }${outputContent ? `\\\\n  ${outputContent}` : \\"\\"}>\\\\n${\\n            additionalCode ? `${additionalCode}\\\\n` : \\"\\"\\n          }</${componentName}>`;\\n\\n          setGeneratedHTML(finalHTML);\\n        }\\n      }\\n    };\\n\\n    if (active) {\\n      generateHTML();\\n    }\\n  }, [api, active]);\\n\\n  return (\\n    <AddonPanel active={active}>\\n      <Markdown\\n        components={{\\n          pre: (props: any) => (\\n            <pre\\n              style={{\\n                whiteSpace: \\"pre-wrap\\",\\n                fontFamily: \\"monospace\\",\\n                fontSize: \\"14px\\",\\n                background: \\"#f5f5f5\\",\\n                padding: \\"10px\\",\\n                borderRadius: \\"4px\\",\\n                overflow: \\"auto\\",\\n                lineHeight: \\"1.5\\",\\n              }}\\n              {...props}\\n            />\\n          ),\\n        }}\\n      >\\n        {`\\\\`\\\\`\\\\`html\\\\n${generatedHTML}\\\\n\\\\`\\\\`\\\\``}\\n      </Markdown>\\n    </AddonPanel>\\n  );\\n}"}],"src/common/shared/models-reader/step-reader.tsx":[{"name":"StepReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/step-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{Step}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/tableField-reader.tsx":[{"name":"TableFieldReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/tableField-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{TableField}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/tab-reader.tsx":[{"name":"TabReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/tab-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{Tab}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/tag-reader.tsx":[{"name":"TagReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/tag-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{Tag}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/custom-title-docs.tsx":[{"name":"TitleDoc","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/custom-title-docs.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<TitleDocsProps>","defaultValue":"({ title, links }) => {\\n  return (\\n    <div\\n      style={{\\n        width: \\"auto\\",\\n        minHeight: \\"128px\\",\\n        backgroundImage: \'url(\\"background.png\\")\',\\n        backgroundRepeat: \\"no-repeat\\",\\n        backgroundSize: \\"cover\\",\\n        backgroundPosition: \\"right center\\",\\n        borderRadius: \\"4px\\",\\n        display: \\"flex\\",\\n        flexDirection: \\"column\\",\\n        justifyContent: \\"center\\",\\n        alignItems: \\"flex-start\\",\\n        padding: \\"32px\\",\\n        boxSizing: \\"border-box\\",\\n        marginBottom: \\"5%\\",\\n      }}\\n    >\\n      <h1\\n        style={{\\n          textAlign: \\"left\\",\\n          width: \\"100%\\",\\n          marginBottom: \\"20px\\",\\n          lineHeight: \\"1\\", // Riduce lo spazio extra\\n        }}\\n      >\\n        {title}\\n      </h1>\\n      <nav style={{ width: \\"100%\\" }}>\\n        <ul\\n          style={{\\n            listStyleType: \\"none\\",\\n            padding: 0,\\n            flexWrap: \\"wrap\\",\\n            display: \\"flex\\",\\n            alignItems: \\"center\\", // Allinea verticalmente\\n            gap: \\"15px\\", // Spazio tra i link\\n            margin: 0,\\n          }}\\n        >\\n          {links.map((link, index) => (\\n            <li\\n              key={link?.href}\\n              style={{\\n                display: \\"flex\\",\\n                alignItems: \\"center\\",\\n                height: \\"100%\\", // Assicura altezza uniforme\\n                whiteSpace: \\"nowrap\\", // Impedisce il wrap della pipe\\n              }}\\n            >\\n              <a\\n                href={link?.href}\\n                target=\\"_self\\"\\n                style={{\\n                  fontSize: \\"1.2em\\",\\n                  color: \\"blue\\",\\n                  textDecoration: \\"none\\",\\n                  display: \\"flex\\",\\n                  alignItems: \\"center\\", // Centra verticalmente il testo del link\\n                  height: \\"100%\\",\\n                }}\\n              >\\n                {link?.text}\\n              </a>\\n              {/* Aggiungi la pipe dinamicamente solo dopo ogni link tranne l\'ultimo */}\\n              {index < links.length - 1 && (\\n                <span\\n                  style={{\\n                    marginLeft: \\"10px\\",\\n                    whiteSpace: \\"nowrap\\", // Impedisce che la pipe vada a capo\\n                  }}\\n                >\\n                  |\\n                </span>\\n              )}\\n            </li>\\n          ))}\\n        </ul>\\n      </nav>\\n    </div>\\n  );\\n}"}],"src/common/shared/custom-title.tsx":[{"name":"TitleWithNavigation","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/custom-title.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<TitleWithNavigationProps>","defaultValue":"({\\n  title,\\n  showCode,\\n  showAccessibility\\n}) => {\\n  // Estrae l\'ultimo segmento del titolo dopo l\'ultimo \'/\'\\n  const extractedTitle = title.split(\\"/\\").pop() || title;\\n\\n  const links = [\\n    { href: \\"#panoramica\\", text: \\"Panoramica\\" },\\n    { href: \\"#caratteristiche-principali\\", text: \\"Caratteristiche Principali\\" },\\n    { href: \\"#varianti\\", text: \\"Varianti\\" },\\n    { href: \\"#best-practices\\", text: \\"Best Practices\\" },\\n    { href: \\"#componenti-correlati\\", text: \\"Componenti Correlati\\" },\\n    showAccessibility ? { href: \\"#accessibilita\\", text: \\"Accessibilità\\" } : null,\\n    showCode ? { href: \\"#codice\\", text: \\"Codice\\" } : null,\\n    { href: \\"#user-experience\\", text: \\"User Experience\\" },\\n    { href: \\"#overview\\", text: \\"Overview\\" },\\n   \\n  ].filter(Boolean);\\n\\n  return (\\n    <div\\n      style={{\\n        width: \\"auto\\",\\n        minHeight: \\"128px\\",\\n        backgroundImage: \'url(\\"background.png\\")\',\\n        backgroundRepeat: \\"no-repeat\\",\\n        backgroundSize: \\"cover\\",\\n        backgroundPosition: \\"right center\\",\\n        borderRadius: \\"4px\\",\\n        display: \\"flex\\",\\n        flexDirection: \\"column\\",\\n        justifyContent: \\"center\\",\\n        alignItems: \\"flex-start\\",\\n        padding: \\"32px\\",\\n        boxSizing: \\"border-box\\",\\n        marginBottom: \\"5%\\",\\n      }}\\n    >\\n      <h1\\n        style={{\\n          textAlign: \\"left\\",\\n          width: \\"100%\\",\\n          marginBottom: \\"20px\\",\\n          lineHeight: \\"1\\", // Riduce lo spazio extra\\n        }}\\n      >\\n        {extractedTitle}\\n      </h1>\\n      <nav style={{ width: \\"100%\\" }}>\\n        <ul\\n          style={{\\n            listStyleType: \\"none\\",\\n            padding: 0,\\n            flexWrap: \\"wrap\\",\\n            display: \\"flex\\",\\n            alignItems: \\"center\\", // Allinea verticalmente\\n            gap: \\"15px\\", // Spazio tra i link\\n            margin: 0,\\n          }}\\n        >\\n          {[\\n            { href: \\"#panoramica\\", text: \\"Panoramica\\" },\\n            { href: \\"#caratteristiche-principali\\", text: \\"Caratteristiche Principali\\" },\\n            { href: \\"#varianti\\", text: \\"Varianti\\" },\\n            { href: \\"#best-practices\\", text: \\"Best Practices\\" },\\n            { href: \\"#componenti-correlati\\", text: \\"Componenti Correlati\\" },\\n            { href: \\"#overview\\", text: \\"Overview\\" },\\n            { href: \\"#api\\", text: \\"API\\" },\\n          ].map((link, index) => (\\n            <li \\n              key={link.href}\\n              style={{\\n                display: \\"flex\\",\\n                alignItems: \\"center\\",\\n                height: \\"100%\\", // Assicura altezza uniforme\\n                whiteSpace: \\"nowrap\\", // Impedisce il wrap della pipe\\n              }}\\n            >\\n              <a\\n                href={link?.href}\\n                target=\\"_self\\"\\n                style={{\\n                  fontSize: \\"1.2em\\",\\n                  color: \\"blue\\",\\n                  textDecoration: \\"none\\",\\n                  display: \\"flex\\",\\n                  alignItems: \\"center\\", // Centra verticalmente il testo del link\\n                  height: \\"100%\\",\\n                }}\\n              >\\n                {link?.text}\\n              </a>\\n              {/* Aggiungi la pipe dinamicamente solo dopo ogni link tranne l\'ultimo */}\\n              {index < links.length - 1 && (\\n                <span\\n                  style={{\\n                    marginLeft: \\"10px\\",\\n                    whiteSpace: \\"nowrap\\", // Impedisce che la pipe vada a capo\\n                  }}\\n                >\\n                  |\\n                </span>\\n              )}\\n            </li>\\n          ))}\\n        </ul>\\n      </nav>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/tooltipModel-reader.tsx":[{"name":"TooltipModelReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/tooltipModel-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{TooltipModel}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/tooltipPlacementEnum-reader.tsx":[{"name":"TooltipPlacementEnumReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/tooltipPlacementEnum-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{TooltipPlacementEnum}</Markdown>\\n    </div>\\n  );\\n}"}],"src/common/shared/models-reader/tooltipPlaceType-reader.tsx":[{"name":"TooltipPlaceTypeReader","ctype":"miscellaneous","subtype":"variable","file":"src/common/shared/models-reader/tooltipPlaceType-reader.tsx","deprecated":false,"deprecationMessage":"","type":"React.FC<any>","defaultValue":"() => {\\n\\n  return (\\n    <div className=\\"panel-content\\">\\n      <Markdown>{TooltipPlaceType}</Markdown>\\n    </div>\\n  );\\n}"}]},"groupedFunctions":{"src/common/shared/Utilities.ts":[{"name":"createRenderFunction","file":"src/common/shared/Utilities.ts","ctype":"miscellaneous","subtype":"function","deprecated":false,"deprecationMessage":"","description":"","args":[{"name":"componentName","type":"string","deprecated":false,"deprecationMessage":""}],"jsdoctags":[{"name":"componentName","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"playFunction","file":"src/common/shared/Utilities.ts","ctype":"miscellaneous","subtype":"function","deprecated":false,"deprecationMessage":"","description":"","args":[{"name":"canvasElement","type":"any","deprecated":false,"deprecationMessage":""}],"jsdoctags":[{"name":"canvasElement","type":"any","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]}],"src/stories/shared/utils/translate-loader.ts":[{"name":"createTranslateLoader","file":"src/stories/shared/utils/translate-loader.ts","ctype":"miscellaneous","subtype":"function","deprecated":false,"deprecationMessage":"","description":"","args":[{"name":"http","type":"HttpClient","deprecated":false,"deprecationMessage":""}],"jsdoctags":[{"name":"http","type":"HttpClient","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]}],"src/stories/table/utils.ts":[{"name":"generateRandomData","file":"src/stories/table/utils.ts","ctype":"miscellaneous","subtype":"function","deprecated":false,"deprecationMessage":"","description":"","args":[{"name":"num","type":"number","deprecated":false,"deprecationMessage":""}],"jsdoctags":[{"name":"num","type":"number","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]},{"name":"isIMockDataKey","file":"src/stories/table/utils.ts","ctype":"miscellaneous","subtype":"function","deprecated":false,"deprecationMessage":"","description":"","args":[{"name":"key","type":"string","deprecated":false,"deprecationMessage":""}],"jsdoctags":[{"name":"key","type":"string","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]}],"src/stories/shared/utils/i18n.module.ts":[{"name":"HttpLoaderFactory","file":"src/stories/shared/utils/i18n.module.ts","ctype":"miscellaneous","subtype":"function","deprecated":false,"deprecationMessage":"","description":"","args":[{"name":"http","type":"HttpClient","deprecated":false,"deprecationMessage":""}],"jsdoctags":[{"name":"http","type":"HttpClient","deprecated":false,"deprecationMessage":"","tagName":{"text":"param"}}]}],"src/stories/inject-injector-to-props.decorator.ts":[{"name":"injectInjectorToProps","file":"src/stories/inject-injector-to-props.decorator.ts","ctype":"miscellaneous","subtype":"function","deprecated":false,"deprecationMessage":"","description":"","args":[],"returnType":"DecoratorFunction<AngularRenderer, TArgs>"}]},"groupedEnumerations":{},"groupedTypeAliases":{}},"routes":[],"coverage":{"count":0,"status":"low","files":[{"filePath":"src/app/app.component.ts","type":"component","linktype":"component","name":"AppComponent","coveragePercent":0,"coverageCount":"0/2","status":"low"},{"filePath":"src/app/app.config.ts","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"appConfig","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/CSSAnalyzer.tsx","type":"interface","linktype":"interface","name":"BoxModel","coveragePercent":0,"coverageCount":"0/11","status":"low"},{"filePath":"src/common/shared/CSSAnalyzer.tsx","type":"interface","linktype":"interface","name":"CSSAnalyzerProps","coveragePercent":0,"coverageCount":"0/2","status":"low"},{"filePath":"src/common/shared/CSSAnalyzer.tsx","type":"interface","linktype":"interface","name":"PropertyProps","coveragePercent":0,"coverageCount":"0/3","status":"low"},{"filePath":"src/common/shared/CSSAnalyzer.tsx","type":"interface","linktype":"interface","name":"StyleSectionProps","coveragePercent":0,"coverageCount":"0/3","status":"low"},{"filePath":"src/common/shared/CSSAnalyzer.tsx","type":"interface","linktype":"interface","name":"TableBoxModelProps","coveragePercent":0,"coverageCount":"0/2","status":"low"},{"filePath":"src/common/shared/CSSAnalyzer.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"CSSAnalyzer","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/CSSAnalyzer.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"Property","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/CSSAnalyzer.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"StyleSection","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/CSSAnalyzer.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"TableBoxModel","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/Utilities.ts","type":"function","linktype":"miscellaneous","linksubtype":"function","name":"createRenderFunction","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/Utilities.ts","type":"function","linktype":"miscellaneous","linksubtype":"function","name":"playFunction","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/Utilities.ts","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"addBodyClass","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/Utilities.ts","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"cleanHead","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/Utilities.ts","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"removeFooter","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/Utilities.ts","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"removeHeader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/custom-title-docs.tsx","type":"interface","linktype":"interface","name":"TitleDocsProps","coveragePercent":0,"coverageCount":"0/3","status":"low"},{"filePath":"src/common/shared/custom-title-docs.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"TitleDoc","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/custom-title.tsx","type":"interface","linktype":"interface","name":"TitleWithNavigationProps","coveragePercent":0,"coverageCount":"0/4","status":"low"},{"filePath":"src/common/shared/custom-title.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"TitleWithNavigation","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/documentation-reader/documentation-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"DocumentationReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/documentation-reader/documentation-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"DocumentationReaderDown","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/documentation-reader/documentation-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"DocumentationReaderTop","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/header-footer.component.ts","type":"class","linktype":"classe","name":"HeaderFooterComponent","coveragePercent":0,"coverageCount":"0/5","status":"low"},{"filePath":"src/common/shared/mdx-reader-component/mdx-reader.tsx","type":"interface","linktype":"interface","name":"MdxReaderProps","coveragePercent":0,"coverageCount":"0/2","status":"low"},{"filePath":"src/common/shared/mdx-reader-component/mdx-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"MdxReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/actionItem-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"ActionItemReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/actionsField-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"ActionsFieldReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/advancedTab-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"AdvancedTabReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/baseInputComponent-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"BaseInputComponentReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/baseModel-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"BaseModelReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/bootstrapSize-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"BootstrapSizeReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/carouselConfig-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"CarouselConfigReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/dateModel-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"DateModelReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/errorLabel-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"ErrorLabelReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/expandablePanelElementSizes-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"ExpandablePanelElementSizesReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/expandableTab-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"ExpandableTabReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/filterText-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"FilterTextReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/formTabellareConfig-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"FormTabellareConfigReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/modalActionItem-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"ModalActionItemReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/multipleSelectLiveSearchStyle-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"MultipleSelectLiveSearchStyleReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/options-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"OptionsReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/radioOption-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"RadioOptionReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/radioTableFormStructure-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"RadioTableFormStructureReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/results-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"ResultsReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/roleAlertModel-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"RoleAlertModelReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/step-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"StepReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/tab-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"TabReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/tableField-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"TableFieldReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/tag-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"TagReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/tooltipModel-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"TooltipModelReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/tooltipPlaceType-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"TooltipPlaceTypeReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/models-reader/tooltipPlacementEnum-reader.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"TooltipPlacementEnumReader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/common/shared/show-code-addon/show-code.tsx","type":"interface","linktype":"interface","name":"ShowCodeProps","coveragePercent":0,"coverageCount":"0/2","status":"low"},{"filePath":"src/common/shared/show-code-addon/show-code.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"ShowCodeAddon","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/angular-schematics/angular-schematics.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"AngularSchematics","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/browser-support/browser-support.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"BrowserSupport","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/form-controls/form-example/error-label.const.ts","type":"class","linktype":"classe","name":"ErrorLabelConstantsExtended","coveragePercent":0,"coverageCount":"0/4","status":"low"},{"filePath":"src/stories/graphicStyles/Colors.tsx","type":"interface","linktype":"interface","name":"IColor","coveragePercent":0,"coverageCount":"0/4","status":"low"},{"filePath":"src/stories/graphicStyles/Colors.tsx","type":"interface","linktype":"interface","name":"IColorPalette","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/graphicStyles/Colors.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"AccessibilityColor","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/graphicStyles/Colors.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"BackgroundColors","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/graphicStyles/Colors.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"ColorPaletteInail","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/graphicStyles/Colors.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"displayColors","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/graphicStyles/Colors.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"PrimaryColors","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/graphicStyles/Colors.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"StatusColors","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/graphicStyles/Icons.tsx","type":"interface","linktype":"interface","name":"Icon","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/graphicStyles/Icons.tsx","type":"interface","linktype":"interface","name":"IconDetails","coveragePercent":0,"coverageCount":"0/3","status":"low"},{"filePath":"src/stories/graphicStyles/Icons.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"Icons","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/graphicStyles/Icons.tsx","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"ShowIcons","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/inject-injector-to-props.decorator.ts","type":"function","linktype":"miscellaneous","linksubtype":"function","name":"injectInjectorToProps","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/shared/utils/i18n.module.ts","type":"function","linktype":"miscellaneous","linksubtype":"function","name":"HttpLoaderFactory","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/shared/utils/i18n.module.ts","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"CDN_ENDPOINT","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/shared/utils/i18n.module.ts","type":"variable","linktype":"miscellaneous","linksubtype":"variable","name":"CLIENT_OIDC","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/shared/utils/translate-loader.ts","type":"function","linktype":"miscellaneous","linksubtype":"function","name":"createTranslateLoader","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/table/utils.ts","type":"interface","linktype":"interface","name":"IMockData","coveragePercent":0,"coverageCount":"0/5","status":"low"},{"filePath":"src/stories/table/utils.ts","type":"function","linktype":"miscellaneous","linksubtype":"function","name":"generateRandomData","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/table/utils.ts","type":"function","linktype":"miscellaneous","linksubtype":"function","name":"isIMockDataKey","coveragePercent":0,"coverageCount":"0/1","status":"low"},{"filePath":"src/stories/user.ts","type":"interface","linktype":"interface","name":"User","coveragePercent":0,"coverageCount":"0/2","status":"low"},{"filePath":"src/stories/wizard-spa/converters/step1.converter.ts","type":"class","linktype":"classe","name":"Step1Converter","coveragePercent":0,"coverageCount":"0/3","status":"low"},{"filePath":"src/stories/wizard-spa/converters/step2.converter.ts","type":"class","linktype":"classe","name":"Step2Converter","coveragePercent":0,"coverageCount":"0/3","status":"low"},{"filePath":"src/stories/wizard-spa/converters/step3.converter.ts","type":"class","linktype":"classe","name":"CarConverter","coveragePercent":0,"coverageCount":"0/3","status":"low"},{"filePath":"src/stories/wizard-spa/converters/utente.converter.ts","type":"class","linktype":"classe","name":"UtenteConverter","coveragePercent":0,"coverageCount":"0/3","status":"low"},{"filePath":"src/stories/wizard-spa/converters/wizard.converter.ts","type":"class","linktype":"classe","name":"WizardConverter","coveragePercent":0,"coverageCount":"0/6","status":"low"},{"filePath":"src/stories/wizard-spa/dtos/step1.dto.ts","type":"class","linktype":"classe","name":"Step1Dto","coveragePercent":0,"coverageCount":"0/6","status":"low"},{"filePath":"src/stories/wizard-spa/dtos/step2.dto.ts","type":"class","linktype":"classe","name":"Step2Dto","coveragePercent":0,"coverageCount":"0/6","status":"low"},{"filePath":"src/stories/wizard-spa/dtos/step3.dto.ts","type":"class","linktype":"classe","name":"Step3Dto","coveragePercent":0,"coverageCount":"0/3","status":"low"},{"filePath":"src/stories/wizard-spa/dtos/utente.dto.ts","type":"class","linktype":"classe","name":"UtenteDto","coveragePercent":0,"coverageCount":"0/14","status":"low"},{"filePath":"src/stories/wizard-spa/dtos/wizard.dto.ts","type":"class","linktype":"classe","name":"WizardDTO","coveragePercent":0,"coverageCount":"0/5","status":"low"},{"filePath":"src/stories/wizard-spa/first-step/first-step.component.ts","type":"component","linktype":"component","name":"FirstStepComponent","coveragePercent":0,"coverageCount":"0/4","status":"low"},{"filePath":"src/stories/wizard-spa/model/step1.model.ts","type":"class","linktype":"classe","name":"Step1","coveragePercent":0,"coverageCount":"0/6","status":"low"},{"filePath":"src/stories/wizard-spa/model/step2.model.ts","type":"class","linktype":"classe","name":"Step2","coveragePercent":0,"coverageCount":"0/6","status":"low"},{"filePath":"src/stories/wizard-spa/model/step3.model.ts","type":"class","linktype":"classe","name":"Step3","coveragePercent":0,"coverageCount":"0/3","status":"low"},{"filePath":"src/stories/wizard-spa/model/utente.model.ts","type":"class","linktype":"classe","name":"Utente","coveragePercent":0,"coverageCount":"0/14","status":"low"},{"filePath":"src/stories/wizard-spa/model/wizard.model.ts","type":"class","linktype":"classe","name":"WizardModel","coveragePercent":0,"coverageCount":"0/6","status":"low"},{"filePath":"src/stories/wizard-spa/second-step/second-step.component.ts","type":"component","linktype":"component","name":"SecondStepComponent","coveragePercent":0,"coverageCount":"0/5","status":"low"},{"filePath":"src/stories/wizard-spa/services/utente.service.ts","type":"injectable","linktype":"injectable","name":"UtenteService","coveragePercent":0,"coverageCount":"0/12","status":"low"},{"filePath":"src/stories/wizard-spa/services/wizard.service.ts","type":"injectable","linktype":"injectable","name":"WizardService","coveragePercent":0,"coverageCount":"0/9","status":"low"},{"filePath":"src/stories/wizard-spa/third-step/third-step.component.ts","type":"component","linktype":"component","name":"ThirdStepComponent","coveragePercent":0,"coverageCount":"0/5","status":"low"}]}}');var documentation_template=__webpack_require__("./src/common/shared/documentation-template.mdx"),Utilities=__webpack_require__("./src/common/shared/Utilities.ts"),external_STORYBOOK_MODULE_PREVIEW_API_=__webpack_require__("storybook/internal/preview-api");(0,angular.$)(documentation_namespaceObject);const _storybook_preview={parameters:{controls:{disableSaveFromUI:!0,matchers:{color:/(background|color)$/i,date:/Date$/i},expanded:!0},docs:{page:documentation_template.default,canvas:{sourceState:"none"}},backgrounds:{disable:!0},options:{storySort:{order:["Getting Started","Foundation","Components","Patterns","Resources"],method:"alphabetical",includeNames:!1}}},decorators:[(Story,context)=>{const channel=external_STORYBOOK_MODULE_PREVIEW_API_.addons.getChannel();return(0,Utilities.YP)(),(0,Utilities.k9)(),(0,Utilities.kw)(),(0,Utilities.oN)(),channel.once("docsRendered",(()=>{(0,Utilities.YP)(),(0,Utilities.k9)(),(0,Utilities.kw)()})),Story()}]}},"./node_modules/@storybook/blocks/dist sync recursive":module=>{function webpackEmptyContext(req){var e=new Error("Cannot find module '"+req+"'");throw e.code="MODULE_NOT_FOUND",e}webpackEmptyContext.keys=()=>[],webpackEmptyContext.resolve=webpackEmptyContext,webpackEmptyContext.id="./node_modules/@storybook/blocks/dist sync recursive",module.exports=webpackEmptyContext},"./node_modules/@storybook/core/dist/components sync recursive":module=>{function webpackEmptyContext(req){var e=new Error("Cannot find module '"+req+"'");throw e.code="MODULE_NOT_FOUND",e}webpackEmptyContext.keys=()=>[],webpackEmptyContext.resolve=webpackEmptyContext,webpackEmptyContext.id="./node_modules/@storybook/core/dist/components sync recursive",module.exports=webpackEmptyContext},"./node_modules/@storybook/core/dist/theming sync recursive":module=>{function webpackEmptyContext(req){var e=new Error("Cannot find module '"+req+"'");throw e.code="MODULE_NOT_FOUND",e}webpackEmptyContext.keys=()=>[],webpackEmptyContext.resolve=webpackEmptyContext,webpackEmptyContext.id="./node_modules/@storybook/core/dist/theming sync recursive",module.exports=webpackEmptyContext},"./node_modules/memoizerific sync recursive":module=>{function webpackEmptyContext(req){var e=new Error("Cannot find module '"+req+"'");throw e.code="MODULE_NOT_FOUND",e}webpackEmptyContext.keys=()=>[],webpackEmptyContext.resolve=webpackEmptyContext,webpackEmptyContext.id="./node_modules/memoizerific sync recursive",module.exports=webpackEmptyContext},"./src lazy recursive ^\\.\\/.*$ include: (?%21.*node_modules)(?:\\/src(?:\\/(?%21\\.)(?:(?:(?%21(?:^%7C\\/)\\.).)*?)\\/%7C\\/%7C$)(?%21\\.)(?=.)[^/]*?\\.mdx)$":(module,__unused_webpack_exports,__webpack_require__)=>{var map={"./common/shared/documentation-template.mdx":["./src/common/shared/documentation-template.mdx"],"./common/shared/models-mdx/ActionItem.mdx":["./src/common/shared/models-mdx/ActionItem.mdx",3681],"./common/shared/models-mdx/ActionsField.mdx":["./src/common/shared/models-mdx/ActionsField.mdx",9245],"./common/shared/models-mdx/AdvancedTab.mdx":["./src/common/shared/models-mdx/AdvancedTab.mdx",4905],"./common/shared/models-mdx/BaseInputComponent.mdx":["./src/common/shared/models-mdx/BaseInputComponent.mdx",1316],"./common/shared/models-mdx/BaseModel.mdx":["./src/common/shared/models-mdx/BaseModel.mdx",5928],"./common/shared/models-mdx/BootstrapSize.mdx":["./src/common/shared/models-mdx/BootstrapSize.mdx",6235],"./common/shared/models-mdx/CarouselConfig.mdx":["./src/common/shared/models-mdx/CarouselConfig.mdx",5886],"./common/shared/models-mdx/DateModel.mdx":["./src/common/shared/models-mdx/DateModel.mdx",5353],"./common/shared/models-mdx/ErrorLabel.mdx":["./src/common/shared/models-mdx/ErrorLabel.mdx",7918],"./common/shared/models-mdx/ExpandablePanelElementSizes.mdx":["./src/common/shared/models-mdx/ExpandablePanelElementSizes.mdx",8574],"./common/shared/models-mdx/ExpandableTab.mdx":["./src/common/shared/models-mdx/ExpandableTab.mdx",1547],"./common/shared/models-mdx/FilterText.mdx":["./src/common/shared/models-mdx/FilterText.mdx",3313],"./common/shared/models-mdx/FormTabellareConfig.mdx":["./src/common/shared/models-mdx/FormTabellareConfig.mdx",6774],"./common/shared/models-mdx/ModalActionItem.mdx":["./src/common/shared/models-mdx/ModalActionItem.mdx",8702],"./common/shared/models-mdx/MultipleSelectLiveSearchStyle.mdx":["./src/common/shared/models-mdx/MultipleSelectLiveSearchStyle.mdx",3391],"./common/shared/models-mdx/Options.mdx":["./src/common/shared/models-mdx/Options.mdx",4860],"./common/shared/models-mdx/RadioOption.mdx":["./src/common/shared/models-mdx/RadioOption.mdx",4236],"./common/shared/models-mdx/RadioTableFormStructure.mdx":["./src/common/shared/models-mdx/RadioTableFormStructure.mdx",5574],"./common/shared/models-mdx/Results.mdx":["./src/common/shared/models-mdx/Results.mdx",3708],"./common/shared/models-mdx/RoleAlertModel.mdx":["./src/common/shared/models-mdx/RoleAlertModel.mdx",5559],"./common/shared/models-mdx/Step.mdx":["./src/common/shared/models-mdx/Step.mdx",3112],"./common/shared/models-mdx/Tab.mdx":["./src/common/shared/models-mdx/Tab.mdx",3795],"./common/shared/models-mdx/TableField.mdx":["./src/common/shared/models-mdx/TableField.mdx",1418],"./common/shared/models-mdx/Tag.mdx":["./src/common/shared/models-mdx/Tag.mdx",9682],"./common/shared/models-mdx/TooltipModel.mdx":["./src/common/shared/models-mdx/TooltipModel.mdx",7666],"./common/shared/models-mdx/TooltipPlaceType.mdx":["./src/common/shared/models-mdx/TooltipPlaceType.mdx",3216],"./common/shared/models-mdx/TooltipPlacementEnum.mdx":["./src/common/shared/models-mdx/TooltipPlacementEnum.mdx",7151],"./stories/Changelog.mdx":["./src/stories/Changelog.mdx",3741],"./stories/Colors.mdx":["./src/stories/Colors.mdx",9237],"./stories/Fonts.mdx":["./src/stories/Fonts.mdx",7821],"./stories/HeaderFooter.mdx":["./src/stories/HeaderFooter.mdx",1707],"./stories/Icons.mdx":["./src/stories/Icons.mdx",9565],"./stories/accessibility.mdx":["./src/stories/accessibility.mdx",1511],"./stories/angular-schematics/schematic.mdx":["./src/stories/angular-schematics/schematic.mdx",104],"./stories/browser-support/browser-support.mdx":["./src/stories/browser-support/browser-support.mdx",1548],"./stories/intro.mdx":["./src/stories/intro.mdx",629],"./stories/logo.mdx":["./src/stories/logo.mdx",9428],"./stories/repository.mdx":["./src/stories/repository.mdx",7849]};function webpackAsyncContext(req){if(!__webpack_require__.o(map,req))return Promise.resolve().then((()=>{var e=new Error("Cannot find module '"+req+"'");throw e.code="MODULE_NOT_FOUND",e}));var ids=map[req],id=ids[0];return Promise.all(ids.slice(1).map(__webpack_require__.e)).then((()=>__webpack_require__(id)))}webpackAsyncContext.keys=()=>Object.keys(map),webpackAsyncContext.id="./src lazy recursive ^\\.\\/.*$ include: (?%21.*node_modules)(?:\\/src(?:\\/(?%21\\.)(?:(?:(?%21(?:^%7C\\/)\\.).)*?)\\/%7C\\/%7C$)(?%21\\.)(?=.)[^/]*?\\.mdx)$",module.exports=webpackAsyncContext},"./src lazy recursive ^\\.\\/.*$ include: (?%21.*node_modules)(?:\\/src(?:\\/(?%21\\.)(?:(?:(?%21(?:^%7C\\/)\\.).)*?)\\/%7C\\/%7C$)(?%21\\.)(?=.)[^/]*?\\.stories\\.(js%7Cjsx%7Cmjs%7Cts%7Ctsx))$":(module,__unused_webpack_exports,__webpack_require__)=>{var map={"./stories/breadcrumb/breadcrumb.stories":["./src/stories/breadcrumb/breadcrumb.stories.ts",4795,7842],"./stories/breadcrumb/breadcrumb.stories.ts":["./src/stories/breadcrumb/breadcrumb.stories.ts",4795,7842],"./stories/buttons/action/action.stories":["./src/stories/buttons/action/action.stories.ts",4795,4464],"./stories/buttons/action/action.stories.ts":["./src/stories/buttons/action/action.stories.ts",4795,4464],"./stories/buttons/actions-dropdown/actions-dropdown.stories":["./src/stories/buttons/actions-dropdown/actions-dropdown.stories.ts",4795,8898],"./stories/buttons/actions-dropdown/actions-dropdown.stories.ts":["./src/stories/buttons/actions-dropdown/actions-dropdown.stories.ts",4795,8898],"./stories/buttons/button/button.stories":["./src/stories/buttons/button/button.stories.ts",4795,2860],"./stories/buttons/button/button.stories.ts":["./src/stories/buttons/button/button.stories.ts",4795,2860],"./stories/buttons/callback-button/callback-button.stories":["./src/stories/buttons/callback-button/callback-button.stories.ts",4795,6122],"./stories/buttons/callback-button/callback-button.stories.ts":["./src/stories/buttons/callback-button/callback-button.stories.ts",4795,6122],"./stories/carousel/carousel.stories":["./src/stories/carousel/carousel.stories.ts",4795,7548],"./stories/carousel/carousel.stories.ts":["./src/stories/carousel/carousel.stories.ts",4795,7548],"./stories/content-loader/content-loader.stories":["./src/stories/content-loader/content-loader.stories.ts",4795,3678],"./stories/content-loader/content-loader.stories.ts":["./src/stories/content-loader/content-loader.stories.ts",4795,3678],"./stories/elements/alert/alert.stories":["./src/stories/elements/alert/alert.stories.ts",4795,5884],"./stories/elements/alert/alert.stories.ts":["./src/stories/elements/alert/alert.stories.ts",4795,5884],"./stories/elements/badges/badge.stories":["./src/stories/elements/badges/badge.stories.ts",4795,3279],"./stories/elements/badges/badge.stories.ts":["./src/stories/elements/badges/badge.stories.ts",4795,3279],"./stories/elements/box/box.stories":["./src/stories/elements/box/box.stories.ts",4795,1596],"./stories/elements/box/box.stories.ts":["./src/stories/elements/box/box.stories.ts",4795,1596],"./stories/elements/button-card/button-card.stories":["./src/stories/elements/button-card/button-card.stories.ts",4795,4052],"./stories/elements/button-card/button-card.stories.ts":["./src/stories/elements/button-card/button-card.stories.ts",4795,4052],"./stories/elements/feedback/feedback.stories":["./src/stories/elements/feedback/feedback.stories.ts",4795,4452],"./stories/elements/feedback/feedback.stories.ts":["./src/stories/elements/feedback/feedback.stories.ts",4795,4452],"./stories/elements/input-detail/input-detail.stories":["./src/stories/elements/input-detail/input-detail.stories.ts",4795,4646],"./stories/elements/input-detail/input-detail.stories.ts":["./src/stories/elements/input-detail/input-detail.stories.ts",4795,4646],"./stories/elements/notice/notice.stories":["./src/stories/elements/notice/notice.stories.ts",4795,1222],"./stories/elements/notice/notice.stories.ts":["./src/stories/elements/notice/notice.stories.ts",4795,1222],"./stories/elements/progress-bar/progress-bar.stories":["./src/stories/elements/progress-bar/progress-bar.stories.ts",4795,8140],"./stories/elements/progress-bar/progress-bar.stories.ts":["./src/stories/elements/progress-bar/progress-bar.stories.ts",4795,8140],"./stories/elements/sticky/sticky.stories":["./src/stories/elements/sticky/sticky.stories.ts",4795,7244],"./stories/elements/sticky/sticky.stories.ts":["./src/stories/elements/sticky/sticky.stories.ts",4795,7244],"./stories/elements/tag/tag.stories":["./src/stories/elements/tag/tag.stories.ts",4795,5372],"./stories/elements/tag/tag.stories.ts":["./src/stories/elements/tag/tag.stories.ts",4795,5372],"./stories/exapdable-panel/expandable-panel.stories":["./src/stories/exapdable-panel/expandable-panel.stories.ts",4795,3360],"./stories/exapdable-panel/expandable-panel.stories.ts":["./src/stories/exapdable-panel/expandable-panel.stories.ts",4795,3360],"./stories/expandale-tabs/expandable-tabs.stories":["./src/stories/expandale-tabs/expandable-tabs.stories.ts",4795,4932],"./stories/expandale-tabs/expandable-tabs.stories.ts":["./src/stories/expandale-tabs/expandable-tabs.stories.ts",4795,4932],"./stories/footer/footer.stories":["./src/stories/footer/footer.stories.ts",8590],"./stories/footer/footer.stories.ts":["./src/stories/footer/footer.stories.ts",8590],"./stories/form-controls/form-controls/checkbox/checkbox.stories":["./src/stories/form-controls/form-controls/checkbox/checkbox.stories.ts",4795,3634],"./stories/form-controls/form-controls/checkbox/checkbox.stories.ts":["./src/stories/form-controls/form-controls/checkbox/checkbox.stories.ts",4795,3634],"./stories/form-controls/form-controls/input-combobox/input-combobox.stories":["./src/stories/form-controls/form-controls/input-combobox/input-combobox.stories.ts",4795,356],"./stories/form-controls/form-controls/input-combobox/input-combobox.stories.ts":["./src/stories/form-controls/form-controls/input-combobox/input-combobox.stories.ts",4795,356],"./stories/form-controls/form-controls/input-currency/input-currency.stories":["./src/stories/form-controls/form-controls/input-currency/input-currency.stories.ts",4795,6700],"./stories/form-controls/form-controls/input-currency/input-currency.stories.ts":["./src/stories/form-controls/form-controls/input-currency/input-currency.stories.ts",4795,6700],"./stories/form-controls/form-controls/input-date/input-date.stories":["./src/stories/form-controls/form-controls/input-date/input-date.stories.ts",4795,6406],"./stories/form-controls/form-controls/input-date/input-date.stories.ts":["./src/stories/form-controls/form-controls/input-date/input-date.stories.ts",4795,6406],"./stories/form-controls/form-controls/input-double-date/input-double-date.stories":["./src/stories/form-controls/form-controls/input-double-date/input-double-date.stories.ts",4795,3974],"./stories/form-controls/form-controls/input-double-date/input-double-date.stories.ts":["./src/stories/form-controls/form-controls/input-double-date/input-double-date.stories.ts",4795,3974],"./stories/form-controls/form-controls/input-number-interval/input-number-interval.stories":["./src/stories/form-controls/form-controls/input-number-interval/input-number-interval.stories.ts",4795,8462],"./stories/form-controls/form-controls/input-number-interval/input-number-interval.stories.ts":["./src/stories/form-controls/form-controls/input-number-interval/input-number-interval.stories.ts",4795,8462],"./stories/form-controls/form-controls/input-number/input-number.stories":["./src/stories/form-controls/form-controls/input-number/input-number.stories.ts",4795,7552],"./stories/form-controls/form-controls/input-number/input-number.stories.ts":["./src/stories/form-controls/form-controls/input-number/input-number.stories.ts",4795,7552],"./stories/form-controls/form-controls/input/input.stories":["./src/stories/form-controls/form-controls/input/input.stories.ts",4795,2986],"./stories/form-controls/form-controls/input/input.stories.ts":["./src/stories/form-controls/form-controls/input/input.stories.ts",4795,2986],"./stories/form-controls/form-controls/multiple-select/multiple-select.stories":["./src/stories/form-controls/form-controls/multiple-select/multiple-select.stories.ts",4795,8914],"./stories/form-controls/form-controls/multiple-select/multiple-select.stories.ts":["./src/stories/form-controls/form-controls/multiple-select/multiple-select.stories.ts",4795,8914],"./stories/form-controls/form-controls/radio/radio.stories":["./src/stories/form-controls/form-controls/radio/radio.stories.ts",4795,4466],"./stories/form-controls/form-controls/radio/radio.stories.ts":["./src/stories/form-controls/form-controls/radio/radio.stories.ts",4795,4466],"./stories/form-controls/form-controls/select/select.stories":["./src/stories/form-controls/form-controls/select/select.stories.ts",4795,1528],"./stories/form-controls/form-controls/select/select.stories.ts":["./src/stories/form-controls/form-controls/select/select.stories.ts",4795,1528],"./stories/form-controls/form-controls/single-checkbox/single-checkbox.stories":["./src/stories/form-controls/form-controls/single-checkbox/single-checkbox.stories.ts",4795,8094],"./stories/form-controls/form-controls/single-checkbox/single-checkbox.stories.ts":["./src/stories/form-controls/form-controls/single-checkbox/single-checkbox.stories.ts",4795,8094],"./stories/form-controls/form-controls/text-area/text-area.stories":["./src/stories/form-controls/form-controls/text-area/text-area.stories.ts",4795,2054],"./stories/form-controls/form-controls/text-area/text-area.stories.ts":["./src/stories/form-controls/form-controls/text-area/text-area.stories.ts",4795,2054],"./stories/form-controls/form-example/form-example.stories":["./src/stories/form-controls/form-example/form-example.stories.ts",4795,3060],"./stories/form-controls/form-example/form-example.stories.ts":["./src/stories/form-controls/form-example/form-example.stories.ts",4795,3060],"./stories/form-controls/form-sections/form-group/form-group.stories":["./src/stories/form-controls/form-sections/form-group/form-group.stories.ts",4795,6322],"./stories/form-controls/form-sections/form-group/form-group.stories.ts":["./src/stories/form-controls/form-sections/form-group/form-group.stories.ts",4795,6322],"./stories/form-controls/form-sections/form-row-break/form-row-break.stories":["./src/stories/form-controls/form-sections/form-row-break/form-row-break.stories.ts",4795,6632],"./stories/form-controls/form-sections/form-row-break/form-row-break.stories.ts":["./src/stories/form-controls/form-sections/form-row-break/form-row-break.stories.ts",4795,6632],"./stories/form-controls/form-sections/form-section/form-section.stories":["./src/stories/form-controls/form-sections/form-section/form-section.stories.ts",4795,2178],"./stories/form-controls/form-sections/form-section/form-section.stories.ts":["./src/stories/form-controls/form-sections/form-section/form-section.stories.ts",4795,2178],"./stories/form-controls/form-sections/form-title/form-title.stories":["./src/stories/form-controls/form-sections/form-title/form-title.stories.ts",4795,3736],"./stories/form-controls/form-sections/form-title/form-title.stories.ts":["./src/stories/form-controls/form-sections/form-title/form-title.stories.ts",4795,3736],"./stories/form-controls/form-sections/input-label/input-label.stories":["./src/stories/form-controls/form-sections/input-label/input-label.stories.ts",4795,9800],"./stories/form-controls/form-sections/input-label/input-label.stories.ts":["./src/stories/form-controls/form-sections/input-label/input-label.stories.ts",4795,9800],"./stories/form-controls/form-sections/input-loading/input-loading.stories":["./src/stories/form-controls/form-sections/input-loading/input-loading.stories.ts",4795,3364],"./stories/form-controls/form-sections/input-loading/input-loading.stories.ts":["./src/stories/form-controls/form-sections/input-loading/input-loading.stories.ts",4795,3364],"./stories/form-controls/form-sections/input-messages/input-messages.stories":["./src/stories/form-controls/form-sections/input-messages/input-messages.stories.ts",4795,9076],"./stories/form-controls/form-sections/input-messages/input-messages.stories.ts":["./src/stories/form-controls/form-sections/input-messages/input-messages.stories.ts",4795,9076],"./stories/form-controls/form-sections/input-space/input-space.stories":["./src/stories/form-controls/form-sections/input-space/input-space.stories.ts",4795,8668],"./stories/form-controls/form-sections/input-space/input-space.stories.ts":["./src/stories/form-controls/form-sections/input-space/input-space.stories.ts",4795,8668],"./stories/form-controls/form-sections/input-tooltip/input-tooltip.stories":["./src/stories/form-controls/form-sections/input-tooltip/input-tooltip.stories.ts",4795,7480],"./stories/form-controls/form-sections/input-tooltip/input-tooltip.stories.ts":["./src/stories/form-controls/form-sections/input-tooltip/input-tooltip.stories.ts",4795,7480],"./stories/form-controls/form-sections/radio-table-form/radio-table-form.stories":["./src/stories/form-controls/form-sections/radio-table-form/radio-table-form.stories.ts",4795,5500],"./stories/form-controls/form-sections/radio-table-form/radio-table-form.stories.ts":["./src/stories/form-controls/form-sections/radio-table-form/radio-table-form.stories.ts",4795,5500],"./stories/form-tabellare/form-tabellare.stories":["./src/stories/form-tabellare/form-tabellare.stories.ts",4795,2398],"./stories/form-tabellare/form-tabellare.stories.ts":["./src/stories/form-tabellare/form-tabellare.stories.ts",4795,2398],"./stories/header/header.stories":["./src/stories/header/header.stories.ts",8954],"./stories/header/header.stories.ts":["./src/stories/header/header.stories.ts",8954],"./stories/modal/modal-basic/modal-basic.stories":["./src/stories/modal/modal-basic/modal-basic.stories.ts",4795,9310],"./stories/modal/modal-basic/modal-basic.stories.ts":["./src/stories/modal/modal-basic/modal-basic.stories.ts",4795,9310],"./stories/modal/modal-confirm/modal-confirm.stories":["./src/stories/modal/modal-confirm/modal-confirm.stories.ts",4795,3466],"./stories/modal/modal-confirm/modal-confirm.stories.ts":["./src/stories/modal/modal-confirm/modal-confirm.stories.ts",4795,3466],"./stories/modal/modal-form/modal-form.stories":["./src/stories/modal/modal-form/modal-form.stories.ts",4795,6264],"./stories/modal/modal-form/modal-form.stories.ts":["./src/stories/modal/modal-form/modal-form.stories.ts",4795,6264],"./stories/page-sections/content-end/content-end.stories":["./src/stories/page-sections/content-end/content-end.stories.ts",4795,2647],"./stories/page-sections/content-end/content-end.stories.ts":["./src/stories/page-sections/content-end/content-end.stories.ts",4795,2647],"./stories/page-sections/content-init/content-init.stories":["./src/stories/page-sections/content-init/content-init.stories.ts",4795,761],"./stories/page-sections/content-init/content-init.stories.ts":["./src/stories/page-sections/content-init/content-init.stories.ts",4795,761],"./stories/page-sections/menu-item/menu-item.stories":["./src/stories/page-sections/menu-item/menu-item.stories.ts",4795,1239],"./stories/page-sections/menu-item/menu-item.stories.ts":["./src/stories/page-sections/menu-item/menu-item.stories.ts",4795,1239],"./stories/page-sections/menu/menu.stories":["./src/stories/page-sections/menu/menu.stories.ts",4795,6547],"./stories/page-sections/menu/menu.stories.ts":["./src/stories/page-sections/menu/menu.stories.ts",4795,6547],"./stories/page-sections/message-viewer/message-viewer.stories":["./src/stories/page-sections/message-viewer/message-viewer.stories.ts",4795,669],"./stories/page-sections/message-viewer/message-viewer.stories.ts":["./src/stories/page-sections/message-viewer/message-viewer.stories.ts",4795,669],"./stories/page-sections/navigation-bar/navigation-bar.stories":["./src/stories/page-sections/navigation-bar/navigation-bar.stories.ts",4795,6705],"./stories/page-sections/navigation-bar/navigation-bar.stories.ts":["./src/stories/page-sections/navigation-bar/navigation-bar.stories.ts",4795,6705],"./stories/page-sections/page-not-found/page-not-found.stories":["./src/stories/page-sections/page-not-found/page-not-found.stories.ts",4795,3745],"./stories/page-sections/page-not-found/page-not-found.stories.ts":["./src/stories/page-sections/page-not-found/page-not-found.stories.ts",4795,3745],"./stories/page-sections/skip-link/skip-link.stories":["./src/stories/page-sections/skip-link/skip-link.stories.ts",4795,7],"./stories/page-sections/skip-link/skip-link.stories.ts":["./src/stories/page-sections/skip-link/skip-link.stories.ts",4795,7],"./stories/page-sections/title/title.stories":["./src/stories/page-sections/title/title.stories.ts",4795,7351],"./stories/page-sections/title/title.stories.ts":["./src/stories/page-sections/title/title.stories.ts",4795,7351],"./stories/panel-tree/panel-tree.stories":["./src/stories/panel-tree/panel-tree.stories.ts",4795,2542],"./stories/panel-tree/panel-tree.stories.ts":["./src/stories/panel-tree/panel-tree.stories.ts",4795,2542],"./stories/role-alert/role-alert.stories":["./src/stories/role-alert/role-alert.stories.ts",4795,2846],"./stories/role-alert/role-alert.stories.ts":["./src/stories/role-alert/role-alert.stories.ts",4795,2846],"./stories/search-filter/search-filter.stories":["./src/stories/search-filter/search-filter.stories.ts",4795,8782],"./stories/search-filter/search-filter.stories.ts":["./src/stories/search-filter/search-filter.stories.ts",4795,8782],"./stories/tab/tab.stories":["./src/stories/tab/tab.stories.ts",4795,1502],"./stories/tab/tab.stories.ts":["./src/stories/tab/tab.stories.ts",4795,1502],"./stories/table/table-paginated/table-paginated.stories":["./src/stories/table/table-paginated/table-paginated.stories.ts",4795,9725],"./stories/table/table-paginated/table-paginated.stories.ts":["./src/stories/table/table-paginated/table-paginated.stories.ts",4795,9725],"./stories/table/table/table.stories":["./src/stories/table/table/table.stories.ts",4795,4833],"./stories/table/table/table.stories.ts":["./src/stories/table/table/table.stories.ts",4795,4833],"./stories/upload-file/upload-file.stories":["./src/stories/upload-file/upload-file.stories.ts",4795,7894],"./stories/upload-file/upload-file.stories.ts":["./src/stories/upload-file/upload-file.stories.ts",4795,7894],"./stories/wizard-spa/wizard-spa.stories":["./src/stories/wizard-spa/wizard-spa.stories.ts",4795,1636],"./stories/wizard-spa/wizard-spa.stories.ts":["./src/stories/wizard-spa/wizard-spa.stories.ts",4795,1636]};function webpackAsyncContext(req){if(!__webpack_require__.o(map,req))return Promise.resolve().then((()=>{var e=new Error("Cannot find module '"+req+"'");throw e.code="MODULE_NOT_FOUND",e}));var ids=map[req],id=ids[0];return Promise.all(ids.slice(1).map(__webpack_require__.e)).then((()=>__webpack_require__(id)))}webpackAsyncContext.keys=()=>Object.keys(map),webpackAsyncContext.id="./src lazy recursive ^\\.\\/.*$ include: (?%21.*node_modules)(?:\\/src(?:\\/(?%21\\.)(?:(?:(?%21(?:^%7C\\/)\\.).)*?)\\/%7C\\/%7C$)(?%21\\.)(?=.)[^/]*?\\.stories\\.(js%7Cjsx%7Cmjs%7Cts%7Ctsx))$",module.exports=webpackAsyncContext},"./src/common/shared/Utilities.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";__webpack_require__.d(__webpack_exports__,{Fs:()=>createRenderFunction,Vx:()=>playFunction,YP:()=>cleanHead,k9:()=>removeHeader,kw:()=>removeFooter,oN:()=>addBodyClass});const removeHeader=()=>{const header=document.querySelector("header");header&&header.remove()},cleanHead=()=>{const head=document.querySelector("head");if(head){const nodes=Array.from(head.childNodes);let startIndex=-1,endIndex=-1;nodes.forEach(((node,index)=>{if(node.nodeType===Node.COMMENT_NODE){const commentNode=node;"SB-START"===commentNode.textContent?.trim()?startIndex=index:"SB-END"===commentNode.textContent?.trim()&&(endIndex=index)}})),-1!==startIndex&&-1!==endIndex&&nodes.slice(startIndex,endIndex+1).forEach((node=>node.remove()))}const body=document.getElementsByTagName("body").item(0);body?.classList.remove("container")},removeFooter=()=>{const footer=document.querySelector("footer");footer&&footer.remove()},addBodyClass=()=>{const body=document.getElementsByTagName("body").item(0);body?.classList.add("background-inail")};function createRenderFunction(componentName){return args=>{const attributes=Object.entries(args).map((([key,value])=>"boolean"==typeof value?value?`[${key}]="${value}"`:`[${key}]="false"`:"function"==typeof value?`(${key})="${key}($event)"`:"object"==typeof value&&null!==value?`[${key}]="${key}"`:`${key}="${value}"`)).filter(Boolean).join(" ");return{props:args,template:`\n        <${componentName} ${attributes}>\n        </${componentName}>\n      `}}}function playFunction(canvasElement){let retries=0;const intervalId=setInterval((()=>{const tooltipElement=canvasElement.querySelector("inail-input-tooltip");if(tooltipElement){const button=tooltipElement.querySelector("button");if(button){const title=button.getAttribute("title");title&&button.setAttribute("data-original-title",title)}clearInterval(intervalId)}retries>=5&&clearInterval(intervalId),retries++}),200)}},"./src/common/shared/documentation-template.mdx":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";__webpack_require__.r(__webpack_exports__),__webpack_require__.d(__webpack_exports__,{Template:()=>Template,default:()=>MDXContent});var react=__webpack_require__("./node_modules/react/index.js"),jsx_runtime=__webpack_require__("./node_modules/react/jsx-runtime.js"),lib=__webpack_require__("./node_modules/@mdx-js/react/lib/index.js"),dist=__webpack_require__("./node_modules/@storybook/blocks/dist/index.mjs");const MdxReader=({mdxPage})=>{const[isExpanded,setIsExpanded]=(0,react.useState)(!1),[mdxContent,setMdxContent]=(0,react.useState)("");return(0,react.useEffect)((()=>{setMdxContent(mdxPage)}),[mdxPage]),react.createElement("div",{id:"user-experience-carousel-box",className:"row accordion-gray content"},react.createElement("div",{className:"row head-accordion-gray "+(isExpanded?"":"collapsed"),"aria-expanded":isExpanded,onClick:()=>setIsExpanded(!isExpanded)},react.createElement("img",{src:"static-webkit/img/user_experience.png",alt:"Icona user experience"}),react.createElement("div",{className:"accordion-title col-xs-7"},react.createElement("strong",null,"User Experience")),react.createElement("em",{className:`fa fa-2x expand-icon pull-right fa-${isExpanded?"minus":"plus"}-circle`,title:isExpanded?"Comprimi elemento":"Espandi elemento"})),react.createElement("div",{id:"user-experience-carousel-box-panel",className:"row panel-body collapse "+(isExpanded?"in":""),"aria-expanded":isExpanded},react.createElement("div",{className:"panel-content"},react.createElement(dist.oz,null,mdxContent))))};var asyncToGenerator=__webpack_require__("./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js"),external_STORYBOOK_MODULE_PREVIEW_API_=__webpack_require__("storybook/internal/preview-api");const DocumentationReader=({type})=>{const[mdxContent,setMdxContent]=(0,react.useState)(""),[currentDoc,setCurrentDoc]=(0,react.useState)("");return external_STORYBOOK_MODULE_PREVIEW_API_.addons.getChannel().once("docsRendered",(doc=>{setCurrentDoc(doc)})),(0,react.useEffect)((()=>{if(currentDoc){(function(){var _ref=(0,asyncToGenerator.A)((function*(){try{const response=yield fetch(`docs/${currentDoc}-${type}.md`);if(!response.ok)throw new Error(`Errore nel caricamento: ${response.statusText}`);const text=yield response.text();setMdxContent(text)}catch(error){console.error(`Errore nel caricamento del file MDX ${type}:`,error),setMdxContent(`Errore nel caricamento del contenuto ${type}.`)}}));return function fetchMdx(){return _ref.apply(this,arguments)}})()()}}),[currentDoc,type]),react.createElement("div",{className:"panel-content"},react.createElement(dist.oz,null,mdxContent))},DocumentationReaderTop=()=>react.createElement(DocumentationReader,{type:"top"}),DocumentationReaderDown=()=>react.createElement(DocumentationReader,{type:"down"}),TitleWithNavigation=({title,showCode,showAccessibility})=>{const extractedTitle=title.split("/").pop()||title,links=[{href:"#panoramica",text:"Panoramica"},{href:"#caratteristiche-principali",text:"Caratteristiche Principali"},{href:"#varianti",text:"Varianti"},{href:"#best-practices",text:"Best Practices"},{href:"#componenti-correlati",text:"Componenti Correlati"},showAccessibility?{href:"#accessibilita",text:"Accessibilità"}:null,showCode?{href:"#codice",text:"Codice"}:null,{href:"#user-experience",text:"User Experience"},{href:"#overview",text:"Overview"}].filter(Boolean);return react.createElement("div",{style:{width:"auto",minHeight:"128px",backgroundImage:'url("background.png")',backgroundRepeat:"no-repeat",backgroundSize:"cover",backgroundPosition:"right center",borderRadius:"4px",display:"flex",flexDirection:"column",justifyContent:"center",alignItems:"flex-start",padding:"32px",boxSizing:"border-box",marginBottom:"5%"}},react.createElement("h1",{style:{textAlign:"left",width:"100%",marginBottom:"20px",lineHeight:"1"}},extractedTitle),react.createElement("nav",{style:{width:"100%"}},react.createElement("ul",{style:{listStyleType:"none",padding:0,flexWrap:"wrap",display:"flex",alignItems:"center",gap:"15px",margin:0}},[{href:"#panoramica",text:"Panoramica"},{href:"#caratteristiche-principali",text:"Caratteristiche Principali"},{href:"#varianti",text:"Varianti"},{href:"#best-practices",text:"Best Practices"},{href:"#componenti-correlati",text:"Componenti Correlati"},{href:"#overview",text:"Overview"},{href:"#api",text:"API"}].map(((link,index)=>react.createElement("li",{key:link.href,style:{display:"flex",alignItems:"center",height:"100%",whiteSpace:"nowrap"}},react.createElement("a",{href:link?.href,target:"_self",style:{fontSize:"1.2em",color:"blue",textDecoration:"none",display:"flex",alignItems:"center",height:"100%"}},link?.text),index<links.length-1&&react.createElement("span",{style:{marginLeft:"10px",whiteSpace:"nowrap"}},"|")))))))},Template=args=>{const{story}=(0,dist.jj)("story",["story"]),mdxPage=story.parameters.docs?.mdxPage||null;return(0,jsx_runtime.jsxs)(jsx_runtime.Fragment,{children:[(0,jsx_runtime.jsx)(TitleWithNavigation,{title:story.title}),(0,jsx_runtime.jsx)(DocumentationReaderTop,{}),(0,jsx_runtime.jsx)(dist.om,{}),(0,jsx_runtime.jsx)(DocumentationReaderDown,{}),mdxPage&&(0,jsx_runtime.jsx)(MdxReader,{mdxPage})]})};function _createMdxContent(props){return(0,jsx_runtime.jsxs)(jsx_runtime.Fragment,{children:[(0,jsx_runtime.jsx)(dist.W8,{isTemplate:!0}),"\n","\n",(0,jsx_runtime.jsx)(Template,{})]})}function MDXContent(props={}){const{wrapper:MDXLayout}={...(0,lib.R)(),...props.components};return MDXLayout?(0,jsx_runtime.jsx)(MDXLayout,{...props,children:(0,jsx_runtime.jsx)(_createMdxContent,{...props})}):_createMdxContent()}},"./src/styles.css?ngGlobalStyle":()=>{},"./storybook-config-entry.js":(__unused_webpack_module,__unused_webpack___webpack_exports__,__webpack_require__)=>{"use strict";var external_STORYBOOK_MODULE_CHANNELS_=__webpack_require__("storybook/internal/channels"),csf=__webpack_require__("./node_modules/@storybook/core/dist/csf/index.js"),external_STORYBOOK_MODULE_PREVIEW_API_=__webpack_require__("storybook/internal/preview-api"),external_STORYBOOK_MODULE_GLOBAL_=__webpack_require__("@storybook/global"),asyncToGenerator=__webpack_require__("./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js");const importers=[function(){var _ref=(0,asyncToGenerator.A)((function*(path){if(!/^\.[\\/](?:src(?:\/(?!\.)(?:(?:(?!(?:^|\/)\.).)*?)\/|\/|$)(?!\.)(?=.)[^/]*?\.mdx)$/.exec(path))return;const pathRemainder=path.substring(6);return __webpack_require__("./src lazy recursive ^\\.\\/.*$ include: (?%21.*node_modules)(?:\\/src(?:\\/(?%21\\.)(?:(?:(?%21(?:^%7C\\/)\\.).)*?)\\/%7C\\/%7C$)(?%21\\.)(?=.)[^/]*?\\.mdx)$")("./"+pathRemainder)}));return function(_x){return _ref.apply(this,arguments)}}(),function(){var _ref2=(0,asyncToGenerator.A)((function*(path){if(!/^\.[\\/](?:src(?:\/(?!\.)(?:(?:(?!(?:^|\/)\.).)*?)\/|\/|$)(?!\.)(?=.)[^/]*?\.stories\.(js|jsx|mjs|ts|tsx))$/.exec(path))return;const pathRemainder=path.substring(6);return __webpack_require__("./src lazy recursive ^\\.\\/.*$ include: (?%21.*node_modules)(?:\\/src(?:\\/(?%21\\.)(?:(?:(?%21(?:^%7C\\/)\\.).)*?)\\/%7C\\/%7C$)(?%21\\.)(?=.)[^/]*?\\.stories\\.(js%7Cjsx%7Cmjs%7Cts%7Ctsx))$")("./"+pathRemainder)}));return function(_x2){return _ref2.apply(this,arguments)}}()];function _importFn(){return(_importFn=(0,asyncToGenerator.A)((function*(path){for(let i=0;i<importers.length;i++){const moduleExports=yield(x=()=>importers[i](path),x());if(moduleExports)return moduleExports}var x}))).apply(this,arguments)}const channel=(0,external_STORYBOOK_MODULE_CHANNELS_.createBrowserChannel)({page:"preview"});external_STORYBOOK_MODULE_PREVIEW_API_.addons.setChannel(channel),"DEVELOPMENT"===external_STORYBOOK_MODULE_GLOBAL_.global.CONFIG_TYPE&&(window.__STORYBOOK_SERVER_CHANNEL__=channel);const preview=new external_STORYBOOK_MODULE_PREVIEW_API_.PreviewWeb((function importFn(_x3){return _importFn.apply(this,arguments)}),(()=>{const previewAnnotations=[__webpack_require__("./node_modules/@storybook/angular/dist/client/preview-prod.js"),__webpack_require__("./node_modules/@storybook/angular/dist/client/docs/config.js"),__webpack_require__("./node_modules/@storybook/angular/dist/client/config.js"),__webpack_require__("./node_modules/@storybook/addon-links/dist/preview.mjs"),__webpack_require__("./node_modules/@storybook/addon-essentials/dist/backgrounds/preview.mjs"),__webpack_require__("./node_modules/@storybook/addon-essentials/dist/viewport/preview.mjs"),__webpack_require__("./node_modules/@storybook/addon-essentials/dist/measure/preview.mjs"),__webpack_require__("./node_modules/@storybook/addon-essentials/dist/outline/preview.mjs"),__webpack_require__("./node_modules/@storybook/addon-essentials/dist/highlight/preview.mjs"),__webpack_require__("./node_modules/@storybook/addon-actions/dist/preview.mjs"),__webpack_require__("./node_modules/@storybook/addon-docs/dist/preview.mjs"),__webpack_require__("./.storybook/preview.ts")],userPreview=previewAnnotations[previewAnnotations.length-1]?.default;return(0,csf.bU)(userPreview)?userPreview.composed:(0,external_STORYBOOK_MODULE_PREVIEW_API_.composeConfigs)(previewAnnotations)}));window.__STORYBOOK_PREVIEW__=preview,window.__STORYBOOK_STORY_STORE__=preview.storyStore,window.__STORYBOOK_ADDONS_CHANNEL__=channel},"@storybook/global":module=>{"use strict";module.exports=__STORYBOOK_MODULE_GLOBAL__},"storybook/internal/channels":module=>{"use strict";module.exports=__STORYBOOK_MODULE_CHANNELS__},"storybook/internal/client-logger":module=>{"use strict";module.exports=__STORYBOOK_MODULE_CLIENT_LOGGER__},"storybook/internal/core-events":module=>{"use strict";module.exports=__STORYBOOK_MODULE_CORE_EVENTS__},"storybook/internal/preview-api":module=>{"use strict";module.exports=__STORYBOOK_MODULE_PREVIEW_API__},"storybook/internal/preview-errors":module=>{"use strict";module.exports=__STORYBOOK_MODULE_CORE_EVENTS_PREVIEW_ERRORS__}},__webpack_require__=>{var __webpack_exec__=moduleId=>__webpack_require__(__webpack_require__.s=moduleId);__webpack_require__.O(0,[4878],(()=>(__webpack_exec__("./node_modules/zone.js/fesm2015/zone.js"),__webpack_exec__("./node_modules/@angular/compiler/fesm2022/compiler.mjs"),__webpack_exec__("./storybook-config-entry.js"),__webpack_exec__("./node_modules/@inail/internet-webkit/styles.scss?ngGlobalStyle"),__webpack_exec__("./src/styles.css?ngGlobalStyle"))));__webpack_require__.O()}]);