## CARATTERISTICHE PRINCIPALI
Le caratteristiche principali del componente "Pulsante di Azione" sono:

* **Funzionalità chiave**: il componente può essere configurato per eseguire azioni specifiche, come ad esempio l'invio di un modulo o la navigazione a una pagina diversa.
* **Aspetti tecnici rilevanti**: il componente utilizza HTML, CSS e JavaScript per fornire un'esperienza utente fluida e rispondente.
* **Caratteristiche di accessibilità**: il componente è progettato per essere accessibile agli utenti con disabilità, grazie all'utilizzo di attributi ARIA e alla conformità alle linee guida WCAG 2.1.

## VARIANTI
Sono disponibili diverse varianti del componente "Pulsante di Azione", ognuna con le sue caratteristiche specifiche:

* **Variante 1: Pulsante Primario**: utilizzato per azioni principali, come ad esempio l'invio di un modulo.
 + Casi d'uso: invio di un modulo, navigazione a una pagina diversa.
 + Descrizione breve: pulsante primario con testo descrittivo.
* **Variante 2: Pulsante Secondario**: utilizzato per azioni secondarie, come ad esempio la cancellazione di un'azione.
 + Casi d'uso: cancellazione di un'azione, annullamento di una selezione.
 + Descrizione breve: pulsante secondario con testo descrittivo.
* **Variante 3: Pulsante Icona**: utilizzato per azioni che richiedono un'icona descrittiva.
 + Casi d'uso: navigazione a una pagina diversa, apertura di un menu.
 + Descrizione breve: pulsante con icona descrittiva.

## BEST PRACTICES
Per utilizzare il componente "Pulsante di Azione" in modo efficace:

* **Raccomandazioni d'uso**: utilizzare il componente per azioni specifiche e ben definite, evitando di sovraccaricare l'utente con troppe opzioni.
* **Linee guida implementative**: seguire le linee guida di progettazione dell'applicazione per garantire la coerenza visiva e funzionale.
* **Pratiche da evitare**: evitare di utilizzare il componente per azioni non specifiche o ambigue, come ad esempio "Cerca" senza indicare cosa si sta cercando.

## COMPONENTI CORRELATI
Il componente "Pulsante di Azione" è spesso utilizzato in combinazione con altri componenti, come:

* **Modulo**: il pulsante può essere utilizzato per inviare un modulo.
* **Menu**: il pulsante può essere utilizzato per aprire un menu.
* **Pagina**: il pulsante può essere utilizzato per navigare a una pagina diversa.

N.D.