## CARATTERISTICHE PRINCIPALI
Le caratteristiche chiave del Wizard Component includono:

* **steps**: un array di oggetti che rappresentano i passaggi del wizard
* **activeStep**: l'oggetto che rappresenta il passaggio attualmente selezionato
* **templates**: un array di template HTML che possono essere utilizzati per personalizzare l'aspetto del componente
* **isSlider**: una proprietà booleana che determina se il wizard deve essere visualizzato come slider o meno

Gli aspetti tecnici rilevanti includono:

* La gestione degli eventi e la comunicazione tra i passaggi
* L'utilizzo di template HTML per personalizzare l'aspetto del componente
* La possibilità di integrare il Wizard Component con altre librerie e framework

Le caratteristiche di accessibilità includono:

* La possibilità di utilizzare tasti di navigazione per muoversi tra i passaggi
* L'utilizzo di attributi ARIA per migliorare l'accessibilità per gli utenti con disabilità

## VARIANTI
Le varianti disponibili del Wizard Component includono:

* **Default**: la variante predefinita del componente, che include tutti i passaggi e le funzionalità principali
* **Slider**: una variante che visualizza il wizard come slider, con la possibilità di navigare tra i passaggi utilizzando tasti di navigazione

I casi d'uso specifici per ogni variante includono:

* Utilizzare la variante Default per guidare l'utente attraverso un processo complesso
* Utilizzare la variante Slider per creare un'esperienza utente più interattiva e dinamica

## BEST PRACTICES
Le raccomandazioni d'uso del Wizard Component includono:

* Utilizzare il componente per guidare l'utente attraverso processi complessi
* Personalizzare l'aspetto e il comportamento del componente per adattarlo alle esigenze specifiche dell'applicazione
* Integrare il Wizard Component con altre librerie e framework per migliorare la user experience

Le linee guida implementative includono:

* Utilizzare template HTML per personalizzare l'aspetto del componente
* Gestire gli eventi e la comunicazione tra i passaggi per creare un'esperienza utente fluida

Le pratiche da evitare includono:

* Utilizzare il Wizard Component per processi troppo semplici o lineari
* Non personalizzare l'aspetto e il comportamento del componente

## COMPONENTI CORRELATI
I componenti associati al Wizard Component includono:

* **Button**: un componente che può essere utilizzato per creare pulsanti di navigazione per il wizard
* **Step**: un componente che rappresenta un singolo passaggio del wizard

Le relazioni con altri elementi includono:

* La possibilità di integrare il Wizard Component con altre librerie e framework per migliorare la user experience

## OVERVIEW
<div class="table-responsive">`import { WizardComponent } from '@inail/internet-webkit/wizard';`</div>
Componente custom che si usa per mostrare i passi di un processo e il stato di ciascuno.

## API
<div class="table-responsive">
  <table class="table">
  <thead>
	<tr>
	  <th style="width: 20%"><strong>Campo</strong></th>
	  <th style="width: 80%"><strong>Descrizione</strong></th>
	</tr>
  </thead>
   <tbody>
	<tr>
	  <td><code>defaultIcons</code></td>
	  <td>
		  `@Input() defaultIcons: boolean = false;` <br />
		  Boolean che cambia l'uso delle icone. Quando è `true`, le icone non cambiano a base del stato del Step.
	  </td>
	</tr>
	<tr>
	  <td><code>step</code></td>
	  <td>
		  `@Input() steps: Step[] = [];` <br />
		  Array di <a href="?path=/docs/resources-models-step--docs">Step</a> che imposta l' elenco di processi presenti nel Wizard.
	  </td>
	</tr>
	<tr>
	  <td><code>activeStep</code></td>
	  <td>
		  `@Input('activeStep') set interceptActiveStepInput(activeStep: any) {}` <br />
		  Imposta lo Step attuale.
	  </td>
	</tr>
	<tr>
	  <td><code>id</code></td>
	  <td>
		  `@Input() id = composeUniqueId('Tabs_');` <br />
		  ID del Wizard.
	  </td>
	</tr>
	<tr>
	  <td><code>templates</code></td>
	  <td>
		  `@Input() templates: TemplateRef<undefined>[] = [];` <br />
		  Array di `TemplateRef` che imposta il contenuto di ogni Step del Wizard.
	  </td>
	</tr>
	<tr>
	  <td><code>uniqueId</code></td>
	  <td>
		  `@Input() uniqueId!: string;` <br />
		  ID aggiuntivo
	  </td>
	</tr>
	<tr>
	  <td><code>isSlider</code></td>
	  <td>
		  `@Input() isSlider = false;` <br />
		  Booleano che cambia l' orientamento del Wizard.
	  </td>
	</tr>
  </tbody>
</table>
</div>

<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Event</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>stepChange</code></td>
      <td>
        `@Output() stepChange: EventEmitter<Step> = new EventEmitter();` <br />
        `EventEmitter` tramite il quale si gestisce la navigazione tra i Step.
      </td>
    </tr>
  </tbody>
</table>
</div>