## CARATTERISTICHE PRINCIPALI
- **Funzionalità chiave**: il componente consente di impostare filtri su più campi, come ad esempio nome, cognome ed email.
- **Aspetti tecnici rilevanti**: il componente utilizza un array di oggetti per rappresentare i criteri di filtro, ognuno dei quali contiene 12 proprietà. Inoltre, è possibile configurare la dimensione degli elementi dell'interfaccia utente utilizzando le classi Bootstrap.
- **Caratteristiche di accessibilità**: N.D.

## VARIANTI
- **Elenco e descrizione delle varianti disponibili**:
  - Variante "Search Filter Sample": una variante di base del componente che consente di filtrare i risultati di ricerca in base a criteri specifici.
  - Variante "INAIL Search Form": una variante personalizzata del componente per l'applicazione INAIL.
- **Casi d'uso specifici per ogni variante**:
  - La variante "Search Filter Sample" può essere utilizzata come esempio di base per la creazione di filtri di ricerca personalizzati.
  - La variante "INAIL Search Form" è progettata per soddisfare le esigenze specifiche dell'applicazione INAIL.
- **Breve descrizione per ogni variante**:
  - Variante "Search Filter Sample": un filtro di ricerca di base che consente di impostare criteri di filtro su più campi.
  - Variante "INAIL Search Form": un filtro di ricerca personalizzato per l'applicazione INAIL.

## BEST PRACTICES
- **Raccomandazioni d'uso**: utilizzare il componente Search Filter quando si necessita di filtrare i risultati di ricerca in base a criteri specifici.
- **Linee guida implementative**: configurare gli elementi dell'interfaccia utente utilizzando le classi Bootstrap per garantire una dimensione coerente.
- **Pratiche da evitare**: non utilizzare il componente Search Filter come un semplice campo di testo, poiché ciò potrebbe limitarne la funzionalità.

## COMPONENTI CORRELATI
- N.D.


## OVERVIEW
<div class="table-responsive">`import { SearchFilterComponent } from '@inail/internet-webkit/search-filter';`</div>

Il componente SearchFilterComponent fornisce un'interfaccia per applicare filtri di ricerca. Consente di configurare criteri di filtro avanzati e visualizzare i risultati in base ai parametri specificati. Include campi per il nome, cognome ed email, con la possibilità di gestire opzioni di filtro avanzate e una legenda per i campi obbligatori.

## API
<div class="table-responsive">
  <table class="table">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>filterTitle</code></td>
         <td>
            `@Input() filterTitle = 'LABEL.SEARCH_FILTER_TITLE';` <br />
            Il titolo visualizzato per il componente filtro, predefinito a 'LABEL.SEARCH_FILTER_TITLE'.
         </td>
      </tr>
      <tr>
         <td><code>filterButtonLabel</code></td>
         <td>
            `@Input() filterButtonLabel = 'BUTTON.SEARCH';` <br />
           L'etichetta per il pulsante filtro, predefinita a 'BUTTON.SEARCH'.
         </td>
      </tr>
	  <tr>
         <td><code>filters</code></td>
         <td>
            `@Input() filters: FilterText[] = [];` <br />
           Un array di criteri di filtro <a href = "?path=/docs/resources-models-filtertext--docs">FilterText</a>.
         </td>
      </tr>
	  <tr>
         <td><code>showAdvancedFilter</code></td>
         <td>
            `@Input() showAdvancedFilter!: boolean;` <br />
          Flag per mostrare o nascondere le opzioni di filtro avanzato.
         </td>
      </tr>
	  <tr>
         <td><code>formTitle</code></td>
         <td>
            `@Input() formTitle!: string;` <br />
           Il titolo del modulo.
         </td>
    </tr>
    <tr>
       <td><code>asteriskRequiredLegend</code></td>
       <td>
           `@Input() asteriskRequiredLegend!: boolean;` <br />
           Flag per mostrare o nascondere la legenda dell'asterisco obbligatorio.
        </td>
    </tr>
    <tr>
       <td><code>sizeActions</code></td>
       <td>
           `@Input() sizeActions: BootstrapSize = new BootstrapSize(12, 12, 12, 12);` <br />
           Configurazione della dimensione Bootstrap per i pulsanti Action. <br />
           Tipo di oggetto <a href = "?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize</a>.
        </td>
    </tr>
   </tbody>
</table>
</div>