CARATTERISTICHE PRINCIPALI

Le caratteristiche chiave della modale di conferma includono:

* **Funzionalità di base**: la modale di conferma offre una serie di funzionalità di base, come la visualizzazione di messaggi e descrizioni, la gestione degli eventi di conferma e annullamento.
* **Personalizzabilità**: la modale di conferma può essere personalizzata per adattarsi alle esigenze specifiche dell'applicazione, incluse la possibilità di modificare il testo, i colori e lo stile.
* **Accessibilità**: la modale di conferma è progettata per essere accessibile, con una struttura semantica corretta e la possibilità di utilizzare tasti di accesso rapido.

## VARIANTI

Le varianti della modale di conferma includono:

* **Conferma semplice**: questa variante offre un messaggio di conferma semplice e diretto.
* **Conferma con descrizione**: questa variante include una descrizione dettagliata del processo di conferma.
* **Conferma con azioni multiple**: questa variante offre più opzioni di azione, come confermare o annullare.

Per ogni variante, sono disponibili casi d'uso specifici:

* **Caso d'uso 1: Conferma semplice**: utilizzare la modale di conferma per confermare un'azione semplice, come l'eliminazione di un elemento.
* **Caso d'uso 2: Conferma con descrizione**: utilizzare la modale di conferma per fornire una descrizione dettagliata del processo di conferma, come la creazione di un nuovo account.

## BEST PRACTICES

Le raccomandazioni d'uso per la modale di conferma includono:

* **Utilizzare testo chiaro e conciso**: utilizzare un linguaggio semplice e diretto per descrivere le azioni da confermare.
* **Fornire opzioni di accessibilità**: garantire che la modale di conferma sia accessibile, con una struttura semantica corretta e la possibilità di utilizzare tasti di accesso rapido.
* **Evitare di sovraccaricare l'utente**: limitare il numero di opzioni disponibili per non confondere l'utente.

## COMPONENTI CORRELATI

I componenti associati alla modale di conferma includono:

* **Pulsanti di azione**: utilizzati per confermare o annullare le azioni.
* **Messaggi di stato**: utilizzati per fornire informazioni sull'esito delle azioni.

N.D. Non sono disponibili altre informazioni relative ai componenti correlati.

## OVERVIEW
<div class="table-responsive">`import { ConfirmationComponent } from '@inail/internet-webkit/modals';`</div>
 
Il ConfirmationComponent è un componente progettato per gestire conferme in modo semplice e personalizzabile. È ideale per scenari in cui è necessario chiedere una conferma all'utente prima di eseguire un'azione, come eliminare un elemento o completare un processo.

Questo componente utilizza un'istanza del ModalComponent per presentare una finestra modale con titolo, messaggi e pulsanti configurabili, consentendo una gestione semplice di eventi di conferma e annullamento.
 
## API
<div class="table-responsive">
  <table class="table">
    <thead>
      <tr>
        <th><strong>Campo</strong></th>
        <th><strong>Descrizione</strong></th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><code>title</code></td>
        <td> <code>@Input() title: string = 'MESSAGES.CONFIRM_ACTION';</code><br /> Titolo della finestra di conferma. Visualizzato nella parte superiore della modale.<br /> Valore predefinito: <code>'MESSAGES.CONFIRM_ACTION'</code>. </td>
      </tr>
      <tr>
        <td><code>actions</code></td>
        <td> <code>@Input() set actions(actionsInput: ActionItem[]);</code><br /> Configura le azioni disponibili nella finestra di conferma. Accetta un array di oggetti di tipo <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>. </td>
      </tr>
      <tr>
        <td><code>cancel</code></td>
        <td> <code>@Input() set cancel(actionCancel: ActionItem);</code><br /> Configura l'azione di annullamento. Accetta un oggetto di tipo <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>. </td>
      </tr>
    </tbody>
  </table>
</div>

 <br />
 <br />

<div class="table-responsive">
  <table class="table">
   <thead>
     <tr>
       <th><strong>Event</strong></th>
       <th><strong>Descrizione</strong></th>
     </tr>
   </thead>
   <tbody>
         <tr>
        <td><code>_onConfirm</code></td>
        <td> <code>@Output('onConfirm') _onConfirm: EventEmitter&lt;any&gt; = new EventEmitter();</code><br /> Evento emesso quando l'utente conferma l'azione. </td>
      </tr>
      <tr>
        <td><code>_onCancel</code></td>
        <td> <code>@Output('onCancel') _onCancel: EventEmitter&lt;any&gt; = new EventEmitter();</code><br /> Evento emesso quando l'utente annulla l'azione. </td>
      </tr>
  </tbody>
  </table>
  </div>