## CARATTERISTICHE PRINCIPALI
Le funzionalità chiave del NoticeComponent includono:

* Il supporto per messaggi personalizzati tramite la proprietà "message"
* L'opzione di cancellabilità tramite la proprietà "closable"
* La possibilità di aggiungere classi CSS extra tramite la proprietà "extClass"

Gli aspetti tecnici rilevanti includono:

* Il componente utilizza un EventEmitter per gestire l'evento di chiusura
* Il componente supporta la personalizzazione dell'aspetto tramite classi CSS

Le caratteristiche di accessibilità includono:

* Il componente è progettato per essere accessibile aiutando gli utenti con disabilità a comprendere meglio il contenuto

## VARIANTI
Le varianti disponibili per il NoticeComponent includono:

* **Info**: una variante che visualizza un messaggio informativo
* **Warning**: una variante che visualizza un messaggio di avvertimento
* **Error**: una variante che visualizza un messaggio di errore

Casi d'uso specifici per ogni variante includono:

* Utilizzare la variante "Info" per fornire informazioni utili all'utente
* Utilizzare la variante "Warning" per avvertire l'utente di un potenziale problema
* Utilizzare la variante "Error" per segnalare un errore critico

Breve descrizione per ogni variante:

* **Info**: fornisce informazioni utili all'utente in modo chiaro e conciso
* **Warning**: avverte l'utente di un potenziale problema in modo visibile
* **Error**: segnala un errore critico in modo evidente

## BEST PRACTICES
Raccomandazioni d'uso:

* Utilizzare il NoticeComponent per fornire informazioni importanti all'utente
* Personalizzare l'aspetto del componente utilizzando classi CSS extra
* Utilizzare la proprietà "closable" per rendere il componente cancellabile

Linee guida implementative:

* Utilizzare il componente in modo coerente all'interno dell'applicazione
* Testare il componente per garantire l'accessibilità e la compatibilità

Pratiche da evitare:

* Non utilizzare il NoticeComponent come sostituto di un messaggio di errore critico
* Non personalizzare eccessivamente l'aspetto del componente, potrebbe compromettere l'accessibilità

## COMPONENTI CORRELATI
Componenti associati:

* ButtonComponent: può essere utilizzato in combinazione con il NoticeComponent per fornire azioni aggiuntive all'utente
* DialogComponent: può essere utilizzato per visualizzare messaggi più dettagliati o complessi

Relazioni con altri elementi:

* Il NoticeComponent può essere utilizzato all'interno di una pagina web o di un'applicazione mobile per fornire informazioni importanti all'utente

## OVERVIEW
<div class="table-responsive">`import { NoticeComponent } from '@inail/internet-webkit/elements';`</div>
Componente personalizzato utilizzato per visualizzare messaggi di vari tipi in base alla situazione.

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>type</code></td>
      <td>
        `@Input() type: 'success' | 'danger' | 'warning' | 'info' = 'info';` <br />
        Campo di tipo string che imposta il tipo di notifica, modificando anche lo stile visivo del componente.
      </td>
    </tr>
    <tr>
      <td><code>message</code></td>
      <td>
          `@Input() message: string = 'Message';` <br />
          Messaggio che viene mostrato nel notice.
      </td>
    </tr>
    <tr>
      <td><code>i18n</code></td>
      <td>
          `@Input() i18n: any;` <br />
          Parametri di traduzione i18n del messaggio. <br />
          `{{ message | translate: i18n }}`
      </td>
    </tr>
    <tr>
      <td><code>closable</code></td>
      <td>
          `@Input() closable = false;` <br />
          Booleano che, quando è impostato su true, permette all'utente di chiudere la notifica tramite un pulsante mostrato condizionalmente.
      </td>
    </tr>
    <tr>
      <td><code>extClass</code></td>
      <td>
          `@Input() extClass!: string;` <br />
          Campo di tipo `string` che aggiunge una classe CSS al componente.
      </td>
    </tr>
  </tbody>
</table>
</div>

<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Event</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>close</code></td>
      <td>
        `@Output() close = new EventEmitter();` <br />
        `EventEmitter` tramite il quale si può gestire la chiusura del componente quando `closable = true`.
      </td>
    </tr>
  </tbody>
</table>
</div>