## CARATTERISTICHE PRINCIPALI
Il componente Carousel presenta le seguenti caratteristiche principali:

* **Funzionalità chiave**: la possibilità di aggiungere più elementi alla sequenza e la navigazione tra essi
* **Aspetti tecnici rilevanti**: il componente utilizza HTML, CSS e JavaScript per funzionare correttamente
* **Caratteristiche di accessibilità**: il componente è progettato per essere accessibile aiutando gli utenti con disabilità a navigare tra gli elementi utilizzando tastiera e tecnologie assistive

## VARIANTI
Il componente Carousel presenta le seguenti varianti:

* **Basic Carousel**: la variante di base del componente, che consente di aggiungere più elementi alla sequenza e di navigare tra essi
* **Carousel con input**: una variante del componente che consente di aggiungere input a ogni elemento della sequenza
* **Carousel con select**: una variante del componente che consente di aggiungere un menu a tendina a ogni elemento della sequenza

Per ogni variante, sono disponibili i seguenti casi d'uso:

* Utilizzare il Basic Carousel per presentare una serie di immagini o video in modo semplice e intuitivo
* Utilizzare il Carousel con input per raccogliere informazioni dagli utenti mentre navigano tra gli elementi della sequenza
* Utilizzare il Carousel con select per offrire agli utenti la possibilità di selezionare opzioni tra un elenco di voci

## BEST PRACTICES
Per utilizzare il componente Carousel in modo efficace, si consiglia di:

* Utilizzare immagini o video di alta qualità per migliorare l'esperienza utente
* Personalizzare l'aspetto e il comportamento del componente per adattarlo alle esigenze specifiche dell'applicazione
* Testare il componente con diverse tecnologie assistive per garantirne l'accessibilità

## COMPONENTI CORRELATI
Il componente Carousel è correlato ai seguenti componenti:

* **Slider**: un componente che consente di visualizzare una serie di elementi in modo sequenziale, ma senza la possibilità di navigare tra essi
* **Galleria**: un componente che consente di visualizzare una serie di immagini o video in modo non sequenziale

Nota: le informazioni relative ai controlli e alle azioni del componente Carousel non sono disponibili poiché il componente è descritto come un elemento di interfaccia utente generico.

## OVERVIEW
<div class="table-responsive">`import { CarouselComponent } from "@inail/internet-webkit/carousel";`</div>


Il CarouselComponent è un componente progettato per creare carousel personalizzabili ed efficienti. Questo componente permette la visualizzazione di contenuti dinamici in un formato a scorrimento, consentendo agli utenti di navigare tra più elementi come immagini, video o testo.

Grazie alla sua configurabilità, il CarouselComponent offre flessibilità nella personalizzazione delle frecce di navigazione, etichette, e altre opzioni di configurazione tramite l'uso di proprietà e template.


## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>templates</code></td>
      <td> <code>`@Input() templates: TemplateRef<undefined>[] = [];`</code><br /> Array di template dinamici che definiscono i contenuti del carousel. È possibile fornire più template per personalizzare ciascuna slide del carousel. </td>
    </tr>
    <tr>
      <td><code>id</code></td>
      <td> <code>@Input() id = '';</code><br /> Identificativo univoco del carousel. Utile per gestire eventi o riferimenti specifici al componente. </td>
    </tr>
    <tr>
      <td><code>config</code></td>
      <td> <code>`private _config: CarouselConfig = new CarouselConfig();`</code>
          <code>`@Input() set config(value: Partial<CarouselConfig>) {}`</code><br />
        Configurazione personalizzata del carousel. Questo input accetta un oggetto parziale
        di tipo <code>CarouselConfig</code>, che viene unito con i valori predefiniti.
        <ul>
          <li>Le etichette <code>nextArrow</code> e <code>prevArrow</code> vengono aggiornate automaticamente tramite il metodo <code>updateLabel()</code>.</li>
          <li>La configurazione finale viene combinata utilizzando lo spread operator per mantenere i valori di default.</li>
        </ul>
      </td>
    </tr>
  </tbody>
</table>
</div>