## CARATTERISTICHE PRINCIPALI

Le caratteristiche chiave del componente "Pulsante di Azione" sono:

* **Funzionalità chiave**: il pulsante può essere configurato per richiamare azioni specifiche, come ad esempio l'invio di un modulo o la navigazione verso una nuova pagina.
* **Aspetti tecnici rilevanti**: il componente è realizzato utilizzando HTML, CSS e JavaScript, e supporta la gestione degli eventi e delle proprietà CSS per personalizzare l'aspetto e il comportamento.
* **Caratteristiche di accessibilità**: il componente è progettato per essere accessibile agli utenti con disabilità, grazie all'utilizzo di attributi ARIA e alla gestione dei focus e degli eventi.

## VARIANTI

Sono disponibili le seguenti varianti del componente "Pulsante di Azione":

* **Variante 1: Pulsante primario**: utilizzato per azioni principali, come ad esempio l'invio di un modulo.
 + Casi d'uso specifici: invio di un modulo, navigazione verso una nuova pagina.
 + Breve descrizione: pulsante con sfondo colore primario e testo bianco.
* **Variante 2: Pulsante secondario**: utilizzato per azioni secondarie, come ad esempio la cancellazione di un'operazione.
 + Casi d'uso specifici: cancellazione di un'operazione, annullamento di una selezione.
 + Breve descrizione: pulsante con sfondo colore secondario e testo nero.
* **Variante 3: Pulsante di icona**: utilizzato per azioni che richiedono un'icona specifica.
 + Casi d'uso specifici: azioni che richiedono un'icona specifica, come ad esempio la stampa o il download di un file.
 + Breve descrizione: pulsante con icona al centro e senza testo.

## BEST PRACTICES

Le raccomandazioni per l'utilizzo del componente "Pulsante di Azione" sono:

* Utilizzare il pulsante primario per azioni principali e il pulsante secondario per azioni secondarie.
* Utilizzare icone coerenti con le azioni associate ai pulsanti.
* Evitare di utilizzare pulsanti troppo piccoli o troppo grandi, in modo da garantire la leggibilità e l'accessibilità.

## COMPONENTI CORRELATI

Il componente "Pulsante di Azione" è correlato ai seguenti componenti:

* **Modulo**: il pulsante può essere utilizzato per inviare un modulo.
* **Link**: il pulsante può essere utilizzato come link verso una nuova pagina.

N.D.