# Step

Documentazione dettagliata della classe custom **Step**, usata nei componenti di Intranet Webkit v17. 
**Step** viene utilizzato per creare l'oggetto `Step` di un componente <a href="?path=/story/components-wizard--wizard">Wizard</a>, che serve per connettere un template alla logica di un passo di un <a href="?path=/story/components-wizard--wizard">Wizard</a> a fasi multiple.

## Implementazione
<div class="table-responsive">`import { Step } from '@inail/intranet-webkit';`</div>
<br />

***Struttura:***
`constructor(id: any,
  title: string,
  hasError: boolean,
  disabled: boolean,
  visited?: boolean | undefined,
  visible?: boolean,
  hasWarning?: boolean | undefined)`

***Esempio d'uso:***
<br />
`step = new Step('step3', 'Warning/Error Step', true, false, false, true, true)`

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>id</code></td>
      <td>
        Campo di tipo any che assegna un id a un step.
      </td>
    </tr>
    <tr>
      <td><code>title</code></td>
      <td>
        Campo di tipo string che imposta il titolo che viene visualizzatto nel <a href="?path=/story/components-wizard--wizard">Wizard</a>.
      </td>
    </tr>
    <tr>
      <td><code>hasError</code></td>
      <td>
        Campo booleano che decide se il step ha un errore presente, impattando anche la visualizzazione dello step. La logica può essere gestita in accordo con le necessita dell' uso di uno step del <a href="?path=/story/components-wizard--wizard">Wizard</a>.
        <br />
        ***Esempio:*** Uno step del <a href="?path=/story/components-wizard--wizard">Wizard</a> contiene un form con dei campi obbligatori non completati dall' utente. Se l' utente passa a un altro step, questo step mostrera un'icona di errore e diventerà rossa per segnalare l' errore all'utente.
      </td>
    </tr>
    <tr>
      <td><code>disabled</code></td>
      <td>
        Campo booleano che si usa per disabilitare un step del <a href="?path=/story/components-wizard--wizard">Wizard</a>.
      </td>
    </tr>
    <tr>
      <td><code>visited</code></td>
      <td>
        Campo booleano non obbligatorio che si usa per segnalare che un step del <a href="?path=/story/components-wizard--wizard">Wizard</a> è stato gia visitato. Se non ci sono errori in questo step (segnato tramite `hasError`) lo stesso mostrera un' icona check e diventerà verde.
      </td>
    </tr>
    <tr>
      <td><code>visible</code></td>
      <td>
        Campo booleano non obbligatorio che si usa per mostrare/nascondere un step.
      </td>
    </tr>
    <tr>
      <td><code>hasWarning</code></td>
      <td>
        Campo booleano non obbligatorio che si usa per mostrare un'icona di warning al posto del numero dello step che viene mostrato normalmente.
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-wizard--wizard">Wizard</a>
