## CARATTERISTICHE PRINCIPALI
Le funzionalità chiave del componente Form Group includono:

* La possibilità di personalizzare l'aspetto e il comportamento dei campi di input
* La gestione degli eventi e delle azioni associate ai campi di input
* L'integrazione con le tecnologie di accessibilità per garantire la fruizione da parte di utenti con disabilità

Gli aspetti tecnici rilevanti del componente Form Group includono:

* La struttura dei dati e la gestione degli stati dei campi di input
* L'utilizzo delle tecnologie web standard per la gestione dell'accessibilità

Le caratteristiche di accessibilità del componente Form Group includono:

* La conformità ai requisiti dell'accessibilità web (WCAG 2.1)
* L'integrazione con le tecnologie di assistenza come ad esempio i lettori di schermo

## VARIANTI
Le varianti disponibili per il componente Form Group includono:

* **Test della descrizione del form group**: una variante che include una breve descrizione dei campi di input
* **INAIL Sample Form Group**: una variante che include un esempio di utilizzo del componente con campi di input specifici
* **I campi contrassegnati con l'asterisco (*) sono obbligatori**: una variante che include un messaggio di errore per i campi obbligatori non compilati

Per ogni variante, è possibile realizzare una breve descrizione:

* La prima variante è utile per fornire contesto ai campi di input
* La seconda variante è utile per dimostrare l'utilizzo del componente in un caso reale
* La terza variante è utile per garantire che gli utenti comprendano l'importanza dei campi obbligatori

## BEST PRACTICES
Le raccomandazioni d'uso del componente Form Group includono:

* Utilizzare il componente per raggruppare più campi di input correlati
* Fornire descrizioni chiare e concise per ogni campo di input
* Utilizzare le tecnologie di accessibilità per garantire la fruizione da parte di utenti con disabilità

Le linee guida implementative includono:

* Utilizzare il componente in combinazione con altri componenti per la gestione dei dati
* Personalizzare l'aspetto e il comportamento del componente per adattarlo alle esigenze specifiche dell'applicazione

Le pratiche da evitare includono:

* Non utilizzare il componente come un contenitore generico per elementi non correlati
* Non omettere le descrizioni dei campi di input

## COMPONENTI CORRELATI
I componenti associati al Form Group includono:

* I campi di input (ad esempio, text box, checkbox, ecc.)
* I pulsanti e i link per la gestione delle azioni
* Altri componenti per la gestione dei dati

Le relazioni con altri elementi includono:

* L'integrazione con le tecnologie di accessibilità per garantire la fruizione da parte di utenti con disabilità
* La gestione degli eventi e delle azioni associate ai campi di input

## OVERVIEW
<div class="table-responsive">`import { FormGroupComponent } from '@inail/intranet-webkit/form-controls';`</div>

Il componente FormGroupComponent presenta un esempio interattivo del componente e consente di configurarne le proprietà principali per osservare come influenzano il suo comportamento e il suo aspetto. Il componente è pensato per essere utilizzato all'interno di form complessi e sfrutta il sistema a griglia di Bootstrap per gestire la larghezza e la disposizione degli elementi.


## API
<div class="table-responsive">
  <table class="table table-documentation">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>title</code></td>
         <td>
            `@Input() title = 'LABEL.NO_TITLE';` <br />
            Titolo del form group.
         </td>
      </tr>
      <tr>
         <td><code>asteriskRequiredLegend</code></td>
         <td>
            `@Input() asteriskRequiredLegend: boolean = true;` <br />
            Mostra o nasconde l'asterisco per i campi obbligatori in base alla configurazione.
         </td>
      </tr>
      <tr>
         <td><code>size</code></td>
         <td>
            `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
            La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
         </td>
      </tr>
      <tr>
         <td><code>id</code></td>
         <td>
            `@Input() override id = composeUniqueId('form_group');` <br />
            La proprietà `id` nella classe `BasePageSection` rappresenta un identificatore univoco. Questo ID è sovrascritto da BasePageSection.
         </td>
      </tr>
   </tbody>
</table>
</div>