## CARATTERISTICHE PRINCIPALI
Le funzionalità chiave del componente sono:

* Personalizzazione del suffisso della valuta (ad esempio, €)
* Specificazione del numero di decimali visualizzato (ad esempio, 2)
* Possibilità di nascondere gli elementi di base della sezione
* Supporto per messaggi di avviso e aiuto

Gli aspetti tecnici rilevanti sono:

* Il componente utilizza il formato HTML standard per l'inserimento di valori monetari
* È possibile personalizzare l'aspetto del componente utilizzando CSS

Le caratteristiche di accessibilità sono:

* Il componente è progettato per essere accessibile aiutanti con disabilità visive o motorie
* Fornisce supporto per lettori di schermo e altre tecnologie assistive

## VARIANTI
Sono disponibili le seguenti varianti del componente:

* **Variante 1:** Inserimento di valori monetari con suffisso personalizzabile (ad esempio, €)
 + Caso d'uso: inserimento di importi in valuta per transazioni commerciali
 + Breve descrizione: il componente consente agli utenti di inserire valori monetari con un suffisso personalizzabile
* **Variante 2:** Specificazione del numero di decimali visualizzato (ad esempio, 2)
 + Caso d'uso: inserimento di importi in valuta per applicazioni finanziarie
 + Breve descrizione: il componente consente agli utenti di specificare il numero di decimali visualizzato
* **Variante 3:** Possibilità di nascondere gli elementi di base della sezione
 + Caso d'uso: inserimento di valori monetari in un contesto con spazio limitato
 + Breve descrizione: il componente consente agli utenti di nascondere gli elementi di base della sezione

## BEST PRACTICES
Le raccomandazioni d'uso sono:

* Utilizzare il componente per l'inserimento di valori monetari in contesti commerciali o finanziari
* Personalizzare l'aspetto del componente utilizzando CSS per adattarlo alle esigenze specifiche dell'applicazione

Le linee guida implementative sono:

* Utilizzare il formato HTML standard per l'inserimento di valori monetari
* Testare il componente con diverse combinazioni di browser e dispositivi per garantire la compatibilità

Le pratiche da evitare sono:

* Non utilizzare il componente per scopi diversi dall'inserimento di valori monetari
* Non modificare il codice sorgente del componente senza una completa comprensione delle sue funzionalità e limitazioni

## COMPONENTI CORRELATI
I componenti associati sono:

* Componente di selezione della valuta
* Componente di formattazione dei numeri

Le relazioni con altri elementi sono:

* Il componente Input Valuta può essere utilizzato in combinazione con il componente di selezione della valuta per fornire un'interfaccia completa per l'inserimento di valori monetari.

## OVERVIEW
<div class="table-responsive">`import { InputCurrencyComponent } from '@inail/internet-webkit/form-controls';`</div>
Questo componente rappresenta un campo di input per l'inserimento di valori in formato valuta, con supporto per personalizzare il suffisso, il numero di decimali e altre opzioni di configurazione. È progettato per l'uso in moduli, con funzionalità come la convalida dei dati, la visualizzazione di messaggi di errore e il supporto per tooltip e personalizzazioni dell'aspetto.

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>suffix</code></td>
      <td>
        `@Input() suffix = '€';` <br />
        Un suffisso personalizzabile per il campo di input della valuta.
      </td>
    </tr>
    <tr>
      <td><code>fractionSize</code></td>
      <td>
        `@Input() fractionSize = 2;` <br />
        Specifica il numero di decimali visualizzati per la valuta.
      </td>
    </tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class InputComboboxComponent extends BaseInputComponent` <br />
        Fare riferimento a <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent</a>
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
      `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
      La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
      </td>
    </tr>

  </tbody>
</table>
</div>