"use strict";(self.webpackChunkcustom_webkit_material=self.webpackChunkcustom_webkit_material||[]).push([[104],{"./src/common/shared/custom-title-docs.tsx":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{__webpack_require__.d(__webpack_exports__,{B:()=>TitleDoc});var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__("./node_modules/react/index.js");const TitleDoc=({title,links})=>react__WEBPACK_IMPORTED_MODULE_0__.createElement("div",{style:{width:"auto",minHeight:"128px",backgroundImage:'url("background.png")',backgroundRepeat:"no-repeat",backgroundSize:"cover",backgroundPosition:"right center",borderRadius:"4px",display:"flex",flexDirection:"column",justifyContent:"center",alignItems:"flex-start",padding:"32px",boxSizing:"border-box",marginBottom:"5%"}},react__WEBPACK_IMPORTED_MODULE_0__.createElement("h1",{style:{textAlign:"left",width:"100%",marginBottom:"20px",lineHeight:"1"}},title),react__WEBPACK_IMPORTED_MODULE_0__.createElement("nav",{style:{width:"100%"}},react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul",{style:{listStyleType:"none",padding:0,flexWrap:"wrap",display:"flex",alignItems:"center",gap:"15px",margin:0}},links.map((link,index)=>react__WEBPACK_IMPORTED_MODULE_0__.createElement("li",{key:link?.href,style:{display:"flex",alignItems:"center",height:"100%",whiteSpace:"nowrap"}},react__WEBPACK_IMPORTED_MODULE_0__.createElement("a",{href:link?.href,target:"_self",style:{fontSize:"1.2em",color:"blue",textDecoration:"none",display:"flex",alignItems:"center",height:"100%"}},link?.text),index<links.length-1&&react__WEBPACK_IMPORTED_MODULE_0__.createElement("span",{style:{marginLeft:"10px",whiteSpace:"nowrap"}},"|"))))))},"./src/stories/angular-schematics/schematic.mdx":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{__webpack_require__.r(__webpack_exports__),__webpack_require__.d(__webpack_exports__,{default:()=>MDXContent});var react=__webpack_require__("./node_modules/react/index.js"),jsx_runtime=__webpack_require__("./node_modules/react/jsx-runtime.js"),lib=__webpack_require__("./node_modules/@mdx-js/react/lib/index.js"),dist=__webpack_require__("./node_modules/@storybook/blocks/dist/index.mjs");const AngularSchematics=()=>react.createElement("div",null,react.createElement(dist.oz,null,"## Introduzione\n\nQuesto repository è l'implementazione di uno Schematics per la generazione di un'applicazione Angular INAIL\n\nL'applicazione generata risolve:\n\n- la **configurazione iniziale** di una app Angular in ambiente Inail,\n- la configurazione per l'**integrazione nell'ecosistema dell'autenticazione e autorizzazione**,\n- la gestione del **contesto applicativo**,\n- la gestione del **processo di startup** configurabile\n\nLa versione di Angular utilizzata è la **Angular 17.3.0**\n\n#### Change log\n\n- 2.0.1 - 2024.07.19\n  - nuova major release : aggiornamento ad angular 17\n- 2.0.2 - 2024.11.06\n  - aggiunta la direttiva wrapperInailFooter per la gestione degli Header e Footer\n  - eliminata la dipendenza dai componenti **inail-header** e **inail-fooher**\n"),react.createElement(dist.oz,null,"## Premessa\n\nPer generare un'applicazione Angular Inail tramite inail-schematics si devono fornire le seguenti informazioni:\n\n- **_nome dell'applicazione_** : è il nome dell'applicazione Angular,\n\n- **_tipo applicazione_**: può essere di tipo \"_internet_\" o \"_intranet_\",\n\n- **_base url_**: è l'url base che verrà usata da tutte le url dell'applicazione,\n- **_base url service_** : è una lista l'url base usate per l'invocazione dei servizi di BE , su cui verrà iniettato il token jwt\n\n- **_client OIDC_**: il nome del client OIDC,\n\n- **_jwtName_**: il nome del token jwt,\n\nInoltre, per poter avviare l'applicazione in locale (in _HTTPS_), devono essere forniti\n\n- il **nome del server locale**,\n\n- il nome della **chiave ssl** del server locale\n\n- il nome del **certificato ssl** del server locale\n\ninfine devono essere **registrate** come **redirect-url** le seguenti url:\n\nhttp://localhost.inail.it:4200/\\<baseref\\>/\nhttp://localhost.inail.it:4200/\\<baseref\\>/silent-refresh.html\n\nun esempio di queste informazioni è\n\n| Key               | Val                                                                     |\n| ----------------- | ----------------------------------------------------------------------- |\n| appName           | tmp-ang-spa                                                             |\n| appType           | intranet                                                                |\n| clientOidc        | ClientTMP                                                               |\n| jWtName           | JWTTMP                                                                  |\n| baseRef           | /appintra/tmp-ang-spa/                                                  |\n| baseUrlServices   | /pcr/restservice1, /pcr/restservice2, /pcr/restservice3                 |\n| sviUrlLocalServer | localhost.inail.it                                                      |\n| sviSslKey         | localhost.inail.it.key                                                  |\n| sviSslCert        | localhost.inail.it.crt                                                  |\n|                   |                                                                         |\n| redirect-url      | http://localhost.inail.it:4200/appintra/tmp-ang-spa/                    |\n| redirect-url      | http://localhost.inail.it:4200/appintra/tmp-ang-spa/silent-refresh.html |\n"),react.createElement(dist.oz,null,"\n## Installazione\n\n**Precondizione** per l'installazione ed il funzionamento di Inail-schematics \n- installazione di *angular-schematics-cli*\n   ```sh\n   npm i -g @schematics/angular \n   ```\n\n- Installazione di *angular-schematics*\n   ```sh\n   npm i -g @schematics/angular@17.0.7\n   ```\n\n- Installazione di *angular-devkit-schematics-cli*\n   ```sh\n   npm i -g @angular-devkit/schematics-cli@17.0.7\n   ```\n- Connessione al Repository Inail **publicartifactsrepo.inailcloud.it**:\n\n  per permettere il recupero dello schematics dal repository nexus Inail è opportuno aggiungere al file .npmrc la seguente riga:\n\n  ```sh\n    @inail:registry=https://publicartifactsrepo.inailcloud.it:8443/nexus/repository/inail-buildedNPM\n    strict-ssl=false\n  ```\n\n---\nInstallazione di **inail-schematics**\n```sh\nnpm i -g @inail/inail-schematics\n```"),react.createElement(dist.oz,null,'\n## **Generazione Progetto Angular**\n\nInail-schematics può essere usato in due modalità: **batch** oppure **interattiva**\n\n### Modalità batch\nin questa modalità le informazioni di configurazioni possono essere fornite attraverso un file json.\n\nDi seguito un **esempio** del file di configurazione *configuration.json* per una appliczione **intranet*\n```json\n{\n   "appName": "tmp-ang-spa",\n   "appType": "intranet",\n   "clientOidc": "ClientTMP",\n   "jWtName": "JWTTMP",\n   "baseRef": "/appintra/tmp-ang-spa/",\n   "baseUrlServices": "/tmp/restservice",\n   "sviUrlLocalServer": "localhost.inail.it",\n   "sviSslKey": "localhost.inail.it.key",\n   "sviSslCert": "localhost.inail.it.crt"\n}\n```\n\noppure la configurazione per **internet**:\n```json\n{\n   "appName": "inail-wk5-spa",\n   "appType": "internet",\n   "clientOidc": "ClientTMP",\n   "clientOidc": "ClientWkinte",\n   "jWtName": "JWTWkinte",\n   "baseRef": "/app/inail-wk5-spa/",\n   "baseUrlServices": "/tmp/restservice",\n   "sviUrlLocalServer": "localhost.inail.it",\n   "sviSslKey": "localhost.inail.it.key",\n   "sviSslCert": "localhost.inail.it.crt"\n}\n```\n\nper avviare la generazione del codice in modalità batch:\n\n```typescript\nschematics @inail/inail-schematics:new --load-from-file=<nome-file-configurazione.json> --no-interactive\n```\n\nesempio\n>schematics @inail/inail-schematics:new --load-from-file=./configuration.json --no-interactive \n\n\n### **Modalità interattiva**\nIn questa modalità inail-schematics chiederà in modo interattivo le informazioni di configurazione per poi generare il nuovo progetto.\n\nper avviare la generazione del codice può essere usato il seguente comando:\n```typescript\nschematics @inail/inail-schematics:new\n```\n\nL’applicazione quindi chiederà le informazioni che occorrono per la configurazione della SPA Angular e genererà il progetto.\n'),react.createElement(dist.oz,null,"\n## **Avvio dell'applicazione generata**\n\nL’applicazione Angular generata è configurata per interagire con l’autenticazione Inail. Per questo deve essere avviata in ssl.\n\nL’applicazione quindi verrà avviata all’indirizzo [https://localhost.inail.it:4200/<appName](https://localhost.inail.it:4200/%3cappName)>;.\n\nEs\n><https://localhost.inail.it:4200/tmp-ang-spa>\n\nSiccome il server localhost.inail.it non viene risolto dai DNS esso deve essere dichiarato nell’**hosts** della macchina dove viene avviato il server, es:\n\n```\n127.0.0.1    localhost.inail.it\n```\n\nInoltre, per gestire i problemi di cors che potrebbero nascere, l’applicazione generata deve essere avviata con il comando\n\n```typescript\nnpm run proxy\n```\n\nIn questo modo l’applicazione userà il file **proxy.conf.json** dove sono definite le regole di proxy per le chiamate remote.\n\n\n>**Attenzione**: il server  https://localhost.inail.it potrebbe risultare **non raggiungibile** anche se si configura il file hosta. \nIn questo caso controllare che il proxy del sistema (nel caso di windows Rete e Internet> Proxy) non sia settato con la proprietà **Rileva automaticamente impostazioni** = true. in tal caso settare la proprietà a **false**"),react.createElement(dist.oz,null,'## Configurazione applicazione generata\n\nL’applicazione generata gestisce vari tipi di file di configurazione:\n\nNella cartella asset sono presenti tre file json:\n\n- **oauth-config**.**json**\n- **local-config**.**json**\n- **custom-config**.**json**\n\n### oauth-config.json\nIn questo file vengono definite le seguenti variabili:\n\n\n|**Proprietà**|**Valore**|\n| :- | :- |\n|**idClientOidc**|Nome del client id|\n|**jWtName**|Nome del Jwt|\n|**silent\\_refresh**|Boolean che attiva il silent refresh|\n|**silent\\_refresh\\_timeout**|Timeout della chiamata al silent refresh (in ms)|\n|**automatic\\_Silent\\_Refresh**|Boolean che attiva il refresh automatico|\n|**timeoutFactor**|Fattore che serve a definire, rispetto alla scadenza del jwt, quando vede essere attivato il silent refresh|\n|**responseType**|Oidc response type|\n|**showDebugInformation**|Mostra più informazioni in fase di autenticazione|\n\n\n>Un esempio del file è:\n```json\n{\n   "idClientOidc": "ClientTMP",\n   "jWtName": "JWTTMP",\n   "silent_refresh": true,\n   "silent_refresh_timeout": 20000,\n   "automatic_Silent_Refresh": true,\n   "timeoutFactor": 0.75,\n   "responseType": "code", \n   "showDebugInformation": false\n} \n```\n\n\n### **local-config.json**\nin questo file vengono defiite le variabili "locali" all\'applicazione\n\n|**Proprietà**|**Valore**|\n| :- | :- |\n|**BASE\\_PATH\\_SERVICE**|la baseUrl dei servizi di be|\n|**APP\\_BASE\\_URL**|la baseurl dell’applicazione|\n|**PATH\\_WITHOUT\\_JWT**|i path dove non verrà iniettato il token jwt|\n|**APP\\_NAME**|Il nome dell’applicazione|\n\n\n>Un esempio del file è:\n```json\n{\n   "BASE__PATH_SERVICE":"/tmp/tmpangapi",\n   "APP_BASE_URL": "/appintra/tmp-ang-spa/",\n   "PATH_WITHOUT_JWT": ["affwebservices/CASSO", "api/static/hf/footer"],\n   "APP_NAME": "tmp-ang-spa"\n}\n```\n\nil file di configurazione può sovrascrivere una proprietà, **GLOBAL_CONFIG_URL**, che per default vale /api/global-config \n\nQuesta proprietà può essere usata per **modificare il recupero della configurazione iniziale**. \n\nNegli ambienti Inail questa proprietà vale  **/api/global-config**. \n\nSe ad esempio si vuole caricare una configurazione iniziale da un file di nome *myConfig.js* posizionato nella cartella assets/conf allora l’url può essere:\n```json\n"GLOBAL_CONFIG_URL": "assets/conf/myConfig.json"\n```\n>**Prestare molta cura alla sovrascrittura di questa proprietà: da essa dipende la configuraiozne dell\'ambiente di autenticazione INAIL**\n\n\n### **custom-config.json**\nQuesto file è, all’atto della creazione del progetto, vuoto e può essere usato per contenere informazioni utili all’applicazione.\nQuesto Json verrà caricato nella fase si startup e garantito nel contesto\n'),react.createElement(dist.oz,null,'\n## **Riferimento alla configurazione dal codice**\nLa configurazione può essere recuperata attraverso il service **InailContextService.**\n\nEsso espone, in modo statico, un oggetto di configurazione, **InailContext:**\n```typescript\nexport class InailContext {\n   globalConfig: GlobalConfiguration = new GlobalConfiguration();\n   oauth2Config: OAuth2Config = new OAuth2Config();\n   localConfig: any = {};\n   customConfig: any = {};\n}\n```\n\n\nL’oggetto **GlobalConfiguration** mappa la risposta del servizio */api/global-config*.\n```typescript\nexport class GlobalConfiguration {\n   readme: string = "";\n   ambiente: string = "";\n   oidc_wellknown_endpoint: string = "";\n   apigateway_wellknown_endpoint: string = "";\n   jwks_CA: string = "";\n   cdn_endpoint: string = "";\n   webkit_endpoint: string = "";\n   spa_endpoint: string = "";\n   apigateway_endpoint: string = "";\n   be_endpoint: string = "";\n   MaxTimeout: number = 21600;\n   IdleTimeout: number = 3600;\n   JWTTimeout: number = 7200;\n   AnalyticsID: string = "";\n   CSRFCookieName: string = "";\n   CSRFCookieHeader: string = "";\n   CSRFTimeout: number = 22000;\n   checksession: string = "";\n   end_session_endpoint: string = "";\n   issuer_endpoint: string = "";\n   pathServiziBE: string = "";\n}\n```\n\nL’Oggetto **OAuth2Config** contiene le informazioni per la gestione dell’autenticazione\n```typescript\nexport class OAuth2Config {\n   idClientOidc: string ="";\n   jWtName: string ="";\n   silent_refresh: boolean = true;\n   silent_refresh_timeout: number = 20000;\n   automatic_Silent_Refresh: boolean = true;\n   timeoutFactor: number = 0.75;\n   responseType: string = "code";\n   showDebugInformation: boolean = false\n}\n```\nLe altre due proprietà dell’oggetto InailContext, e cioè **localConfig** e **customConfig** sono oggetti definiti dallo sviluppatore'),react.createElement(dist.oz,null,"\n## Sequenza di boot dell’applicazione generata.\nL’applicazione gestisce una sequenza di boot che può essere estesa.\n\nLa sequenza viene implementata attraverso i Provider Angular. Nell’**app.module.ts** dell’applicazione è presente la **pipeline di boot**:\n\n<img src=\"sequence.png\" alt=\"drawing\" width=\"20%\"/>\nLa sequenza viene eseguita in modo **sincrono** in modo da “bloccare” l’esecuzione dell’applicazione.\n\nEssa può essere arricchita aggiungendo altri provider. Di seguito un esempio di un servizio che simula una operazione sincrona (un timer) e rilascia il controllo. \n\nInoltre è mostrato come può essere recuperata il contesto corrente (**@Inject(INAIL_APP_CONTEXT) private inailContext: InailContext**) e come ascoltare gli **eventi del processo di autenticazione**.\n\n\n\n>servizio1.service.ts\n```typescript\nimport { Inject, Injectable } from '@angular/core';\nimport { tap, timer } from 'rxjs';\nimport { OAuthErrorEvent, OAuthService } from 'angular-oauth2-oidc';\nimport { INAIL_APP_CONTEXT, InailContext } from '@inail/coreconfig';\nimport { InailAuthService } from '@inail/oauth';\nimport { HttpClient, HttpHeaders } from '@angular/common/http';\n\n@Injectable({\n   providedIn: 'root'\n})\nexport class Servizio1Service {\n   constructor(@Inject(INAIL_APP_CONTEXT) private inailContext: InailContext,\n               private inailAuthService: InailAuthService,\n               private oauthService: OAuthService) {\n    this.inailAuthService.setEventHandler(this.localFn.bind(this));\n   }\n   \n   initPromise() {\n      return timer(5000).pipe(tap(x=> console.log(\"..Timeout 1 (5000) ...\"))).toPromise();\n   }\n\n   private localFn(event: any) {\n      // Eventi del service inailAuthService a cui è possibile sottoscriversi:\n      //   'discovery_document_loaded', 'jwks_load_error', \n      //   'invalid_nonce_in_state', 'discovery_document_load_error',\n      //   'discovery_document_validation_error', \n      //   'user_profile_loaded', 'user_profile_load_error', 'token_received',\n      //   'token_error', 'code_error', 'token_refreshed', \n      //   'token_refresh_error', 'silent_refresh_error', \n      //   'silently_refreshed', 'silent_refresh_timeout', \n      //   'token_validation_error', 'token_expires', \n      //   'session_changed', 'session_error', 'session_terminated', 'session_unchanged', \n      //   'logout', 'popup_closed', 'popup_blocked', 'token_revoke_error';\n\n    if (event instanceof OAuthErrorEvent) {\n      console.error('OAuthErrorEvent Object:', event);\n    } else if (event.type === \"token_received\") {\n      // Esempi..\n      // Access Token\n      console.log('*** AccessToken',this.oauthService.getAccessToken());  \n      // idToken\n      console.log('*** IdToken',this.oauthService.getIdToken());    \n      // Claim         \n      console.log('*** identityClaims',this.inailAuthService.claims);     \n     }else {\n      console.log('OAuthEvent Object:', event);\n    }\n   }   \n}\n```\ne di seguito un frammento dell' app.module.ts\n>app.module.ts\n\n```typescript\n[...]\n{\n   provide: INAIL_APP_INITIALIZER,\n   useFactory: (sevice: Servizio1Service) => () => sevice.initPromise(),\n   deps: [Servizio1Service],\n   multi: true\n}\n[...]\n```"));var custom_title_docs=__webpack_require__("./src/common/shared/custom-title-docs.tsx");function _createMdxContent(props){return(0,jsx_runtime.jsxs)(jsx_runtime.Fragment,{children:[(0,jsx_runtime.jsx)(dist.W8,{title:"Risorse/Schematic"}),"\n",(0,jsx_runtime.jsx)(custom_title_docs.B,{title:"INAIL App Schematics",links:[{text:"Introduzione",href:"#introduzione"},{text:"Premessa",href:"#premessa"},{text:"Installazione",href:"#installazione"},{text:"Generazione Progetto Angular",href:"#generazione-progetto-angular"},{text:"Avvio dell'applicazione generata",href:"#avvio-dellapplicazione-generata"},{text:"Configurazione applicazione generata",href:"#configurazione-applicazione-generata"},{text:"Riferimento alla configurazione dal codice",href:"#riferimento-alla-configurazione-dal-codice"},{text:"Sequenza di boot dell'applicazione generata",href:"#sequenza-di-boot-dellapplicazione-generata"}]}),"\n",(0,jsx_runtime.jsx)(AngularSchematics,{})]})}function MDXContent(props={}){const{wrapper:MDXLayout}={...(0,lib.R)(),...props.components};return MDXLayout?(0,jsx_runtime.jsx)(MDXLayout,{...props,children:(0,jsx_runtime.jsx)(_createMdxContent,{...props})}):_createMdxContent()}}}]);