var serviceGetEntityRows = "/JSONGet/entities/getEntityRows?callback=?";
var serviceGetEntityList = "/JSONGet/entities/getEntityList?callback=?";
var getFileDocs = "/JSONGet/entities/getFileDocs?callback=?";
var getDocInfo = "/gestioneFile/getDocInfo";
var serviceGetDocumentTitle="/JSONGet/entities/getDocumentTitle?callback=?";
var servicePingDomain = "/JSONGet/utilities/pingDomain?callback=?";
var serviceGetFilter = "/JSONGet/entities/getFilters?callback=?";
var serviceGetLayout = "/JSONGet/entities/getLayout?callback=?";
var serviceGetFile = "/gestioneFile/file";
var serviceGetThingEntity = "/JSONGet/entities/getThingEntity?callback=?";
var serviceGetEntitySingleRow = "/JSONGet/entities/getEntitySingleRow?callback=?";
var serviceGetTotRows = "/JSONGet/entities/getTotRows?callback=?";
var serviceGetLocalFile = "/gestioneFile/getLocalFile";
var serviceTimeout = "30000";

function getFileExtension(filename)
{
	var ext = /^.+\.([^.]+)$/.exec(filename);
	return ext == null ? "" : ext[1];
}
$(document).ready(function(){
	setTimeout(color, serviceTimeout);
	writeDocumentTitle(restDomain);
	writeEntityList(restDomain);

});

(function($){
	helpToggle = function() {
		$("a.toggle").click(function(){
			if($( "a.toggle" ).hasClass( "open" )) {
				$( "a.toggle" ).removeClass( "open" );
			} else {
				$( "a.toggle" ).addClass( "open" );
			}
			$("div.panel-body").toggle("blind");
		});
	};
})(jQuery);

(function($){
	pingRestDomain = function(restDomain) {
		$.ajax({
			type: "GET",
			url: restDomain+servicePingDomain,
			dataType: "json",
			data:'idSession='+document.getElementById("formEntityList:idSession").value,
			beforeSend: function () {
			},
			success: function (data) {
				data.messaggio;
			},
			error: function (error) {
				$('.entityList').remove();
			}   
		});
	};
})(jQuery);

Number.prototype.formatMoney = function(c, d, t){
	var n = this, 
	c = isNaN(c = Math.abs(c)) ? 2 : c, 
			d = d == undefined ? "." : d, 
					t = t == undefined ? "," : t, 
							s = n < 0 ? "-" : "", 
									i = parseInt(n = Math.abs(+n || 0).toFixed(c)) + "", 
									j = (j = i.length) > 3 ? j % 3 : 0;
									return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
};

var titolo;
(function($){
	writeDocumentTitle = function(restDomain) {
		var idSession = document.getElementById("formEntityList:idSessionList").value;
		var siteLevel = document.location;
		$.ajax({
			type: "GET",
			url: restDomain+serviceGetDocumentTitle,
			dataType: "json",
			data:'siteLevel='+siteLevel+'&idSession='+idSession,
			success: function (data) {
				if(data!==null){
					titolo=data.codice;		
				}
						
			},
			error: function (error) {
			},timeout:serviceTimeout  
		});
	};
})(jQuery);

(function($){
	writeEntityList = function(restDomain){
		var idSession = document.getElementById("formEntityList:idSessionList").value;
		var siteLevel = document.location;
		$("#divVoceMenu").empty();
		$.ajax({
			type: "GET",
			url: restDomain+serviceGetEntityList,
			dataType: "json",
			data:'siteLevel='+siteLevel+'&idSession='+idSession,
			success: function (data) {
				if(data==null){
					$('.entityList').remove();
				}
				else{
					var entities ="";
					if(data.entityBean == undefined){
						entities =data;
					}else{
						entities =data.entityBean;
					}
					if( Object.prototype.toString.call( entities ) !== '[object Array]' ) {
						entities = [].concat( entities );
					}
					if(entities.length >0){
						$('.entityList').empty();
						$('.entityList').append('');
						scriviEntityList(entities,idSession,restDomain);
					}else{
						$('.entityList').remove();
					}
				}
			},
			error: function (error) {
				$('.entityList').remove();
			},
			complete: function () {
				$("#onLoadingList").hide();
			},timeout:serviceTimeout
		});
	};
})(jQuery);

var contenutoprincipale;
function scriviEntityList(listaEntity,idSession,restDomain) {
	
	var lastUpdatePag =  $('.lastupdate').html();
	var socialiInviaStampa = $('.social_invia_stampa').html();
	var footer='<div class="row social_invia_stampa">';
	footer+=socialiInviaStampa;
	footer+='</div>';
	footer+='<p class="lastupdate">';
	footer+=lastUpdatePag;
	footer+='</p>';
	
	var box ='<div class="box">';
	box+=$('.box').html();
	box+='</div>';
	$('.box').remove();
	
	var content = $('#contenutoprincipale div').html();
	$('.content').remove();
	
	contenutoprincipale = $('#contenutoprincipale').html();
	$('#contenutoprincipale').empty();
	$('#contenutoprincipale').append('<h2>'+titolo+'</h2><div class="content"> </div>');
	$('.content').html(content);
	trDaAppendere ='';
	$.each(listaEntity, function(index,entityItem){
		trDaAppendere+='<li>';
		var descrCod=encodeURI(entityItem.descr).replace(/'/g,"%27");
		trDaAppendere+='<a href="#" title="\''+entityItem.label+'\'" onClick=" loadTable(\''+restDomain+'\',\''+idSession+'\',\''+
		entityItem.idEntity+'\',\''+entityItem.label+'\',\''+descrCod+'\',\''+
		entityItem.dataAggiornamento+'\',\''+entityItem.pathOwlEntity+'\');">'+entityItem.label+'</a>';
		trDaAppendere+='</li>';
	});
	$('.entityList').append(trDaAppendere);
	
	$('.content').after(footer);
	$('.content').after(box);
};




function loadTable(restDomain,idSession,idEntity,nomeEntity,descrEntity,dataAggiornamento,pathOwlEntity){
	setTimeout(colorTable, serviceTimeout);
	$("#contenutoprincipale").empty();
	$("#contenutoprincipale").append(contenutoprincipale);
	$("#contenutoprincipale h2").append(nomeEntity);
	$(".lastupdate").html(dataAggiornamento=='undefined'?'':'Ultimo aggiornamento: '+dataAggiornamento);
	var numPaginaS = 1;
	var elemInPaginaS = 5;
	writePaginazione(restDomain,idSession,idEntity,pathOwlEntity,'',numPaginaS,elemInPaginaS);
	writeFilters(restDomain,idSession,idEntity,pathOwlEntity,'');
}

function backLoadTable(restDomain, idSession,idEntity,nomeEntity,dataAggiornamento,filtri,numPaginaS,elemInPaginaS){
	setTimeout(colorTable, serviceTimeout);
	$("#contenutoprincipale").empty();
	$("#contenutoprincipale").append(contenutoprincipale);
	$("#contenutoprincipale h2").append(nomeEntity);
	$(".lastupdate").html(dataAggiornamento);
	writePaginazione(restDomain,idSession,idEntity,'',filtri,numPaginaS,elemInPaginaS);
	writeFilters(restDomain,idSession,idEntity,'',filtri);

}

(function($){
	writeFilters = function(restDomain,idSession,idEntity,pathOwlEntity,filtri){
		$.ajax({
			type: "GET",
			url: restDomain+serviceGetFilter,
			dataType: "json",
			data:'idEntity='+idEntity+'&idSession='+idSession,
			success: function (data) {
				if(data==null){
				}
				else{
					var listaFiltri ="";
					if(data.filterBean == undefined){
						listaFiltri =data;
					}else{
						listaFiltri = data.filterBean;
					}
					if( Object.prototype.toString.call( listaFiltri ) !== '[object Array]' ) {
						listaFiltri = [].concat( listaFiltri );
					}
					if(listaFiltri.length!=0){
						$("#contenutoprincipale h3").append("Filtra per");
						$('.activebg').append('<div class="row"> </div>');
						scriviTabellaFiltri(listaFiltri,idEntity,idSession,restDomain,pathOwlEntity,filtri);
					}
					else{
						$("#contenutoprincipale h3").remove();
						$('.activebg').remove();
					}
				}

			},
			error: function (error) {
				$('.entityList').remove();
			}  
		});
	};
})(jQuery);

function contains(a, obj) {
	for (var i = 0; i < a.length; i++) {
		if (a[i] === obj) {
			return true;
		}
	}
	return false;
}

function scriviTabellaFiltri(listaFiltri,idEntity,idSession,restDomain,pathOwlEntity,filtri) {
	var trDaAppendere='';
	var stringaFiltri='';//costruisco la stringa con i nomi dei filtri da passare a filtra entity
	//controllo i filtri selezionati precedentemente
	var arrayFiltriSel;
	if(filtri!==''){
		arrayFiltriSel=filtri.split("-");
	}
	$.each(listaFiltri, function(index, filtro){
		//inizio each esterno
		stringaFiltri+=filtro.idColonna+"-";
		trDaAppendere+='<p class="col-xs-12 col-md-6"><label for="'+filtro.idColonna+'">'+filtro.name+':</label><select name="'+filtro.idColonna+'" id="'+filtro.idColonna+'">';
		trDaAppendere+='<option>'+filtro.name+'</option>';
		trDaAppendere+='<option value="0">Tutti</option>';
		var valoriPossibili = filtro.itemsFilter;
		$.each(valoriPossibili, function(index2, item){
			//inizio each interno
			if(arrayFiltriSel!=null){
				if(contains(arrayFiltriSel,item.value)){
					trDaAppendere+='<option value="'+item.value+'" selected>'+item.label+'</option>';
				}else{
					trDaAppendere+='<option value="'+item.value+'">'+item.label+'</option>';
				}
			}else{
				trDaAppendere+='<option value="'+item.value+'">'+item.label+'</option>';
			}
			//fine each interno
		});
		trDaAppendere+='</select></p>';

		//fine each esterno
	});
	btDaAppendere='<p class="bottoni"><input type="button" value="cerca" title="cerca" onClick="filtraEntity(\''+stringaFiltri+'\',\''+idEntity+'\',\''+idSession+'\',\''+restDomain+'\',\''+pathOwlEntity+'\');"></p>';
	$('.activebg > div:last').append(trDaAppendere);
	$('.activebg').append(btDaAppendere);
	$('#formEntityList').remove();
	$('.content').remove();
};

function filtraEntity(stringaFiltri,idEntity,idSession,restDomain,pathOwlEntity){
	setTimeout(colorTable, serviceTimeout);
	var arrayIdFiltri=stringaFiltri.split("-");
	var stringaValoriFiltri='';
	$.each(arrayIdFiltri, function(index,idFiltro){
		if(idFiltro!==''){
			try{
				stringaValoriFiltri+=$("#"+idFiltro).val()+'-';// document.getElementById("formEntityTable:"+filtro.name).value; 
			}catch(err){

			}
		}
	});

	var numPaginaS = 1;
	var elemInPaginaS = 5;
	writePaginazione(restDomain,idSession,idEntity,pathOwlEntity,stringaValoriFiltri,numPaginaS,elemInPaginaS);

};

function writePaginazione(restDomain,idSession,idEntity,pathOwlEntity,filtri,numPaginaS,elemInPaginaS){
	var numTotaleRecord = 0;
	var numTotalePagine = 0;
	setTimeout(colorTable, serviceTimeout);
	$.ajax({
		type: "GET",
		url: restDomain+serviceGetTotRows,
		dataType: "json",
		data:'idEntity='+idEntity+'&idSession='+idSession+'&filtri='+filtri,
		success: function (data) {
			numTotaleRecord = data;
			
			if (numTotaleRecord >0){
				numTotalePagine = Math.ceil(numTotaleRecord/elemInPaginaS);
				renderBloccoPaginazione(restDomain,idSession,idEntity,pathOwlEntity,filtri,numPaginaS,elemInPaginaS,numTotaleRecord,numTotalePagine);

				if(filtri!==''){
					newEntityTable(restDomain,idSession,idEntity,pathOwlEntity,filtri,numPaginaS,elemInPaginaS);
				}
				else{
					writeEntityTable(restDomain,idSession,idEntity,pathOwlEntity,numPaginaS,elemInPaginaS);
				}
			}
			else{
				$('.error').remove();
				$(".pagination").empty();
				$(".num4page").empty();
				$('#form table').empty();
				$('#form table').append('<thead> </thead> <tbody> </tbody>');
				$('#contenutoprincipale > p:first').empty();
				$("#form").append('<div class="error" style="text-align: center;">La ricerca non ha prodotto risultati</div>');
			}
			
			
		},
		error: function (error) {
			$('.entityList').remove();
		}   
	});
};

(function($){
	writeEntityTable = function(restDomain,idSession,idEntity,pathOwlEntity, numPaginaS, elemInPaginaS) {
//		$("#divTabEntity").hide();
		$('#form table').empty();
		$('#form table').append('<thead> </thead> <tbody> </tbody>');
		$.ajax({
			type: "GET",
			url: restDomain+serviceGetEntityRows,
			dataType: "json",
			data:'idEntity='+idEntity+'&idSession='+idSession+'&filtri=&numPagina='+numPaginaS+'&elemInPagina='+elemInPaginaS,
			success: function (data) {
				if(data==null){
					$('.entityList').remove();
					$(".pagination").remove();
				}
				else{
					var righe ="";
					if(data.rigaBean == undefined){
						righe =data;
					}else{
						righe = data.rigaBean;
					}
					if( Object.prototype.toString.call( righe ) !== '[object Array]' ) {
						righe = [].concat( righe );
					}
					if(righe.length >1){
						$("#divTabEntity").show();
						scriviTabellaEntity(righe,idSession,restDomain,idEntity,'','',pathOwlEntity,'',numPaginaS,elemInPaginaS);
					}else{
						$('.entityList').remove();
						$(".pagination").remove();
					}
				}

			},
			error: function (error) {
				$('.entityList').remove();
			},
			complete: function () {
			}   
		});
	};
})(jQuery);


//viene invocato quando si seleziona un filtro e i record sono maggiori di zero
function newEntityTable(restDomain,idSession,idEntity,pathOwlEntity,filtri,numPaginaS,elemInPaginaS){
	$('#form table').empty();
	$('#form table').append('<thead> </thead> <tbody> </tbody>');
	
	$.ajax({
		type: "GET",
		url: restDomain+serviceGetEntityRows,
		dataType: "json",
		data:'idEntity='+idEntity+'&idSession='+idSession+'&filtri='+filtri+'&numPagina='+numPaginaS+'&elemInPagina='+elemInPaginaS,
		success: function (data) {
			
				var righe ="";
				if(data.rigaBean == undefined){
					righe = data;
				}else{
					righe = data.rigaBean;
				}
				if( Object.prototype.toString.call( righe ) !== '[object Array]' ) {
					righe = [].concat( righe );
				}
				if(righe.length>1){
					$("#divTabEntity").show();
					$('.error').remove();
					scriviTabellaEntity(righe,idSession,restDomain,idEntity,'','',pathOwlEntity,filtri,numPaginaS,elemInPaginaS);
//					newFilterTable(idEntity,idSession,restDomain,pathOwlEntity,filtri);
				}else{
					$('.entityList').remove();
				}
			
		},
		error: function (error) {
			$('.entityList').remove();
		}   
	});
};

//function newFilterTable(idEntity,idSession,restDomain,pathOwlEntity,filtri){
//	$.ajax({
//		type: "GET",
//		url: restDomain+serviceGetFilter,
//		dataType: "json",
//		data:'idEntity='+idEntity+'&idSession='+idSession,
//		success: function (data) {
//			var listaFiltri ="";
//			if(data.filterBean == undefined){
//				listaFiltri =data;
//			}else{
//				listaFiltri = data.filterBean;
//			}
//			if( Object.prototype.toString.call( listaFiltri ) !== '[object Array]' ) {
//				listaFiltri = [].concat( listaFiltri );
//			}
//			if(listaFiltri.length!=0){
//				$("#contenutoprincipale h3").append("Filtra per");
//				$('.activebg').append('<div class="row"> </div>');
//				scriviTabellaFiltri(listaFiltri,idEntity,idSession,restDomain,pathOwlEntity, filtri);
//			}
//		},
//		error: function (error) {
//			$('.entityList').remove();
//		}  
//	});
//};

function renderBloccoPaginazione(restDomain,idSession,idEntity,pathOwlEntity,filtri,numPaginaS,elemInPaginaS,numTotaleRecord,numTotalePagine){
	//svuoto i div prima di riempirli altrimenti accoda
	var primaPagina = 1;
	var ultimaPagina = numTotalePagine;

	$('.indietro').empty();
	$('.pagination li').empty();
	$('.avanti').empty();
	$('.num4page').empty();

	pagVerifica (numPaginaS, numTotalePagine, ultimaPagina, idSession, idEntity, pathOwlEntity, filtri, elemInPaginaS );

	if (numPaginaS != 1 ){
		var paginaPrecedente = +numPaginaS-1;
		var previousS = '<a href="#" title="indietro" class="indietro" onClick="writePaginazione(\''+restDomain+'\',\''+idSession+'\',\''+idEntity+'\',\''+pathOwlEntity+'\',\''+filtri+'\',\''+paginaPrecedente+'\',\''+elemInPaginaS+'\');">indietro</a>';
		$('.indietro').append(previousS);
	}

	if (numPaginaS != numTotalePagine){
		var paginaSuccessiva = +numPaginaS+1;
		var nextS = '<a href="#" title="avanti" class="avanti" onClick="writePaginazione(\''+restDomain+'\',\''+idSession+'\',\''+idEntity+'\',\''+pathOwlEntity+'\',\''+filtri+'\',\''+paginaSuccessiva+'\',\''+elemInPaginaS+'\');">avanti</a>';
		$('.avanti').append(nextS);
	}


	//deve ripartire sempre dalla prima pagina
	var elemXpagS='<label for="num4page">Elementi per pagina</label> ';
	elemXpagS+='<select id="num4page" onChange="writePaginazione(\''+restDomain+'\',\''+idSession+'\',\''+idEntity+'\',\''+pathOwlEntity+'\',\''+filtri+'\',\''+primaPagina+'\',this.options[this.selectedIndex].value)">';

	var elemXPaginaValues = { "3": "3", "5": "5", "10": "10" , "20": "20", "50": "50", "100": "100"};
	$.each(elemXPaginaValues, function(key, value) {   
		if (key == elemInPaginaS){
			elemXpagS+='<option value="' + key + '" selected>' + value + '</option>';
		}
		else{
			elemXpagS+='<option value="' + key + '">' + value + '</option>';
		}
	});
	elemXpagS+='</select>';
	$('.num4page').append(elemXpagS);
	$("a[title='"+numPaginaS+"']").parent().addClass("active");
}

function pagVerifica (numPaginaS, numTotalePagine, ultimaPagina, idSession, idEntity, pathOwlEntity, filtri, elemInPaginaS ){

	$('.pagination li').remove();
	$('.pagination').append('<li class="indietro"></li>');
	$('.pagination').append('<li class="avanti"></li>');

	if((numPaginaS == ultimaPagina) && ((numPaginaS-4)>0)){
		var back4 = +numPaginaS-4;
		var thisA = '<li><a href="#" title="'+back4+'" class="" onClick="writePaginazione(\''+restDomain+'\',\''+idSession+'\',\''+idEntity+'\',\''+pathOwlEntity+'\',\''+filtri+'\',\''+back4+'\',\''+elemInPaginaS+'\');">'+back4+'</a></li>';
		$( ".pagination li:last-child" ).before(thisA);
	}

	if((numPaginaS > 3) && (numPaginaS >= (+ultimaPagina-2))){
		var back3 = +numPaginaS-3;	
		var thisA = '<li><a href="#" title="'+back3+'" class="" onClick="writePaginazione(\''+restDomain+'\',\''+idSession+'\',\''+idEntity+'\',\''+pathOwlEntity+'\',\''+filtri+'\',\''+back3+'\',\''+elemInPaginaS+'\');">'+back3+'</a></li>';
		$( ".pagination li:last-child" ).before(thisA);
	}

	if(numPaginaS > 2 ){
		var back2 = +numPaginaS-2;	
		var thisA = '<li><a href="#" title="'+back2+'" class="" onClick="writePaginazione(\''+restDomain+'\',\''+idSession+'\',\''+idEntity+'\',\''+pathOwlEntity+'\',\''+filtri+'\',\''+back2+'\',\''+elemInPaginaS+'\');">'+back2+'</a></li>';
		$( ".pagination li:last-child" ).before(thisA);
	}

	if(numPaginaS != 1 ){
		var back = +numPaginaS-1;
		var thisA = '<li><a href="#" title="'+back+'" class="" onClick="writePaginazione(\''+restDomain+'\',\''+idSession+'\',\''+idEntity+'\',\''+pathOwlEntity+'\',\''+filtri+'\',\''+back+'\',\''+elemInPaginaS+'\');">'+back+'</a></li>';
		$( ".pagination li:last-child" ).before(thisA);
	}
	var thisS = '<li><a href="#" title="'+numPaginaS+'" class="" onClick="writePaginazione(\''+restDomain+'\',\''+idSession+'\',\''+idEntity+'\',\''+pathOwlEntity+'\',\''+filtri+'\',\''+numPaginaS+'\',\''+elemInPaginaS+'\');">'+numPaginaS+'</a></li>';
	$( ".pagination li:last-child" ).before(thisS);

	if (numPaginaS != numTotalePagine){
		var next = +numPaginaS+1;	
		var thisA = '<li><a href="#" title="'+next+'" class="" onClick="writePaginazione(\''+restDomain+'\',\''+idSession+'\',\''+idEntity+'\',\''+pathOwlEntity+'\',\''+filtri+'\',\''+next+'\',\''+elemInPaginaS+'\');">'+next+'</a></li>';
		$( ".pagination li:last-child" ).before(thisA);
	}
	if ((+numPaginaS+3) <= (+ultimaPagina)){
		var next2 = +numPaginaS+2;
		var thisA = '<li><a href="#" title="'+next2+'" class="" onClick="writePaginazione(\''+restDomain+'\',\''+idSession+'\',\''+idEntity+'\',\''+pathOwlEntity+'\',\''+filtri+'\',\''+next2+'\',\''+elemInPaginaS+'\');">'+next2+'</a></li>';
		$( ".pagination li:last-child" ).before(thisA);
	}

	if(numPaginaS == 1 || numPaginaS == 2){
		var next3 = +numPaginaS+3;
		if(next3 <= numTotalePagine){
			var thisA = '<li><a href="#" title="'+next3+'" class="" onClick="writePaginazione(\''+restDomain+'\',\''+idSession+'\',\''+idEntity+'\',\''+pathOwlEntity+'\',\''+filtri+'\',\''+next3+'\',\''+elemInPaginaS+'\');">'+next3+'</a></li>';
			$( ".pagination li:last-child" ).before(thisA);	
		}
	}

	if(((+numPaginaS-2) > (+ultimaPagina-5)) && ((+numPaginaS+3) < (+ultimaPagina-2))){
		var next3 = +numPaginaS+3;	
		var thisA = '<li><a href="#" title="'+next3+'"  class="" onClick="writePaginazione(\''+restDomain+'\',\''+idSession+'\',\''+idEntity+'\',\''+pathOwlEntity+'\',\''+filtri+'\',\''+next3+'\',\''+elemInPaginaS+'\');">'+next3+'</a></li>';
		$( ".pagination li:last-child" ).before(thisA);
	}

	if(numPaginaS == 1 ){
		var next4 = +numPaginaS+4;
		if(next4 <= numTotalePagine){
			var thisA = '<li><a href="#" title="'+next4+'" class="" onClick="writePaginazione(\''+restDomain+'\',\''+idSession+'\',\''+idEntity+'\',\''+pathOwlEntity+'\',\''+filtri+'\',\''+next4+'\',\''+elemInPaginaS+'\');">'+next4+'</a></li>';
			$( ".pagination li:last-child" ).before(thisA);	
		}
	}

}



//chiamata da scriviTabellaEntity se l'attribute e di tipo ENTITY
function getEntityTableFromPath(pathOwlEntity,rowId, rowType, idSession, restDomain ){
	$(".lastupdate").html('');
	$('#form table').empty();
	$('#form table').append('<thead> </thead> <tbody> </tbody>');
	$.ajax({
		type: "GET",
		url: restDomain+serviceGetThingEntity,
		dataType: "json",
		data:'pathOwlEntity='+pathOwlEntity+'&idSession='+idSession,
		success: function(thingData){
			if(thingData!=null){
				$.ajax({
					type: "GET",
					url: restDomain+serviceGetEntitySingleRow,
					dataType: "json",
					data:'idEntity='+thingData.idEntity+'&rowId='+rowId+'&rowType='+rowType+'&idSession='+idSession,
					success: function (data) {
						$(".lastupdate").html(thingData.dataAggiornamento==undefined?'':'Ultimo aggiornamento: '+thingData.dataAggiornamento);
						var righe = "";
						if(data.rigaBean == undefined){
							righe = data;
						}else{
							righe = data.rigaBean;	
						}
						if( Object.prototype.toString.call( righe ) !== '[object Array]' ) {
							righe = [].concat( righe );
						}
						if(righe.length>1){
							$('.error').remove();
							scriviTabellaEntity(righe,idSession,restDomain,thingData.idEntity,rowId,rowType,pathOwlEntity,'','','');
//							newFilterTable(thingData.idEntity,thingData.label,idSession,restDomain,pathOwlEntity,'');
						}else{
							$('.entityList').empty();
							$(".pagination").empty();
							$(".num4page").empty();
						}
					},
					error: function (error) {
						$('.entityList').remove();
					}   
				});
			}else{
				$('.entityList').remove();
			}
		},
		error: function (error) {
			$('.entityList').remove();
		}   
	});
};


function scriviTabellaEntity(righe,idSession,restDomain,idEntity,rowId,rowType,pathOwlEntity,filtri,numPaginaS,elemInPaginaS) {
	var layout="HorizontalTable";
	$.ajax({
		type: "GET",
		url: restDomain+serviceGetLayout,
		dataType: "json",
		data:'idEntity='+idEntity+'&idSession='+idSession,
		success: function (data) {
			if(data!=null){
				if(data.codice == undefined){
					layout=data;	
				}else{
					layout=data.codice;
				}
				if((layout="HorizontalTable") || (layout == "VerticalTable")){
					$.each(righe, function(index, riga){
						//inizio each esterno
						var trDaAppendere='<tr>';
						var listaCol = riga.colonne;
						$.each(listaCol, function(index2, col){
							//inizio each interno
							if(index==0){
								trDaAppendere+='<th>'+col.valore+'</th>';    
							}else{
								if(col == null)
									trDaAppendere+='<td></td>';
								else if(col.tipo == 'URL'){

									var filename = col.infoAggiuntive.substring(col.infoAggiuntive.lastIndexOf('/')+1);
									if(filename.indexOf("?") !== -1){
										filename = filename.split("?",1); 
									}       
									var estensione=getFileExtension(col.valore);
									var urlfinale=ucmLinkAlFile+"/"+filename+"."+estensione;

									if(col.infoAggiuntive.indexOf("/cs/internet/")!==-1)
									{
										urlfinale=col.infoAggiuntive;
									}

									trDaAppendere+='<td> <a href="'+urlfinale+'" target="_blank">'+col.valore+'</a> </td>';  
								}else if(col.tipo == 'ENTITY'){
									trDaAppendere+='<td>'+
									'<input class="imgDettaglio" type="button" value="'+col.valore+'" onClick="getEntityTableFromPath(\''+col.pathOwlEntity+'\',\''+col.valore+'\',\''+col.infoAggiuntive+'\',\''+idSession+'\',\''+restDomain+'\');">'+
									'</td>';    
								}else if(col.tipo == 'FILE'){
									trDaAppendere+='<td>'+
									'<a class="imgFile" title="download" href="'+restDomain+serviceGetFile+'?idSession='+idSession+'&idFile='+col.valore+'&callback=?"></a>'+
									'</td>';
								}else if(col.tipo == 'euro' || col.tipo == 'EURO'){				
									trDaAppendere+='<td>'+(col.valore==undefined?'':(parseInt(col.valore)).formatMoney(2, ',', '.'))+' &euro; </td> ';
								}else if(col.tipo == 'List_URL'){
									var rowId = riga.rowId;
									if(col.valore>0){
										trDaAppendere+='<td>' + '<a href="#" class="imgFile" title="download" onclick="getFileDocsX('+idEntity+','+rowId+','+idSession+',\''+filtri+'\','+numPaginaS+','+elemInPaginaS+')">Documentazione</a></td>';
									}else{
										trDaAppendere+='<td></td>';
									}
								}else if(col.tipo == 'LIST'){
									//se ? una lista itero sulle colonne interne
									var listaColInt = col.listaColonne;
									trDaAppendere+='<td>';
									$.each(listaColInt, function(index3, colInt){
										//inizio each interno
										if(colInt.tipo == 'URL'){
											var filename = colInt.infoAggiuntive.substring(colInt.infoAggiuntive.lastIndexOf('/')+1);
											var estensione=getFileExtension(colInt.valore);
											var urlfinale=ucmLinkAlFile+"/"+filename+"."+estensione;
											trDaAppendere+='<a href="'+urlfinale+'" target="_blank">'+colInt.valore+'</a></br>';  
										}else{
											trDaAppendere+=(colInt.valore==undefined?'':colInt.valore)+'</br>';   
										}
										//fine each interno
									});
									trDaAppendere+='</td>';
									trDaAppendere+='</div></p>';
								}else{
									var textToAdd =  col.valore==undefined?'':col.valore;
									if(textToAdd.length>70){
										trDaAppendere+='<td class="table_td_large">'+textToAdd+'</td>';  
									}else{
										trDaAppendere+='<td>'+(col.valore==undefined?'':col.valore)+'</td>';   
									}
								}
							}
							//fine each interno
						});
						trDaAppendere+='</tr>';
						if(index==0){
							$('#form table > thead:last').append(trDaAppendere);
						}else{
							$('#form table > tbody:last').append(trDaAppendere);
						}
						//fine each esterno
					});
				};
			}
		},complete: function(){
			$('#contenutoprincipale > p:first').remove();
			var hrefLinkPdf=restDomain+serviceGetLocalFile+'?idEntity='+idEntity+'&fileName=PDFTABLE&idSession='+idSession;    
			var appInputPdf = "<p class='pull-right'><a href=\'" + hrefLinkPdf+ "' class='btnfake' role='button' title='Esporta Pdf'>esporta pdf</a> ";
			
			var hrefLinkCsv=restDomain+serviceGetLocalFile+'?idEntity='+idEntity+'&fileName=CSVTABLE&idSession='+idSession;   
			var appInputCsv = "<a href=\'" + hrefLinkCsv+ "' class='btnfake' role='button' title='Esporta Csv'>esporta csv</a></p> ";
			$('#contenutoprincipale > nav:last').after(appInputPdf+appInputCsv);                            
		} 
	});
};

var testoLi;
function getFileDocsX(idEntity,rowId,idSession,filtri,numPaginaS,elemInPaginaS){
	
	var lastUpdatePag =  $('.lastupdate').html();
	
	var nomeEntity = $('#contenutoprincipale h2').html();
	$("#contenutoprincipale").empty();
	$('#contenutoprincipale').append('<h2>'+nomeEntity+'</h2>');
	campoHidden =[];
	$.ajax({
		type: "GET",
		url: restDomain+getFileDocs,
		dataType: "json",
		data: 'idEntity='+idEntity+'&rowId='+rowId+'&idSession='+idSession,
		success: function (data) {
			if(data!=null){
				$("#contenutoprincipale").append("<h3>Documentazione</h3><p></p><div class='box'><ul class='allegati'>");
				var arrayOrObject = "";
				if(data.docInfosBean == undefined){
					arrayOrObject = data;
				}else{
					arrayOrObject = data.docInfosBean;
				}
				testoLi='';
				//MULTIPLO
				if(arrayOrObject instanceof Array){
					var indice = 0;
					$.each(arrayOrObject, function(index, items){ 
						for(var i=0; i < items.docInfoBean.length; i++){ 
							var item = items.docInfoBean[i];							
							if(item.isVisible=='S'){
								if(i==0){
									var docInfo = JSON.stringify(items.docInfoBean);
									docInfo = "{\"docInfoBean\":" + docInfo +"}";
									var hrefLink=restDomain+getDocInfo+'?idEntity='+idEntity+'&docInfosBean='+docInfo+'&idSession='+idSession+'&callback=?';
									testoLi ='<li><a class="imgFile" title="download" href=\''+hrefLink+'\'>'+item.docInfoValue+'</a><p class="page-description">(';	
								}else if (i==1){
									testoLi +=item.docInfoValue +' - ';
								}else if (i==2){
									testoLi += item.docInfoValue +')</p></li>';
								}
							}
						}
						$("ul.allegati").append(testoLi);
						indice ++;
					});
				}else {
					//SINGOLO	
					for(var i=0; i < arrayOrObject.docInfoBean.length; i++){ 
						var item = arrayOrObject.docInfoBean[i];							
						if(item.isVisible=='S'){
							if(i==0){
								var docInfo = JSON.stringify(arrayOrObject.docInfoBean);
								docInfo = "{\"docInfoBean\":" + docInfo +"}";
								var hrefLink=restDomain+getDocInfo+'?idEntity='+idEntity+'&docInfosBean='+docInfo+'&idSession='+idSession+'&callback=?';
								testoLi ='<li><a class="imgFile" title="download" href=\''+hrefLink+'\'>'+item.docInfoValue+'</a><p class="page-description">(';	
							}else if (i==1){
								testoLi +=item.docInfoValue +' - ';
							}else if (i==2){
								testoLi += item.docInfoValue +')</p></li>';
							}
						}
					}

					$("ul.allegati").append(testoLi);
				}

				$("#contenutoprincipale").append("</ul></div>");
				
				var backButton = '<p class="pull-right"><a href="#" class="btnfake" role="button" title="Inditro" onClick="backLoadTable(\''+restDomain+'\','+idSession+','+idEntity+',\''+nomeEntity+'\',\''+lastUpdatePag+'\',\''+filtri+'\','+numPaginaS+','+elemInPaginaS+')">indietro</a>';
				$('#contenutoprincipale > div:last').after(backButton);                            
			}
		}, error: function (error) {
			console.log(error);
			$("#contenutoprincipale").empty();
			$("#contenutoprincipale").append("Servizio momentaneamente non disponibile");
		}		

	});
}


function color() {
	version = browserVer();
	if (parseInt(version) === 7 ||  parseInt(version) === 8) {
		$("#tabellaEntityList tr:even").css("background-color", "#FF9");
	}
}

function colorTable() {
	version = browserVer();
	if (parseInt(version) === 7 ||  parseInt(version) === 8) {
		$("#form table tr:even").css("background-color", "#DAE5F4");
	}
}


function browserVer() {
	if(!jQuery.browser){
		jQuery.browser = {};
		jQuery.browser.mozilla = false;
		jQuery.browser.webkit = false;
		jQuery.browser.opera = false;
		jQuery.browser.safari = false;
		jQuery.browser.chrome = false;
		jQuery.browser.msie = false;
		jQuery.browser.android = false;
		jQuery.browser.blackberry = false;
		jQuery.browser.ios = false;
		jQuery.browser.operaMobile = false;
		jQuery.browser.windowsMobile = false;
		jQuery.browser.mobile = false;

		var nAgt = navigator.userAgent;
		jQuery.browser.ua = nAgt;

		jQuery.browser.name  = navigator.appName;
		jQuery.browser.fullVersion  = ''+parseFloat(navigator.appVersion);
		jQuery.browser.majorVersion = parseInt(navigator.appVersion,10);
		var nameOffset,verOffset,ix;

		// In Opera, the true version is after "Opera" or after "Version"
		if ((verOffset=nAgt.indexOf("Opera"))!=-1) {
			jQuery.browser.opera = true;
			jQuery.browser.name = "Opera";
			jQuery.browser.fullVersion = nAgt.substring(verOffset+6);
			if ((verOffset=nAgt.indexOf("Version"))!=-1)
				jQuery.browser.fullVersion = nAgt.substring(verOffset+8);
		}

		// In MSIE < 11, the true version is after "MSIE" in userAgent
		else if ( (verOffset=nAgt.indexOf("MSIE"))!=-1) {
			jQuery.browser.msie = true;
			jQuery.browser.name = "Microsoft Internet Explorer";
			jQuery.browser.fullVersion = nAgt.substring(verOffset+5);
		}

		// In TRIDENT (IE11) => 11, the true version is after "rv:" in userAgent
		else if (nAgt.indexOf("Trident")!=-1 ) {
			jQuery.browser.msie = true;
			jQuery.browser.name = "Microsoft Internet Explorer";
			var start = nAgt.indexOf("rv:")+3;
			var end = start+4;
			jQuery.browser.fullVersion = nAgt.substring(start,end);
		}

		// In Chrome, the true version is after "Chrome"
		else if ((verOffset=nAgt.indexOf("Chrome"))!=-1) {
			jQuery.browser.webkit = true;
			jQuery.browser.chrome = true;
			jQuery.browser.name = "Chrome";
			jQuery.browser.fullVersion = nAgt.substring(verOffset+7);
		}
		// In Safari, the true version is after "Safari" or after "Version"
		else if ((verOffset=nAgt.indexOf("Safari"))!=-1) {
			jQuery.browser.webkit = true;
			jQuery.browser.safari = true;
			jQuery.browser.name = "Safari";
			jQuery.browser.fullVersion = nAgt.substring(verOffset+7);
			if ((verOffset=nAgt.indexOf("Version"))!=-1)
				jQuery.browser.fullVersion = nAgt.substring(verOffset+8);
		}
		// In Safari, the true version is after "Safari" or after "Version"
		else if ((verOffset=nAgt.indexOf("AppleWebkit"))!=-1) {
			jQuery.browser.webkit = true;
			jQuery.browser.name = "Safari";
			jQuery.browser.fullVersion = nAgt.substring(verOffset+7);
			if ((verOffset=nAgt.indexOf("Version"))!=-1)
				jQuery.browser.fullVersion = nAgt.substring(verOffset+8);
		}
		// In Firefox, the true version is after "Firefox"
		else if ((verOffset=nAgt.indexOf("Firefox"))!=-1) {
			jQuery.browser.mozilla = true;
			jQuery.browser.name = "Firefox";
			jQuery.browser.fullVersion = nAgt.substring(verOffset+8);
		}
		// In most other browsers, "name/version" is at the end of userAgent
		else if ( (nameOffset=nAgt.lastIndexOf(' ')+1) < (verOffset=nAgt.lastIndexOf('/')) ){
			jQuery.browser.name = nAgt.substring(nameOffset,verOffset);
			jQuery.browser.fullVersion = nAgt.substring(verOffset+1);
			if (jQuery.browser.name.toLowerCase()==jQuery.browser.name.toUpperCase()) {
				jQuery.browser.name = navigator.appName;
			}
		}

		/*Check all mobile environments*/
		jQuery.browser.android = (/Android/i).test(nAgt);
		jQuery.browser.blackberry = (/BlackBerry/i).test(nAgt);
		jQuery.browser.ios = (/iPhone|iPad|iPod/i).test(nAgt);
		jQuery.browser.operaMobile = (/Opera Mini/i).test(nAgt);
		jQuery.browser.windowsMobile = (/IEMobile/i).test(nAgt);
		jQuery.browser.mobile = jQuery.browser.android || jQuery.browser.blackberry || jQuery.browser.ios || jQuery.browser.windowsMobile || jQuery.browser.operaMobile;


		// trim the fullVersion string at semicolon/space if present
		if ((ix=jQuery.browser.fullVersion.indexOf(";"))!=-1)
			jQuery.browser.fullVersion=jQuery.browser.fullVersion.substring(0,ix);
		if ((ix=jQuery.browser.fullVersion.indexOf(" "))!=-1)
			jQuery.browser.fullVersion=jQuery.browser.fullVersion.substring(0,ix);

		jQuery.browser.majorVersion = parseInt(''+jQuery.browser.fullVersion,10);
		if (isNaN(jQuery.browser.majorVersion)) {
			jQuery.browser.fullVersion  = ''+parseFloat(navigator.appVersion);
			jQuery.browser.majorVersion = parseInt(navigator.appVersion,10);
		}
		jQuery.browser.version = jQuery.browser.majorVersion;
	}
	return jQuery.browser.version;

}