## CARATTERISTICHE PRINCIPALI

- Funzionalità chiave: il pannello può essere espanso o compresso, consentendo all'utente di visualizzare o nascondere le informazioni contenute.
- Aspetti tecnici rilevanti: il componente utilizza una struttura ad albero per organizzare le informazioni e consente la personalizzazione delle proprietà dei singoli nodi.
- Caratteristiche di accessibilità: il componente è progettato per essere accessibile da tastiera e supporta le funzionalità di lettura dello schermo.

## VARIANTI

Il Pannello Espandibile presenta tre varianti principali:

**Leaf 1**: una variante di base che consente la visualizzazione di informazioni semplici.

* Caso d'uso: utilizzare per presentare informazioni di base su un argomento specifico.
* Breve descrizione: il pannello espandibile di base per la presentazione di informazioni semplici.

**Leaf 2**: una variante che consente la visualizzazione di informazioni più dettagliate e organizzate in modo gerarchico.

* Caso d'uso: utilizzare per presentare informazioni complesse su un argomento specifico.
* Breve descrizione: il pannello espandibile avanzato per la presentazione di informazioni complesse.

**Leaf 3**: una variante che consente la visualizzazione di informazioni personalizzate e interattive.

* Caso d'uso: utilizzare per creare esperienze utente personalizzate e interattive.
* Breve descrizione: il pannello espandibile personalizzato per la creazione di esperienze utente uniche.

## BEST PRACTICES

- Raccomandazioni d'uso: utilizzare il pannello espandibile per presentare informazioni complesse e organizzate in modo gerarchico.
- Linee guida implementative: seguire le linee guida di accessibilità e utilizzare i controlli e le azioni forniti dal componente per garantire una esperienza utente fluida.
- Pratiche da evitare: non utilizzare il pannello espandibile per presentare informazioni troppo semplici o poco organizzate.

## COMPONENTI CORRELATI

Il Pannello Espandibile può essere utilizzato in combinazione con altri componenti, come ad esempio:

- **Tabella**: per presentare dati tabellari e organizzare le informazioni in modo strutturato.
- **Grafico**: per visualizzare dati statistici e fornire una rappresentazione visiva delle informazioni.

## OVERVIEW

<div class="table-responsive">`import { PanelTreeComponent } from "@inail/intranet-webkit/panel-tree";`</div>

Il componente PanelTreeComponent permette di visualizzare una struttura ad albero che include nodi foglia personalizzabili tramite un template. Il suo scopo principale è quello di fornire una rappresentazione visiva dei dati in modo chiaro e organizzato.

## API

<div class="table-responsive">
  <table class="table table-documentation">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>id</code></td>
         <td>
            `@Input() id = composeUniqueId('tree');` <br />
            Un identificatore univoco per l'albero del pannello, che viene generato utilizzando la funzione composeUniqueId('tree').
         </td>
      </tr>
      <tr>
         <td><code>leaf</code></td>
         <td>
            `@Input() leaf: any[] = [];` <br />
           Un array di elementi foglia che verranno visualizzati nell'albero.
         </td>
      </tr>
	  <tr>
         <td><code>leafTemplate</code></td>
         <td>
            `@Input() leafTemplate: any;` <br />
           Un template personalizzato utilizzato per rendere i nodi foglia dell'albero.
         </td>
      </tr>
	  <tr>
         <td><code>showChild</code></td>
         <td>
            `@Input() showChild = true;` <br />
          Un valore booleano che determina se i nodi figli devono essere mostrati (true) o nascosti (false).
         </td>
      </tr>
	  <tr>
         <td><code>leafTitle</code></td>
         <td>
            `@Input() leafTitle!: string;` <br />
           Il titolo per i nodi foglia dell'albero.
         </td>
      </tr>
   </tbody>
</table>
</div>