## Caratteristiche Principali

### Funzionalità chiave

Il componente "Form Row Break" offre le seguenti funzionalità:

* Creazione di una separazione orizzontale tra gli elementi del form
* Personalizzazione dell'aspetto della separazione

### Aspetti tecnici rilevanti

Il componente è realizzato utilizzando tecnologie web standard e non richiede l'utilizzo di librerie o framework specifici.

### Caratteristiche di accessibilità

Il componente "Form Row Break" è progettato per essere accessibile e rispetta le linee guida WCAG 2.1.

## Varianti

Le varianti disponibili per il componente "Form Row Break" includono:

* **Test della descrizione del form row break INAIL**: Questa variante include una breve descrizione del componente.
* **N.D.**: Non ci sono altre varianti disponibili.

## Best Practices

### Raccomandazioni d'uso

Il componente "Form Row Break" dovrebbe essere utilizzato per creare una separazione orizzontale tra gli elementi del form, migliorando la leggibilità e l'organizzazione dei contenuti.

### Linee guida implementative

Per implementare il componente "Form Row Break", è necessario seguire le linee guida di progettazione e sviluppo standard per i componenti web.

### Pratiche da evitare

È importante evitare l'utilizzo del componente "Form Row Break" come elemento di layout principale, poiché potrebbe compromettere la struttura e l'accessibilità del contenuto.

## Componenti Correlati

Il componente "Form Row Break" può essere utilizzato in combinazione con altri componenti di form per creare un'esperienza utente completa e accessibile.


## OVERVIEW
<div class="table-responsive">`import { FormRowBreakComponent } from '@inail/intranet-webkit/form-controls';`</div>

Il FormRowBreakComponent consente di creare una pausa tra le righe di un modulo, migliorando la leggibilità e l'organizzazione dei dati. Utilizza un template HTML e stili SCSS personalizzati per definire l'aspetto visivo della separazione.

## API
Questo componente non è visibile sui layout.