## CARATTERISTICHE PRINCIPALI
Il componente di feedback presenta le seguenti caratteristiche principali:

Funzionalità chiave

* Possibilità di mostrare diversi tipi di messaggi (conferma, errore, avviso)
* Supporto per testo personalizzato
* Facilità di utilizzo e integrazione con altre componenti

Aspetti tecnici rilevanti

* Implementato in HTML, CSS e JavaScript
* Utilizza le librerie Angular per la gestione degli stati e delle azioni
* Compatibile con i principali browser web

Caratteristiche di accessibilità

* Supporto per gli standard di accessibilità WCAG 2.1
* Possibilità di personalizzare il contenuto del messaggio per adattarlo alle esigenze degli utenti con disabilità

## VARIANTI
Il componente di feedback presenta le seguenti varianti:

Elenco e descrizione delle varianti disponibili

* Variante 1: Messaggio di conferma
 + Descrizione: Mostra un messaggio di conferma all'utente dopo aver completato un'azione
 + Casi d'uso specifici: Utilizzare per confermare l'avvenuta registrazione, l'invio di un modulo, ecc.
* Variante 2: Messaggio di errore
 + Descrizione: Mostra un messaggio di errore all'utente in caso di problema tecnico o di validazione dei dati
 + Casi d'uso specifici: Utilizzare per segnalare errori di compilazione del modulo, problemi di connessione al server, ecc.

## BEST PRACTICES
Per utilizzare il componente di feedback in modo efficace:

Raccomandazioni d'uso

* Utilizzare il componente di feedback per fornire informazioni immediate e chiare all'utente
* Personalizzare il contenuto del messaggio per adattarlo alle esigenze degli utenti con disabilità
* Utilizzare le varianti disponibili per mostrare diversi tipi di messaggi

Linee guida implementative

* Implementare il componente di feedback in modo da garantire la compatibilità con i principali browser web
* Utilizzare le librerie Angular per la gestione degli stati e delle azioni
* Seguire gli standard di accessibilità WCAG 2.1 per garantire l'accessibilità del componente

Pratiche da evitare

* Non utilizzare il componente di feedback per mostrare messaggi non rilevanti o non immediati
* Evitare di sovraccaricare il componente con troppe informazioni o azioni

## COMPONENTI CORRELATI
Il componente di feedback può essere utilizzato in combinazione con altri componenti, come ad esempio:

Componenti associati

* Modulo di registrazione
* Form di contatto
* Pagina di errore

Relazioni con altri elementi

* Il componente di feedback può essere utilizzato per mostrare messaggi di conferma o errore in risposta alle azioni dell'utente sui componenti associati.

## OVERVIEW
<div class="table-responsive">`import { FeedbackComponent } from '@inail/intranet-webkit/elements';`</div>

Componente personalizzato utilizzato per visualizzare messaggi di feedback o contenuti informativi all'interno di una pagina web.

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>type</code></td>
      <td>
          `@Input() type: FeedbackType = 'default';` <br />
          Tipo di feedback, che influisce anche sullo stile del componente. <br />
          `type FeedbackType = 'success' | 'danger' | 'warning' | 'info' | 'primary' | 'default';`
      </td>
    </tr>
    <tr>
      <td><code>title</code></td>
      <td>
          `@Input() title = 'LABEL.TITLE';` <br />
          Input di tipo string che assegna il titolo al messaggio di feedback.
      </td>
    </tr>
    <tr>
      <td><code>actions</code></td>
      <td>
          `@Input() actions: any[] = [];` <br />
         Input di tipo array che assegna un elenco di azioni <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a> al feedback.
      </td>
    </tr>
    <tr>
      <td><code>body</code></td>
      <td>
          `@Input() body = false;` <br />
          Input di tipo booleano che controlla la visualizzazione di un contenuto condizionale nel corpo del feedback.
      </td>
    </tr>
    <tr>
      <td><code>i18nParams</code></td>
      <td>
          `@Input() i18nParams = {};` <br />
          Oggetto che definisce i parametri per la traduzione del titolo e del corpo del feedback.<br />
          `{{ title | translate: i18nParams }}`
      </td>
    </tr>
  </tbody>
</table>
</div>