## CARATTERISTICHE PRINCIPALI
-----------------------------

Le caratteristiche principali del componente Sticky includono:

* **Funzionalità chiave**: il componente diventa sticky quando l'utente fa scroll sulla pagina
* **Aspetti tecnici rilevanti**: il componente utilizza le proprietà CSS per rimanere visibile e accessibile anche quando la pagina viene scollata
* **Caratteristiche di accessibilità**: il componente è progettato per essere accessibile da utenti con disabilità, grazie alla possibilità di specificare un titolo e un sottotitolo accessibili

## VARIANTI
-------------

Le varianti disponibili per il componente Sticky includono:

* **Variante 1**: il componente è closable (chiudibile)
	+ Caso d'uso: quando l'utente vuole chiudere il componente per non visualizzarlo più
	+ Breve descrizione: il componente può essere chiuso dall'utente, ma può essere riaperto in seguito
* **Variante 2**: il componente è reopenable (riapribile)
	+ Caso d'uso: quando l'utente vuole riaprire il componente per visualizzarlo di nuovo
	+ Breve descrizione: il componente può essere riaperto dall'utente dopo essere stato chiuso

## BEST PRACTICES
-----------------

Le raccomandazioni d'uso per il componente Sticky includono:

* Utilizzare il componente solo quando è necessario, per evitare di sovraccaricare la pagina con elementi visivi
* Specificare un titolo e un sottotitolo accessibili per il componente, per garantire l'accessibilità per utenti con disabilità
* Evitare di utilizzare il componente in modo eccessivo, per evitare di creare confusione nell'interfaccia utente

## COMPONENTI CORRELATI
-------------------------

I componenti associati al componente Sticky includono:

* **Componente di navigazione**: il componente Sticky può essere utilizzato in combinazione con un componente di navigazione per fornire una migliore esperienza utente
* **Componente di contenuto**: il componente Sticky può essere utilizzato per visualizzare contenuti importanti, come ad esempio messaggi di errore o avvisi.

## OVERVIEW
<div class="table-responsive">`import { StickyComponent } from '@inail/internet-webkit/elements';`</div>
Componente custom che rimane fissato in cima alla pagina anche quando si effettua lo scroll.

## API
<div class="table-responsive">
  <table class="table">
  <thead>
	<tr>
	  <th><strong>Campo</strong></th>
	  <th><strong>Descrizione</strong></th>
	</tr>
  </thead>
  <tbody>
	<tr>
	  <td><code>title</code></td>
	  <td>
		  `@Input() title!: string;` <br />
		  Campo `string` che imposta il titolo del componente Sticky.
	  </td>
	</tr>
	<tr>
	  <td><code>subtitle</code></td>
	  <td>
		  `@Input() subtitle!: string;` <br />
		  Sottotitolo opzionale per il componente Sticky.
	  </td>
	</tr>
	<tr>
	  <td><code>tags</code></td>
	  <td>
		  `@Input() tags!: Tag[];` <br />
		  Array di <a href="?path=/docs/resources-models-tag--docs">Tag</a> che si mostrano nel componente.
	  </td>
	</tr>
	<tr>
	  <td><code>actions</code></td>
	  <td>
		`@Input() actions!: ActionItem[];` <br />
		Array di <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>.
	  </td>
	</tr>
	<tr>
	  <td><code>closable</code></td>
	  <td>
		`@Input() closable: boolean = true;` <br />
		Booleano che determina se il componente può essere chiuso.
	  </td>
	</tr>
	<tr>
	  <td><code>reopenable</code></td>
	  <td>
		`@Input() reopenable: boolean = false;` <br />
		Booleano che permette di riaprire il componente Sticky quando si torna all'inizio della pagina.
	  </td>
	</tr>
	<tr>
	  <td><code>hideTitle</code></td>
	  <td>
		`@Input() hideTitle: boolean = false;` <br />
		Booleano che nasconde il titolo del componente.
	  </td>
	</tr>
  </tbody>
</table>
</div>