## CARATTERISTICHE PRINCIPALI

* Funzionalità chiave:
 + Consente la creazione di wizard con più passaggi
 + Supporta la gestione delle transizioni tra i passaggi
* Aspetti tecnici rilevanti:
 + Utilizza un sistema di templating per la gestione dei contenuti
 + Supporta l'integrazione con altri componenti e librerie
* Caratteristiche di accessibilità:
 N.D.

## VARIANTI

Il componente StoriesWizardComponente presenta quattro varianti, ognuna delle quali rappresenta un passaggio del wizard:

1. **First Step**
 + Descrizione: Primo passaggio del wizard, che introduce l'utente all'attività da svolgere.
 + Casi d'uso specifici: Utilizzato per presentare le informazioni di base relative all'attività.
2. **Second Step**
 + Descrizione: Secondo passaggio del wizard, che fornisce ulteriori dettagli sull'attività da svolgere.
 + Casi d'uso specifici: Utilizzato per raccogliere le informazioni necessarie per proseguire con l'attività.
3. **Third Step**
 + Descrizione: Terzo passaggio del wizard, che consente all'utente di eseguire azioni specifiche relative all'attività.
 + Casi d'uso specifici: Utilizzato per gestire le operazioni principali dell'attività.
4. **Warning/Error Step**
 + Descrizione: Passaggio finale del wizard, che visualizza eventuali messaggi di errore o avvisi relativi all'attività svolta.
 + Casi d'uso specifici: Utilizzato per gestire le situazioni di errore e fornire indicazioni all'utente.

## BEST PRACTICES

* Raccomandazioni d'uso:
 + Utilizzare il componente StoriesWizardComponente per creare wizard con più passaggi, in modo da guidare l'utente attraverso l'attività da svolgere.
 + Personalizzare i contenuti e le transizioni tra i passaggi del wizard per adattarli alle esigenze specifiche dell'applicazione.
* Linee guida implementative:
 + Utilizzare il sistema di templating fornito dal componente per gestire i contenuti dei passaggi del wizard.
 + Integrazione con altri componenti e librerie per estendere le funzionalità del wizard.
* Pratiche da evitare:
 N.D.

## COMPONENTI CORRELATI

Il componente StoriesWizardComponente può essere utilizzato in combinazione con altri componenti, come ad esempio:

* Componenti di input e form: per raccogliere le informazioni necessarie per proseguire con l'attività.
* Componenti di gestione delle operazioni: per gestire le azioni specifiche relative all'attività.
* Componenti di visualizzazione dei messaggi: per visualizzare eventuali messaggi di errore o avvisi relativi all'attività svolta.

## OVERVIEW
<div class="table-responsive">`import { WizardComponent } from '@inail/intranet-webkit/wizard';`</div>

Componente custom utilizzato per visualizzare i passaggi di un processo e lo stato di ciascuno di essi.

## API

<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
	<tr>
	  <th style="width: 20%"><strong>Campo</strong></th>
	  <th style="width: 80%"><strong>Descrizione</strong></th>
	</tr>
  </thead>
  <tbody>
	<tr>
	  <td><code>defaultIcons</code></td>
	  <td>
		  `@Input() defaultIcons: boolean = false;` <br />
		  Boolean che cambia l' uso delle icone. Quando e `true`, le icone non cambiano a base del stato del Step.
	  </td>
	</tr>
	<tr>
	  <td><code>step</code></td>
	  <td>
		  `@Input() steps: Step[] = [];` <br />
		  Array di <a href="?path=/docs/resources-models-step--docs">Step</a> che imposta il elenco di processi presenti nel Wizard.
	  </td>
	</tr>
	<tr>
	  <td><code>activeStep</code></td>
	  <td>
		  `@Input('activeStep') set interceptActiveStepInput(activeStep: any) {}` <br />
		  Imposta lo Step attuale.
	  </td>
	</tr>
	<tr>
	  <td><code>id</code></td>
	  <td>
		  `@Input() id = composeUniqueId('tabs');` <br />
		  ID del Wizard.
	  </td>
	</tr>
	<tr>
	  <td><code>templates</code></td>
	  <td>
		  `@Input() templates: TemplateRef<undefined>[] = [];` <br />
		  Array di `TemplateRef` che imposta il contenuto di ogni Step del Wizard.
	  </td>
	</tr>
	<tr>
	  <td><code>uniqueId</code></td>
	  <td>
		  `@Input() uniqueId!: string;` <br />
		  ID aggiuntivo
	  </td>
	</tr>
	<tr>
	  <td><code>isSlider</code></td>
	  <td>
		  `@Input() isSlider = false;` <br />
		  Booleano che cambia il orientamento del Wizard.
	  </td>
	</tr>
  </tbody>
</table>
</div>

<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Campo</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>stepChange</code></td>
      <td>
        `@Output() stepChange: EventEmitter<Step> = new EventEmitter();` <br />
        `EventEmitter` tramite il quale si gestisce la navigazione tra i Step.
      </td>
    </tr>
  </tbody>
</table>
</div>