## CARATTERISTICHE PRINCIPALI

* Funzionalità chiave:
 + Possibilità di personalizzare le proprietà del pulsante
 + Supporto per diverse dimensioni e layout
* Aspetti tecnici rilevanti:
 + Utilizza la tecnologia HTML/CSS per la rappresentazione visiva
 + Può essere integrato con altre librerie e framework per l'interfaccia utente
* Caratteristiche di accessibilità:
 N.D.

## VARIANTI

Le seguenti varianti del componente sono disponibili:

1. **Default**: Variante predefinita del pulsante card, senza personalizzazioni.
	* Caso d'uso: utilizzare come pulsante standard per azioni comuni.
2. **Small**: Variante con dimensione ridotta del pulsante card.
	* Caso d'uso: utilizzare in spazi limitati o per azioni secondarie.
3. **Large**: Variante con dimensione aumentata del pulsante card.
	* Caso d'uso: utilizzare per azioni importanti o per richiamare l'attenzione dell'utente.

## BEST PRACTICES

* Raccomandazioni d'uso:
 + Utilizzare il componente in modo coerente all'interno dell'applicazione
 + Personalizzare le proprietà del pulsante per adattarlo alle esigenze specifiche
* Linee guida implementative:
 + Assicurarsi di utilizzare la tecnologia HTML/CSS corretta per la rappresentazione visiva
 + Utilizzare librerie e framework per l'interfaccia utente per integrare il componente con altre funzionalità
* Pratiche da evitare:
 + Non utilizzare il componente in modo eccessivo o inappropriato, al fine di non confondere l'utente

## COMPONENTI CORRELATI

Il Button Card Componente può essere utilizzato in combinazione con altri componenti per creare interfacce utente più complesse. Alcuni esempi di componenti correlati includono:

* Form: componente per la creazione di form
* Grid: componente per la creazione di griglie
* Menu: componente per la creazione di menu

## OVERVIEW
<div class="table-responsive">`import { ButtonCardComponent } from '@inail/intranet-webkit/elements';`</div>

Componente personalizzato utilizzato per creare pulsanti in stile card, che possono contenere messaggi o contenuti informativi all'interno di una pagina web.

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>onClick</code></td>
      <td>
        `@Output() onClick: EventEmitter<boolean> = new EventEmitter<boolean>();` <br />
        `EventEmitter` tramite il quale si può gestire la logica del click del button.
      </td>
    </tr>
  </tbody>
</table>
</div>