## CARATTERISTICHE PRINCIPALI
Il Button Componente presenta le seguenti caratteristiche chiave:

* Funzionalità di base per la creazione di bottoni
* Aspetti tecnici rilevanti:
 + Utilizza un sistema di template per la personalizzazione del layout
 + Supporta gli eventi di clic e altri eventi standard dei bottoni
* Caratteristiche di accessibilità: N.D.

## VARIANTI
Le varianti disponibili per il Button Componente sono:

* **Default**: Variante predefinita del bottone, senza personalizzazioni particolari.
 + Caso d'uso: Utilizzare come bottone standard in una forma o in un menu.
 + Breve descrizione: Bottone standard con testo e icona opzionale.
* **Primary**: Variante del bottone con stile primario, utilizzato per azioni importanti.
 + Caso d'uso: Utilizzare per azioni principali come "Invia" o "Salva".
 + Breve descrizione: Bottone con sfondo colorato e testo bianco.
* **Secondary**: Variante del bottone con stile secondario, utilizzato per azioni meno importanti.
 + Caso d'uso: Utilizzare per azioni secondarie come "Annulla" o "Indietro".
 + Breve descrizione: Bottone con sfondo trasparente e testo grigio.

## BEST PRACTICES
Raccomandazioni d'uso:

* Utilizzare il Button Componente per creare bottoni personalizzati e gestire gli eventi di clic.
* Evitare di utilizzare il Button Componente come link, poiché ciò può causare problemi di accessibilità.

Linee guida implementative:

* Utilizzare un sistema di template per la personalizzazione del layout del bottone.
* Supportare gli eventi di clic e altri eventi standard dei bottoni.

Pratiche da evitare:

* Non utilizzare il Button Componente come link.
* Non utilizzare stili non standard per i bottoni, poiché ciò può causare problemi di accessibilità.

## COMPONENTI CORRELATI
Il Button Componente è correlato ai seguenti componenti:

* Form: Il Button Componente può essere utilizzato all'interno di un form per creare bottoni di submit o reset.
* Link: Il Button Componente non deve essere utilizzato come link, poiché ciò può causare problemi di accessibilità.

## OVERVIEW
<div class="table-responsive">`import { ButtonComponent } from '@inail/intranet-webkit/buttons';`</div>

Il ButtonComponent è un componente versatile per la creazione di pulsanti personalizzati e interattivi in un'interfaccia utente. Consente di definire icone, etichette, colori, dimensioni, tooltip, classi CSS aggiuntive e di configurare il comportamento del pulsante tramite eventi e proprietà.

Questo componente è progettato per essere altamente configurabile e si adatta a vari contesti, offrendo funzionalità per pulsanti semplici, collegamenti (link), pulsanti con icone a destra o sinistra, e molto altro. È un'ottima soluzione per migliorare l'accessibilità e l'estetica dell'applicazione.


## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Campo</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>extId</code></td>
      <td> <code>@Input('ext-id') extId: string = composeUniqueId();</code><br /> Identificativo esterno univoco generato automaticamente. Può essere personalizzato. </td>
    </tr>
    <tr>
      <td><code>title</code></td>
      <td><code>@Input() set title(title: string) {...}</code><br /> Titolo del pulsante. Viene utilizzato per generare un ID univoco sostituendo gli spazi con underscore.<br /> Valore di default: <code>'INSERT TITLE PROPERTY'</code>. </td>
    </tr>
    <tr>
      <td><code>icon</code></td>
      <td> <code>@Input() icon!: string | string[];</code><br /> Icona da visualizzare nel pulsante. Supporta stringhe o array di stringhe per configurazioni avanzate. </td>
    </tr>
    <tr>
      <td><code>iconRight</code></td>
      <td> <code>@Input('icon-right') iconRight!: string;</code><br /> Icona visualizzata sul lato destro del pulsante. </td>
    </tr>
    <tr>
      <td><code>isLink</code></td>
      <td> <code>@Input() isLink = false;</code><br /> Booleano che determina se il pulsante si comporta come un collegamento (link).<br /> Valore predefinito: <code>false</code>. </td>
    </tr>
    <tr>
      <td><code>sizeButton</code></td>
      <td> <code>@Input('size') sizeButton = 'md';</code><br /> Dimensione del pulsante. Valori supportati: <code>'sm'</code>, <code>'md'</code>, <code>'lg'</code>.<br /> Valore predefinito: <code>'md'</code>. </td>
    </tr>
    <tr>
      <td><code>colorButton</code></td>
      <td> <code>@Input('color') colorButton = 'primary';</code><br /> Colore del pulsante. I valori supportati sono: <code>'primary'</code>, <code>'secondary'</code>, <code>'danger'</code>, ecc.<br /> Valore predefinito: <code>'primary'</code>. </td>
    </tr>
    <tr>
      <td><code>extClass</code></td>
      <td> <code>@Input('ext-class') extClass = '';</code><br /> Classe CSS aggiuntiva per personalizzare lo stile del pulsante. </td>
    </tr>
    <tr>
      <td><code>disabledButton</code></td>
      <td> <code>@Input('disabled') disabledButton!: boolean;</code><br /> Booleano che abilita o disabilita il pulsante. Se impostato su <code>true</code>, il pulsante è disattivato. </td>
    </tr>
    <tr>
      <td><code>hideLabel</code></td>
      <td> <code>@Input() hideLabel = false;</code><br /> Booleano che determina se l'etichetta del pulsante viene nascosta.<br /> Valore predefinito: <code>false</code>. </td>
    </tr>
    <tr>
      <td><code>buttonType</code></td>
      <td> <code>@Input() buttonType = 'button';</code><br /> Tipo di pulsante HTML. Valori supportati: <code>'button'</code>, <code>'submit'</code>, <code>'reset'</code>.<br /> Valore predefinito: <code>'button'</code>. </td>
    </tr>
    <tr>
      <td><code>description</code></td>
      <td> <code>@Input() description: string | null = null;</code><br /> Descrizione opzionale per il pulsante, utile per tooltip o accessibilità. </td>
    </tr>
    <tr>
      <td><code>label</code></td>
      <td> <code>@Input() label: string | null = null;</code><br /> Etichetta del pulsante, visualizzata accanto all'icona. </td>
    </tr>
  </tbody>
</table>
</div>

<br />
<br />

<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Event</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
  <tr>
      <td><code>onClick</code></td>
      <td> <code>@Output() onClick: EventEmitter&lt;Event&gt;;</code><br /> Evento emesso quando il pulsante viene cliccato. </td>
    </tr>
    <tr>
      <td><code>click</code></td>
      <td> <code>@Output() click: EventEmitter&lt;Event&gt; = new EventEmitter();</code><br /> Evento emesso al clic sul pulsante. Sinonimo di <code>onClick</code>. </td>
    </tr>
 </tbody>
 </table>
 </div>
