## CARATTERISTICHE PRINCIPALI
Il componente Double Date presenta le seguenti caratteristiche chiave:

* Funzionalità di input per la gestione delle date
* Possibilità di personalizzare il formato della data
* Aspetti tecnici rilevanti: utilizza un meccanismo di input avanzato per la gestione delle date


## VARIANTI
Il componente Double Date presenta le seguenti varianti:

* Test della descrizione del input double date INAIL
 + Descrizione: Variante che include una descrizione dettagliata dell'input double date.
 + Casi d'uso specifici: Utilizzare questa variante quando si desidera fornire agli utenti ulteriori informazioni sulla funzione dell'input double date.

## BEST PRACTICES
Raccomandazioni d'uso:

* Utilizzare il componente Double Date per la gestione delle date in formato duplice.
* Personalizzare il formato della data secondo le esigenze specifiche dell'applicazione.

Linee guida implementative:

* Assicurarsi di utilizzare un meccanismo di input avanzato per la gestione delle date.
* Fornire agli utenti ulteriori informazioni sulla funzione dell'input double date, se necessario.


## COMPONENTI CORRELATI
Il componente Double Date può essere utilizzato in combinazione con altri componenti di interfaccia utente, come ad esempio:

* **Calendario**: un componente che consente all'utente di visualizzare e selezionare date in un formato calendario
* **Form**: un componente che consente all'utente di inserire dati in un modulo web

In questo caso, non ci sono componenti correlati specifici menzionati nel testo.

## OVERVIEW
<div class="table-responsive">`import { InputDoubleDateComponent } from '@inail/intranet-webkit/form-controls';`</div>
Questo componente rappresenta un campo di input doppio per date, che permette agli utenti di inserire una data di inizio e una data di fine. È completamente configurabile attraverso diverse proprietà come etichette, placeholder, validazioni e dimensioni. 


## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>fromLabel</code></td>
      <td>
        `@Input() fromLabel = 'INPUT.DDATE.FROM';` <br />
        Etichetta per il campo input della data di inizio.
      </td>
    </tr>
    <tr>
      <td><code>toLabel</code></td>
      <td>
        `@Input() toLabel = 'INPUT.DDATE.TO';` <br />
        Etichetta per il campo input della data di fine.
      </td>
    </tr>
    <tr>
      <td><code>disableFrom</code></td>
      <td>
        `@Input() disableFrom: boolean;` <br />
        Disabilita l'input della data di inizio.
      </td>
    </tr>
     <tr>
      <td><code>disableTo</code></td>
      <td>
        `@Input() disableTo: boolean;` <br />
        Disabilita l'input della data di fine.
      </td>
    </tr>
    <tr>
      <td><code>regex</code></td>
      <td>
        `@Input() regex!: RegExp | string | string[];` <br />
        Modello regex per convalidare l'input della data.
       <ul>
            <li>
              Se il valore è un oggetto `RegExp`, significa che si sta passando un' espressione regolare JavaScript. Le espressioni regolari sono utilizzate per cercare e fare il matching di pattern all'interno di stringhe.
              `regex = /^[a-zA-Z]+$/;`
            </li>
            <li>
              Se il valore è una stringa, verrà trattato come una rappresentazione di un pattern. Quando la stringa viene utilizzata come regex, viene convertita internamente in una `RegExp` per eseguire operazioni di matching. 
              `regex = "^abc";`
            </li>
             <li>
              Se il valore è un array di stringhe, ciascun elemento dell'array rappresenta un pattern da utilizzare separatamente per il matching.
              `regex = ["^abc", "xyz$"];`
            </li>
       </ul>  
      </td>
    </tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class InputDoubleDateComponent extends BaseInputComponent` <br />
        La classe InputDoubleComponent estende <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent</a>
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
      `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
      La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
      </td>
    </tr>
  </tbody>
</table>
</div>