# RoleAlertModel

Documentazione dettagliata del model **RoleAlertModel**, usato nei componenti di Internet Webkit v17. 
L'interfaccia **RoleAlertModel** rappresenta un modello di dati per configurare un avviso (alert) associato a un ruolo o a una specifica funzione in un'applicazione.

## Implementazione
<div class="table-responsive">`import { RoleAlertModel } from '@inail/internet-webkit/accessibility'`</div>
<br />


***Struttura:***
`interface RoleAlertModel {
    message: string;
    active?: boolean;
    back?: string;
}`

***Esempio d'uso:***
<br />
`  roleAlert: RoleAlertModel = {
  message: 'Role Alert',
  active: true,
  back: ''
}`


## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>message</code></td>
      <td>
        Il messaggio principale dell'alert.
      </td>
    </tr>
    <tr>
      <td><code>active</code></td>
      <td>
       Indica se l'alert è attivo o meno.
      </td>
    </tr>
    <tr>
      <td><code>back</code></td>
      <td>
        Specifica un riferimento per tornare indietro, come un URL o un identificatore.
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-accessibility-role-alert--role-alert">Role Alert</a>
<br/>

