## CARATTERISTICHE PRINCIPALI
Le funzionalità chiave del componente Modal includono:

* La possibilità di impostare il titolo e il contenuto della finestra modale
* L'opzione per mostrare o nascondere il pulsante di chiusura
* Il supporto per la gestione dell'accessibilità

Gli aspetti tecnici rilevanti del componente Modal includono:

* La possibilità di utilizzare HTML e CSS per personalizzare l'aspetto della finestra modale
* L'utilizzo di JavaScript per gestire gli eventi e le interazioni con la finestra modale

Le caratteristiche di accessibilità del componente Modal includono:

* Il supporto per la navigazione con tastiera
* La possibilità di impostare un attributo ARIA per descrivere il contenuto della finestra modale

## VARIANTI
Il componente Modal dispone delle seguenti varianti:

* **Basic Modal**: una versione base del componente Modal che consente di visualizzare un contenuto personalizzabile
	+ Caso d'uso: utilizzare per visualizzare informazioni aggiuntive o richiedere input dall'utente
	+ Descrizione breve: finestra modale con contenuto personalizzabile

## BEST PRACTICES
Le raccomandazioni d'uso del componente Modal includono:

* Utilizzare il componente Modal solo quando è necessario visualizzare informazioni aggiuntive o richiedere input dall'utente
* Assicurarsi di impostare un attributo ARIA per descrivere il contenuto della finestra modale

Le linee guida implementative del componente Modal includono:

* Utilizzare HTML e CSS per personalizzare l'aspetto della finestra modale
* Utilizzare JavaScript per gestire gli eventi e le interazioni con la finestra modale

Le pratiche da evitare quando si utilizza il componente Modal includono:

* Utilizzare il componente Modal come sostituto di una pagina web completa
* Non impostare un attributo ARIA per descrivere il contenuto della finestra modale

## COMPONENTI CORRELATI
Il componente Modal è associato ai seguenti componenti:

* **Button**: utilizzato per chiudere la finestra modale
* **Overlay**: utilizzato per coprire il contenuto della pagina sottostante quando la finestra modale è aperta

Le relazioni con altri elementi del componente Modal includono:

* La possibilità di utilizzare il componente Modal all'interno di un altro componente, come ad esempio un **Tab** o un **Accordion**.

## OVERVIEW
<div class="table-responsive">`import { ButtonComponent } from '@inail/internet-webkit/buttons';`</div>

Il ModalComponent è un componente progettato per creare finestre modali personalizzabili e interattive all'interno di un'applicazione. Offre un'ampia gamma di opzioni per configurare titolo, contenuto, dimensione, azioni e comportamento, rendendolo ideale per notifiche, conferme e altri tipi di interazione con l'utente.

Il componente è altamente configurabile e supporta proprietà, eventi e opzioni per gestire scenari complessi, migliorando l'esperienza utente e l'accessibilità


## API
<div class="table-responsive">
  <table class="table">
    <thead>
      <tr>
        <th style="width: 20%"><strong>Campo</strong></th>
        <th style="width: 80%"><strong>Descrizione</strong></th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><code>title</code></td>
        <td> <code>@Input() title!: string;</code><br /> Titolo della finestra modale. Visualizzato nella barra superiore del componente. </td>
      </tr>
      <tr>
        <td><code>id</code></td>
        <td> <code>@Input() id = '';</code><br /> Identificativo univoco per la finestra modale. Può essere utilizzato per riferirsi al componente in modo specifico. </td>
      </tr>
      <tr>
        <td><code>headerAction</code></td>
        <td> <code>@Input() headerAction!: ActionItem[];</code><br /> Azioni configurabili da mostrare nell'intestazione della finestra modale. Accetta un array di elementi di tipo <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>. </td>
      </tr>
      <tr>
        <td><code>size</code></td>
        <td> <code>@Input() size: ModalSizeType = 'md';</code><br /> Dimensione della finestra modale. Valori supportati: <code>'sm'</code>, <code>'md'</code>, <code>'lg'</code>.<br /> Valore predefinito: <code>'md'</code>. </td>
      </tr>
      <tr>
        <td><code>buttons</code></td>
        <td> <code>@Input() buttons: any[]=buttons: any[] = [</code><br />
		<code>new ModalActionItem('BUTTON.CLOSE', () => {</code><br />
		<code>this.close();</code><br />
		<code>}),</code><br />
	<code>];</code><br /> Pulsanti configurabili visualizzati nel footer della finestra modale.Possono includere azioni personalizzate, come chiudere la finestra o eseguire una funzione.Accetta un array di elementi di tipo <a href="?path=/docs/resources-models-modalactionitem--docs">ModalActionItem</a>. </td>
      </tr>
      <tr>
        <td><code>oneLastFocus</code></td>
        <td> <code>@Input() oneLastFocus!: boolean;</code><br /> Indica se un elemento specifico dovrebbe ricevere il focus dopo la chiusura della finestra modale. </td>
      </tr>
      <tr>
        <td><code>backdrop</code></td>
        <td> <code>@Input() backdrop = false;</code><br /> Indica se il clic sull'area di sfondo (backdrop) chiude la finestra modale. Valore predefinito: <code>false</code>. </td>
      </tr>
      <tr>
        <td><code>showButtonClose</code></td>
        <td> <code>@Input() showButtonClose = true;</code><br /> Determina se mostrare il pulsante di chiusura nella barra superiore della finestra modale.<br /> Valore predefinito: <code>true</code>. </td>
      </tr>
    </tbody>
  </table>
</div>
<br />
<br />
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Event</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
       <tr>
        <td><code>onClose</code></td>
        <td> <code>@Output() onClose: EventEmitter&lt;any&gt; = new EventEmitter&lt;any&gt;();</code><br /> Evento emesso quando la finestra modale viene chiusa. </td>
      </tr>
 </tbody>
 </table>
 </div>